/*	com.c	x.x	03/30/85	*/

/*
 * Common routines.
 */

/*
 *  Copyright (c) 1984 by John Seamons, Lucasfilm Ltd.
 *  All rights reserved.
 *
 * history
 * 07/XX/85	jks	created
 * 04/20/85	croft	debug output can be toggled
 */

#include <mac/quickdraw.h>
#include <mac/toolintf.h>
#include "fs.h"
#include "efs.h"

NewMemPtr (size, heap)
register int size, heap;
{
	register int prevZone, np;

	prevZone = GetZone();
	SetZone (heap);
        if ((np = NewPtr (size)) == 0)
		efserr = memFulErr;
	SetZone (prevZone);
	return (np);
}

bzero (p, bytes)
register char *p;
register int bytes;
{
	while (bytes--)
		*p++ = 0;
}

#ifdef DEBUG
/*
 * Scaled down version of C Library printf.
 * Used to print diagnostic information directly on console tty.
 * Since it is not interrupt driven, all system activities are
 * suspended.  Printf should not be used for chit-chat.
 *
 * One additional format: %b is supported to decode error registers.
 * Usage is:
 *	printf("reg=%b\n", regval, "<base><arg>*");
 * Where <base> is the output base expressed as a control character,
 * e.g. \10 gives octal; \20 gives hex.  Each arg is a sequence of
 * characters, the first of which gives the bit number to be inspected
 * (origin 1), and the next characters (up to a control character, i.e.
 * a character <= 32), give the name of the register.  Thus
 *	printf("reg=%b\n", 3, "\10\2BITTWO\1BITONE\n");
 * would produce output:
 *	reg=2<BITTWO,BITONE>
 */
/*VARARGS1*/
printf(fmt, x1)
	char *fmt;
	unsigned x1;
{

	prf(fmt, &x1, 0);
}

prf(fmt, adx)
	register char *fmt;
	register unsigned int *adx;
{
	register int b, c, i;
	char *s;
	int any;

loop:
	while ((c = *fmt++) != '%') {
		if(c == '\0')
			return;
		putchar(c);
	}
again:
	c = *fmt++;
	/* THIS CODE IS VAX DEPENDENT IN HANDLING %l? AND %c */
	switch (c) {

	case 'l':
		goto again;
	case 'x': case 'X':
		b = 16;
		goto number;
	case 'd': case 'D':
	case 'u':		/* what a joke */
		b = 10;
		goto number;
	case 'o': case 'O':
		b = 8;
number:
		printn((unsigned long)*adx, b);
		break;
	case 'c':
		b = *adx;
		for (i = 24; i >= 0; i -= 8)
			if (c = (b >> i) & 0x7f)
				putchar(c);
		break;
#ifdef 0
	case 'b':
		b = *adx++;
		s = (char *)*adx;
		printn((unsigned long)b, *s++);
		any = 0;
		if (b) {
			putchar('<');
			while (i = *s++) {
				if (b & (1 << (i-1))) {
					if (any)
						putchar(',');
					any = 1;
					for (; (c = *s) > 32; s++)
						putchar(c);
				} else
					for (; *s > 32; s++)
						;
			}
			if (any)
				putchar('>');
		}
		break;
#endif
	case 's':
		s = (char *)*adx;
		while (c = *s++)
			putchar(c);
		break;

	case '%':
		putchar('%');
		break;
	}
	adx++;
	goto loop;
}

/*
 * Printn prints a number n in base b.
 * We don't use recursion to avoid deep kernel stacks.
 */
printn(n, b)
	unsigned long n;
{
	char prbuf[11];
	register char *cp;

	if (b == 10 && (int)n < 0) {
		putchar('-');
		n = (unsigned)(-(int)n);
	}
	cp = prbuf;
	do {
		*cp++ = "0123456789abcdef"[n%b];
		n /= b;
	} while (n);
	do
		putchar(*--cp);
	while (cp > prbuf);
}

int bout = 0, bin = 0;
char sershk[8] = { 1, 0, 'q'&037, 's'&037, 0, 0, 0, 0 };

putchar(c)
	register int c;
{
	char s = c;
	int cnt = 1;

	if (!bout) {
		bout = OpenDriver (".AOUT");
		SerHShake (bout, sershk);
	}		
	FSWrite (bout, &cnt, &s);
}

getchar() {
	char s;
	int cnt = 1;

	if (!bin)
		bin = OpenDriver (".AIN");
	FSRead (bin, &cnt, &s);
	return (s);
}

/*
 * dprintf - debug printf.  Only prints
 * if shift-lock key is down.
 */
/*VARARGS1*/
dprintf(fmt, x1)
	char *fmt;
	unsigned x1;
{
	if (((*(char *)0x17b) & 0x2) == 0)
		return;		/* shift lock not down */
	prf(fmt, &x1, 0);
}

#endif

/*
 * Our own NumToString, so we don't pull in all that extra junk.
 */
NumToString(n, st)
	char *st;
{
	char prbuf[20];
	register char *cp = prbuf;
	register char *dp = st;

	if ((int)n < 0) {
		*dp++ = '-';
		n = (unsigned)(-(int)n);
	}
	do {
		*cp++ = "0123456789"[n%10];
		n /= 10;
	} while (n);
	do
		*dp++ = *--cp;
	while (cp > prbuf);
	*dp++ = 0;
}

