;
; Initialization program for North Star single density controller.
;
NTRACK:	EQU	35		; 35 tracks on Shugart SA-400 drive.
	ORG	100H
	PUT	100H
INIT:
	MOV	AH,PRINT	
	MOV	DX,HEADER
	INT	33
	MOV	CX,0A00H	; Size of track in bytes.
	MOV	AL,0E5H		; What to put on the disk.
	MOV	DI,TRACKBUF
	REP			; Fill the buffer.
	STOB
INITLOOP:
	MOV	AH,PRINT
	MOV	DX,WHICHDRIVE
	INT	33
	MOV	AH,INBUF
	MOV	DX,BUFFER
	INT	33
	MOV	AH,OUTPUT
	MOV	DL,10		; Line feed.
	INT	33
	CMP	B,[BUFFER+1],1	; Be sure we got a character.
	JAE	SOMETHING	; Return if nothing typed.
	INT	32		; Program terminate.
SOMETHING:
	MOV	AL,[BUFFER+2]	; Get the character.
	SUB	AL,'A'		; Convert to drive number.
	JB	INITLOOP	; Jump if too small.
	PUSH	AX		; Save drive number.
	MOV	AH,SELDSK	; Find out how many drives there are.
	MOV	DL,-1		; DL = invalid drive number so default
	INT	33		;  drive number isn't disturbed.
	MOV	DL,AL
	POP	AX
	CMP	AL,DL		; See if drive number too big.
	JAE	INITLOOP	; Jump if too big.
	MOV	CX,NTRACK	; Initialize by tracks.
INITTRACK:
	PUSH	CX		; Save track count & drive number.
	PUSH	AX
	MOV	AL,NTRACK	; Compute logical sector number.
	SUB	AL,CL
	MOV	AH,10
	MUL	AL,AH		; AL = AH*10 + AL, AH = 0.
	MOV	DX,AX		; DX = logical sector number.
	POP	AX		; Get drive number.
	PUSH	AX
	MOV	BX,TRACKBUF	; BX = address of what to put on disk.
	MOV	CX,10		; 10 sectors.
	INT	38		; Absolute disk write.
	POP	AX		; Pop flags off stack (put there by the INT
				;  instruction, but not removed by the RET L
				;  instruction at the end of the write routine)
	POP	AX		; Get drive number & track count.
	POP	CX
	JNC	NEXTTRACK	; Sucessful write if CY flag not set.
ERROR:
	MOV	AH,PRINT
	MOV	DX,WERROR
	INT	33
	JP	INITLOOP
NEXTTRACK:
	LOOP	INITTRACK	; Loop till all tracks initialized.
	JP	INITLOOP
;
OUTPUT:	EQU	2		; 86-DOS function numbers.
PRINT:	EQU	9
INBUF:	EQU	10
SELDSK:	EQU	14
;
; Messages.
;
HEADER:	DB	13,10,'Disk initialization for North Star '
	DB	'single density disks.',13,10,10
	DB	'-> Destroys previous contents of entire disk! <-',13,10,10,'$'
WHICHDRIVE:
	DB	'Initialize disk in which drive? $'
WERROR:	DB	'Write protect error.',13,10,'$'
;
BUFFER:	DB	2,0,0,0
TRACKBUF:
	DS	0A00H		; One tracks worth of space.
	END
