  @     	     Name 	 >          make - Maintains, updates, and regenerates groups of >           programs.          Syntax  D          make [-f makefile] [-p] [-i] [-k] [-s] [-r] [-n] [-b] [-e] D            [-t] [-q] [-d] [names]           Description  F          The following is a brief description of all options and some F           special names:     E          -f  makefile  Description filename.  makefile is assumed to E I              be the name of a description file.  A filename of - denotes I H              the standard input.  The contents of makefile override the H 1              built-in rules if they are present. 1    B          -p  Prints out the complete set of macro definitions and B "              target descriptions. "     @     E          -i  Ignores error codes returned by invoked commands.  This E E              mode is entered if the fake target name .IGNORE appears E &              in the description file. &    H          -k  Abandons work on the current entry, but continues on other H 8              branches that do not depend on that entry. 8    J          -s  Silent mode.  Does not print command lines before executing. J G              This mode is also entered if the fake target name .SILENT G .              appears in the description file. .    .          -r  Does not use the built-in rules. .    K          -n  No execute mode.  Prints commands, but does not execute them. K 9              Even lines beginning with an @ are printed. 9                    @  3          -b  Compatibility mode for old makefiles. 3    J          -e  Environment variables override assignments within makefiles. J    F          -t  Touches the target files (causing them to be up-to-date) F 4              rather than issues the usual commands. 4    G          -d  Debug mode.  Prints out detailed information on files and G               times examined.     C          -q  Question.  The make command returns a zero or nonzero C G              status code depending on whether the target file is or is G               not up-to-date.     B         .DEFAULT If a file must be made but there are no explicit B ?              commands or relevant built-in rules, the commands ?                                                    @  F              associated with the name .DEFAULT are used if it exists. F    @         .PRECIOUS Dependents of this target will not be removed @ -              when quit or interrupt are hit. -    .         .SILENT Same effect as the -s option. .    .         .IGNORE Same effect as the -i option. .    A         make executes commands in makefile to update one or more A E         target names.  Name is typically a program.  If no -f option E C         is present makefile is the default file name.  If makefile C F         is -, the standard input is taken.  More than one -f makefile F "         argument pair may appear. "    C         make updates a target only if it depends on files that are C                                                    @  C         newer than the target.  All prerequisite files of a target C E         are added recursively to the list of targets.  Missing files E &         are deemed to be out of date. &    =         makefile contains a sequence of entries that specify = >         dependencies.  The first line of an entry is a blank- > =         separated, nonnull list of targets, then a :, then a = D         (possibly null) list of prerequisite files or dependencies. D E         Text following a ; and all following lines that begin with a E D         tab are shell commands to be executed to update the target. D D         The first line that does not begin with a tab or # begins a D C         new dependency or macro definition.  Shell commands may be C                 @  =         continued across lines with the <backslash><newline> = 6         sequence.  (#) and newline surround comments. 6    B         The following makefile says that pgm depends on two files B ;         a.o and b.o, and that they in turn depend on their ; C         corresponding source files (a.c and b.c) and a common file C          incl.h:                   pgm: a.o b.o  &                   nbcc a.o b.o -o pgm &               a.o: incl.h a.c                     nbcc -c a.c                b.o: incl.h b.c                     nbcc -c b.c     C          Command lines are executed one at a time, each by its own C E          shell.  A line is printed when it is executed unless the -s E                                                    @  E          option is present, or the entry .SILENT: is in makefile, or E A          unless the first character of the command is @.  The -n A F          option specifies printing without execution; however, if the F @          command line has the string $(MAKE) in it, the line is @ F          always executed (see discussion of the MAKEFLAGS macro under F C          Environment).  The -t (touch) option updates the modified C 8          date of a file without executing any commands. 8    D          Commands returning nonzero status normally terminate make. D D          If the -i option is present, or the entry .IGNORE: appears D C          in makefile, or if the line specifying the command begins C                                                       @  E          with <tab><hyphen>, the error is ignored.  If the -k option E A          is present, work is abandoned on the current entry, but A @          continues on other branches that do not depend on that @           entry.     C          The -b option allows old makefiles (those written for the C E          old version of make) to run without errors.  The difference E B          between the old version of make and this version is that B >          this version requires all dependency lines to have a > E          (possibly null) command associated with them.  The previous E =          version of make assumed if no command was specified = /          explicitly that the command was null. /                                                          @  B          Interrupt and quit cause the target to be deleted unless B           .PRECIOUS is on it.          Environment  E          The environment is read by make.  All variables are assumed E =          to be macro definitions and processed as such.  The = E          environment variables are processed before any makefile and E @          after the internal rules; thus, macro assignments in a @ A          makefile override environment variables.  The -e option A E          causes the environment to override the macro assignments in E           a makefile.     D          The MAKEFLAGS environment variable is processed by make as D C          containing any legal input option (except -f, -p, and -d) C                                          @  B          defined for the command line.  Further, upon invocation, B ;          make ``invents'' the variable if it is not in the ; F          environment, puts the current options into it, and passes it F @          on to invocations of commands.  Thus, MAKEFLAGS always @ F          contains the current input options.  This proves very useful F C          for ``super-makes''. In fact, as noted above, when the -n C A          option is used, the command $(MAKE) is executed anyway; A A          hence, one can perform a make -n recursively on a whole A E          software system to see what would have been executed.  This E E          is because the -n is put in MAKEFLAGS and passed to further E                                                            @  F          invocations of $(MAKE).  This is one way of debugging all of F E          the makefiles for a software project without actually doing E           anything.          Macros  F          Entries of the form string1 = string2 are macro definitions. F D          Subsequent appearances of $(string1[:subst1=[subst2]]) are D @          replaced by string2. The parentheses are optional if a @ =          single character macro name is used and there is no = ?          substitute sequence. The optional :subst1=subst2 is a ? E          substitute sequence. If it is specified, all nonoverlapping E B          occurrences of subst1 in the named macro are replaced by B <          subst2.  Strings (for the purposes of this type of <                     @  >          substitution) are delimited by blanks, tabs, newline > D          characters, and beginnings of lines. An example of the use D >          of the substitute sequence is shown under Libraries. >         Internal Macros  F          There are five internally maintained macros which are useful F 1          for writing rules for building targets: 1    ?          $*   The macro $* stands for the filename part of the ? @               current dependent with the suffix deleted.  It is @ 2               evaluated only for inference rules. 2    B          $@   The $@ macro stands for the full target name of the B B               current target. It is evaluated only for explicitly B "               named dependencies. "                         @  D          $<   The $< macro is only evaluated for inference rules or D C               the .DEFAULT rule.  It is the module which is out of C 9               date with respect to the target (i.e., the 9 B               ``manufactured'' dependent filename).  Thus, in the B E               .c.o rule, the $< macro would evaluate to the .c file. E    ?               An example for making .o files from .c files is: ?                        .c.o:  %                         nbcc -c $*.c %                or:                     .c.o:  #                         nbcc -c $< #    A          $?   The $? macro is evaluated when explicit rules from A <               the makefile are evaluated. It is the list of <                                           @  A               prerequisites that are out of date with respect to A C               the target; essentially, those modules which must be C                rebuilt.     C          $%   The $% macro is only evaluated when the target is an C A               archive library member of the form lib(file.o). In A E               this case, $@ evaluates to lib and $% evaluates to the E &               library member, file.o. &    F          Four of the five macros can have alternative forms.  When an F E          upper case D or F is appended to any of the four macros the E C          meaning is changed to ``directory part'' for D and ``file C D          part'' for F.  Thus, $(@D) refers to the directory part of D                                          @  =          the string $@.  If there is no directory part ./ is = C          generated.  The only macro excluded from this alternative C           form is $?.     
     Suffixes 
 A          Certain names (for instance, those ending with .o) have A ?          default dependents such as .c, .s, etc.  If no update ? ?          commands for such a file appear in makefile, and if a ? D          default dependent exists, that prerequisite is compiled to D B          make the target.  In this case, make has inference rules B F          which allow building files from other files by examining the F C          suffixes and determining an appropriate inference rule to C 7          use. The current default inference rules are: 7                              @  D              .c .c~ .sh .sh~ .c.o .c~.o .c~.c .s.o .s~.o .y.o .y~.o D               .x.o .x~.o  4              .y.c .y~.c .x.c .c.a .c~.a .s~.a .h~.h 4    F          The internal rules for make are contained in the source file F C          rules.c for the make program.  These rules can be locally C E          modified.  To print out the rules compiled into the make on E ?          any machine in a form suitable for recompilation, the ? $          following command is used: $    2               make -fp - 2>"dev=null" <"dev=null" 2    B          The only peculiarity in this output is the (null) string B =          which (NBC)printf prints when handed a null string. =    @          A tilde in the above rules refers to an SCCS file (see @      @  E          sccsfile(F)).  Thus, the rule .c~.o would transform an SCCS E D          C source file into an object file (.o).  Because the s. of D C          the SCCS files is a prefix it is incompatible with make's C F          suffix point-of-view.  Hence, the tilde is a way of changing F ?          any file reference into an SCCS file reference.  This ? 3          capability is not implemented for MPX-32. 3    E          A rule with only one suffix (i.e. .c:) is the definition of E B          how to build x from x.c.  In effect, the other suffix is B B          null.  This is useful for building targets from only one B B          source file (e.g., shell procedures, simple C programs). B                                                              @  B          Additional suffixes are given as the dependency list for B C          .SUFFIXES.  Order is significant; the first possible name C A          for which both a file and a rule exist is inferred as a A           prerequisite.               The default list is:     (               .SUFFIXES: .o .c .y .x .s (    A          Here again, the above command for printing the internal A D          rules will display the list of suffixes implemented on the D =          current machine.  Multiple suffix lists accumulate; = F          .SUFFIXES: with no dependencies clears the list of suffixes. F         Inference Rules  5          The first example can be done more briefly: 5                   pgm: a.o b.o                                 @  '                    nbcc a.o b.o -o pgm '                a.o b.o: incl.h     >          This is because make has a set of internal rules for >           building files.  D          The user may add rules to this list by simply putting them D           in the makefile.     C          Certain macros are used by the default inference rules to C B          permit the inclusion of optional matter in any resulting B E          commands.  For example, CFLAGS, LFLAGS, and YFLAGS are used E H          for compiler options to (NBC)nbcc, (NBC)nblex, and (NBC)nbyacc H E          respectively.  Again, the previous method for examining the E '          current rules is recommended. '                                                                        @  E          The inference of prerequisites can be controlled.  The rule E D          to create a file with suffix .o from a file with suffix .c D B          is specified as an entry with .c.o: as the target and no B @          dependents.  Shell commands associated with the target @ B          define the rule for making a .o file from a .c file. Any B C          target that has no slashes in it and starts with a dot is C 8          identified as a rule and not as a true target. 8          Libraries  A          This capability is not currently available in MAKE4MPX. A <          Future releases will provide a simular capability. < ?          See the prototype makefile for handling of libraries. ?                                                      @  D          If a target or dependency name contains parentheses, it is D =          assumed to be an archive library, the string within = E          parentheses referring to a member within the library.  Thus E A          lib(file.o) and $(LIB)(file.o) both refer to an archive A D          library which contains file.o. (This assumes the LIB macro D F          has been previously defined.)  The expression $(LIB)(file1.o F =          file2.o) is not legal.  Rules pertaining to archive = B          libraries have the form .XX.a where the XX is the suffix B E          from which the archive member is to be made. An unfortunate E D          byproduct of the current implementation requires the XX to D                                                           @  D          be different from the suffix of the archive member.  Thus, D D          one cannot have lib(file.o) depend upon file.o explicitly. D F          The most common use of the archive interface follows.  Here, F ;          we assume the source files are all C type source: ;    :               lib: lib(file1.o) lib(file2.o) lib(file3.o) : /                    @echo lib is now up to date /                   .c.a:  )                    $(CC) -c $(CFLAGS) $< ) "                    ar -rv $@ $*.o "                     rm -f $*.o     D          In fact, the .c.a rule listed above is built into make and D B          is unnecessary in this example.  A more interesting, but B @          more limited example of an archive library maintenance @    @            construction follows:     :               lib: lib(file1.o) lib(file2.o) lib(file3.o) : 1                    $(CC) -c $(CFLAGS) $(?:.o=.c) 1 !                    ar -rv lib $? ! 6                    rm $?  @echo lib is now up to date 6                .c.a:;     E          Here the substitution mode of the macro expansions is used. E C          The $?  list is defined to be the set of object filenames C A          (inside lib) whose C source files are out of date.  The A E          substitution mode translates the .o to .c.  (Unfortunately, E F          one cannot as yet transform to .c~) Note also, the disabling F A          of the .c.a: rule, which would have created each object A                                                       @  @          file, one by one.  This particular construct speeds up @ A          archive library maintenance considerably.  This type of A B          construct becomes very cumbersome if the archive library B =          contains a mix of assembly programs and C programs. =    
     Files 
           makefile     
     See Also 
           sh.m, cmprs.m     
     Notes 
 E          Some commands return nonzero status inappropriately; use -i E A          to overcome the difficulty.  Commands that are directly A C          executed by the shell, notably cd, are ineffectual across C E          newlines in make.  The syntax (lib(file1.o file2.o file3.o) E E          is illegal.  You cannot build lib(file.o) from file.o.  The E                        X@  -          macro $(a:.o=.c~) is not available. - D          Command lines MUST begin with the TAB character.  EDIT can D B          not be used to generate a makefile.  If EDT is used, the B B          tab option must be set to emit the TAB character and not B           spaces.     (          (printed 5/7/94 - J B Systems) (                                                                                                                                                                                                                                                                                                                                                                                                                                           