using System;
using System.Collections.Generic;
using System.IO;
using System.Text;

namespace PERQDisk
{
    /// <summary>
    /// Represents a disk Cylinder, which contains one or more Tracks
    /// </summary>
    public class Cylinder
    {
        /// <summary>
        /// Constructs a new Cylinder given a Cylinder ID, the number of
        /// Tracks in this Cylinder, and the number of Sectors per Track.
        /// </summary>
        /// <param name="cylinderID"></param>
        /// <param name="tracks"></param>
        public Cylinder(int cylinderID, int tracks, int sectors)
        {

            if (cylinderID < 0 || tracks < 1 || sectors < 1)
            {
                throw new ArgumentOutOfRangeException("Invalid Cylinder specification.");
            }

            _cylinderID = cylinderID;
            _tracks = tracks;
            _sectors = sectors;

            _trackList = new Track[_tracks];

            CreateTracks();
        }

        public Sector GetSector(int track, int sector)
        {
            if (track < 0 || track >= _tracks)
            {
                throw new ArgumentOutOfRangeException("track");
            }

            return _trackList[track].GetSector(sector);
        }

        public void LoadSector(FileStream fs, int track, int sector)
        {
            if (track < 0 || track >= _tracks)
            {
                throw new ArgumentOutOfRangeException("track");
            }

            _trackList[track].LoadSector(fs, sector);
        }

        private void CreateTracks()
        {
            for (int i = 0; i < _tracks; i++)
            {
                _trackList[i] = new Track(i, _sectors);
            }
        }

        private Track[] _trackList;
        private int _cylinderID;
        private int _tracks;
        private int _sectors;
    }
}
