Module Sleep;

{---------------------------------------
  PERQ Software SLEEP Routines
  Written by: J. Strait
  Capitalization by: R. guggenHeim
  Copyright (C) 1980
  Three Rivers Computer Corporation
  Pittsburgh, Pa. 15217
  --------------------------------------}


EXPORTS
  Procedure Nap(Ticks : integer);         { Sleep for n clock ticks }
  Procedure Sleep(Seconds : integer);     { Sleep for n seconds }

PRIVATE
  Imports IO_Others from IO_Others;

 Procedure Nap{Ticks : integer};
    var T, OldT: Double;
    begin
    if Ticks > 0 then
      begin
      IOGetTime(OldT);
      while Ticks > 0 do
        begin
        IOGetTime(T);
        Ticks := Ticks - T[0] + OldT[0];
        OldT := T
        end;
      end;
    end;
    
 Procedure Sleep{Seconds : integer};
    var i : integer;
    begin
    for i := 1 to Seconds do Nap(60);
    end.
 
 