Program SlideSquare;

Imports SigUtils from SigUtils;
Imports XScreen from XScreen;
Imports SaveWindow from SaveWindow;
Imports FastRandom from FastRandom;

procedure bounce1(win: WinRange; squareSize, numTimes, wait: integer);
var num, x, y, xinc, yinc, i: integer;
    leftx, topy, rightx, bottomy,w,h: integer;
begin
    xinc:=4;
    yinc:=4;
    ChangeWindow(win);
    XSGetUseWindow(win,leftx, topy, w, h);
    Write(FF);
    x:=leftx;
    y:=topy;
    for num := 1 to numTimes do begin
        rasterop(RNot, squareSize, squareSize, x, y, SScreenW, SScreenP,
                                               x, y, SScreenW, SScreenP);
        x:=x+xinc;
        if (x >= leftx+w-1-squareSize) or (x <= leftx) then xinc:=-xinc;
        y:=y+yinc;
        if (y >= topy+h-1-squareSize) or (y <= topy) then yinc:=-yinc;
        for i:=1 to wait do
    end
end;

var i, squareSize, wait, numTimes: integer;
    win: WinRange;
    str: String;
    save: Boolean;
    
begin

If ArgCount <> 6 then
   begin
   WriteLn('** Usage: SlideSquare win# save squareSize wait numTimes');
   exit(SlideSquare);
   end;

NextArgStr(str);  {flush SlideSquare}
NextArgInt(i);
win := i;
NextArgInt(i);
save := RECAST(i, boolean);
NextArgInt(squareSize);
if squareSize < 1 then
  begin
  WriteLn('** SquareSize should be > 1.');
  exit(SlideSquare);
  end;

NextArgInt(wait);
NextArgInt(numTimes);

if save then SaveAndRestoreWindow(win, 'Sliding Square')
else XSRedrawWindow(win, 'Sliding Square');

SetUpRandom;
Bounce1(win, squareSize, numTimes, wait);

end.

const XSIZE = 704;
      YSIZE = 960;

