     
{---------------------------------------------------------------}
{                                                               }
{   Sketch - Perq sketching doodler.                            }
{             J. P. Strait     2 May 80.                        }
{             J. P. Strait    30 Jul 81  Heavily modified.      }
{                                                               }
{---------------------------------------------------------------}


program Sketch;
 
 imports System from System;
 imports IO_Others from IO_Others;
 imports Memory from Memory;
 imports Raster from Raster;
 imports Screen from Screen;
 imports GPIB from GPIB;
 imports FileSystem from FileSystem;
 imports FileUtils from FileUtils;
 imports Transcript from Transcript;
 imports CmdParse from CmdParse;
  
 
 
const None = -1;

      WFirst = 1;
      WBrush = 1;
      WSketch = 2;
      WCmd = 3;
      WInteraction = 4;
      WLast = 4;

      CFirst = 1;
      CDraw = 1;
      CErase = 2;
      CSketch = 3;
      CLine = 4;
      CClear = 5;
      CGet = 6;
      CSave = 7;
      CQuit = 8;
      CFill = 9;
      CMove = 10;
      CCopy = 11;
      CLast = 11;

type Color = (White, Black);
     CursorBits = array[0..63] of array[0..3] of packed array[0..15] of Color;
     pScreenBits = ^ScreenBits;
     ScreenBits = array[0..0] of
                    array[0..47] of packed array[0..15] of Color;
     pCursorBits = ^CursorBits;
     Box = record
             BX, BY, BW, BH: Integer
             end;
     pPnt = ^Pnt;
     Pnt = record
             X, Y: Integer;
             Nxt: pPnt
             end;

var X, Y, OldX, OldY: integer;
    LX1, LY1, LX2, LY2: integer;
    MX, MY, MW, MH: Integer;
    Switch, OldSwitch: boolean;
    Quitting: boolean;
    Mode: (MSketch, MStartLine, MLine, MFill,
           MCopy1, MCopy2, MCopy, MCopyDone,
           MMove1, MMove2, MMove, MMoveDone);
    Func: Integer;
    DrawWithSwitchUp: boolean;
    BrushPattern: FontPtr;
    BrushPosition: array[0..#177] of Box;
    BrushW, BrushH: Integer;
    Brush: record case Integer of
             1: (C: CurPatPtr);
             2: (B: pCursorBits)
             end;
    Window: array[WFirst..WLast] of Box;
    Cmd: array[CFirst..CLast] of Box;
    CursorKind: (ArrowCursor, BrushCursor);
    WhichWindow: Integer;
    WhichBrush: Integer;
    WhichCmd: Integer;
    LastWindow: Integer;
    LastBrush: Integer;
    LastCmd: Integer;
    Buttons: PressRec;
    LErase: Boolean;
    MErase: Boolean;
    MoveSeg, MoveScan: Integer;
    Wait: Boolean;
    FreePnts: pPnt;
    PntSeg: Integer;
    Transcript: Boolean;
    

 procedure Clear;
 begin { Clear }
  with Window[WSketch] do
    RasterOp(RXor, BW, BH, BX, BY, SScreenW, SScreenP,
                           BX, BY, SScreenW, SScreenP)
 end { Clear };

 
 procedure Initialize;
 label 1;
 const CharWidth = 9;
       CharHeight = 13;
 var FontName: String;
     FontId: FileId;
     FontSeg: Integer;
     X, Y, NextY, W, H: Integer;
     C: Char;
     Blocks, Bits, Block: Integer;
     I, J: Integer;
     TName, Option, IgnoreS: String;
   
   
   procedure AddC( C: Integer; S: String );
   begin { AddC }
     Writeln;
     SReadCursor(X,Y);
     Write(S);
     with Cmd[C] do
       begin
         BX := X;
         BY := Y - CharHeight + 1;
         BW := Length(S) * CharWidth;
         BH := CharHeight
       end
   end { AddC };
   
   
 begin { Initialize }
  with Window[WBrush] do
    begin
      BX := 0;
      BW := 100;
      BY := 0;
      BH := 1024 - 200;
      CreateWindow(WBrush, BX, BY, BW, BH, 'Brushes')
    end;
  with Window[WSketch] do
    begin
      BX := 103;
      BW := 768 - 100 - 6;
      BY := 20;
      BH := 1024 - 100 - 20 - 3;
      CreateWindow(WSketch, BX - 3, BY - 20, BW + 6, BH + 20 + 3, 'Sketch')
    end;
  with Window[WCmd] do
    begin
      BX := 0;
      BW := 100;
      BY := 1024 - 200;
      BH := 200;
      CreateWindow(WCmd, BX, BY, BW, BH, 'Command')
    end;
  with Window[WInteraction] do
    begin
      BX := 100;
      BW := 768 - 100;
      BY := 1024 - 100;
      BH := 100;
      CreateWindow(WInteraction, BX, BY, BW, BH, 'Interaction')
    end;
  ChangeWindow(WInteraction);
  RemDelimiters(UsrCmdLine,' ',IgnoreS);
  GetSymbol(UsrCmdLine,IgnoreS,' ',IgnoreS);
  RemDelimiters(UsrCmdLine,' ',IgnoreS);
  GetSymbol(UsrCmdLine,Option,' ',IgnoreS);
  RemDelimiters(UsrCmdLine,' ',IgnoreS);
  GetSymbol(UsrCmdLine,TName,' ',IgnoreS);
  CnvUpper(Option);
  Wait := True;
  if Option = '' then
    begin
      Transcript := False;
      IOCursorMode(TrackCursor);
      Writeln('******* NOT WRITING A TRANSCRIPT *******')
    end
  else
    begin
      if TName = '' then TName := 'Sketch.Transcript';
      Transcript := True;
      if (Option = 'REPLAY') or (Option = 'FAST') then
        if FSLookUp(TName,Blocks,Bits) = 0 then
          begin
            Writeln('**  ', TName, ' not found.');
            Exit(Sketch)
          end
        else
          begin
            Writeln('Replaying transcript ', TName, '.');
            InitTranscript(TName,True);
            Wait := Option <> 'FAST'
          end
      else
        if Option = 'SAVE' then
          begin
            InitTranscript(TName,False);
            Writeln('Writing transcript ', TName, '.')
          end
        else
          begin
            Writeln('** Unknown option ', Option, '.');
            Exit(Sketch)
          end
    end;
  FontName := 'Brush.Kst';
  FontId := FSExtSearch(FSSysSearchList,' .Kst ',FontName,Blocks,Bits);
  if FontId = 0 then
    begin
      Writeln('** ', FontName, ' not found.');
      Exit(Sketch)
    end;
  CreateSegment(FontSeg,Blocks,1,Blocks);
  BrushPattern := MakePtr(FontSeg,0,FontPtr);
  for Block := 0 to Blocks-1 do
    FSBlkRead(FontId,Block,MakePtr(FontSeg,256*Block,pDirBlk));
  WhichWindow := None;
  WhichCmd := None;
  WhichBrush := None;
  New(Brush.C);
  Write(Chr(#012));
  C := Chr(0);
  X := 10;
  Y := 20;
  NextY := Y;
  for C := Chr(0) to Chr(127) do
    with Window[WBrush], BrushPattern^ do
      begin
        with Index[Ord(C)] do
          begin
            RasterOp(RXor,64,64,0,0,4,Brush.C,0,0,4,Brush.C);
            RasterOp(RRpl,Width,Height,0,0,4,Brush.C,
                                       Offset,Line*Height,48,
                                              MakePtr(FontSeg,#404,FontPtr));
            J := Height;
            repeat J := J - 1;
              I := Width;
              repeat
                I := I - 1
              until (I = 0) or
                    (Brush.B^[J][I div 16][15 - I mod 16] = Black)
            until (J = 0) or
                  (Brush.B^[J][I div 16][15 - I mod 16] = Black);
            H := J + 1;
            I := Width;
            repeat I := I - 1;
              J := Height;
              repeat
                J := J - 1
              until (J = 0) or
                    (Brush.B^[J][I div 16][15 - I mod 16] = Black)
            until (I = 0) or
                  (Brush.B^[J][I div 16][15 - I mod 16] = Black);
            W := I + 1;
            if X + W + 3 >= BX + BW - 1 then
              begin
                Y := NextY;
                X := 10;
                if Y + H + 3 >= BY + BW - 1 then
                  begin
                    with BrushPosition[Ord(C)] do
                      begin
                        BX := -1;
                        BY := -1;
                        BW := 0;
                        BH := 0
                      end;
                    goto 1
                  end
              end;
            if Y + H + 6 > NextY then NextY := Y + H + 6;
            with BrushPosition[Ord(C)] do
              begin
                BX := X;
                BY := Y;
                BW := W;
                BH := H;
                RasterOp(RRpl,BW,BH,BX,BY,SScreenW,SScreenP,
                                    0,0,4,Brush.C)
              end;
            X := X + W + 6
          end;
   1: end;
  ChangeWindow(WCmd);
  AddC(CDraw,'Draw');
  AddC(CErase,'Erase');
  AddC(CSketch,'Sketch');
  AddC(CLine,'Line');
  AddC(CFill,'Fill');
  AddC(CCopy,'Copy');
  AddC(CMove,'Move');
  AddC(CClear,'Clear');
(*
  AddC(CGet,'Get');
  AddC(CSave,'Save');
*)
  Writeln;
  Writeln;
  AddC(CQuit,'Quit');
  Quitting := false;
  X := 384;
  Y := 512;
  OldX := X;
  OldY := Y;
  LErase := False;
  MErase := False;
  Switch := TabSwitch;
  OldSwitch := TabSwitch;
  IOSetModeTablet(relTablet);
  IOSetFunction(CTCursCompl);
  IOReadCursPicture(Brush.C,X,Y);
  BrushW := 1;
  BrushH := 1;
  CursorKind := ArrowCursor;
  Mode := MSketch;
  Func := ROr;
  DrawWithSwitchUp := false;
  FreePnts := nil;
  CreateSegment(PntSeg,10,1,10);
  ChangeWindow(WInteraction);
 end { Initialize };


  procedure Draw(Func,x1,y1,x2,y2: integer);
   var x,y,t,dx,dy,d,e,f,xstep,ystep: integer;
   begin
   RasterOp(Func,BrushW,BrushH,X1,Y1,SScreenW,SScreenP,
                               0,0,4,Brush.C);
   x := x1; y := y1;
   
   dx := x2-x1;  dy := y2-y1;
   
   if dx >= 0 then xstep := 1
   else begin
        xStep := -1;
        dx := -dx;
        end;
   if dy >= 0 then ystep := 1
   else begin
        yStep := -1;
        dy := -dy;
        end;
   
   t := dy;
   d := dy-dx;
   f := dx+dy;
   if d >= 0 then begin
                  t := dx;
                  d := dx-dy;
                  end;
   e := 0;
   
   {loop}
   
   while f > 0 do
     begin
     f := f-1;
     if d+e+e+t >= 0 then
        begin
        f := f-1;
        e := d+e;
        y := y+yStep;
        x := x+xStep;
        end
     else begin
          e := e+t;
          if dx >= dy then x := x+ xStep
          else y := y + yStep;
          end;
     RasterOp(Func,BrushW,BrushH,X,Y,SScreenW,SScreenP,
                                 0,0,4,Brush.C);
     end;
   end;
    
    
  procedure Toggle( W, B, C: Integer );
  begin { Toggle }
    if W = WBrush then
      begin
        if B <> None then
          with BrushPosition[B] do
            RasterOp(RNot,BW+4,BH+4,BX-2,BY-2,SScreenW,SScreenP,
                                    BX-2,BY-2,SScreenW,SScreenP)
      end
    else
      if W = WCmd then
        begin
          if C <> None then
            with Cmd[C] do
              RasterOp(RNot,BW+4,BH+4,BX-2,BY-2,SScreenW,SScreenP,
                                      BX-2,BY-2,SScreenW,SScreenP)
        end
  end { Toggle };
  
  
  procedure Track;
  
  
    procedure FindWindow;
    var I: Integer;
        RightX, BottomY: Integer;
    begin { FindWindow }
      for I := WFirst to WLast do
        with Window[I] do
          begin
            RightX := BX + BW - 1;
            BottomY := BY + BH - 1;
            if I = WSketch then
              begin
                RightX := RightX - BrushW;
                BottomY := BottomY - BrushH
              end;
            if (X >= BX) and (X <= RightX) and
               (Y >= BY) and (Y <= BottomY) then
              begin
                WhichWindow := I;
                Exit(FindWindow)
              end
          end;
      WhichWindow := None
    end { FindWindow };
    
    
    procedure FindBrush;
    var I: Integer;
    begin { FindBrush }
      for I := 0 to #177 do
        with BrushPosition[I] do
          if (X >= BX - 2) and (X <= BX + BW + 1) and
             (Y >= BY - 2) and (Y <= BY + BH + 1) then
            begin
              WhichBrush := I;
              Exit(FindBrush)
            end;
      WhichBrush := None
    end { FindBrush };
    
    
    procedure FindCmd;
    var I: Integer;
    begin { FindCmd }
      for I := CFirst to CLast do
        with Cmd[I] do
          if (X >= BX) and (X <= BX + BW - 1) and
             (Y >= BY) and (Y <= BY + BH - 1) then
            begin
              WhichCmd := I;
              Exit(FindCmd)
            end;
      WhichCmd := None
    end { FindCmd };

  
  begin { Track }
    FindWindow;
    if WhichWindow = WSketch then
      begin
        if (CursorKind = ArrowCursor) and (Mode <> MFill) and
           (Mode <> MCopy1) and (Mode <> MCopy2) and (Mode <> MCopy) and
           (Mode <> MCopyDone) and
           (Mode <> MMove1) and (Mode <> MMove2) and (Mode <> MMove) and
           (Mode <> MMoveDone) then
          begin
            IOLoadCursor(Brush.C,0,0);
            CursorKind := BrushCursor;
            if Mode = MSketch then
              begin
                OldX := X;
                OldY := Y
              end
          end
      end
    else
      begin
        if CursorKind = BrushCursor then
          begin
            IOLoadCursor(DefaultCursor,0,0);
            CursorKind := ArrowCursor
          end;
        if WhichWindow = WBrush then FindBrush
        else
          if WhichWindow = WCmd then FindCmd
      end;
    if (LastWindow <> WhichWindow) or
       (LastBrush <> WhichBrush) or
       (LastCmd <> WhichCmd) then
      begin
        Toggle(LastWindow,LastBrush,LastCmd);
        Toggle(WhichWindow,WhichBrush,WhichCmd)
      end
  end { Track };
  
  
  procedure ChangeBrush;
  begin { ChangeBrush }
    if WhichBrush = None then Write(Chr(#007))
    else
      with BrushPosition[WhichBrush] do
        begin
          BrushW := BW;
          BrushH := BH;
          RasterOp(RXor,64,64,0,0,4,Brush.C,0,0,4,Brush.C);
          RasterOp(RNot,BW,BH,0,0,4,Brush.C,
                              BX,BY,SScreenW,SScreenP);
          IOLoadCursor(Brush.C,0,0);
        end
  end { ChangeBrush };
  
  
  procedure DoCmd;
  begin { DoCmd }
    case WhichCmd of
      CDraw: Func := ROr;
      CErase: Func := RAndNot;
      CSketch: Mode := MSketch;
      CLine: Mode := MStartLine;
      CFill: Mode := MFill;
      CMove: Mode := MMove1;
      CCopy: Mode := MCopy1;
      CGet,
      CSave: Write(Chr(#007));
      CClear: Clear;
      CQuit: Quitting := True;
      otherwise: Write(Chr(#007))
      end
  end { DoCmd };
  
  
  procedure FillArea( FX, FY: Integer );
  var Pnts, P: pPnt;
      Desired: Color;
      Scrn: pScreenBits;
      XUpper, XLower: Integer;
      Last: pPnt;
    
    
    procedure NewPnt( var P: pPnt );
    label 1;
    
    
      handler FullSegment;
      begin { FullSegment }
        CreateSegment(PntSeg,10,1,10);
        goto 1
      end { FullSegment };
    
    
    begin { NewPnt }
      1:
      if FreePnts = nil then New(PntSeg,1,P)
      else
        begin
          P := FreePnts;
          FreePnts := P^.Nxt
        end
    end { NewPnt };
    
    
    procedure DisposePnt( var P: pPnt );
    begin { DisposePnt }
      P^.Nxt := FreePnts;
      FreePnts := P
    end { DisposePnt };
    
    
  begin { FillArea }
    {$R-}
    Scrn := Recast(SScreenP,pScreenBits);
    if Func = ROr then Desired := Black else Desired := White;
    NewPnt(Pnts);
    with Pnts^ do
      begin
        X := FX;
        Y := FY;
        Nxt := nil
      end;
    Last := Pnts;
    Scrn^[FY][FX div 16][15 - FX mod 16] := Desired;
    repeat
      FX := Pnts^.X;
      FY := Pnts^.Y;
      XUpper := FX div 16;
      XLower := 15 - FX mod 16;
      if Scrn^[FY+1][XUpper][XLower] <> Desired then
        begin
          NewPnt(P);
          with P^ do
            begin
              X := FX;
              Y := FY + 1;
              Nxt := nil
            end;
          Last^.Nxt := P;
          Last := P;
          Scrn^[FY+1][XUpper][XLower] := Desired
        end;
      if Scrn^[FY-1][XUpper][XLower] <> Desired then
        begin
          NewPnt(P);
          with P^ do
            begin
              X := FX;
              Y := FY - 1;
              Nxt := nil
            end;
          Last^.Nxt := P;
          Last := P;
          Scrn^[FY-1][XUpper][XLower] := Desired
        end;
      if Scrn^[FY][(FX+1) div 16][15 - (FX+1) mod 16] <> Desired then
        begin
          NewPnt(P);
          with P^ do
            begin
              X := FX + 1;
              Y := FY;
              Nxt := Pnts^.Nxt
            end;
          Pnts^.Nxt := P;
          Scrn^[FY][(FX+1) div 16][15 - (FX+1) mod 16] := Desired
        end;
      if Scrn^[FY][(FX-1) div 16][15 - (FX-1) mod 16] <> Desired then
        begin
          NewPnt(P);
          with P^ do
            begin
              X := FX - 1;
              Y := FY;
              Nxt := Pnts^.Nxt
            end;
          Pnts^.Nxt := P;
          Scrn^[FY][(FX-1) div 16][15 - (FX-1) mod 16] := Desired
        end;
      P := Pnts;
      Pnts := P^.Nxt;
      DisposePnt(P)
    until Pnts = nil
    {$R=}
  end { FillArea };
  
  
  procedure XOrBox;
  begin { XOrBox }
    Line(XOrLine,LX1,LY1,LX2,LY1,SScreenP);
    Line(XOrLine,LX2,LY1,LX2,LY2,SScreenP);
    Line(XOrLine,LX2,LY2,LX1,LY2,SScreenP);
    Line(XOrLine,LX1,LY2,LX1,LY1,SScreenP)
  end { XOrBox };
  
  
  procedure MoveStuff;
  var SegSize, T: Integer;
  begin { MoveStuff }
    if (Mode = MMove1) or (Mode = MCopy1) then
      begin
        if Switch and not OldSwitch then
          begin
            LX1 := X;
            LY1 := Y;
            LX2 := X;
            LY2 := Y;
            Mode := Succ(Mode);
            XOrBox
          end
      end
    else
      if (Mode = MMove2) or (Mode = MCopy2) then
        begin
          LX2 := X;
          LY2 := Y;
          if OldSwitch and not Switch then
            begin
              if LX2 < LX1 then
                begin
                  T := LX1;
                  LX1 := LX2;
                  LX2 := T
                end;
              if LY2 < LY1 then
                begin
                  T := LY1;
                  LY1 := LY2;
                  LY2 := T
                end;
              MX := X - LX1;
              MY := Y - LY1;
              MW := LX2 - LX1 + 1;
              MH := LY2 - LY1 + 1;
              MoveScan := (MW + 63) div 63 * 4;  { in words }
              SegSize := (MH * MoveScan + 255) div 255; { blocks }
              CreateSegment(MoveSeg,SegSize,1,SegSize);
              RasterOp(RRpl,MW,MH,
                            0,0,MoveScan,MakePtr(MoveSeg,0,RasterPtr),
                            LX1,LY1,SScreenW,SScreenP);
              if Mode = MCopy2 then
                RasterOp(RXor,MW,MH,
                              X-MX,Y-MY,SScreenW,SScreenP,
                              0,0,MoveScan,MakePtr(MoveSeg,0,RasterPtr));
              OldX := X;
              OldY := Y;
              Mode := Succ(Mode)
            end
          else XOrBox
        end
      else
        if (Mode = MMove) or (Mode = MCopy) then with Window[WSketch] do
          begin
            OldX := X;
            OldY := Y;
            if Switch and not OldSwitch then with Window[WSketch] do
              begin
                if (X-MX >= BX) and (Y-MY >= BY) and
                   (X-MX+MW <= BX+BW) and (Y-MY+MH <= BY+BH) then
                  RasterOp(ROr,MW,MH,
                             X-MX,Y-MY,SScreenW,SScreenP,
                             0,0,MoveScan,MakePtr(MoveSeg,0,RasterPtr));
                Mode := Succ(Mode)
              end
            else
              if (X-MX >= BX) and (Y-MY >= BY) and
                 (X-MX+MW <= BX+BW) and (Y-MY+MH <= BY+BH) then
                RasterOp(RXor,MW,MH,
                              X-MX,Y-MY,SScreenW,SScreenP,
                              0,0,MoveScan,MakePtr(MoveSeg,0,RasterPtr));
          end
        else { MMoveDone or MCopyDone }
          if not Switch then Mode := MSketch
  end { MoveStuff };
            
    
    
    
begin { Sketch }
  Initialize;
  repeat
    LastWindow := WhichWindow;
    LastBrush := WhichBrush;
    LastCmd := WhichCmd;
    OldSwitch := Switch;
    if Transcript then Switch := GetAction(X,Y,Wait,Buttons)
    else
      begin
        Switch := TabSwitch;
        IOReadTablet(X,Y)
      end;
    if (WhichWindow = WSketch) and (Mode = MLine) then
        Line(XOrLine,LX1,LY1,LX2,LY2,SScreenP);
    if (WhichWindow = WSketch) and 
       ((Mode = MMove2) or (Mode = MCopy2)) then XOrBox;
    if (WhichWindow = WSketch) and 
       ((Mode = MMove) or (Mode = MCopy)) then
      with Window[WSketch] do
        if (X-MX >= BX) and (Y-MY >= BY) and
           (X-MX+MW <= BX+BW) and (Y-MY+MH <= BY+BH) then
          RasterOp(RXor,MW,MH,
                        OldX-MX,OldY-MY,SScreenW,SScreenP,
                        0,0,MoveScan,MakePtr(MoveSeg,0,RasterPtr));
    Track;
    case WhichWindow of
      WSketch:   if Mode = MSketch then
                   begin
                     if Switch then Draw(Func,OldX,OldY,X,Y);
                     OldX := X;
                     OldY := Y
                   end
                 else
                   if Mode = MFill then
                     begin
                       if Switch and not OldSwitch then
                         begin
                           FillArea(X,Y);
                           Mode := MSketch
                         end
                     end
                   else
                     if (Mode = MCopy1) or (Mode = MCopy2) or
                        (Mode = MCopy) or (Mode = MCopyDone) or
                        (Mode = MMove1) or (Mode = MMove2) or
                        (Mode = MMove) or (Mode = MMoveDone) then
                       MoveStuff
                     else
                       begin
                         if Switch and not OldSwitch then
                           begin
                             if Mode = MStartLine then
                               begin
                                 OldX := X;
                                 OldY := Y;
                                 Mode := MLine
                               end
                             else
                               begin
                                 Draw(Func,OldX,OldY,X,Y);
                                 OldX := X;
                                 OldY := Y
                               end
                           end;
                         if Mode = MLine then
                           begin
                             Line(XOrLine,OldX,OldY,X,Y,SScreenP);
                             LX1 := OldX;
                             LY1 := OldY;
                             LX2 := X;
                             LY2 := Y
                           end
                       end;
      WBrush:    if Switch and not OldSwitch then ChangeBrush;
      WCmd:      if Switch and not OldSwitch then DoCmd;
      otherwise:
      end
  until Quitting;
  if Transcript then CloseTranscript
end { Sketch }.
