Program Ripple;

Imports SigUtils from SigUtils;
Imports XScreen from XScreen;
Imports SaveWindow from SaveWindow;
Imports FastRandom from FastRandom;

procedure rippler(win: WinRange; numTimes: Integer);
var num, x, y, xinc, yinc: integer;
    leftx, topy, w,h: integer;
begin
    xinc:=4;
    yinc:=4;
    ChangeWindow(win);
    XSGetUseWindow(win,leftx, topy, w, h);
    Write(FF);
    x:=0;
    y:=0;
    for num := 1 to numTimes do begin
        if (x<>0) and (y<>0) then
            rasterop(RNot, x*2, y*2, leftx+w div 2-x, topY+h div 2-y,
                         SScreenW, SScreenP,
                                     leftx+w div 2-x, topY+h div 2-y,
                         SScreenW, SScreenP);
        x:=x+xinc;
        if (x>=w div 2) or (x=0) then xinc:=-xinc;
        y:=y+yinc;
        if (y>=h div 2) or (y=0) then yinc:=-yinc
    end
end;

var i, numTimes: integer;
    win: WinRange;
    str: String;
    save: Boolean;
    
begin

If ArgCount <> 4 then
   begin
   WriteLn('** Usage: Ripple win# save numTimes');
   exit(Ripple);
   end;

NextArgStr(str);  {flush Ripple}
NextArgInt(i);
win := i;
NextArgInt(i);
save := RECAST(i, boolean);
NextArgInt(numTimes);

if save then SaveAndRestoreWindow(win, 'Rippling Rectangles')
else XSRedrawWindow(win, 'Rippling Rectangles');

SetUpRandom;
Rippler(win, numTimes);

end.


const XSIZE = 380;
      YSIZE = 512;
