program Test;

Imports Ether10IO from Ether10IO;
Imports EBuffer from EBuffer;
Imports ELowSends from ELowSends;

Const   Data = 1001;
        Ack  = 1002;
        NAck = 1003;

Type    pStr = ^String;

Var     SendBuf,  RecBuf,  AckBuf:  pEtherBuffer;
        SendHead, RecHead, AckHead: pEtherHeader;
        SendStat, RecStat, AckStat: pEtherStatus;
        AdRec: pEtherAdRec;
        MyAddress, HisAddress, BroadcastAddress: EtherAddress;
        Rec_Command: EtherCommand;

Procedure printaddr (ea: EtherAddress; s: String);

        Begin
        with ea do
            writeln (s, High:1, ', ', Mid:1, ', ', Low:1, '.');
        End;

Function EquAddress (a, b: EtherAddress): Boolean;

        Begin
        EquAddress := (a . High = b . High) and (a . Mid = b . Mid) and
                (a . Low = b . Low);
        End;

Function Swab (i: Integer): Integer;

        Begin
        Swab := LOR (Shift (i, -8), Shift (i, 8));
        End;

Handler E10ReceiveDone (stat: pEtherStatus);

        Handler E10ReceiveDone (stat: pEtherStatus);

                Begin
                writeln;
                writeln ('**** BOGUEOUT!!! ****');
                writeln ('Got a second receive when we only posted one.');
                End;

        Var     PacketOK: Boolean;

        Handler E10DByteError;

                Begin
                writeln ('Bad number of bits in received packet.');
                PacketOK := False;
                End;

        Label   1, 2;

        Var     Bytes: Integer;
                sbuf: pStr;

        Begin
        if stat <> RecStat then
            begin
            writeln ('**** BOGUEOUT!! ****');
            writeln ('Received packet status not RecStat.');
            Goto 2;
            end;
        PacketOK := True;
        with RecHead^ do
            begin
            if EquAddress (Dest, BroadcastAddress) then
                begin
                Goto 1;
                end;
            if not EquAddress (Dest, MyAddress) then
                begin
                Goto 1;
                end;
            if not EquAddress (Src, HisAddress) then
                begin
                printaddr (Src, 'Received packet from ');
                PacketOK := False;
                end;
            end;
        Bytes := E10DataBytes (stat^ . BitsRecv);
        if PacketOK then
          Case RecHead^ . EType of
            Data: begin
                sbuf := ReCast (RecBuf, pStr);
                write ('Received string:  ');
                writeln (sbuf^);
                AckHead^ . EType := Ack;
                SendNoAck (AckHead, AckBuf, AckStat, MinDataBytes)
                end;
            Ack: begin
                ELS_Receive (RecHead^ . Src, 1, True);
                end;
            NAck: begin
                ELS_Receive (RecHead^ . Src, 1, False);
                end;
            Otherwise: begin
                writeln ('Received packet with unknown type.');
                PacketOK := False;
                end;
            end;
        if not PacketOK then
            begin
            with RecHead^ do
                begin
                printaddr (Src, 'Src is ');
                printaddr (Dest, 'Dest is ');
                writeln ('Type is ', EType:1);
                end;
            with RecStat^ do
                begin
                writeln ('CRCError is ', CRCError);
                writeln ('Collision is ', Collision);
                writeln ('RecvTrans is ', RecvTrans);
                writeln ('Busy is ', Busy);
                writeln ('ClockOver is ', ClockOver);
                writeln ('PIP is ', PIP);
                writeln ('Carrier is ', Carrier);
                writeln ('RetryTime is ', RetryTime:1);
                writeln ('SendError is ', SendError);
                writeln ('CmdInProg is ', CmdInProg);
                writeln ('BitsRecv is ', BitsRecv:1);
                writeln ('Bytes is ', Bytes:1);
                end;
            end;
1:      E10IO (Rec_Command, RecHead, RecBuf, RecStat, MaxDataBytes);
2:      End;

Var     sbuf: pStr;

Begin
writeln ('Timeout in 5 seconds with 5 retries.');
ELS_Init (5, 3);
EB_Alloc (3, AdRec);
EB_Buffers (SendHead, SendBuf, SendStat);
EB_Buffers (AckHead, AckBuf, AckStat);
EB_Buffers (RecHead, RecBuf, RecStat);
writeln ('Buffers Allocated.');
E10Init;
MyAddress := E10GetAdr;
with MyAddress do
    begin
    High := Swab (High);
    Mid := Swab (Mid);
    end;
printaddr (MyAddress, 'My address is ');
HisAddress := MyAddress;
with HisAddress do
    begin
    write ('What is his machine number? ');
    readln (Low);
    end;
printaddr (HisAddress, 'His address is ');
with AdRec^ do
    begin
    LowAddress := MyAddress . Low;
    MCB := MltCstNone;
    end;
E10Reset (AdRec);
writeln ('Reset Ethernet.');
Rec_Command := EReceive;
sbuf := ReCast (SendBuf, pStr);
with SendHead^ do
    begin
    Src := MyAddress;
    Dest := HisAddress;
    EType := Data;
    end;
with AckHead^ do
    begin
    Src := MyAddress;
    Dest := HisAddress;
    end;
E10IO (Rec_Command, RecHead, RecBuf, RecStat, MaxDataBytes);
writeln;
repeat
    write ('Send? ');
    readln (sbuf^);
    if sbuf^ <> 'quit' then
        begin
        case SendWAck (SendHead, SendBuf, SendStat, MaxDataBytes, 1) of
            SWA_Received: writeln ('Message received.');
            SWA_Timeout:  writeln ('Timed out--not received.');
            SWA_Error:    writeln ('Send-within-send.');
            Otherwise:    writeln ('Illegal return value from SendWAck');
            end;
        end;
    until sbuf^ = 'quit';
E10Reset (AdRec);
End.

