MODULE Commands ;
EXPORTS

PROCEDURE ComLine (var outchan : text);
PROCEDURE Do_Command (commandstring : string;
                      var inchan : text;
                      prompt : string;
                      var realoutchan : text);
PROCEDURE CommandLoop (prompt : string; var inchan : text; var outchan : text);

PRIVATE {****************************************************************}
IMPORTS CmdParse FROM CmdParse;
IMPORTS System FROM System;


FUNCTION AquireArg (num : integer) : string;
{ reads the command line and returns the NUMth argument,
  with the 0th argument being the command name. }
var
    i : integer;
    workstr, tempstr, curSymbol : string;
begin
    workstr := UsrCmdLine;
    curSymbol := '';
    for i := 0 to num do begin
        GetSymbol (workstr, curSymbol, ' ,', tempstr);
        RemDelimeters (workstr, ' ,', tempstr);
    end;
    AquireArg := curSymbol;
end;

PROCEDURE ComLine (var outchan : text);
VAR
    infile : string;
    inchan : text;
BEGIN
    { get input source and call evaluation routine }
    infile := AquireArg (1);
    if (length (infile) > 0) then BEGIN
        writeln ('COMMAND INPUT FILE IS ', infile);
        reset (inchan, infile);
        CommandLoop ('CF> ', inchan, outchan);
    END;
END;

PROCEDURE Do_Command (commandstring : string;
                      var inchan : text;
                      prompt : string;
                      var realoutchan : text);
VAR
    ch : char;
    tempstr : string;
    inchan2 : text;
{    i, num, link : integer;
    a, b, c : integer;
    longnum, longi : long;
    thisscore, bestscore : integer;
    outchan, inchan2 : text;
    instr, outstr : string;
    count : integer;
    pointThreshold : integer;
}
begin
    if (length (commandstring) <> 0) then ch := commandstring[1]
    else ch := 'h';

    case ch of 
        'h' : writeln ('The commands really are ''hq><@''');

        'q' :
            BEGIN
                Writeln ('Quitting...');
{                Exit (foo procedure);}
            END;
        '>':
            BEGIN
                writeln ('Redirect output, ARE YOU SURE YOU WANT TO DO THIS');
                readln (inchan, tempstr);
                if (length (tempstr)>0) then if (tempstr[1] = 'y') then begin
                    writeln ('Enter the name of the output file');
                    readln (inchan, tempstr);
                    writeln ('Be sure to use a matching ''<'' command');
                    close (realoutchan);
                    rewrite (realoutchan, tempstr);
                end;
            END;

        '@':
            BEGIN
                writeln ('Get Input from command file');
                writeln ('Enter the name of the command file');
                readln (inchan, tempstr);
                writeln ('taking commands from file ''', tempstr, '''.');
                reset (inchan2, tempstr);
                CommandLoop ('T>> ', inchan2, realoutchan);
                close (inchan2);
            END;
        '<':
            BEGIN
                close (realoutchan);
                rewrite (realoutchan, 'console:');
{                exit (tempest);}
            END;


        otherwise : writeln ('The commands are ''hq><@''');
    end;
end;

PROCEDURE CommandLoop (prompt : string; var inchan : text; var outchan : text);
{    CommandLoop ('T> ', input, output); {example call}
var
    continue : boolean;
    commandstring : string;
begin
    writeln ;
    write (prompt);
    while (not eof (inchan)) do begin
        readln (inchan, commandstring);
        if (length (commandstring) <> 0) then begin
            Do_Command (commandstring, inchan, prompt, outchan);
        end;
        writeln ;
        write (prompt);
    end;
end.
{ }
