module PaneSelect;

(***********************************************************************
 *
 *    AUTHOR: Lee Iverson
 *    ABSTRACT:
 *      This module implements the selection of various borders and
 *      intersection points for the panes defined in the PaneViewport.
 *
 *    -----------
 *    CHANGE LOG:
 *      Jun 27 1984     Lee Iverson     ** Created **
 *
 ***********************************************************************)

exports

imports SapphDefs from SapphDefs;
imports PaneGlobs from PaneGlobs;

type
  (* Type of selection made *)
  SelType = ( VertLine, HorizLine, Point, Aborted );
  Selection = record
                case t: SelType of
                  Aborted:   ();
                  Point:     (ul, ur, dl, dr: pPane);
                  VertLine:  (left, right: pPane);
                  HorizLine: (above, below: pPane)
              end {SelRecord};

procedure
  askNewPane(
    var sel: Selection;
    var rect: PnRectangle;
    var newPn: pPane
  );

(***********************************************************************
 *
 *      AUTHOR: Lee Iverson
 *      ABSTRACT:
 *        Ask the user for the size and position of a new pan, then
 *        resize the other panes effected (those covered are Iconized)
 *        and place the new information in the structure pointed to
 *        by newPn.
 *
 ***********************************************************************)

procedure
  ReshapeSelect(
    var sel: Selection;
    var endPt: PnPoint
  );

(***********************************************************************
 *
 *    AUTHOR: Lee Iverson
 *    ABSTRACT:
 *      This function asks the user to define a reshaping operation on
 *      the screen's panes.  It calls each changed screen's Resize
 *      routine so they may refresh themselves.
 *
 ***********************************************************************)

private

{$include PaneSelect.impl}.

