module PaneCursors;

(***********************************************************************
 *
 *    AUTHOR: Lee Iverson
 *    ABSTRACT:
 *      This module deals with the cursors used by the Panes manager.
 *
 *    -----------
 *    CHANGE LOG:
 *      Jun 26 1984     Lee Iverson     ** Created **
 *
 ***********************************************************************)

exports

type
  PaneCurs = ( cursNormal, cursSelLine, cursMoveH, cursMoveV,
               cursMvPnt1, cursMvPnt2, cursMvPnt3, cursMvPnt4, cursMvPnt5,
               cursWait, cursMenu, cursListener, cursGrow, cursIconize,
               cursCancel, cursCnclMv );

procedure
  CursOutside(
        curs: PaneCurs
  );

 (***********************************************************************
  *
  *   AUTHOR: Lee Iverson
  *   ABSTRACT:
  *     Sets the cursor for all outside regions to the value provided.
  *
  ***********************************************************************)

procedure
  GetCursor(
        reg: Integer;
    var curs: PaneCurs
  );

(***********************************************************************
 *
 *      AUTHOR: Lee Iverson
 *      ABSTRACT:
 *        Get the cursor that is set for the specified pane manager
 *        region.
 *
 ***********************************************************************)

procedure
  InitPaneCursors;

(***********************************************************************
 *
 *      AUTHOR: Lee Iverson
 *      ABSTRACT:
 *        Initialize the cursors needed for the pane manager.
 *
 ***********************************************************************)

procedure
  SetCursor(
    reg: Integer;
    curs: PaneCurs
  );

(***********************************************************************
 *
 *      AUTHOR: Lee Iverson
 *      ABSTRACT:
 *        Set the cursor for the pane manager's region.
 *
 ***********************************************************************)

private

{$include PaneCursors.impl}.

