module pasmac2;
{++}
{ abstract: routines for the scanner
{--}

{++}
{ history in pasmac.p
{--}

EXPORTS

imports pasmac1 from pasmac1;


procedure capitalize (var c: char);
procedure error(n:errornum);  
procedure writefile(c:char);
procedure writeinfo(bnds:bndpnt;sourcechunk:chunkpnt; var destchunk:chunkpnt;
                    source:getplace; dest:putplace);
function chunktobody(c:chunkpnt):bndpnt;
procedure idstring(b:bndpnt; var id:ident);
procedure gettoken(var c:chunkpnt; p:putplace);

PRIVATE

(*
function aexpr:integer;forward;
function arithbool(var bool:boolean;var int:integer):boolorint;forward;
procedure prmassign;forward;
function readparam:chunkpnt;forward;
procedure prmvardef(isglobal:boolean);forward;
procedure prmif(var c:chunkpnt;p:putplace);forward;
procedure prmexp(var c:chunkpnt;p:putplace);forward;
procedure callmacro(t:tabpnt;r:readplace;p:putplace;var c:chunkpnt);forward;
*)

(* This function de-capitalizes, contrary to its name *)
procedure capitalize (* var c: char *);
begin
if ((c >= 'A') and (c <= 'Z')) then c := chr(ord('a') + (ord(c)-ord('A')))
end;


procedure errorline;
var i : integer;
    scratch : string [255];

begin

  (* LWE 3/14/80: try to get the whole line out at once instead of *)
  { dzg - Perq Pascal string hacking }
  {$R-}
  { dzg - the following statement caused a Perq Pascal error message;
  had to use a recast, because column is NOT integer - it is bound! }
  for i := linebnd^.first to recast(column[filenum],integer) do
          scratch[i-linebnd^.first+1] :=  filelin[filenum ,i];
  scratch[0] := chr (column[filenum]-linebnd^.first+1);
  writeln(tty,scratch);
  for i := column[filenum]+1 to linebnd^.last do
          scratch[i-linebnd^.first+1] := filelin[filenum,i];
  scratch[0] := chr (linebnd^.last -column[filenum]);
  writeln(tty,scratch);
  {$R+}
  {  dzg   - changed the call to "halt" with a message  }
  writeln(tty,'---- unclean internal status - cannot continue');
end;

procedure error(* n:errornum *);  
(*error message procedure. depending the number of the error, print out
  1) the number of the error
  2) the error message
  3) the line being read from the source file when the error occurred. 
        (note that the line is broken in two, at the point where the
         error occurred) *)
(* dzg - changed scratch to a Perq Pascal string *)
(* scratch: array[linsize] of char;  *)
var scratch: string[255];
var i:integer;
begin (* LWE 3/11/80 Hacked in bogus message statement to get to Channel 2.*)
writeln(tty,'error number: ',n);
case n of
  1: writeln(tty,'integer overflow');
  2: writeln(tty,'unbalanced parentheses');
  3: writeln(tty,'incorrect token type in arithmetic expression');
  4: writeln(tty,'improper form of arithmetic expression');
  5: writeln(tty,'left parenthesis expected on string comparison');
  6: writeln(tty,'right parenthesis expected on string comparison');
  7: writeln(tty,'boolean expression expected after "not"');
  8: writeln(tty,'incorrect token type in boolean expression');
  9: writeln(tty,'incorrect operand type given to  "and"');
  10:writeln(tty,'incorrect operand type given to "or"');
  11:writeln(tty,'unmatched operand types in boolean relation');
  12:writeln(tty,'arithmetic expression where boolean expression expected');
  13:writeln(tty,'improper form of boolean expression');
  14:writeln(tty,'nesting too deep on minclude calls ( >8 )');
  15:writeln(tty,'left parenthesis expected on minclude');
  16:writeln(tty,'right parenthesis expected on minclude');
  17:writeln(tty,'unexpected macro time reserved word');
  18:writeln(tty,'left parenthesis expected on macro call');
  19:writeln(tty,'"mbegin" or "mvar" expected');
  20:writeln(tty,'"mbegin" expected');
  21:writeln(tty,'"mfi" expected');
  22:writeln(tty,'name of macro must be an identifier');
  23:writeln(tty,'name of a formal parameter must be an identifier');
  24:writeln(tty,'too many parameters for macro  ( >',maxparno,')');
  25:writeln(tty,'macro type expected');
  26:writeln(tty,'; or ) expected');
  27:writeln(tty,'; expected');
  28:writeln(tty,'illegal to reuse global macro or mvar names');
  29:writeln(tty,'name of mvar must be an identifier');
  30:writeln(tty,'illegal to use same names for local mvar and formal parameter');
  31:writeln(tty,': expected');
  32:writeln(tty,':= expected');
  33:writeln(tty,'left parenthesis expected on massign');
  34:writeln(tty,'name of mvar expected');
  35:writeln(tty,'no such mvar found');
  36:writeln(tty,'cannot assign to macro');
  37:writeln(tty,', expected');
  38:writeln(tty,'left parenthesis expected on mexp call');
  39:writeln(tty,'incorrect file specification in minclude');
  40:writeln(tty,'macro body over limit of ', maxmac);
  41:writeln(tty,'knowcomment is false! contact maintainer.');
  42:writeln(tty,'unmatched right curly comment delimiter found (i.e. "}")');
  43:writeln(tty,'unexpected end of file - possibly unterminated string');
  end;
errorline;
end;


procedure writefile(* c:char *);

(*write the character c to the output file*)

begin
if c='' then       (*  is used by the program to represent crlf *)
   writeln(output)
else
   write(output,c);
end;


procedure writeinfo(* bnds:bndpnt;sourcechunk:chunkpnt; var destchunk:chunkpnt;
                    source:getplace; dest:putplace *);

(*this procedure copies characters from a source to a destination. because
  of the various possible sources and destinations, various parameters
  are needed. often dummy variables will be passed to this procedure if
  all parameters are not applicable.
  
  if the source is an array, bnds will be a pointer to a record containing
  the numbers of the first and last character to be read. if the source is
  a chunk or chunk list, sourcechunk will contain a pointer to the first
  chunk to be read. if the destination is a chunk, destchunk will be a pointer
  to a chunk or chunklist in which the appropriate characters were written.
  if the destination is an array or a file, the characters will simply be
  appended to the end of that array or file.
 
  source and dest are parameters representing the source and destination
  location types. source may be [work,body,trfal,intexp,chk,line] and
  dest may be [out,fnam,work,body,chk,nowhere].*)

var
  i:integer;      (* counter of character position *)
  c:char;         (* character read from source *)
  done:boolean;   (* done reading from source *)
  t1chunk,t2chunk:chunkpnt;  (* chunkpointers used for traversing or building
                                a chunk list *)


begin
done := false;

(*initialize value of i*)
if bnds <> nil then  (* source is not chk *)
   i := bnds^.first
else                 (* source is chk *)
   begin
   if source<>chk then writeln(output,'error writeinfo');
   i := 1;
   end;

if dest=chk then     (*if destination is chunk, initialize destchunk if it nil,
                       otherwise, move to the position of its last character,
                       so that writing will begin at the right point*)
   begin
   if destchunk=nil then
      begin
      new(destchunk);
      destchunk^.pos := 0;
      destchunk^.nxt := nil;
      t1chunk := destchunk;
      end 
   else
      begin
      t1chunk := destchunk;
      while t1chunk^.nxt <> nil do t1chunk := t1chunk^.nxt;
      end;
   end;



(*writeinfo continued*)
while not done do
   begin  (*get next character from source*)
   case source of
       work: c := workarea[i];
       body: c := macbodyptr^[i];
       trfal:c := truefalse[i];
       intexp:c:= intexparea[i];
       chk : c := sourcechunk^.arr[i];
       line: c := filelin[filenum,i]
   end;

   (*check to see if we have reached the end of the source*)
   if (source = chk) then  
      while (i >= sourcechunk^.pos) and (not done) do
         if sourcechunk^.nxt = nil
           then done := true
           else
              begin
                sourcechunk := sourcechunk^.nxt;
                i := 0
              end;
   i := i+1;  (*update i so that it looks at the next character*)
   if (bnds <> nil) then 
      if (i>bnds^.last) then done := true;

   case dest of          (*write c to the destination*)
       out: writefile(c);
       fnam:write(filnames,c);
       work:begin
            workarea[workend] := c;
            workend := workend+1;
            end;
       body:begin
            macbodyptr^[bodyend] := c;
            if (bodyend + 1) > maxmac
              then error(40)
              else bodyend := bodyend+1;
            end;
       chk: begin
            if t1chunk^.pos = maxchunk then (*need to add new chunk to chunklist*)
                begin
                new(t2chunk);
                t1chunk^.nxt := t2chunk;
                t1chunk := t1chunk^.nxt;
                t1chunk^.pos := 1;
                t1chunk^.nxt := nil;
                end
            else
                t1chunk^.pos := t1chunk^.pos + 1;
            t1chunk^.arr[t1chunk^.pos] := c;
            end;
       nowhere:
       end;
   end;
end;


function chunktobody(* c:chunkpnt :bndpnt *);

(*write the characters in a chunklist pointed to by c to the end of
  the body array, and return a pointer to a bnd record containing the
  the numbers of the first and last characters written into the array.
  this function is used to copy the string value of an mvar of type
  mstring into the global body array for permanent keeping. the chunk
  array, used to temporarily store this  string may be disposed of.*)

var
   b1,b2:integer;(* temporaries containing first and last position in body array*)
   bnd:bndpnt;   (* the pointer to be returned*)
begin
if dotrace then writeln(output,'chunktobody');
b1 := bodyend;
writeinfo(nil,c,dummychunk,chk,body);
b2 := bodyend-1;
dispose(c);   (* dispose of the the chunk array, since it is no longer needed*)
new(bnd);
bnd^.first := b1;
bnd^.last := b2;
chunktobody := bnd;
end;


procedure idstring(* b:bndpnt; var id:ident *);

(*take the string 'pointed' to by the boundary record pointer b, which
exists within the workarea array (i.e. is a token just read in), and
convert it into  a string of maxidlen characters, padding on the right
with any necessary blanks. the resulting string is of type ident and
is returned in the var parameter id.*)

var
   pos,i:integer;
begin
pos := b^.first;
for i := 1 to maxidlen do
   begin
   if pos > b^.last then
      id[i] := ' '   
   else
      begin
      id[i] := workarea[pos];
      pos := pos+1;
      end;
   end;
end;


procedure gettoken(* var c:chunkpnt; p:putplace *);

(*this is a very important procedure which reads in tokens from the
current place being  read from (either a file, a linked list of "chunk"
records, or the macbody array). the tokens are classified and 
various global parameters are set. if the place we are reading from
becomes exhausted, the boolean done will be set to true and procedure
will quit and return whatever it has read in so far. otherwise, the
procedure will read in tokens of expected form only.
 
the procedure operates in the following way:
  first, all blanks and carriage return-linefeeds are read in and placed
into the workarea array and pointed to by blanks. if any such blanks
and crlf's have been found, a global boolean haveblanks is  set to true.
  next, a token will be read in. token types range from reserved words,
macro time keywords, identifiers, integers, reals, strings, to several
one-character tokens such as plustok, multtok, etc. this token is also
read into the workarea array, and pointed to by global newtok. if such
a token has been found, a global boolean havetok is set to true. the type
of the new token is specified by the global newtoktype, and if the token
type is a macro key word, the global  newmkeytype will specify which
macro key word, in particular, has been found.
  if a comment is found while reading in these blanks and tokens, it
is immediately output to the place specified by the parameter p. since
this place might be a chunk, the var parameter c is passed in order that
this chunk may be written into with appropriate effects. 
  if reading in a token involves reading in one character ahead, this
information will be transmitted via the global havelookahead. this will
notify the next call of gettoken that it need not read in the first
character that it needs. it will already be in the global ch.  *)
 
var 
   done:boolean;
 
procedure getchar;forward;


procedure readfile;
(*this procedure reads in the next character from a file into the global
character varible, ch. the file read from will depend on the global
filenum, which is set by the minclude procedure. because of the limitations
on the usage of file variables in pascal, this procedure is admittedly
clumsy. note that entire lines are read in at a time and stored in global
array filelin *)
var 
  iseof:boolean;   (* indicates that we have reached the end of the file *)
  oldfnum:integer; (* the file number we start off with *)
begin
iseof := false;
if column[filenum] = linlen[filenum] then  (* we are at the end of a line *)
   begin
   oldfnum:= filenum;
   case filenum of    (*test to see if we have reached end-of-file*)
      0:if eof(input) then   (* if we exhaust file no. 0 (the input file) *)
         begin               (* we are done macroprocessing and the global*)
         iseof := true;      (* endmac indicates this fact.               *)
         endmac := true;
         done := true;
         end;
      1:if eof(file1) then   (* if we exhaust any of files 1 through 8, then *)
         begin               (* we simply pop the relevant file number back 1.*)
         iseof := true;
         filenum := filenum-1;
         end;
      2:if eof(file2) then
         begin
         iseof := true;
         filenum := filenum-1;
         end;
      3:if eof(file3) then
         begin
         iseof := true;
         filenum := filenum-1;
         end;
      4:if eof(file4) then
         begin
         iseof := true;
         filenum := filenum-1;
         end;
      5:if eof(file5) then
         begin
         iseof := true;
         filenum := filenum-1;
         end;
      6:if eof(file6) then
         begin
         iseof := true;
         filenum := filenum-1;
         end;
      7:if eof(file7) then
         begin
         iseof := true;
         filenum := filenum-1;
         end;
      8:if eof(file8) then
         begin
         iseof := true;
         filenum := filenum-1;
         end
      end;


   if oldfnum <> filenum then (*we've been bounced back*)
      begin
      if inclusion[inctop-1] = wasbody then (* if we were reading from the *)
         begin                              (* body array before minclude was *)
         currplace := bodyarray;            (* done, then read from body where*)
         currbodypos := inclusion[inctop-2];(* we left off from. *)
         bodyextent := inclusion[inctop-3];
         inctop := inctop-3;
         getchar;
         end
      else
         begin                  (* if we were reading from a file before the *)
         inctop := inctop-3;    (* minclude was performed, then just read from *)
         currplace := afile;    (* the previous file *)
         readfile;
         end;
      end;

   if not iseof then (* read in a new line *)
      begin
      linlen[filenum] := 0;
      column[filenum] := 0;
      case filenum of

      0:while not eoln(input) do
         begin
         linlen[filenum] := linlen[filenum]+1;
         read(input,ch);
         filelin[filenum,linlen[filenum]] := ch;
         end;
      1:while not eoln(file1) do
         begin
         linlen[filenum] := linlen[filenum]+1;
         read(file1,ch);
         filelin[filenum,linlen[filenum]] := ch;
         end;
      2:while not eoln(file2) do
         begin
         linlen[filenum] := linlen[filenum]+1;
         read(file2,ch);
         filelin[filenum,linlen[filenum]] := ch;
         end;
      3:while not eoln(file3) do
         begin
         linlen[filenum] := linlen[filenum]+1;
         read(file3,ch);
         filelin[filenum,linlen[filenum]] := ch;
         end;
      4:while not eoln(file4) do
         begin
         linlen[filenum] := linlen[filenum]+1;
         read(file4,ch);
         filelin[filenum,linlen[filenum]] := ch;
         end;
      5:while not eoln(file5) do
         begin
         linlen[filenum] := linlen[filenum]+1;
         read(file5,ch);
         filelin[filenum,linlen[filenum]] := ch;
         end;


      6:while not eoln(file6) do
         begin
         linlen[filenum] := linlen[filenum]+1;
         read(file6,ch);
         filelin[filenum,linlen[filenum]] := ch;
         end;
      7:while not eoln(file7) do
         begin
         linlen[filenum] := linlen[filenum]+1;
         read(file7,ch);
         filelin[filenum,linlen[filenum]] := ch;
         end;
      8:while not eoln(file8) do
         begin
         linlen[filenum] := linlen[filenum]+1;
         read(file8,ch);
         filelin[filenum,linlen[filenum]] := ch;
         end
      end;

      (* absorb end of line marker *)
      linlen[filenum] := linlen[filenum] + 1;
      filelin[filenum,linlen[filenum]] := ''; (*crlf is represented by  *)
      case filenum of    (* set up file 'cursor' to look at the next line *)
        0:readln(input);
        1:readln(file1);
        2:readln(file2);
        3:readln(file3);
        4:readln(file4);
        5:readln(file5);
        6:readln(file6);
        7:readln(file7);
        8:readln(file8)
      end;
      linebnd^.first := 1;              (* the new line read in will be pointed *)
      linebnd^.last := linlen[filenum]; (* to by global linebnd *)
      if dotrace then 
         begin writeln(output,'newline in: ');
               writeinfo(linebnd,nil,dummychunk,line,out);
               writeln(output);
         end;
      end;
   end;

if not iseof then   (* if there was no end-of-file reached, set ch to the *)
   begin            (* next input character  in the filelin array         *)
   column[filenum] := column[filenum]+1;
   ch := filelin[filenum,column[filenum]];
   end
else 
if done then ch := '#';
end;


procedure getchar;

(* this procedure reads in the next character from any of the three possible
'reading' places: a file, a chunk list, or the bodyarray. if reading is from
a chunk, this chunk will always be the global chunk globalchunk.*)

begin
case currplace of
   afile: readfile;
   charray: begin
            if (currchunkpos > globalchunk^.pos) and (globalchunk^.nxt=nil) then
               done := true   (* we have hit end of the chunk array *)
            else   
               begin
               if currchunkpos > globalchunk^.pos then  (* move on to next chunk *)
                  begin
                  globalchunk := globalchunk^.nxt;
                  currchunkpos := 1;
                  end;
               ch := globalchunk^.arr[currchunkpos];
               end;
            currchunkpos := currchunkpos + 1;
            end;
   bodyarray:begin
             if currbodypos > bodyextent then (*have exhausted what we wish to *)
                done := true                  (*read from the body array*)
             else
                ch := macbodyptr^[currbodypos];
             currbodypos := currbodypos + 1;
             end
end;
if done then
   ch := '';
end;


procedure getnumber;

(* this procedure reads in an unsigned integer or real and sets the
token type appropriately. *)

begin
newtoktype := inttok;

repeat
   begin
   workarea[workend] := ch;
   workend := workend+1;
   getchar;
   end
until not (ch in ['0'..'9']);
 
if (ch='.') or (ch='e') then
   begin
   newtoktype := realtok;
   workarea[workend] := ch;
   workend := workend+1;
   getchar;
   repeat
      begin
      workarea[workend] := ch;
      workend := workend+1;
      getchar;
      end
   until not(ch in ['0'..'9']);
   end;
 
if not done then
   havelookahead := true;
newtok^.last := workend-1;
end;


procedure getspec(c:char);

(* this procedure sets up a new token containing the character c, and sets
the token type appropriately *)

begin
workarea[workend] := c;
newtok^.last := workend;
workend := workend+1;
case c of
  '''':newtoktype := squotetok;
  '(' :newtoktype := lparentok;
  ':' :newtoktype := colontok;
  '<' :newtoktype := lesstok;
  '>' :newtoktype := grttok;
  '&' :newtoktype := amptok;
  ';' :newtoktype := semitok;
  ',' :newtoktype := commatok;
  '[' :newtoktype := lbracktok;
  ']' :newtoktype := rbracktok;
  ')' :newtoktype := rparentok;
  '*' :newtoktype := multtok;
  '+' :newtoktype := plustok;
  '-' :newtoktype := minustok;
  '=' :newtoktype := equaltok;
  '.' :newtoktype := periodtok;
  '!' :newtoktype := bangtok;
  '$' :newtoktype := dollartok;
  '%' :newtoktype := percenttok;
  '/' :newtoktype := dividetok;
  '^' :newtoktype := arrowtok;
  '\' :newtoktype := slashtok;
  '?' :newtoktype := questtok;
  '@' :newtoktype := attok;
  '_' :newtoktype := assigntok;
  '' :newtoktype := bartok; 
  '"' :newtoktype := dquotetok
  end;
end;


function toktyper(id:ident):toktype;

(* this function takes an identifier id and classifies it appropriately as
a reserved word, macro time keyword, a special operator or value such
as true or not, or simply as a pascal identifier. the function returns the
appropriate token type *)

var
   t:toktype;  (*token type decided upon*)
   i:integer;  (*counter*)
   fin:boolean;(*indicates whether or not we should continue searching
                 the key/reserved-word arrays, since they are organized
                 alphabetically*)
begin
t := identtok;
if id = 'true      ' then  t := booltok;
if id = 'false     ' then  t := booltok;
if id = 'div       ' then  t := divtok;
if id = 'not       ' then  t := nottok;
if id = 'or        ' then  t := ortok;
if id = 'and       ' then  t := andtok;
if id = 'mod       ' then  t := modtok;
if id = 'mequ      ' then  t := mequtok;
if id = 'mls       ' then  t := mlstok;

if t = identtok then  (* test for being a macro time keyword *)
   begin
   i := 1;
   fin := false;
   while (i <= 14) and not fin do
      begin
      if id = mkeystring[i] then
         begin
         t := mkwdtok;
         newmkeytype := mkeyword[i];
         end;
      if id <= mkeystring[i] then
         fin := true;
      i := i+1;
      end;
   end;

if t = identtok then  (* test for being a pascal reserved word *)
   begin
   i := 1;
   fin := false;
   while (i <= 30) and not fin do
      begin
      if id = reserve[i] then
         t := reservetok; 
      if id <= reserve[i] then
         fin := true;
      i := i+1;
      end;
   end;

toktyper := t;
end;


procedure getident;

(*this procedure reads in a pascal identifier, i.e. a string of alphanumeric
characters, beginning with an alphabetic,  and then calls toktyper to identify
the true token type of the string read in *)

var 
  id:ident;
begin
repeat
   begin
   capitalize(ch);
   workarea[workend] := ch;
   workend := workend + 1;
   getchar;
   end
until not((ch in ['A'..'Z','0'..'9'])
          or ((ch >= 'a') and (ch <= 'z')));
    (* lower case must be checked in this manner due to limitations
       in cmu's set of char. *)
 
if not done then
   havelookahead := true;
newtok^.last := workend-1;
idstring(newtok,id);
newtoktype := toktyper(id);
end;


procedure getstring;

(* this procedure reads in a pascal string, and notifies reception of
a stringtok. note that if this procedure is used, pascal strings will
not be expanded by the processor *)
var i : integer;

begin
newtoktype := stringtok;
repeat
   begin
   workarea[workend] := ch;
   workend := workend+1;
   getchar;
   while (ch <> '''') and (workend < maxwork) do
      begin
      workarea[workend] := ch;
      workend := workend+1;
      getchar;
      end;
   workarea[workend] := ch;
   if workend < maxwork
   then workend := workend+1;
   getchar;
   end
until (ch <> '''') or (workend = maxwork);

if not done then
   havelookahead := true;
newtok^.last := workend-1;
end;


procedure getname;

(* this procedure reads in a macro name-string, and notifies reception of
a nametok. note that this procedure simply spews out the name strings, and
does not remove the double quotes. this is done later at expansion time. 
this procedure simply ensures that strings that are double quoted are
insignificant as far as scanning goes.*)

begin
newtoktype := nametok;
workarea[workend] := '"';
workend := workend +1;
repeat
   begin
   workarea[workend] := ch;
   workend := workend+1;
   getchar;
   while ch <> '"' do
      begin
      workarea[workend] := ch;
      workend := workend+1;
      getchar;
      end;
   workarea[workend] := ch;
   workend := workend+1;
   getchar;
   end
until ch <> '"';
if not done then
   havelookahead := true;
newtok^.last := workend-1;
end;


procedure getcomment;

(* this procedure reads in a pascal comment and outputs it, character by
character, to the place indicated by the parameter to gettoken, p. 
bnd is used to pass the location of the next character to print out to the
procedure writeinfo *)

var
  bnd:bndpnt;
begin
new(bnd);
bnd^.first := workend;
bnd^.last := workend;
if haveblanks then   (* if blanks preceded the comment, print them out too *)
   writeinfo(blanks,nil,c,work,p);
haveblanks := false;
workarea[workend] := '(';
writeinfo(bnd,nil,c,work,p);
workarea[workend] := ch;
writeinfo(bnd,nil,c,work,p);
getchar;
 
repeat
   begin
   while ch <> '*' do
      begin
      workarea[workend] := ch;
      writeinfo(bnd,nil,c,work,p);
      getchar;
      end;
   workarea[workend] := ch;
   writeinfo(bnd,nil,c,work,p);
   getchar;
   end
until ch = ')';

workarea[workend] := ch;
writeinfo(bnd,nil,c,work,p);
getchar;
dispose(bnd)
end;


procedure getcurlycomment;

(* this procedure reads in a curly pascal comment and outputs it, character by
character, to the place indicated by the parameter to gettoken, p. 
bnd is used to pass the location of the next character to print out to the
procedure writeinfo *)

var
  bnd:bndpnt; 
begin
new(bnd);
bnd^.first := workend;
bnd^.last := workend;
if haveblanks then   (* if blanks preceded the comment, print them out too *)
   writeinfo(blanks,nil,c,work,p);
haveblanks := false;
 
repeat
   begin
   workarea[workend] := ch;
   writeinfo(bnd,nil,c,work,p);
   getchar;
   end
until ch = '}';

workarea[workend] := ch;
writeinfo(bnd,nil,c,work,p);
getchar;
havelookahead := true;
dispose(bnd)
end;

procedure getunknown;
{ this procedure reads in an unknown character and outputs it,
to the place indicated by the parameter to gettoken, p. 
bnd is used to pass the location of the next character to print out to the
procedure writeinfo }
var bnd:bndpnt;
begin
new(bnd);
bnd^.first := workend;
bnd^.last := workend;
if haveblanks then { if blanks preceded the character, print them out too }
   writeinfo(blanks,nil,c,work,p);
haveblanks := false;
workarea[workend] := ch;
writeinfo(bnd,nil,c,work,p);
getchar;
havelookahead := true;
dispose(bnd)
end; 

(*main body of gettoken*)
begin
if dotrace then writeln(output,'gettoken');
done := false;
if not havelookahead then  (* if don't have lookahead, then get next char*)
   getchar;
havelookahead := false;
workend := 1;
havetok := false;
haveblanks := false;
newtoktype := nulltok;
 
(* read in blanks and crlf's into workarea array, and set the pointer blanks *)

blanks^.first := workend;
while ((ch = ' ') or (ch = '')) and not done do
   begin
   workarea[workend] := ch;
   workend := workend+1;
   getchar;
   end;
blanks^.last := workend-1;
if blanks^.last >= blanks^.first then
   haveblanks := true;
 
(* read in the next token *)

newtok^.first := workend;
newtok^.last := workend-1;
if not done then  (* if haven't reached end of reading place, go on *)
   begin
   repeat   (* may have to repeat this loop if comments are encountered *)
      begin 
      if not((ch >= '!') and (ch <= '~')) 
      then getunknown
      else case ch of

        'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p',
        'q','r','s','t','u','v','w','x','y','z'  { dzg } ,
        'A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P',
        'Q','R','S','T','U','V','W','X','Y','Z': 
                 getident;   
 
        '0','1','2','3','4','5','6','7','8','9': 
                 getnumber;

 
        '''': 
              
              if knowstring then 
                 getstring
              else
                 getspec(ch);
              
 
        '{' : 
                if knowcomment
                then getcurlycomment
                else error(41);

        '}' :  error(42);

        '(' : begin
              getchar;
              if (ch = '*') and knowcomment then
                 getcomment
              else
                 getspec('(');
              havelookahead := true;
              end;
        


       ':' : begin   (* check for  := *)
              getchar;
              getspec(':');
              if ch = '=' then
                 begin
                 getspec(ch);
                 newtoktype := assigntok;
                 getchar;
                 end;
              havelookahead := true;
              end;

        '<' : begin   (* check for <>  or <= *)
              getchar;
              getspec('<');
              if ch = '>' then
                 begin
                 getspec(ch);
                 newtoktype := neqtok;
                 getchar;
                 end
              else
              if ch = '=' then
                 begin
                 getspec(ch);
                 newtoktype := lseqtok;
                 getchar;
                 end;
              havelookahead := true;
              end;
         
        '>' : begin   (* check for >= *)
              getchar;
              getspec('>');
              if ch = '=' then
                 begin
                 getspec(ch);
                 newtoktype := greqtok;
                 getchar;
                 end;
              havelookahead := true;
              end;
         
        '"' : begin
              getchar;
              if ch = '"' then
                 getspec(ch)
              else
                 getname;
              end;
 
        ';',',','[',']',')','*','+','-','=','.','!','$','%','\','^','/','&',
        '?','@','_','':  getspec(ch); 
 
        '': 
                        writeln(tty,'internal error gettoken');
        (* dzg - added: the char # sent the "case" bananas ! *)
        otherwise: getunknown;
        end;

(*gettoken continued*)

      if newtok^.last >= newtok^.first then 
         havetok := true;
      if not(done or havetok)  then (* have encountered a comment *)
         begin                      (* so get blanks and repeat loop *)
         blanks^.first := workend;
         while ((ch = ' ') or (ch = '')) and not done do
             begin
             workarea[workend] := ch;
             workend := workend+1;
             getchar;
             end;
         blanks^.last := workend-1;
         if blanks^.last >= blanks^.first then
            haveblanks := true;
         newtok^.first := workend;
         newtok^.last := workend-1;
         if havelookahead
           then havelookahead := false
           else getchar
         end;
      end
   until done or havetok;
   end;

if dotrace then 
   begin
   if haveblanks then
      begin
      writeln(output);
      write(output,'*bb*');
      writeinfo(blanks,nil,dummychunk,work,out);
      write(output,'*bb*');
      end
   else
      writeln(output,'noblanks');
   if havetok then
      begin
      writeln(output);
      writeinfo(newtok,nil,dummychunk,work,out);
      writeln(output);
      end
   else
      writeln(output,'notoken');
   end;

end.
