module Dirmod;

{-------------------------------------------------------------------------
{
{ Abstract:
{    This is a stripped down direct program that is used by dirtree to list 
{ the contents of the directories.
{
{ Written by: C-MU Spice group.
{
{-------------------------------------------------------------------------}
 
{  5-Feb-82  V4.0  Nora Lederle
{ Modularized direct and made direct to do just a shortfast directory.
{ }

{ 23-Jun-81  V3.2  Brad Myers
{ Fixed counter of number of files and directories to not include the
{  directories passed through but not used
{ }

{ 19-May-81  V3.1  Brad Myers
{ New exceptions
{ Fix help message to tell about new wild cards
{ Changed the LISTDIRECTORY switch to list or not directories with no matches
{ }

{ 16-Apr-81  V3.0  Brad Myers
{ Added ability to list multiple directories matching the pattern (but NOT
{  multiple partitions or devices);
{ Added switch LISTDIRECTORIES which lists directories if match dirSpec but not
{  spec
{ Added switch for multicolumn or single column listing
{ }

{ 30-Mar-81  V2.1  Brad Myers
{ Changed SpiceDir to FileDir
{ }

{ 28-Mar-81  V2.0  Brad Myers
{ Uses FSAddToTitleLine.  Outputs to file in alpha order;
{ tells when directory name part is bad
{ }

{ 19-Mar-81  V1.6  Brad Myers
{ Changed to PERQ_String; Search => PMatch; use FSScan from FileUtils.
{ }

{ 11-Mar-81  V1.5  Don Scelza
{ Added code to allow direct to work with sub directories.
{ }

{ 10-Mar-81  V1.4  Don Scelza
{ Added Brad's changes to the scanner and sort routiens.
{ }

{ 3-Mar-81   V1.3  John Strait
{ Expand the "All" form of the directory to print FileType, LastBlk, full
{   creation time, update time, and access time.
{ Report version number and current date.
{ Don't do an FSLookUp on files because that sets the access time and thus
{   makes printing the access time kind of silly.
{ }

{ 2-Mar-81   V1.2  Don Scelza
{ Changed switch parsing.  Added Help switch.
{ }

{ 1-Mar-81   V1.1  Brian Rosen
{ Added switches and printing of time and date.
{ }

{ ??-??-81   V1.0  C-MU Spice group.
{ Created the Direct program.
{ }


{ ********************} Exports {***************************}

imports FileDefs from FileDefs;

function direct (SearchMask:string; outFileName: PathName):  boolean;

{$R-}    
{***********************} Private {**********************}

const Version = '4.0';

imports System from System;
imports fileutils from fileutils;
imports Perq_String from Perq_String;
imports filedir from filedir;
imports PMatch from PMatch;
imports ReadDisk from ReadDisk;
imports Clock from Clock;
imports AllocDisk from ALlocDisk;
imports IO FROM IO;


Type BigNameArray = array[1..600] of SimpleName;

     pDirStack = ^dirStack;
     dirStack = RECORD
                   dirName: PathName;
                   dirInd: integer;
                   next: pDirStack;
                   prev: pDirStack;
                END;


function direct (SearchMask:string; outFileName: PathName):  boolean;

const
    debug = false;
     
var
  pTop, pBot, pTemp : pDirStack;
  dirHasStar        : boolean;
  totFiles          : integer;
  totBlocks         : integer;
  totDirectories    : integer;
  allDirs           : integer;
  dir, spec, dirSpec: PathName;

var
  scanptr : ptrScanRecord;
  id,xpos,i,j : integer;
  stkindx   : integer;
  l,k       : integer;
  realindex : integer;
  numrows   : integer;
  CmdLine   : string[255];
  Cmd       : string;
  Broke     : string;
  up1,up2   : SimpleName;
  upperNamearray : BignameArray;
  namearray : BignameArray;
  indx      : array [1..600] of integer;
  stacki    : array [1..600] of integer;
  stackj    : array [1..600] of integer;
  idarray   : array [1..600] of FileId;
  filename  : PathName;
  randomseed: integer;
  All       : boolean;
  segnum    : integer;
  TotalBlks : integer;
  Buffer    : ptrDiskBuffer;
  TempString,
  CurrentTime,
  CreateTime,
  UpdateTime,
  AccessTime: string;
  OutFile   : Text;
  NumMatch  : Integer;



Function FindBase(fileName: PathName; VAR dir, dirSpec, spec: PathName;
                     VAR dirHasStar: boolean): boolean;
{----------------------------------------------------------------------------
Abstract: gets the directory name from filename and returns the directory
          part and the fileName part.  If no fileName part then returns 
          true else false.
Parameters: fileName is the user-supplied fileName which should contain one
            or more wildcards and should have the device and partition on
            the front.  dir is the directory part of the filename to
            the left of the star (includes device and partition).
            Spec is the rest.  If spec would be null, then set to '*'.
            If a directory has a star, then dirHasStar set to true else false.
            If no partition or device, then error set to true, else false.
            If device or partition has a star, then assumed to be part of
            valid name so not called a wildcard.
Returns: True if all OK else false if error
----------------------------------------------------------------------------}
  var i, len, partIndex, index: integer;
      state : (start, devFound, partFound, inStar, leave);
  begin
  len := Length(fileName);
  FindBase := false; {assume error}
  state := start;
  i := 1;
  dirHasStar := false;
    repeat
    if i > len then if state < partFound then exit(FindBase)  {error}
                    else state := leave
    else if fileName[i] = ':' then if state = start then state := devFound
                                   else exit(FindBase)  {error}
    else if (fileName[i]='*')  {or (fileName[i]='#')}
           then if state >= partFound then state := inStar
                else {ok to have *'s in dev and part}
    else if (fileName[i] = '>') then 
              case state of
                 start : exit(FindBase); {error}
                 devFound : begin
                            partIndex := i;
                            state := partFound;
                            end;
                 partFound: partIndex := i;
                 inStar: begin
                         dirHasStar := true;
                         index := i;
                         end;
                 end; {case}
  i := i+1;
  until state = leave;
 
  FindBase := true; {no errors}

  dir := SubStr(fileName, 1, partIndex); {part with no stars}
  if dirHasStar then dirSpec := SubStr(fileName, partIndex+1, index-partIndex)
  else begin
       dirSpec := '*>';
       index := partIndex;
       end;
  if len = index then spec := '*'  { is "...foo>" }
  else spec := SubStr(fileName, index+1, len-index);
     IF debug then WriteLn(outfile, 'fileName: ',fileName,' dir: ',dir,
                        ' dirSpec: ',dirSpec,' spec: ',spec,' dirHasStar: ',
                        dirHasStar);
  end; {FindBase}
        
procedure Sort1(f,l : integer; var cut1,cut2: integer);
{----------------------------------------------------------------------
{
{ Abstract:
{    Procedure used to sort the directory entries.
{
{---------------------------------------------------------------------}
  var
    i,j : integer;
    temp: integer;
    a   : string;
    k   : integer;
    
  begin
    i := f;
    j := l;
    k := randomseed mod (l-f+1);
    k := k+f;
    if (k > l) or (k < f) then 
      WriteLn(outfile, 'Error');
    randomseed := randomseed + 1;
    a:= upperNamearray[indx[k]];
    
    while i < j do
      begin
        up1 := upperNamearray[indx[i]];
        up2 := upperNamearray[indx[j]];
        while (up2 >= a) and (j >= f) do 
          begin
            j := j-1;
            if j >= f then
              begin
                up2 := upperNamearray[indx[j]];
              end;
          end;
        while (up1 <  a) and (i <= l) do 
          begin
            i := i+1;
            if i <= l then
              begin
                up1 := upperNamearray[indx[i]];
              end;
          end;
        if i < j then
          begin
            temp := indx[i];
            indx[i] := indx[j];
            indx[j] := temp;
          end;
      end;
    cut1 := i;
    cut2 := j;
  end;

 
   

procedure Sort(i,j: integer);
{----------------------------------------------------------------------
{
{ Abstract:
{    Procedure used to sort the directory entries.
{
{---------------------------------------------------------------------}
  var
    cut1,cut2,k,l : integer;
    Str : String;
  
  begin
    for k := 1 to j do {conv all to upper case}
       begin
        Str := nameArray[k];
        for l := 1 to Length(Str) do
            Str[l] := chr(LAnd(ord(Str[l]), #337));  {cheap uppercase}
        UpperNameArray[k] := Str;
       end;

    randomseed := 1;
    if i >= j then exit(Sort);
    stkindx := 1;
    stacki[stkindx] := i;
    stackj[stkindx] := j;
    while stkindx >= 1 do
      begin
        i := stacki[stkindx];
        j := stackj[stkindx];
        stkindx := stkindx - 1;
        Sort1(i,j,cut1,cut2);
        if (cut2 >= i) and (i < cut1-1) and ((cut1-1-i) > 0) then
          begin
            stkindx := stkindx + 1;
            stacki[stkindx] := i;
            stackj[stkindx] := cut1-1;
          end;
        if (cut1 <= j) and (cut2+1 < j) and ((j-cut2-1) > 0) then
          begin
            stkindx := stkindx + 1;
            stacki[stkindx] := cut2+1;
            stackj[stkindx] := j;
          end;
      end;
  end;


 


procedure ShortFastDir;
{---------------------------------------------------------------------
{
{ Abstract:
{    This procedure is used to supply a simple short directory.
{
{---------------------------------------------------------------------}
  var JumpLine, len: Integer;
    begin  
    if NumMatch <= 1 then
        JumpLine := 1024
    else
        JumpLine := 1024 div (NumMatch - 1);
    numrows := (NumMatch - 1 + 3) div 4;
    for k := 1 to numrows do
      begin
        xpos := 0;
        for j := 1 to 4 do
          begin
            realindex := (j - 1)*numrows + k;
            if realindex <= (NumMatch - 1) then
              begin
                Write(outfile, namearray[indx[realindex]]);
                len := length(namearray[indx[realindex]]);
                xpos := xpos + len;
                if len >= 20 then 
                        begin
                          Write(outfile, '  ');
                          xpos := xpos+2;
                        end
                else
                    if j < 4 then
                      for l := 1 to 20 - (xpos mod 20) do 
                        begin
                          Write(outfile, ' ');
                          xpos := xpos + 1;
                        end;
              end;
          end;
        WriteLn (outfile);
      end
   end;


procedure linearFastDir;
{---------------------------------------------------------------------
{
{ Abstract:
{    This procedure is used to supply a simple short linear directory.
{
{---------------------------------------------------------------------}
var
  i: integer;
begin  
  for i := 1 to numMatch - 1 do
    writeln(outfile, namearray[indx[i]]);
end;


function CheckIfDir(var dir, fullDir, dirSpec: PathName;
                      name: PathName): boolean;
{---------------------------------------------------------------
{
{ Abstract:
{    sees if name is a directory and if so, checks to see if matches dirSpec;
{     if so, adds to Top of dir stack 
{
{ Parameters:
{    dir is dir name in without partition name
{    fulldir is full name
{    dirSpec is pattern to match directories to 
{    name is file name that may be a directory
{
{ Returns:
{    true if file was dir and accepted else false;
{
{ Side Effects:
{    Alters stack of dirs if name is dir
{-------------------------------------------------------------------}
  var s: String[3];
      pTemp: pDirStack;
      tempName: PathName;
    Procedure AddIt;
        begin
        NEW(pTemp);
        if pBot = NIL then pBot := pTemp;
        pTemp^.next := pTop;
        if pTop <> NIL then pTop^.prev := pTemp;
        pTemp^.prev := NIL;
        pTop := pTemp;
        pTemp^.dirName := Concat(fullDir, name);
        if debug then writeln(outfile, '~~~NEW Dir found is ',pTemp^.dirName);
        CheckIfDir := true;
        end; {AddIt}
  begin
  CheckIfDir := false;
  s := Substr(name, length(name)-2,3);
  ConvUpper(s);
  if s = '.DR' then
     begin
     name := SubStr(name, 1, length(name)-3);  {remove .DR}
     AppendChar(name, '>');
     if all then AddIt
     else begin
          tempName := Concat(dir,name);
          if debug then WriteLn(outfile, '~~checking dir "',tempName,
                '" against spec: ', dirSpec);
          if PattMatch(tempName,dirSpec,true) then AddIt;
          end;
     end;
  end; {CheckIfDir}


Procedure RemovePartition(var dir: PathName);
{---------------------------------------------------------------
{
{ Abstract:
{    Removes device and partition from dir so can do match 
{
{-------------------------------------------------------------------}
  var i: integer;
  begin
  i := PosC(dir, '>');
  if i = 0 then writeLn(outfile, '***WHERE HAS THE PARTITION GONE?? ',dir)
  else dir := SubStr(dir, i+1, length(dir)-i);
  end;


procedure DoDirScan(spec, dirSpec, dir: PathName; dirHasStar: Boolean);
{---------------------------------------------------------------
{
{ Abstract:
{    Gets all files matching pattern into global array 
{
{ Parameters:
{    SearchMask is pattern to match against
{    dir is dir inside of
{    dirHasStar tells whether to do complex stuff
{
{ Environment:
{    Assumes ScanPtr set up with correct directory
{
{ Side Effects:
{    Sets globals NumMatch and namearray
{    Alters stack of dirs if dirHasStar and dir found that matches
{-------------------------------------------------------------------}
  var fullDir: PathName;
      isDir: Boolean;
  begin
  isDir := false;
  NumMatch := 1;
  fullDir := dir;
  RemovePartition(dir);
  while FSScan(scanptr, namearray[NumMatch], idarray[NumMatch]) do
    begin
      if dirHasStar then isDir := CheckIfDir(dir, fullDir, dirSpec,
                                                 namearray[NumMatch]);

      if All then
          begin
          indx[NumMatch] := NumMatch;
          NumMatch := NumMatch + 1
          end
      else
       begin
       if PattMatch(namearray[NumMatch],spec,true) then
        begin
          indx[NumMatch] := NumMatch;
          NumMatch := NumMatch + 1;
        end;
       end;
    end;
  end;
    

Procedure ProcessOneDir(spec, dirSpec, dir: PathName; dirHasStar: boolean);
{---------------------------------------------------------------
{
{ Abstract:
{    Prints one directory to file or screen 
{
{ Parameters:
{    SearchMask is pattern to match against
{    dir is directory to match in
{    dirHasStar tells whether to worry about updating list of directories
{      and to use the more complex checking
{-------------------------------------------------------------------}
      var fid: FileID;
          dum: integer;
      begin
      
      fid := FSInternalLookup(dir, dum, dum);
      if fid = 0 then
        begin
        WriteLn (outfile);
        WriteLn(outfile, '** Directory ',dir,' doesn''t exist');
        exit(ProcessOneDir);
        end;

      scanptr^.InitialCall := true;
      scanptr^.dirName := dir;
      
      
      DoDirScan(spec, dirSpec, dir, dirHasStar);
      
      if (numMatch > 1) then
         begin
         WriteLn (outfile);
         Write(outfile, '   --- In ',dir,' --- ');
         WriteLn (outfile);
         WriteLn (outfile);
      
         Sort(1, NumMatch-1);
      
         xpos := 0;
    
         linearFastDir;
        
         writeln (outfile);  
         NumMatch := NumMatch - 1;
         if NumMatch = 0 then writeln(outfile, '** No files found.')
         else if NumMatch = 1 then writeln(outfile, '1 file found.')
         else writeln(outfile, NumMatch:1, ' files found.');
      
         totFiles := totFiles+NumMatch;
         totDirectories := totDirectories+1;
         end;
        
      allDirs := allDirs + 1;
      end; {ProcessOneDir}


Procedure BreadthFirstSearch(spec, dirSpec, dir: PathName);
{---------------------------------------------------------------
{
{ Abstract:
{    Goes through all directories and files that match spec starting at dir
{     and prints their contents 
{
{ Parameters:
{    spec is pattern to match against
{    dir is directory to match in
{-------------------------------------------------------------------}
   var leave: boolean;
       
   begin

   totFiles := 0;
   totBlocks := 0;
   totDirectories := 0;
   allDirs := 0;

   pBot := NIL;
   pTop := NIL;
   leave := false;
   
   repeat
      ProcessOneDir(spec, dirSpec, dir, true);
      
      if pBot <> NIL then
         begin
         dir := pBot^.dirName;
         pTemp := pBot;
         pBot := pBot^.prev;
         if pBot <> NIL then pBot^.next := NIL;
         DISPOSE(pTemp);
         end
      else leave := true; 

  until leave;
  
  WriteLn (outfile);
  Write(outfile, ' Grand Total: ');
  Write(outfile, totFiles:1, ' file');
  if totFiles <> 1 then write(outfile, 's');
  Write(outfile, ' in ',totDirectories:1, ' director');
  if totDirectories <> 1 then write(outfile, 'ies')
  else write(outfile, 'y');
  Write(outfile, ' out of ',allDirs:1, ' director');
  if allDirs <> 1 then write(outfile, 'ies')
  else write(outfile, 'y');
  WriteLn(outfile, ' scanned.');
  end;
     
 
{****************************************************************}

begin
direct := false;
FSRemoveDots (searchMask);
rewrite (outFile, outFileName);
  new(scanptr);
  if FindBase(SearchMask, dir, dirSpec, spec, dirHasStar) then
     begin
        begin
        if (spec = '*') and (dirSpec = '*>') then all := true
        else all := false;
        GetTString(CurrentTime);
        Write(outfile, 'Direct V', Version, '   ', CurrentTime);
        if not dirHasStar then begin
                              WriteLn(outfile,'   Files matching ',spec,' : ');
                              ProcessOneDir(spec, '', dir, false);
                              end
        else begin
             WriteLn (outfile);
             WriteLn(outfile, '   Files matching ', spec,
                     ' in directories matching ', dirSpec,' : ');
             BreadthFirstSearch(spec, dirSpec, dir);
             end;
        end
     end
  else WriteLn(outfile, '** Filename ',SearchMask,' is malformed.');
        
WriteLn (outfile);
close (outfile);
direct := true;
end.
