{ Command codes for the Region Editor }

{ Any new commands must also be added to RepeatableCmds
{ (when appropriate).  The set is initialized in EdInit. }

{ To change the binding of a command, simply replace the argument of the
{ ord function.  Note that most commands must be unique.  Exceptions are
{ HelpCmd and QHelp, BSChar and DelBChar, TABCmd, and InsTab, and OopsLine 
{ and DelBLine.  To specify a command that requires a prefix, enter 
{       PrefixBit + ord ('<any char.>')
{ After changing any key, you should recompile all editor modules.     }

{ If you make significant changes to the key bindings or want more than one
{ version on your machine, it may be helpful to change the help file name.  }


const HelpFile  = '>EdHelp.EHelp';

const

PrefixKey       = ord ('x');

ForChar         = ord ('f');
BackChar        = ord ('b');
ForWord         = ord ('F');
BackWord        = ord ('B');
BeginLine       = ord ('a');
EndLine         = ord ('e');
UpLine          = ord ('p');
DownLine        = ord ('n');
UpPage          = ord ('V');
DownPage        = ord ('v');
TopWindow       = ord (',');
BottomWindow    = ord ('.');
BeginFile       = PrefixBit + ord (',');
EndFile         = PrefixBit + ord ('.');
PosToSelect     = ord ('=');
SetMark         = ord ('@');
FindMark        = PrefixBit + ord ('x');

SelChar         = ord ('[');
UpSelChar       = ord (']');
SelWord         = ord ('{');
UpSelWord       = ord ('}');
SelLine         = ord ('<');
UpSelLine       = ord ('>');
ExtendSel       = ord ('(');
UpExtend        = ord (')');
SelAll          = ord ('*');

{ InsChar is defined in EdCanvas for now }
QuoteChar       = ord ('q');
InsTab          = ord ('i');
TabCmd          = ord (TAB);
MakeNewLine     = ord ('m');
CRCmd           = ord (CR);
IndentNewLine   = ord ('j');
LFCmd           = ord (LF);
InsSpace        = ord (' '); { just a hack to force ctrl-space to be inserted }
Twiddle         = ord ('t');
OpenSpace       = ord ('o');
OpenIndent      = ord ('O');
DelFChar        = ord ('d');
BSChar          = ord (BS);
DelBChar        = ord ('h'); 
DelFWord        = ord ('D');
DelBWord        = ord ('H');
DelELine        = ord ('k');
DelBLine        = ord (Oops);
DelTWhite       = ord ('K');
InsSelection    = ord ('''');
DelSelection    = ord ('"');
Yank            = ord ('y');
PopKill         = ord ('Y');

ForSearch       = ord ('s');
RevSearch       = ord ('r');
ForReplace      = ord ('Q');
RevReplace      = ord ('R');

InSearchString  = PrefixBit + ord ('2');
InReplaceString = PrefixBit + ord ('3');
SearchDown      = ord ('S');
SearchUp        = PrefixBit + ord ('S');
ReplaceDown     = PrefixBit + ord ('Q');
ReplaceUp       = PrefixBit + ord ('R');

{ new Commands }
incrNum         = prefixBit + ord('+');
decrNum         = prefixBit + ord('-');
paraFill        = ord('J');
selFill         = prefixBit + ord('j');
lineCenter      = prefixBit + ord('h');
selCenter       = prefixBit + ord('H');
startMacro      = prefixBit + ord('(');
stopMacro       = prefixBit + ord(')');
doMacro         = prefixBit + ord('e');
endMacroMarker  = prefixBit + ord('$'); { a marker to allow repeating doMacro }
ChangePath      = PrefixBit + ord ('P');
PrintDir        = PrefixBit + ord ('D');
DiffFiles       = PrefixBit + ord ('q');
NextWindow      = PrefixBit + ord ('n');
PrevWindow      = PrefixBit + ord ('p');
OneWindow       = PrefixBit + ord ('1');
SaveModFiles    = PrefixBit + ord ('m');
blockIndent     = PrefixBit + ord ('i');
blockUndent     = PrefixBit + ord ('I');

{ the following five commands cannot be changed }

Accept          = ord (INS);
Reject          = ord (DEL);
SkipRepl        = ord (' ');
DoStop          = ord (TAB);
DoAll           = ord ('!');

MakeWindow      = PrefixBit + ord ('v');
KillWindow      = PrefixBit + ord ('d');
ReplWindow      = PrefixBit + ord ('r');
GrowWindow      = PrefixBit + ord ('Z');
ShrinkWindow    = PrefixBit + ord ('z');
{ GotoWindow    = 1..9 (window number) }

ToggleInsert    = PrefixBit + ord ('6');
ToggleScroll    = PrefixBit + ord ('_');
ToggleThumb     = PrefixBit + ord ('^');
DebugCmd        = PrefixBit + ord ('!');
ExitCmd         = PrefixBit + ord ('f');
QuitCmd         = ord ('c');

WritFile        = PrefixBit + ord ('w');
SaveFile        = PrefixBit + ord ('s');
BackFile        = PrefixBit + ord ('S');
RefrScreen      = ord ('l');

NewParm         = ord ('X');
CountCmd        = ord ('u');
DoAgainCmd      = ord (INS);
QHelp           = ord ('?');

{ HelpCmd, NoopCmd, and NullCmd are defined in EdCanvas }

OneUp           = UpLine;
OneDown         = DownLine;
ScrollTop       = UpSelChar;
ScrollBottom    = UpExtend;
Cont1Scroll     = SelWord;
Cont2Scroll     = SelLine;
Stop1Scroll     = UpSelWord;
Stop2Scroll     = UpSelLine;

MoveRight       = ForChar;
MoveLeft        = BackChar;
DownThumb       = SelWord;
UpThumb         = UpSelWord;
