module Writer;


{-----------------------------------------------------------------------------
{
{       Writer - Stream package output conversion routines.
{       J. P. Strait   ca. 1 Jan 81.
{       Copyright (C) Three Rivers Computer Corporation, 1981.
{
{ Abstract:
{       Writer is the character output module of the Stream package.  It
{       is called by code generated by the Pascal compiler in response to
{       a Write or Writeln.  It is one level above Module Stream and uses
{       Stream's output routines.
{
{-----------------------------------------------------------------------------}


{ 4 Jun 81  V2.2  John Strait.
{ Add Virgil headers and comments.
{ }

{ 19 May 81  V2.1  Brad Myers.
{ Turn off Range checking so printing of chArrays will work.
{ }

{ 12 May 81  V2.0  John Strait.
{ Use exceptions rather than StreamError.
{ }

exports


imports Stream from Stream;

 
 procedure WriteBoolean( var F: FileType; X: Boolean; Field: integer );
 procedure WriteCh( Var F: FileType; X: char; Field: integer );
 procedure WriteChArray( var F: FileType; var X: ChArray; Max, Field: integer );
 procedure WriteIdentifier( var F: FileType; X: integer; 
                            var IT: IdentTable; L, Field: integer );
 procedure WriteInteger( var F: FileType; X: integer; Field: integer );
 procedure WriteString( var F: FileType; var X: String; Field: integer );
 procedure WriteX( var F: FileType; X, Field, B: integer );


private
