Program System;
{------------------------------------------------------------
{     System - POS main program.
{     Perq Software Group.
{     Copyright (C) Three Rivers Computer Corporation, 1980, 1981.
{     
{ Abstract:
{     Initialize POS 
{     and go into loop alternately running Shell and user program
{------------------------------------------------------------}

{------------------------------------------------------------
{ Change Log:
{ 
{      21 Jan 82  V2.2 BAM     Add new variables isFloppy, PopAllowed.
{       6 Jan 82  V2.1 WJH     Use smaller screen for floppy booted on 1/4 MB
{
{       4 Dec 81  V2.0 WJH     Change to ShellCtrl from three vars
{                              add UseCmd, UserPtr, and UserInt
{                              add TimeFID
{                              remove CmdFile
{                              rearrange definitions of variables
{                              change xxTime variables to Long
{                              move StreamKeyBoardReset to Shell
{       1-Dec-81  BAM          Added the new exception HELPKey and a default
{                                handler.
{                              Added default handler for Flush Fail that works
{                                 like diskFailure.
{                              Make ^C^C clear ^S.
{      05-NOV-81  DAS          Added calls to EtherInit.
{      13-Aug-81  BAM          Add new vbles to hold pointers for the shell.
{      30-Jun-81  BAM          Add new vbles for DefScrOff and Comp and demo.
{      25-Jun-81  BAM          Change to window 0 before error type out.
{      25-Jun-81  JPS          Turn tablet off in command loop.
{      23-Jun-81  BAM          Address for DiskFailure printed in unsigned 
{                               decimal
{       1-Jun-81  BAM          Do automatic re-enable of swapping if turned off
{                               by Shell (i.e. for Scavenger)
{      28-May-81  BAM          Handler for Stream Reset error
{      23-May-81  JPS          Replace enable/disable of control-c processing
{                              (exported by System) with enable/disable of
{                              KeyBoard interrupts (exported by IO_Others).
{      22-May-81  JPS          Fix control-c processing.
{      18-May-81  JPS          Use StreamKeyBoardReset.
{                              Change TwoCtlC exception to CtlCAbort.
{      13-May-81  BAM          Remove old comments about stand alone 
{                              Add vble for default cursor function (screen
{                                 color) that can be set by login from profile
{                              Add comments to some exceptions
{      13-May-81  JPS          1. Add exceptions and default handlers for 
{                                 control-C.
{                              2. Add procedures to enable and disable 
{                                 control-C processing.
{                              3. Add exception to ExitProgram.
{                              4. Remove vestiges of old system: standard error
{                                 procedures.
{      12-May-81  BAM          Add default handlers for many exceptions
{                              Use new IO
{       6-Apr-81  JPS          Retrofit changes for exceptions to version of
{                               system that diverged after 15-Mar-81.
{                              Virtual memory and timing statistics.
{                              Get rid of "System" conditional compile.
{                              Change main version from C to D.
{      15-Mar-81  JPS          Put in stuff for exceptions.
{      28-Mar-81  BAM          Changed length of UsrCmdLine to 255.
{      19-Mar-81  BAM          PERQ_String.
{      17-Mar-81  BAM          Set time when come up so Login LookUp faster.
{       3-Mar-81  DAS          Added variables for Login.  Added
{                              InCmdFile for Shell.
{      25-Feb-81  DAS          Added FlushAll call in command.
{      24-Feb-81  JPS          Add code to shrink and expand the screen.
{                              *** Caution *** The Shell must never be loaded
{                              when the screen is small, because it might
{                              allocate a buffer for a command file.  This
{                              buffer will hang around after the Shell returns
{                              to the system.
{      23-Feb-81  RFR          Added SysDisk, SysBootChar definitions.
{                              Added call to FSSetupSystem.
{      19-Feb-81  John Strait  Incorporate system version number into the
{                              name of the LogIn run file.
{      17-Feb-81   Don Scelza  Removed the include file for SysVers.
{                              Put the code inline in System.
{      16-Feb-81  John Strait  Removed the Loader to a separate module.
{      16-Feb-81  Don Scelza   Changed System to use Perq.String and
{                              changed MainVersion to C.
{      11-Feb-81  Diana Forgy  Took out command interpreter and made
{                              most of it program Shell.
{
{                              This program is compatable with the
{                              new Compiler and PString.
{                              
{
{      17-Nov-80  Don Scelza   Added the code for LastFileName.
{                              This will allow a user to supply the
{                              name of a file once for the Editor, Compiler,
{                              and Linker.
{      14-Nov-80  Don Scelza   Added conditional compile for stand
{                              alone programs 
{      10 Oct 80  JPS          Add support for the diagnostic display (DDS).
{      23 Sep 80  JPS and DAS  Add PAUSE command.
{                              Announce 12 or 24 MByte disk.
{}



{********************} Exports {********************}

Const MainVersion = 'D';
      DebugSystemInit = False;
      FirstDDS = 199;
      ShellConst = 'Shell.';
      LogConst = 'LogIn.';
      PFileConst = 'Default.Profile';
      
      SysTiming = True;    { Gather System timing statistics.  If this constant
                             is changed, IO, Loader, Memory, Movemem, System,
                             and Shell should be re-compiled, and the System
                             should be re-linked. }


Type Sys9s = String[10];


Var UsrCmdLine: String[255];    {Command line entered by user}
    UseCmd: Boolean;            {Set True to tell shell to execute UsrCmdLine}
    InCmdFile: Boolean;         {True if shell commands from file}
    LastFileName,               {Name of file to use if none given}
    RFileName,                  {Name of next program to run}
    ShellName: String;          {Name of Shell}

    CurUserID,                  {Index of user in System.Users}
    CurGroupID: 0..255;         {Groupid of current user}
    CurUserName,                {LogIn name of current user}
    CurPFile: String;           {Name of current profile file}
    UserMode: Boolean;          {True while executing user program}

    CtrlCPending: Boolean;      {True if one control-C typed}

    NextSSize: Integer;         {Screen size for next program}
    NextSComplemented: Boolean; {Whether to complement bottom for next pgm}
    NextSOff: Boolean;          {Whether bottom should display data bits}
    DefCursFunct: Integer;      {What to set curs func to after each prog}
    DefScrComp: Boolean;        {Default value for NextSComplemented}
    DefScrOff: Boolean;         {Default value for NextSOff}

    ShellCtrl: pointer;         {Pointer to information record for Shell}
    TimeFID: integer;           {File ID of file holding current time}
    CmdSegment: Integer;        {SegmentNumber of seg holding command files}

    InPmd: Boolean;             {True if in Scrounge (PostMortemDump)}
    SysDisk: Integer;           {Number of the disk booted from}
    SysBootChar: Integer;       {Ord(char held down to boot)}

    StrVersion: string;         {System version number as a string}
    SystemVersion: Integer;     {Integer giving system version number}
    SystemInitialized: Boolean; {True after system initialized}
    DDS: Integer;               {Keeps current diagnostic display value}
    ShouldReEnableSwapping: Boolean;  {True if swapping must be reenabled}
    SavedSwapId: Integer;       {Save id of where to swap to}

    {$ifc SysTiming then}
    LoadTime, OldLoadTime: long;
    ExecuteTime, OldExecuteTime: long;
    SwapTime, OldSwapTime: long;
    MoveTime, OldMoveTime: long;
    IOTime, OldIOTime: long;
    PrintStatistics: Boolean;
    {$endc}
    

    UserPtr: pointer;           {A pointer variable for use between user
                                 programs.  (Use IncRefCount to keep segment)}
    UserInt: integer;           {May be a segment number for UserPtr}

    DemoInt: Integer;           {reserved for Demo system}
    
    isFloppy: Boolean;          {true if booted from floppy, else false}
    pointAllowed: Boolean;      {true if should use pointing device}
 
 
{*** WARNING!!  IF YOU CHANGE THE EXPORTED PROCEDURES AND EXCEPTIONS, MAKE
{***            SURE THE NUMBERS FOR THE FOLLOWING EXCEPTIONS ARE UPDATED
{***            AND RECOMPILE SCROUNGE IF CHANGED !!!!! *****}

{*** WARNING!!  DO NOT CHANGE THE ORDER OF THE ^C EXCEPTIONS !!!!! *****}

Procedure Command;
Procedure SetDDS( Display: Integer );
Procedure SysVers( n: integer; var S: string );

Const ErrCtlC = 4; {******}
Exception CtlC;
{-----------------------------------------------------------------------------
{
{ Abstract:
{       CtlC is raised by the KeyBoard interrupt routine when a control-c
{       is typed.  If you handle this exception you should clear
{       CtrlCPending in your handler. If you are catching control-c's to
{       try to prevent aborts, you should enable CtlCAbort also, since the
{       Stream package will raise it when the control-c is read.
{
{-----------------------------------------------------------------------------}

Const ErrCtlCAbort = 5; {******}
Exception CtlCAbort;
{-----------------------------------------------------------------------------
{
{ Abstract:
{       CtlCAbort is raised by the KeyBoard interrupt routine when the second
{       of two adjacent control-c's is typed.  It is also raised by the
{       Stream package when a control-c is read.  If you handle this exception
{       you should clear CtrlCPending in your handler.
{
{       When this is raised by the KeyBoard interrupt routine, the KeyBoard
{       type-ahead buffer is cleared.  If you want to prevent this, you must
{       catch CtlC also.
{
{       If your program uses a Text file and you want to clear the line editing
{       buffer for that file, you should call the Stream routine
{       StreamKeyBoardReset(F) (assuming F is the name of the file).  If F
{       is a Text file which is attached to the console, this will get rid
{       of the character F^ points to and clear Stream's line editing buffer.
{
{-----------------------------------------------------------------------------}

Const ErrCtlShftC = 6; {******}
Exception CtlShftC;
{-----------------------------------------------------------------------------
{
{ Abstract:
{       CtlShftC is raised by the KeyBoard interrupt routine when a control-
{       shift-c is typed.  If you handle this exception you should clear
{       CtrlCPending in your handler.
{
{       When this is raised by the KeyBoard interrupt routine, the KeyBoard
{       type-ahead buffer is cleared.  You cannot prevent this.
{
{       If your program uses a Text file and you want to clear the line editing
{       buffer for that file, you should call the Stream routine
{       StreamKeyBoardReset(F) (assuming F is the name of the file).  If F
{       is a Text file which is attached to the console, this will get rid
{       of the character F^ points to and clear Stream's line editing buffer.
{
{-----------------------------------------------------------------------------}

Const ErrExitProgram = 7; {******}
Exception ExitProgram;
{-----------------------------------------------------------------------------
{
{ Abstract:
{       ExitProgram is raised to abort (or exit) a program.  The default
{       handler for CtlCAbort and Scrounge raise this exception.
{
{       WARNING: No one but System and Loader should Handle this exception.
{                Anyone may raise it to exit a program.
{
{-----------------------------------------------------------------------------}

Const ErrHelpKey = 8; {******}
Exception HelpKey(var retStr: Sys9s);
{-----------------------------------------------------------------------------
{
{ Abstract:
{       HelpKey is raised when the HELP key is hit.
{
{ Parameters:
{       retStr - the set of characters to put into the input stream.  This
{                should be set by the handler if it continues    from the
{                exception.   Likely values are "/Help<CR>" and chr(7)
{                (the current value returned).  The key board interupt routine
{                sets retStr to '' before raising this exception so if not set,
{                and the handler resumes, nothing will be put into the input
{                stream.
{ Resume:
{         Allowed.  Should set retStr first.
{-----------------------------------------------------------------------------}
type DoubleWord = ^integer;    {should use Long instead}


{********************} Private {********************}
