module RandomNumbers;
{------------------------------------------------------------------------
     RandomNumbers - Random number generator.
      J. P. Strait    15 Sep 80.
      Copyright (C) Three Rivers Computer Corporation, 1980.
      
      
      Module RandomNumbers contains two routines:
      
        InitRandom - initializes the random number generator.
        
        Random - a function which returns a new random number each time
                 it is referenced.
                 
      There is currently no way to seed the generator.
      
      Random is a feedback shift-register pseudo-random number generator.
      The algorithm used is one described in the article:
      
           'Generalized Feedback Shift Register Pseudorandom Number
                 Generator'
           T. G. Lewis and W. H. Payne
           JACM Vol. 20, No. 3, July 1973, pp. 456-468.
           
      Random produces multidimensional pseudo-random numbers equally
      distributed in the interval -32768..32767 and has a period of
      2^98.
------------------------------------------------------------------------}

{------------------------------------------------------------------------
  Change log:
      
       1 Jun 81  BAM  V1.2  Add comments.
      17 Sep 80  JPS  V1.1  Correct an error in the table.
------------------------------------------------------------------------}

{////////////////////////////} exports {\\\\\\\\\\\\\\\\\\\\\\\\\}

procedure InitRandom;
function Random: integer;
 
{////////////////////////////} private {\\\\\\\\\\\\\\\\\\\\\\\\\}
