module PMatch;

{--------------------------------------------------------------
{
{ Abstract: 
{    Does pattern matching on strings
{
{            Patterns accepted are as follows:
{
{
{              "*" matches 0 or more characters.
{
{              "&" matches 1 or more characters.
{
{              "#" matches exactly 1 character.
{
{              "'0" matches any digit.
{
{              "'A" matches any alphabetic (capitals only unless casefold).
{
{              "'a" matches any alphabetic(lower case only unless 'casefold').
{
{              "'@" matches any non-alphanumeric.
{
{              "'*" matches '*', other patterns chars can be quoted also.
{             
{ Written by: Gene Ball at CMU
{--------------------------------------------------------------}

{--------------------------------------------------------------
 Change log:
     28-Dec-81 Brad Myers  V2.5  Removed IsPattern removal of ' if not pattern.
      1-Dec-81 Brad Myers  V2.4  Changed length of files compared to 255
      1-Dec-81 Brad Myers  V2.3  Fixed so IsPattern removes ' if not pattern
     13-Aug-81 Brad Myers  V2.2  Fixed exit in IsPattern so didn't exit from
                                  PattMatch so no crash if string ends in "'"
     15-May-81 Brad Myers  V2.1  Added new exception and changed module name
                                 Use the PERQ_String function uppercase
                                 Added comments in 3RCC style
     ??-Apr-81 Gene Ball   V2.0  Fixed bugs in PattMatch and added new
                                  procedures PattMap and IsPattern
     13-Mar-81 Brad Myers  V1.1  Fixed a small bug and changed import from
                                    PERQ.String to PERQ_String
     ??-Feb-81 Gene Ball   V1.0  Started
--------------------------------------------------------------}

{/////////////////////////////} Exports {\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\}

Type pms255 = String[255];

Function PattMatch(var str,pattern: pms255; fold: boolean): boolean;
Function PattMap(var str,inpatt,outpatt,outstr:pms255; fold:boolean): boolean;
Procedure PattDebug(v: boolean);
Function IsPattern(var str: pms255): boolean;

Exception BadPatterns;
{---------------------------------------------------------------
 Abstract: Raised if outPatt and inPatt do not have the same patterns
            in the same order for PattMap
---------------------------------------------------------------}
 
{/////////////////////////////} Private {\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\}
