Module PERQ_String;
{-----------------------------------------------------------------------------
{
{ PERQ String manipulation routines.
{ Written by: Donald Scelza
{ Copyright (C) 1980
{ Three Rivers Computer Corporastion
{
{ Abstract:
{    This module implements the string manipulation routines for the
{    Three Rivers PERQ Pascal.
{
{    Strings in PERQPascal are stored a single character per byte with
{    the byte indexed by 0 being the length of the string.  When the
{    routines in this module must access the length byte, they must turn
{    off range checking.
{
{---------------------------------------------------------------------------}

{-----------------------------------------------------------------------------
{    Change Log:
{
{ Date: 27 Jan 82   V2.4
{ Who: Brad Myers
{ Fixed some comments
{ }

{ Date: 20 May 81   V2.3
{ Who: JE Ball (CMU) and Brad Myers
{ Rewrote copy loop in Insert
{ Added new function: RevPosC
{ }

{ Date: 13-May-81  V2.2
{ Who: John Strait
{ Use exceptions.
{ }

{ Date: 19-Jan-81  V2.1
{ Who: Diana Connan Forgy
{ Changed ConCat and SubStr to functions.
{ }

{ Date: 16-Dec-80  V2.0
{ Who: Brad A. Myers
{ Added New procedures: PosC, AppendString, AppendChar, UpperCase, ConvUpper.
{ }

{ 27-Nov-80  1.1  Don Scelza
{ Fixed a bug in SubStr.  Added calls to UserError for errors.
{ (Not released)
{ }

{ Date: 30-Apr-80
{ Who: Don Scelza
{ Changed ConCat and SubStr to use temp strings for their hacking.
{ This will allow a use to pass the same string as input and result
{ parameters.
{ }

{ Date: 8-Apr-80
{ Who: Don Scelza
{ Created the string hacking module.
{ }
{------------------------------------------------------------------------}



{-------------------------------------------------------------------------
{
{ Strings in PERQ Pascal are stored a single character per byte with
{ the byte indexed by 0 being the length of the string.  When the routines
{ in this module must access the length byte they must turn off range
{ checking.  The effective definition of strings is:
{     Type String = RECORD
{                     length: 0..255;
{                     chars: PACKED ARRAY[1..MaxLength] of Char;
{                   END;
{ Note that the characters are packed and that the first index is 1.
{ See the PERQ Pascal Extensions manual for more information on strings.
{
{------------------------------------------------------------------------}

{********************}  Exports  {********************}


Const MaxPStringSize=255;          { Length of strings}
Type PString = String[MaxPStringSize];

Procedure Adjust(Var STR:PString;  LEN:Integer);
Function Concat(Str1,Str2:PString):PString;
Function Substr(Source:PString;  Index,Size: Integer):PString;
Procedure Delete(Var Str:PString;  Index,Size:Integer);
Procedure Insert(Var Source,Dest:PString; Index:Integer);
Function Pos(Source,Mask:PString): Integer;

FUNCTION PosC(s: PString; c: Char): Integer;
PROCEDURE AppendString(var s1: PString; s2: PString);
PROCEDURE AppendChar(var s: PString; c: Char);
FUNCTION UpperCase(c: Char): Char;
PROCEDURE ConvUpper(Var s: PString);

Exception StrBadParm;
{-------------------------------------------------------------------------
 Abstract: Raised when bad index or length parameters passed to procedures or
           sometimes when string will be too long (other times, StrLong is
           raised in this case
-------------------------------------------------------------------------}

Function RevPosC(s: PString; c: char): integer;

{********************}  Private  {********************}
