module Loader;

{-----------------------------------------------------------------------------
{
{       Loader - Perq system loader.
{       J. P. Strait    10 Feb 81.  rewritten as a module.
{       Copyright (C) Three Rivers Computer Corporation, 1981.
{
{ Abstract:
{       This module implements the Perq POS system loader.  Given a run-file
{ name as input, it loads and executes that program.  When the program
{ terminates (normally or abnormally) it returns to the loader which returns
{ to its caller.
{
{-----------------------------------------------------------------------------}

{-----------------------------------------------------------------------------
{ Change Log:
{
{  6 Jan 82  V2.7  Brad Myers
{ Fixed bug in reporting Qcode version incompatibility if hint succeeds
{
{ 10 Dec 81  V2.6  WJHansen
{ changes to use type long (xxTime, stretch(0), don't use Arith)
{
{ 25 Oct 81  V2.5  John Strait
{ Changes to agree with Memory V2.11.
{ }

{ 21 Jul 81  V2.4  John Strait
{ Change the loader to add segments to the segment table (marked as swapped-
{ out) rather than actually load them into memory.  This means that in some
{ sense the loader becomes part of the memory manager.
{ Add Hints.
{ }

{ 4 Jun 81  V2.3   John Strait
{ Add Virgil headers and comments.
{ }

{ 23 May 81  V2.2   John Strait
{ Use new IOKeyDisable/IOKeyEnable in place of old DisCtlC/EnaCtlC.
{ }

{ 18 May 81  V2.1   Brad Myers
{ Import IO_Unit and IO_Others instead of IO.
{ Added ** to error messages
{ }

{ 13 May 81  V2.0  John Strait
{ Use exceptions.
{ }

{ 13 Apr 81  V1.9  John Strait
{ Fix bug in multi-sector read code.
{ }

{ 10 Apr 81  V1.8  John Strait
{ Use new RunRead module.
{ }

{  6 Apr 81  V1.7  John Strait
{ 1) Fix bug in Q-code version processing.
{ 2) Stuff for virtual memory.
{ 3) Make use of new ProgramSN in RunHeader.
{ }

{ 30 Mar 81  V1.6  Brad Myers.
{ Use local lookup for seg file names.
{ }

{ 25 Mar 81  V1.5  John Strait.
{ Improved retries and messages from retry mechanism.
{ }

{ 25 Mar 81  V1.5  John Strait.
{ Improved retries and messages from retry mechanism.
{ }

{ 20 Mar 81  V1.4  Miles A. Barel
{ Added QCode Version Checks and long file names
{ }

{ 3 Mar 81  V1.3  John Strait.
{ Improve retry mechanism to immediately do a recalibrate after an
{ address error.
{ }

{ 1 Mar 81  V1.2  John Strait.
{ Speed up the loader by using multi-sector reads from the hard disk.
{ If errors, abort loading before loading the stack segment.
{ }

{ 23 Feb 81  V1.1  RFR.
{ Changed <= to = FSLookup test.
{ }

{ 10 Feb 81  V1.0  John Strait.
{ Start file.
{ }
{-----------------------------------------------------------------------------}

exports


   const LoaderVersion = '2.7';
   

   procedure Load( RunFileName: String );


private
