module FileUtils;
{----------------------------------------------------------------------
{Abstract: 
{
{ Filesystem utilities not needed by the system
 
   Written by Brad Myers.  March 5, 1981.

----------------------------------------------------------------------}

{----------------------------------------------------------------------
 Change log:

  2 Dec 81  BAM  V1.10    Rename to its original name changes capitalization.
 30 Nov 81  BAM  V1.9     Rename of a file to its original name works.
                          Exception for renaming a directory.
                          New routine FSRemoveDots.
 23 Jun 81  BAM  V1.8     Fixed so rename when couldn't enter file leaves it in
                           old directory
  1 Jun 81  BAM  V1.7     Added Get and Set FSData procedures
 27 May 81  BAM  V1.6     Added new exception to rename to handle file exists
 19 May 81  BAM  V1.5     Added new procedure for Extension lookup written by
                            JPS;
 12 May 81  BAM  V1.4     Added exceptions;
 16 Apr 81  BAM  V1.3     Fixed so Rename xx to y>..>y works;
 28 Mar 81  BAM  V1.2     Removed SetPath routine (is in shell);
                          Changed Push and Pop to take SearchList as argument.
                          Added AddToTitleLine procedure so programs will
                           display the current path
 26 Mar 81  BAM  V1.1     Changed MakeDirectory so doesn't uppercase the name;
                            checks to see if file exists; and changes the arg
                            to be the full path name of the new directory
                          Added headers;
 19 Mar 81  BAM  V1.0     PERQ_String;
 17 Mar 81  BAM  V0.3     New procedures FSPushSearchItem and Pop;
 16 Mar 81  BAM  V0.2     Fixed MakeDirectory to do more error checking;
  5 Mar 81  BAM  V0.1     Created this module by breaking off from FileSystem;
                           Also Made FSScan faster; added FSMakeDirectory
----------------------------------------------------------------------}


{********************} Exports {********************}

imports FileSystem from FileSystem;

type
  ptrScanRecord = ^ScanRecord;
  ScanRecord    = record
                    InitialCall : boolean;
                    Blk         : DiskAddr;
                    Entry       : Integer;
                    DirName     : PathName;
                  end;
                  
Procedure FSDelete(filename: PathName);
Function  FSScan(scanptr : ptrScanRecord; var name : SimpleName;
                 var id : FileID) : boolean;
Procedure FSRename(SrcName, DestName: PathName);
Function FSMakeDirectory(var DirName: PathName): FileID;
Procedure FSSetSearchList(sList: SearchList);
Procedure FSPopSearchItem(var sList: SearchList);
Procedure FSPushSearchItem(name: PathName; var sList: SearchList);
Procedure FSAddToTitleLine(msg: String); {adds as much of msg as possible to
                                          title line after the current path}
Exception DelError(FileName: PathName);
{----------------------------------------------------------------------
  Abstract: Raised when can't delete file (because not there)
  Parameters: FileName is file that can't delete
----------------------------------------------------------------------}

Exception RenError(msg: String; FileName: PathName);
{----------------------------------------------------------------------
  Abstract: Raised when can't rename file
  Parameters: msg is reason can't rename and fileName is file with the
               problem.  To print message, use "WriteLn('** ',msg,filename);"
----------------------------------------------------------------------}

Exception MkDirErr(msg: String; dirName: PathName);
{----------------------------------------------------------------------
  Abstract: Raised when can't make a directory because
             1) a file named dirName already exists
             2) dirName cannot be entered (bad subdir part)
             3) dirName is empty
             4) dirName is ROOT.DR (reserved directory name)
  Parameters:  msg explains problem with makedir attempt;
               dirName is name attempted to use.
              Use "WriteLn('** ',msg,dirName);"
----------------------------------------------------------------------}

Exception SrchWarn(fileName: PathName);
{----------------------------------------------------------------------
   Abstract: Raised if try to Pop last item or push into last hole of the
              Search List
   Parameters: '' if Pop; name of item trying to push if Push
   Resume: ALLOWED; if resume then does the operation anyway
----------------------------------------------------------------------}

Exception SrchErr(fileName: PathName);
{----------------------------------------------------------------------
  Abstract: Raised if try to Pop empty list or push onto full list for the
              Search List
  Parameters: '' if Pop; name of item trying to push if Push
  Resume: NOT allowed
----------------------------------------------------------------------}

Function FSExtSearch(var SList : SearchList; Extensions: String; 
                     var FileName : PathName;
                     var BlksInFile, BitsInLBlkInLBlk: Integer) : FileID;
                                          
Exception RenToExist(fileName: PathName);
{----------------------------------------------------------------------
  Abstract: Raised when try to rename to a file that already exists.  Not 
            raised if renaming a file to its own name (no-op).
  Parameters: fileName - new name that already exists
  Resume: ALLOWED; If you wish to rename anyway; just continue and FSRename
           will delete the DestName; In this case; you should be prepared
           to accept DelError;
----------------------------------------------------------------------}

Exception RenDir(fileName: PathName);
{----------------------------------------------------------------------
  Abstract: Raised when try to rename a directory.
  Parameters: fileName - name of the source directory.
  Resume: ALLOWED; If you wish to rename anyway; just continue and FSRename
           will do the operation.  RenToExist etc. may still be raised.
----------------------------------------------------------------------}

Procedure FSGetFSData(id: FileID; pData: ptrFSDataEntry);
Procedure FSSetFSData(id: FileID; pData: ptrFSDataEntry);
Procedure FSRemoveDots(var fname: PathName);


{********************} Private {********************}
