module ControlStore;
{-----------------------------------------------------------------------------
{
{ ControlStore - Load and call routines in the PERQ control-store.
{ J. P. Strait   ca. July 80.
{ Copyright (C) Three Rivers Computer Corporation, 1981.
{
{ Abstract:
{        The ControlStore module exports types defining the format of PERQ
{ micro-instructions and procedures to load and call routines in the
{ control-store.
{
{-----------------------------------------------------------------------------}

{-------------------------------------
{ Change Log:
{
{ 9 Dec 81  V1.2  WJHansen
{    Remove close comment bracket from inside comment
{
{ 3 Jun 81  V1.1  John Strait.
{ Add Virgil headers and comments.
{ }

{ ca. Jul 81  V1.0  John Strait.
{ Started file.
{ }
{-----------------------------------------------------------------------------}

exports


type MicroInstruction = { The format of a micro-instruction as produced by
                          the micro-assembler. }
       packed record case integer of
         0: (Word1: integer;
             Word2: integer;
             Word3: integer);
         1: (Jmp: 0..15;
             Cnd: 0..15;
             Z:   0..255;
             SF:  0..15;
             F:   0..3;
             ALU: 0..15;
             H:   0..1;
             W:   0..1;
             B:   0..1;
             A:   0..7;
             Y:   0..255;
             X:   0..255);
         2: (JmpCnd: 0..255;
             Fill1:  0..255;
             SFF:    0..63;
             ALU0:   0..1;
             ALU1:   0..1;
             ALU23:  0..3)
         end;
      
     MicroBinary = { The format of a micro-instruction and its address as
                     produced by the micro-assembler. }
       record
         Adrs: integer;
         MI:   MicroInstruction
         end;
      
     TransMicro = { The format of a micro-instruction as needed by the WCS
                    QCode. }
       packed record case integer of
         0: (Word1: integer;
             Word2: integer;
             Word3: integer);
         1: (ALU23: 0..3;
             ALU0:  0..1;
             W:     0..1;
             ALU1:  0..1;
             A:     0..7;
             Z:     0..255;
             SFF:   0..63;
             H:     0..1;
             B:     0..1;
             JmpCnd:0..255)
         end;
      
     MicroFile = file of MicroBinary;   { A file of micro-instructions. }
     
     
 procedure LoadControlStore( var F: MicroFile );
 procedure LoadMicroInstruction( Adrs: integer; MI: MicroInstruction );
 procedure JumpControlStore( Adrs: integer );
 
 
private
