Module CmdParse;
{---------------------------------------------------------------
{ Abstract:
{    This module provides a number of routines to help with command parsing.
{
{ Written by Don Scelza    April 30, 1980
{
{ Copyright (C) 1980 - Three Rivers Computer Corporation
{---------------------------------------------------------------}


{------------------------------------------------------------------
{ Change Log:
{
{ Date: 26 Jan-82  V3.6 Brad Myers
{ New procedure NextString like NextID only doesn't remove final character.
{ }

{ Date:  5 Jan-82  V3.5 Brad Myers
{ Fixed ParseStringArgs so inputs and outputs correctly set to NIL if error.
{ Additional error message from ParseStringArgs for , in outputs.
{ }

{ Date: 29 Dec-81  V3.4 Brad Myers
{ No period after ErAnyError message.
{ New error message: ErBadQuote.
{ Changed so err set to '' if no error (to avoid StringTooLong abort)
{ }

{ Date: 28 Dec-81  V3.3 Brad Myers
{ New procedure for removing quotes.  
{ New procedure for reporting errors.  
{ Renamed destroy procedures to Dstry... due to name conflicts
{ }

{ Date: 18 Dec-81  V3.2 Brad Myers
{ Allow quoting of special characters for NextID.  
{ }
{
{ Date: 27 Nov-81  V3.1 Brad Myers
{ New procedure: DestroyCmdFiles.  
{ }

{ Date: 13 Nov-81  V3.0 Brad Myers
{ Add new commands to make parsing easier.  Also don't require importing
{ system for UsrCmdLine.  
{ }

{ Date: 13-May-81  V2.0 John Strait
{ Change length of most strings to be 255 characters in length.  The strings
{   in CmdArrays are left as 80 characters because 255 character strings take
{   a lot of space and we figure that no command names will be longer than
{   80 characters.
{ }

{ Date: 19-Mar-81  Brad Myers
{ PERQ_String.
{ }

{ Date: 12-Feb-81  Diana Forgy
{ Module is now compatable with new PString, System, and Compiler.
{ }

{ Date: 23-Sep-80 Miles Barel
{ Incremented MaxCmds to 30.  Added the version number.
{ }

{ Date: 30-Apr-80 Don Scelza
{ Create CmdParse
{ }
{------------------------------------------------------------------}


{********************} Exports {********************}

Const CmdPVersion = '3.5';
      MaxCmds = 30;
      MaxCString = 255;
      CCR = Chr(13);  {same as standard CR}
      CmdChar = Chr(24);
      CmdFileChar = Chr(26);
      
Type CString = String[MaxCString];
     CmdArray = Array[1..MaxCmds] Of String;

Procedure CnvUpper(Var Str:CString);  {*** USE ConvUpper IN PERQ_String***}
Function UniqueCmdIndex(Cmd:CString; Var CmdTable: CmdArray;
                        NumCmds:Integer): Integer;
Procedure RemDelimiters(Var Src:CString; Delimiters:CString;
                        Var BrkChar:CString);
Procedure GetSymbol(Var Src,Symbol:CString; Delimiters:CString;
                    Var BrkChar:CString);

Function NextID(var id: CString; var isSwitch: Boolean): Char;
Function NextIDString(var s, id: CString;var isSwitch: Boolean): Char;

Type pArgRec = ^ArgRec;
     ArgRec = RECORD
                name: CString;
                next: pArgRec;
              END;

     pSwitchRec = ^SwitchRec;
     SwitchRec = RECORD
                   switch: CString;
                   arg: CString;
                   correspondingArg: pArgRec;
                   next: pSwitchRec;
                 END;

Function ParseCmdArgs(var inputs, outputs: pArgRec; var switches: pSwitchRec;
                      var err: String): boolean;
Function ParseStringArgs(s: CString; var inputs, outputs: pArgRec;
                      var switches: pSwitchRec; var err: String): boolean;
Procedure DstryArgRec(var a: pArgRec);
Procedure DstrySwitchRec(var a: pSwitchRec);

Type pCmdList = ^CmdListRec;
     CmdListRec = RECORD
                    cmdFile: Text;
                    isCharDevice: Boolean;
                    next: pCmdList;
                    seg: Integer;
                  END;

Procedure InitCmdFile(var inF: pCmdList; seg: Integer);
Function DoCmdFile(line: CString; var inF: pCmdList; var err: String): boolean;
Procedure ExitCmdFile(var inF: pCmdList);
Procedure ExitAllCmdFiles(var inF: pCmdList);
Procedure DstryCmdFiles(var inF: pCmdList);

Function RemoveQuotes(var s: CString): boolean;

Type ErrorType = (ErBadSwitch, ErBadCmd, ErNoSwParam, ErNoCmdParam, ErSwParam,
                  ErCmdParam, ErSwNotUnique, ErCmdNotUnique, ErNoOutFile,
                  ErOneInput, ErOneOutput, ErFileNotFound, ErDirNotFound,
                  ErIllCharAfter, ErCannotCreate, ErAnyError, ErBadQuote);
                  
Procedure StdError(err: ErrorType; param: CString; leaveProg: Boolean);
Function NextString(var s, id: CString; var isSwitch: Boolean): Char;

{********************} Private {********************}
