MODULE EtherTypes;
EXPORTS
IMPORTS AccentType FROM AccentType;
CONST
IOEIOC =#0;
IOETIM =#1;
IOEPTL =#2;
IOERNT =#3;
IOEBSE =#4;
IOEFUZ =#5;
TYPE
EtherHeader =PACKED RECORD
Src :0..255;
Dst :0..255;
Typ :INTEGER;
END;
CONST
MinEtherWords =WordSize(EtherHeader);
MaxEtherWords =748;
TYPE
pEtherPacket =^EtherPacket;
EtherPacket =RECORD
CASE Integer OF
0 :(
Header :EtherHeader;
DataWords :ARRAY[0 ..MaxEtherWords -
WordSize(EtherHeader)-1
]OF INTEGER );
1 :(
Words :ARRAY[0 ..MaxEtherWords-1]OF INTEGER );
2:(
LongHeader :EtherHeader;
LongWords :ARRAY[0 ..(MaxEtherWords -
WordSize(EtherHeader))
div 2 -1]OF LONG );
3 :(
ConfigHdr :EtherHeader;
SkipC :integer;
ConfigBytes :PACKED ARRAY
[0 ..2 *(MaxEtherWords -
WordSize(EtherHeader)-1)]
OF Bit8)
END;
CONST
EtherTypEchoMe =#700;
EtherTypIAmAnEcho =#701;
EtherTyp3ConfigTest =#220;
EtherTypPup =#1000;
EtherTypConfigTest =#220;
FwdCode =2;
ReplyCode =1;
TYPE
PupLLong =RECORD
CASE INTEGER OF
1 :(Lng :Long );
2 :(Low :Integer;
Hgh :Integer )
END;
TYPE
PupHLong =RECORD
CASE INTEGER OF
1 :(Lng :Long );
2 :(Hgh :Integer;
Low :Integer );
END;
TYPE
PupPort =PACKED RECORD
CASE integer OF
0 :(
Host:0..255;
Net :0..255;
Soc :PupHLong );
1 :(
All :PACKED ARRAY [0..5]OF Char )
END;
TYPE
PupHeader =PACKED RECORD
Len :INTEGER;
Typ :0..255;
TC :0..255;
Id :PupHLong;
Dst :PupPort;
Src :PupPort
END;
TYPE
pPupData =^PupData;
PupData =RECORD
CASE INTEGER OF
0 :(Chars :PACKED ARRAY[0..1043]OF CHAR);
1 :(Bytes :PACKED ARRAY[0..1043]OF 0..255);
2 :(Words :PACKED ARRAY[0..521]OF INTEGER);
3 :(HLongs :PACKED ARRAY[0..260]OF PupHLong);
4 :(Ports :PACKED ARRAY[0..260]OF PupPort);
END;
CONST
MinPupWords =WordSize(PupHeader)+1;
MaxPupWords =533;
TYPE
pPupPacket =^PupPacket;
PupPacket =RECORD
CASE INTEGER OF
0 :(Header :PupHeader;
Data :PupData );
1 :(ChkSums :ARRAY [0..532]OF Integer )
END;
CONST
PupCMUNet =#52;
CONST
PupError =#4;
PupEFTPData =#30;
PupEFTPAck =#31;
PupEFTPEnd =#32;
PupEFTPBort =#33;
CONST
PupNameSocket =#4*#200000;
PupEFTPSocket =#20*#200000;
TYPE
MsgPacket =RECORD
Head :Msg;
TPacket :TypeType;
END;
MsgEtherPacket =RECORD
Head :Msg;
TPacket :TypeType;
Packet :EtherPacket;
END;
MsgPupPacket =RECORD
Head :Msg;
TPacket :TypeType;
Packet :PupPacket;
END;
CONST
PacketBytes =2 *WordSize(MsgPacket);
EtherPacketBytes =2 *WordSize(MsgEtherPacket);
PupPacketBytes =2 *WordSize(MsgPupPacket);
CONST
EtherIDBase =800;
IDGetEtherAddress =EtherIDBase +1;
IDRGetEtherAddress =EtherIDBase +101;
IDSetEtherFilter =EtherIDBase +2;
IDRSetEtherFilter =EtherIDBase +102;
IDClrEtherFilter =EtherIDBase +3;
IDRClrEtherFilter =EtherIDBase +103;
IDSendEtherPacket =EtherIDBase +4;
IDRecvEtherPacket =EtherIDBase +104;
IDSetPupFilter =EtherIDBase +5;
IDRSetPupFilter =EtherIDBase +105;
IDClrPupFilter =EtherIDBase +6;
IDRClrPupFilter =EtherIDBase +106;
IDSendPupPacket =EtherIDBase +7;
IDRecvPupPacket =EtherIDBase +107;
TYPE
pMsgGetEtherAddress =^MsgGetEtherAddress;
MsgGetEtherAddress =RECORD
Head :Msg
END;
pMsgRGetEtherAddress=^MsgRGetEtherAddress;
MsgRGetEtherAddress =RECORD
Head :Msg;
TEtherAddress :TypeType;
EtherAddress :INTEGER
END;
pMsgSetEtherFilter =^MsgSetEtherFilter;
MsgSetEtherFilter =RECORD
Head :Msg;
TTyp :TypeType;
Typ :INTEGER;
TProcessPort:TypeType;
ProcessPort :Port
END;
pMsgRSetEtherFilter =^MsgRSetEtherFilter;
MsgRSetEtherFilter =RECORD
Head :Msg;
TTyp :TypeType;
Typ :INTEGER;
TAnswer :TypeType;
Answer :BOOLEAN
END;
pMsgClrEtherFilter =^MsgClrEtherFilter;
MsgClrEtherFilter =RECORD
Head :Msg;
TTyp :TypeType;
Typ :INTEGER;
TProcessPort:TypeType;
ProcessPort :Port
END;
pMsgRClrEtherFilter =^MsgRClrEtherFilter;
MsgRClrEtherFilter =RECORD
Head :Msg;
TTyp :TypeType;
Typ :INTEGER;
TAnswer :TypeType;
Answer :BOOLEAN
END;
pMsgSendEtherPacket =^MsgSendEtherPacket;
MsgSendEtherPacket =MsgEtherPacket;
pMsgRecvEtherPacket =^MsgRecvEtherPacket;
MsgRecvEtherPacket =MsgEtherPacket;
pMsgSetPupFilter =^MsgSetPupFilter;
MsgSetPupFilter =RECORD
Head :Msg;
TSocket :TypeType;
Socket :Long;
TProcessPort:TypeType;
ProcessPort :Port
END;
pMsgRSetPupFilter =^MsgRSetPupFilter;
MsgRSetPupFilter =RECORD
Head :Msg;
TSocket :TypeType;
Socket :Long;
TAnswer :TypeType;
Answer :Boolean
END;
pMsgClrPupFilter =^MsgClrPupFilter;
MsgClrPupFilter =RECORD
Head :Msg;
TSocket :TypeType;
Socket :Long;
TProcessPort:TypeType;
ProcessPort :Port
END;
pMsgRClrPupFilter =^MsgRClrPupFilter;
MsgRClrPupFilter =RECORD
Head :Msg;
TSocket :TypeType;
Socket :Long;
TAnswer :TypeType;
Answer :Boolean
END;
pMsgSendPupPacket =^MsgSendPupPacket;
MsgSendPupPacket =MsgPupPacket;
pMsgRecvPupPacket =^MsgRecvPupPacket;
MsgRecvPupPacket =MsgPupPacket;
PRIVATE
 { Stub created by MakeStub at15-Feb-84  17:23:54 }
begin
end.
