/*	$NetBSD: getstr.c,v 1.12 2000/05/01 12:30:30 blymn Exp $	*/

/*
 * Copyright (c) 1981, 1993, 1994
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <sys/cdefs.h>
#ifndef lint
#if 0
static char sccsid[] = "@(#)getstr.c	8.2 (Berkeley) 5/4/94";
#else
__RCSID("$NetBSD: getstr.c,v 1.12 2000/05/01 12:30:30 blymn Exp $");
#endif
#endif				/* not lint */

#include "curses.h"
#include "curses_private.h"

#ifndef _CURSES_USE_MACROS

/*
 * getstr --
 *	Get a string from stdscr starting at (cury, curx).
 */
int
getstr(char *str)
{
	return wgetstr(stdscr, str);
}

/*
 * mvgetstr --
 *      Get a string from stdscr starting at (y, x).
 */
int
mvgetstr(int y, int x, char *str)
{
	return mvwgetstr(stdscr, y, x, str);
}

/*
 * mvwgetstr --
 *      Get a string from the given window starting at (y, x).
 */
int
mvwgetstr(WINDOW *win, int y, int x, char *str)
{
	if (wmove(win, y, x) == ERR)
		return ERR;

	return wgetstr(win, str);
}

#endif

/*
 * wgetstr --
 *	Get a string starting at (cury, curx).
 */
int
wgetstr(WINDOW *win, char *str)
{
	char *ostr, ec;
	int oldx;

	ostr = str;
	ec = erasechar();
	oldx = win->curx;
	
	while ((*str = wgetch(win)) != ERR && *str != '\n') {
		if (*str == ec) {
			*str = '\0';
			if (str != ostr) {
				mvwdelch(win, win->cury, win->curx);
				str--;
			} else
				wmove(win, win->cury, oldx);
		} else
			str++;
	}
	
	if (*str == ERR) {
		*str = '\0';
		return (ERR);
	}
	*str = '\0';
	return (OK);
}
