/*	$NetBSD: menus.mi.fr,v 1.28.2.2 2000/10/18 17:51:15 tv Exp $	*/

/*
 * Copyright 1997 Piermont Information Systems Inc.
 * All rights reserved.
 *
 * Written by Philip A. Nelson for Piermont Information Systems Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed for the NetBSD Project by
 *      Piermont Information Systems Inc.
 * 4. The name of Piermont Information Systems Inc. may not be used to endorse
 *    or promote products derived from this software without specific prior
 *    written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY PIERMONT INFORMATION SYSTEMS INC. ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL PIERMONT INFORMATION SYSTEMS INC. BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 * Menu system definitions -- machine independent
 *
 * Some menus may be called directly in the code rather than via the 
 * menu system.
 *
 *  This file must be first in the sed command line.
 *
 */

{
#include <stdio.h>
#include <curses.h>
#include "defs.h"
#include "md.h"
#include "msg_defs.h"
#include "menu_defs.h"
}

default y=12, no exit, scrollable;

allow dynamic menus;

menu netbsd, title "NetBSD-@@VERSION@@ Programme d'installation",
    exit, exitstring "Quitter le programme d'installation";
	display action  { toplevel(); };
	option "Installation de NetBSD sur disque dur",
		action { do_install(); };
	option "Mise  jour de NetBSD sur disque dur",
		action { do_upgrade(); };
	option "Rinstaller ou installer de nouveaux composants",
		action { do_reinstall_sets(); };
	option "Redmarrer l'ordinateur", exit,
		action (endwin) { run_prog(0, NULL, "/sbin/reboot"); };
	option "Menu utilitaire", sub menu utility;

menu utility, title "Utilitaires NetBSD-@@VERSION@@", exit;
	/* option "test", action { run_prog(RUN_DISPLAY, NULL, "/bin/pwd"); }; */
	/* option "testfalse", action { run_prog(0, "%s: kaput", "/bin/false"); }; */
	option "Excuter /bin/sh",
		action (endwin) { system("/bin/sh"); };
	option "Configuration du rseau",
		action {
			extern int network_up;

			network_up = 0;
			config_network();
		};
/*	option "Partitioner un disque"; XXX add later.  */
	option "Traces", action { do_logging(); };
	option "Arrter le systme", exit,
		action (endwin) { run_prog(0, NULL, "/sbin/halt"); };

menu yesno, title "oui ou non?";
	option "Oui", exit, action  {yesno = 1;};
	option "Non",  exit, action  {yesno = 0;};

menu noyes, title "oui ou non?";
	option "Non",  exit, action  {yesno = 0;};
	option "Oui", exit, action  {yesno = 1;};

menu ok, title "Presser entre pour continuer";
	option "ok", exit;

menu layout, y=13, title  "Choisissez votre type d'installation";
	option "Standard", 	  exit, action { layoutkind = 1; };
	option "Standard avec X", exit, action { layoutkind = 2; };
	option "Personnalise", 	  exit, action { layoutkind = 3; };

menu sizechoice, title  "Choisissez votre unit d'espace disque";
	option "Megaoctets", exit, action 
		{ sizemult = MEG / sectorsize;
		  multname = msg_string(MSG_megname);
		};
	option "Cylindres", exit, action 
		{ sizemult = current_cylsize; 
		  multname = msg_string(MSG_cylname);
		};
	option "Secteurs", exit, action 
		{ sizemult = 1; 
		  multname = msg_string(MSG_secname);
		};

menu fspartok, title "Partitions ok?", y=15;
	display action  {
		msg_display(MSG_fspart, multname);
		disp_cur_fspart(-1, 0);
	};
	option "Changer une partition", sub menu editfsparts;
	option "Les Partitions sont ok", exit;

menu edfspart, title "Changer quoi?", exit, y=15;
	display action  {
		msg_display (MSG_edfspart, 'a'+editpart);
		disp_cur_fspart(editpart, 1);
	};
	option "type de FS", sub menu  selfskind;
	option "Offset/taille", action  
		{	int start, size;
			msg_display_add(MSG_defaultunit, multname);
			start = getpartoff(MSG_offset, 0);
			size = getpartsize(MSG_size, start, 0);
			if (size == -1)
				size = dlsize - start;
			bsdlabel[editpart].pi_offset = start;
			bsdlabel[editpart].pi_size = size;
		};
	option "Taille de block/Taille de fragment", action 
		{	char buf[40]; int i;

			if (bsdlabel[editpart].pi_fstype != FS_BSDFFS) {
				msg_display (MSG_not42bsd, 'a'+editpart);
				process_menu (MENU_ok);
				return FALSE;
			}
			msg_prompt_add (MSG_bsize, NULL, buf, 40);
			i = atoi(buf);
			bsdlabel[editpart].pi_bsize = i;
			msg_prompt_add (MSG_fsize, NULL, buf, 40);
			i = atoi(buf);
			bsdlabel[editpart].pi_fsize = i;
		};
	option "Point de montage", action 
		{	if (bsdlabel[editpart].pi_fstype == FS_BSDFFS ||
			    bsdlabel[editpart].pi_fstype == FS_MSDOS)
				msg_prompt_add (MSG_mountpoint, NULL,
					fsmount[editpart], 20);
			else {
				msg_display (MSG_nomount, 'a'+editpart);
				process_menu (MENU_ok);
			}
		};

menu selfskind, title "Selection du type de systme de fichier", y=15;
	option "4.2BSD", exit, action 
			{ bsdlabel[editpart].pi_fstype = FS_BSDFFS;
			  bsdlabel[editpart].pi_bsize  = 8192;
			  bsdlabel[editpart].pi_fsize  = 1024;
			};
	option "unused", exit, action 
			{ bsdlabel[editpart].pi_fstype = FS_UNUSED;
			  bsdlabel[editpart].pi_bsize  = 0;
			  bsdlabel[editpart].pi_fsize  = 0;
			};
	option "swap", exit, action 
			{ bsdlabel[editpart].pi_fstype = FS_SWAP;
			  bsdlabel[editpart].pi_bsize  = 0;
			  bsdlabel[editpart].pi_fsize  = 0;
			};
	option "msdos", exit, action 
			{ bsdlabel[editpart].pi_fstype = FS_MSDOS;
			  bsdlabel[editpart].pi_bsize  = 0;
			  bsdlabel[editpart].pi_fsize  = 0;
			};


menu distmedium, title "Slection du media d'installation";
	display action { msg_display (MSG_distmedium); nodist = 0; };
	option "ftp",  action   {
				got_dist = get_via_ftp();
				},
				exit;
	option "nfs",  action   {
				got_dist = get_via_nfs();
				}, exit;
	option "cdrom", action  {
				got_dist = get_via_cdrom();
				}, exit;
	option "disquette", action {
				got_dist = get_via_floppy();
				}, exit;
	
	option "systeme de fichier non-mont", action {
				got_dist = get_via_localfs();
				}, exit;
	option "rpertoire local", action {
				got_dist = get_via_localdir();
				}, exit;
	option "aucun",  action { nodist = 1; }, exit;

menu distset, title "Slection de la distribution";
	display action { msg_display (MSG_distset); };
	option "Installation complte", exit;
	option "Installation personnalise", next menu md_distcustom;

menu ftpsource, title "Changer";
	display action
		{ msg_clear();
		  msg_table_add (MSG_ftpsource, ftp_host, ftp_dir, ftp_user,
		     strcmp(ftp_user, "ftp") == 0 ? ftp_pass :
		       strlen(ftp_pass) != 0 ? "** cach **" : "");
		};
	option "Serveur ftp", action
		{ msg_prompt (MSG_host, ftp_host, ftp_host, 255); };
	option "Rpertoire", action
		{ msg_prompt (MSG_dir, ftp_dir, ftp_dir, 255); };
	option "Utilisateur", action
		{ msg_prompt (MSG_user, ftp_user, ftp_user, 255); };
	option "Mot de passe", action
		{ if (strcmp(ftp_user, "ftp") == 0)
			msg_prompt (MSG_email, ftp_pass, ftp_pass, 255);
		  else {
			msg_prompt_noecho (MSG_passwd, "", ftp_pass, 255);
		  }
		};
	option "Rcuprer la Distribution", exit;

menu nfssource, title "Changer";
	display action
		{ msg_display (MSG_nfssource, nfs_host, nfs_dir); };
	option "Serveur nfs", action
		{ msg_prompt (MSG_host, NULL, nfs_host, 255); };
	option "Rpertoire", action
		{ msg_prompt (MSG_dir, NULL, nfs_dir, 255); };
	option "Continuer", exit;

menu nfsbadmount, title "Que voulez vous faire?";
	option "Ressayer", exit, sub menu nfssource, action
		{ yesno = 1; ignorerror = 0; };
	option "Abandonner", exit, action
		{ yesno = 1; ignorerror = 0; };
	option "Ignorer les erreurs, continuer quand mme", exit, action
		{ yesno = 1; ignorerror = 1; };


menu fdremount, title "Que voulez vous faire?";
	option "Ressayer", exit, action { yesno = 1; };
	option "Annuler l'installation", exit, action { yesno = 0; };

menu fdok, title "Presser entre pour continuer";
	option "OK", exit, action { yesno = 1; };
	option "Abandonner l'installation", exit, action { yesno = 0; };


menu cdromsource, title "Changer";
	display action
		{ msg_display (MSG_cdromsource, cdrom_dev, cdrom_dir); };
	option "Device", action
		{ msg_prompt (MSG_dev, cdrom_dev, cdrom_dev, SSTRSIZE); };
	option "Rpertoire", action
		{ msg_prompt (MSG_dir, cdrom_dir, cdrom_dir, STRSIZE); };
	option "Continuer", exit;

menu cdrombadmount, title "Que voulez-vous faire?";
	option "Ressayer", exit, sub menu cdromsource, action
		{ yesno = 1; ignorerror = 0; };
	option "Abandonner", exit, action
		{ yesno = 0; ignorerror = 0; };
	option "Ignorer les erreurs, continuer quand mme", exit, action
		{ yesno = 1; ignorerror = 1; };

menu localfssource, title "Changer";
	display action
		{ msg_display (MSG_localfssource, localfs_dev, localfs_fs, localfs_dir); };
	option "Device", action
		{ msg_prompt (MSG_dev, localfs_dev, localfs_dev, SSTRSIZE); };
	option "Systme de fichier", action
		{ msg_prompt (MSG_filesys, localfs_fs, localfs_fs, STRSIZE); };
	option "Rpertoire", action
		{ msg_prompt (MSG_dir, localfs_dir, localfs_dir, STRSIZE); };
	option "Continuer", exit;

menu localfsbadmount, title "Que voulez vous faire?";
	option "Ressayer", exit, sub menu localfssource, action
		{ yesno = 1; ignorerror = 0; };
	option "Abandonner", exit, action
		{ yesno = 1; ignorerror = 0; };
	option "Ignorer les erreurs, continuer quand mme", exit, action
		{ yesno = 1; ignorerror = 1; };

menu localdirsource, title "Changer";
	display action
		{ msg_display(MSG_localdir, localfs_dir); };
	option "Rpertoire", action
		{ msg_prompt (MSG_dir, localfs_dir, localfs_dir, STRSIZE); },
		exit;
	option "Continuer", exit;

menu localdirbad, title "Que voulez vous faire?";
	option "Changer le chemin d'accs",  action
		{ yesno = 1;
			msg_prompt(MSG_localdir, localfs_dir, localfs_dir, STRSIZE);
		}, exit;
	option "Abandonner", exit, action
		{ yesno = 0; ignorerror = 0; };
	option "Ignorer les erreurs, continuer quand mme", exit, action
		{ yesno = 1; ignorerror = 1; };

menu namesrv6, title "  Choisissez un serveur de noms IPv6 :";
	option "paradise.v6.kame.net", exit, action
		{
#ifdef INET6
		  strncpy(net_namesvr6, "3ffe:501:4819::42",
		      sizeof(net_namesvr6));
		  yesno = 1;
#else
		  yesno = 0;
#endif
		}; 
	option "kiwi.itojun.org", exit, action
		{
#ifdef INET6
		  strncpy(net_namesvr6, "3ffe:501:410:100:5254:ff:feda:48bf",
		      sizeof(net_namesvr6));
		  yesno = 1;
#else
		  yesno = 0;
#endif
		}; 
	option "sh1.iijlab.net", exit, action
		{
#ifdef INET6
		  strncpy(net_namesvr6, "3ffe:507:0:1:260:97ff:fe07:69ea",
		      sizeof(net_namesvr6));
		  yesno = 1;
#else
		  yesno = 0;
#endif
		}; 
	option "ns1.v6.intec.co.jp", exit, action 
		{
#ifdef INET6
		  strncpy(net_namesvr6, "3ffe:508:0:1::53",
		      sizeof(net_namesvr6));
		  yesno = 1;
#else
		  yesno = 0;
#endif
		}; 
	option "nttv6.net", exit, action
		{
#ifdef INET6
		  strncpy(net_namesvr6, "3ffe:1800:1000::1",
		      sizeof(net_namesvr6));
		  yesno = 1;
#else
		  yesno = 0;
#endif
		}; 
	option "light.imasy.or.jp", exit, action
		{
#ifdef INET6
		  strncpy(net_namesvr6, "3ffe:505:0:1:2a0:c9ff:fe61:6521",
		      sizeof(net_namesvr6));
		  yesno = 1;
#else
		  yesno = 0;
#endif
		}; 
	option "other ", exit, action
		{ yesno = 0; };

menu ip6autoconf, title "Faire la configuration automatique IPv6 ?";
	option "Yes", exit, action  {yesno = 1;};
	option "No",  exit, action  {yesno = 0;};

menu dhcpautoconf, title "Excutez la configuration automatique de DHCP?";
        option "Yes", exit, action  {yesno = 1;};
        option "No",  exit, action  {yesno = 0;};
