/*	$NetBSD: lockd.c,v 1.2 1997/10/18 04:01:18 lukem Exp $	*/

/*
 * Copyright (c) 1995
 *	A.R. Gordon (andrew.gordon@net-tel.co.uk).  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed for the FreeBSD project
 * 4. Neither the name of the author nor the names of any co-contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ANDREW GORDON AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include <sys/cdefs.h>
#ifndef lint
__RCSID("$NetBSD: lockd.c,v 1.2 1997/10/18 04:01:18 lukem Exp $");
#endif

/*
 * main() function for NFS lock daemon.  Most of the code in this
 * file was generated by running rpcgen /usr/include/rpcsvc/nlm_prot.x.
 *
 * The actual program logic is in the file procs.c
 */

#include <err.h>
#include <stdio.h>
#include <stdlib.h>
#include <syslog.h>
#include <unistd.h>

#include <rpc/rpc.h>
#include <rpcsvc/sm_inter.h>

#include "lockd.h"
#include "nlm_prot.h"

/*
 * XXX - Actual locking is not implemented.  Some notes from the FreeBSD
 * rpc.lockd/handles.c:
 *
 * - Need to find all fds in use by a host and free them when host crashes
 *   (need not be efficient)
 * - Need to find fd corresponding to <inode, device>
 */

typedef struct fdinfo {
	int	fd;		/* The file descriptor itself */
	int	ref_count;	/* Count of hosts using the fd - fd is
				   closed when this reaches zero */
	ino_t	inode_no;	/* The inode number of this file. */
	dev_t	device;		/* device on which the file lives. */
	struct fdinfo	*next;	/* Chain of FdInfo structures */
	struct fdinfo	*prev;
}       FdInfo;

int		debug_level = 0;	/* 0 = no debugging syslog() calls */
int		_rpcsvcdirty = 0;

int	main __P((int, char **));
void	nlm_prog_1 __P((struct svc_req *, SVCXPRT *));
void	nlm_prog_3 __P((struct svc_req *, SVCXPRT *));

int
main(argc, argv)
	int argc;
	char **argv;
{
	SVCXPRT *transp;
	int ch;

	while ((ch = getopt(argc, argv, "d:")) != (-1)) {
		switch (ch) {
		case 'd':
			debug_level = atoi(optarg);
			if (!debug_level) {
				errx(1, "usage: rpc.lockd [-d <debuglevel>]");
				/* NOTREACHED */
			}
			break;
		default:
		case '?':
			errx(1, "usage: rpc.lockd [-d <debuglevel>]");
			/* NOTREACHED */
		}
	}

	(void)pmap_unset(NLM_PROG, NLM_VERS);
	(void)pmap_unset(NLM_PROG, NLM_VERSX);

	transp = svcudp_create(RPC_ANYSOCK);
	if (transp == NULL) {
		errx(1, "cannot create udp service.");
		/* NOTREACHED */
	}
	if (!svc_register(transp, NLM_PROG, NLM_VERS,
	    nlm_prog_1, IPPROTO_UDP)) {
		errx(1, "unable to register (NLM_PROG, NLM_VERS, udp).");
		/* NOTREACHED */
	}
	if (!svc_register(transp, NLM_PROG, NLM_VERSX,
	    nlm_prog_3, IPPROTO_UDP)) {
		errx(1, "unable to register (NLM_PROG, NLM_VERSX, udp).");
		/* NOTREACHED */
	}
	transp = svctcp_create(RPC_ANYSOCK, 0, 0);
	if (transp == NULL) {
		errx(1, "cannot create tcp service.");
		/* NOTREACHED */
	}
	if (!svc_register(transp, NLM_PROG, NLM_VERS,
	    nlm_prog_1, IPPROTO_TCP)) {
		errx(1, "unable to register (NLM_PROG, NLM_VERS, tcp).");
		/* NOTREACHED */
	}
	if (!svc_register(transp, NLM_PROG, NLM_VERSX,
	    nlm_prog_3, IPPROTO_TCP)) {
		errx(1, "unable to register (NLM_PROG, NLM_VERSX, tcp).");
		/* NOTREACHED */
	}

	/*
	 * Note that it is NOT sensible to run this program from inetd - the
	 * protocol assumes that it will run immediately at boot time.
	 */
	if (daemon(0, 0)) {
		err(1, "cannot fork");
		/* NOTREACHED */
	}

	openlog("rpc.lockd", 0, LOG_DAEMON);
	if (debug_level)
		syslog(LOG_INFO, "Starting, debug level %d", debug_level);
	else
		syslog(LOG_INFO, "Starting");

	svc_run();		/* Should never return */
	exit(1);
}
