/* Copyright 1990 Network Computing Devices, Inc.  All rights reserved. */

#ident "@(#)pcftosnf.h	13.1	90/08/16"

/*
 * this is a bunch of horrible hacks to deal with DEC
 * re-using a bunch of snf names with radically different structures
 */

#define GLYPHPADOPTIONS 4	/* 1, 2, 4, or 8 */

typedef struct _pcfFontProp {
    ATOM name;
    INT32 value;        /* assumes ATOM is not larger than INT32 */
} pcfFontPropRec;

typedef struct _pcfFontProp	*pcfFontPropPtr;


/*
 * a single CharSet structure may be used by multiple EncodedFont records if 
 * there are multiple encodings using the same basic set of glyphs.
 */
typedef struct _CharSet {
        /* Information about Font File */
    Mask	tables;		/* which tables are currently loaded */
    int		fileType;	/* what format is the source file */
	/* Font accelerator information */
    Bool	noOverlap;	/* true if:
				 * max(rightSideBearing-characterWidth)
				 * <= minbounds->metrics.leftSideBearing
				 */
    Bool	constantMetrics;
    Bool	terminalFont;	/* Should be deprecated!  true if:
				 * constant metrics &&
				 * leftSideBearing == 0 &&
				 * rightSideBearing == characterWidth &&
				 * ascent == fontAscent &&
				 * descent == fontDescent
				 */
    Bool	constantWidth;/* true if minbounds->metrics.characterWidth
				 *      == maxbounds->metrics.characterWidth
				 */
    Bool	inkInside;	/* true if for all defined glyphs:
				 * leftSideBearing >= 0 &&
				 * leftSideBearing >= 0 &&
				 * rightSideBearing <= characterWidth &&
				 * -fontDescent <= ascent <= fontAscent &&
				 * -fontAscent <= descent <= fontDescent
				 */
    Bool	inkMetrics;	/* ink metrics != bitmap metrics */
					/* used with terminalFont */
    short	drawDirection;
    int		fontDescent;	/* minimum for quality typography */
    int		fontAscent;	/* minimum for quality typography */
    int		maxOverlap;	/* how much right side bearing is than width */
    xCharInfo	maxbounds;	/* for all characters in font -- used by DDX */
    xCharInfo	minbounds;

	/* property information */
    int		nProps;
    pcfFontPropPtr	props;
    Bool	*isStringProp;

    int		nChars;

	/* metric information */
    Mask	metricFlags;	/* information about metrics */
    union {
	CharInfoPtr	 pCI;	/* all of the defined glyphs (1d),for DDX */
	CharInfoPtr	*ppCI;	/* all of the defined glyphs (2d), for DDX */
    } ci;
    union {
	CharInfoPtr	 pCI;	/* ink metrics, for passing to client (1d) */
	CharInfoPtr	*ppCI;	/* ink metrics, for passing to client (2d) */
    } inkci;

	/* scalable width information */
    int		*sWidth;	/* scalable width of char */

	/* glyph picture information */
    Mask	bitmapFlags;
    int		bitmapsSizes[GLYPHPADOPTIONS];
    int		pixDepth;	/* intensity bits per pixel */
    int		glyphSets;	/* number of sets of glyphs, for
				    sub-pixel positioning */
    char	**pBitOffsets;	/* pointer to bitmaps for each character */
    char	*pBitmaps;	/* pointer to buffer containing all bitmaps */

	/* glyph name information */
    Atom	*glyphNames;	/* references in order of metrics */

	/* private miscellania */
    int		refcnt;		/* # of encodings referencing these glyphs */
    pointer	osPrivate;
    pointer	*devPriv;	/* information private to screen */
/* 4/23/89 (ef) -- this has to get allocated somehow */
} CharSetRec;


/*
 * Font is created at font load time. It is specific to a single encoding.
 * e.g. not all of the glyphs in a font may be part of a single encoding.
 */
typedef struct _EncodedFont {
    char	*encoding;	/* name of this encoding */
    int		encIndex;	/* index of this encoding */
    CharSetPtr	pCS;		/* pointer to the shared data */
    int		firstCol;
    int		lastCol;
    int		firstRow;
    int		lastRow;
    Bool	linear;	/* true if firstRow == lastRow */
    Bool	allExist;	/* true if no holes in array */
    Mask	ciFlags;	/* info about CharInfo (1d vs. 2d) */
    CharInfoPtr *ppCI;		/* an array of pointers */
    CharInfoPtr *ppInkCI;	/*	may be copy of chars */
    xCharInfo	inkMin;		/* for this encoding's ink metrics */
    xCharInfo	inkMax;		/*	for reporting to clients */
    int		defaultCh;	/* for this encoding, may be NO_SUCH_CHAR */
    CharInfoPtr	pDefChar;	/* realized for this encoding */
    int		refcnt;
    pointer	osPrivate;
    pointer	*devPriv;	/* information private to screen */
} EncodedFontRec;
