/* Copyright 1990 Network Computing Devices, Inc.  All rights reserved. */

#ident "@(#)bdftosnf.h	13.1	90/08/16"

#ifdef SYSV
#include <memory.h>
#define bzero(b,length) memset(b,0,length)
/* these are not strictly equivalent, but suffice for uses here */
#define bcopy(b1,b2,length) memcpy(b2,b1,length)
#endif /* SYSV */

#ifndef MIN
#define MIN(a,b) ((a)>(b)?(b):(a))
#endif
#ifndef MAX
#define MAX(a,b) ((a)>(b)?(a):(b))
#endif

typedef struct _GlyphMap {
    char	*bits;
    int		h;
    int		w;
    int		widthBytes;
} GlyphMap;

/*
 * a structure to hold all the pointers to make it easy to pass them all
 * around. Much like the FONT structure in the server.
 */

typedef struct _TempFont {
    FontInfoPtr pFI;
    CharInfoPtr pCI;
    unsigned char *pGlyphs;
    FontPropPtr pFP;
    CharInfoPtr pInkCI;
    CharInfoPtr pInkMin;
    CharInfoPtr pInkMax;
} TempFont; /* not called font since collides with type in X.h */

#ifdef NCD
#     define DEFAULTGLPAD     4               /* default padding for glyphs */
#     define DEFAULTBITORDER  MSBFirst        /* default bitmap bit order */
#     define DEFAULTBYTEORDER MSBFirst        /* default bitmap byte order */
#     define DEFAULTSCANUNIT  1               /* default bitmap scan unit */
#else NCD


#ifdef vax

#	define DEFAULTGLPAD 	1		/* default padding for glyphs */
#	define DEFAULTBITORDER 	LSBFirst	/* default bitmap bit order */
#	define DEFAULTBYTEORDER LSBFirst	/* default bitmap byte order */
#	define DEFAULTSCANUNIT	1		/* default bitmap scan unit */
#else
# ifdef sun

#  if (sun386 || sun5)
#	define DEFAULTGLPAD 	4		/* default padding for glyphs */
#	define DEFAULTBITORDER 	LSBFirst	/* default bitmap bit order */
#	define DEFAULTBYTEORDER LSBFirst	/* default bitmap byte order */
#	define DEFAULTSCANUNIT	1		/* default bitmap scan unit */
#  else
#	define DEFAULTGLPAD 	4		/* default padding for glyphs */
#	define DEFAULTBITORDER 	MSBFirst	/* default bitmap bit order */
#	define DEFAULTBYTEORDER MSBFirst	/* default bitmap byte order */
#	define DEFAULTSCANUNIT	1		/* default bitmap scan unit */
#  endif

# else
#  ifdef apollo

#	define DEFAULTGLPAD 	2		/* default padding for glyphs */
#	define DEFAULTBITORDER 	MSBFirst	/* default bitmap bit order */
#	define DEFAULTBYTEORDER MSBFirst	/* default bitmap byte order */
#	define DEFAULTSCANUNIT	1		/* default bitmap scan unit */

#  else
#   ifdef ibm032

#	define DEFAULTGLPAD 	1		/* default padding for glyphs */
#	define DEFAULTBITORDER 	MSBFirst	/* default bitmap bit order */
#	define DEFAULTBYTEORDER MSBFirst	/* default bitmap byte order */
#	define DEFAULTSCANUNIT	1		/* default bitmap scan unit */

#   else
#    ifdef hpux

#	define DEFAULTGLPAD 	2		/* default padding for glyphs */
#	define DEFAULTBITORDER 	MSBFirst	/* default bitmap bit order */
#	define DEFAULTBYTEORDER MSBFirst	/* default bitmap byte order */
#	define DEFAULTSCANUNIT	1		/* default bitmap scan unit */

#    else
#     ifdef pegasus

#	define DEFAULTGLPAD 	4		/* default padding for glyphs */
#	define DEFAULTBITORDER 	MSBFirst	/* default bitmap bit order */
#	define DEFAULTBYTEORDER MSBFirst	/* default bitmap byte order */
#	define DEFAULTSCANUNIT	1		/* default bitmap scan unit */

#     else
#      ifdef macII

#       define DEFAULTGLPAD     4               /* default padding for glyphs */
#       define DEFAULTBITORDER  MSBFirst        /* default bitmap bit order */
#	define DEFAULTBYTEORDER MSBFirst	/* default bitmap byte order */
#	define DEFAULTSCANUNIT	1		/* default bitmap scan unit */

#      else
#       ifdef mips
#        ifdef MIPSEL

#	  define DEFAULTGLPAD 	  4		/* default padding for glyphs */
#	  define DEFAULTBITORDER  LSBFirst	/* default bitmap bit order */
#	  define DEFAULTBYTEORDER LSBFirst	/* default bitmap byte order */
#	  define DEFAULTSCANUNIT  1		/* default bitmap scan unit */

#        else
#	  define DEFAULTGLPAD 	  4		/* default padding for glyphs */
#	  define DEFAULTBITORDER  MSBFirst	/* default bitmap bit order */
#	  define DEFAULTBYTEORDER MSBFirst	/* default bitmap byte order */
#	  define DEFAULTSCANUNIT  1		/* default bitmap scan unit */
#        endif
#       else

#	 define DEFAULTGLPAD 	1		/* default padding for glyphs */
#	 define DEFAULTBITORDER MSBFirst	/* default bitmap bit order */
#	 define DEFAULTBYTEORDER MSBFirst	/* default bitmap byte order */
#	 define DEFAULTSCANUNIT	1		/* default bitmap scan unit */

#       endif
#      endif
#     endif
#    endif
#   endif
#  endif
# endif
#endif

#endif NCD

#define GLWIDTHBYTESPADDED(bits,nbytes) \
	((nbytes) == 1 ? (((bits)+7)>>3)	/* pad to 1 byte */ \
	:(nbytes) == 2 ? ((((bits)+15)>>3)&~1)	/* pad to 2 bytes */ \
	:(nbytes) == 4 ? ((((bits)+31)>>3)&~3)	/* pad to 4 bytes */ \
	:(nbytes) == 8 ? ((((bits)+63)>>3)&~7)	/* pad to 8 bytes */ \
	: 0)

#ifdef NCD
#define	n1dChars(pfi)	((pfi)->lastCol - (pfi)->firstCol + 1)
/*
 * for 2D char sets
 */

#define n2dCols(font)   ((font)->lastCol - (font)->firstCol +1 )
#define n2dRows(font)   ((font)->lastRow - (font)->firstRow + 1)
#define n2dChars(font)  (n2dCols(font) * n2dRows(font))

#define GLYPHWIDTHPIXELS(pci)   (pci->metrics.rightSideBearing \
				    - pci->metrics.leftSideBearing)


#define GLYPHWIDTHBYTES(pci)    (((GLYPHWIDTHPIXELS(pci))+7) >> 3)

#if GLYPHPADBYTES == 0 || GLYPHPADBYTES == 1
#define GLYPHWIDTHBYTESPADDED(pci)      (GLYPHWIDTHBYTES(pci))
#define PADGLYPHWIDTHBYTES(w)           (((w)+7)>>3)
#endif

#if GLYPHPADBYTES == 2
#define GLYPHWIDTHBYTESPADDED(pci)      ((GLYPHWIDTHBYTES(pci)+1) & ~0x1)
#define PADGLYPHWIDTHBYTES(w)           (((((w)+7)>>3)+1) & ~0x1)
#endif

#if GLYPHPADBYTES == 4
#define GLYPHWIDTHBYTESPADDED(pci)      ((GLYPHWIDTHBYTES(pci)+3) & ~0x3)
#define PADGLYPHWIDTHBYTES(w)           (((((w)+7)>>3)+3) & ~0x3)
#endif

#if GLYPHPADBYTES == 8 /* for a cray? */
#define GLYPHWIDTHBYTESPADDED(pci)      ((GLYPHWIDTHBYTES(pci)+7) & ~0x7)
#define PADGLYPHWIDTHBYTES(w)           (((((w)+7)>>3)+7) & ~0x7)
#endif

#endif NCD
