#!/bin/sh
#set -x		# uncomment this line for debugging

# Copyright 1990 Network Computing Devices, Inc.  All rights reserved.

#ident "@(#)if.sh	13.1	90/07/23"

# Determine the current directory, ncd unit name, and printer type.
SEP="\."			# use . as the seperator character
SEP="%"				# use % as the seperator character
DIR=`dirname $0`
NCD_NAME=`expr $0 : ".*$SEP\(.*\)" \| $0`
PRINTER_TYPE=`expr $0 : ".*$SEP\(.*\)$SEP.*" \| ps`

# Define common utilities here!
FOLD=/usr/ucb/fold
TXT_TO_PS="/usr/local/bin/lwf -s11"
NCD_LW_DRIVER=$DIR/ps2ncd
NCD_DRIVER=$DIR/cat2ncd
CHR=$DIR/chr
TMP=/tmp

# Initialize parameter values.
landscape=0
fold=1
cols=80
ind=0
width=""
length=""
indent=""
name=unknown
host=unknown
acct_file=""
date=`date +"%a  %h %d, 19%y @ %H:%M"`

# Process arguments.
while [ $# -gt 0 ]
do
    case "$1" in
	-c)
	    echo bad flag to filter: $1 >&2
	    exit 1
	    ;;
	-w*)
	    width="$1"
	    cols=`expr X"$1" : 'X-w\([0-9][0-9]*\)$' \| 0`
	    if [ $cols -eq 0 ]
	    then
		fold=0
	    else
		if [ $cols -gt 80 ]
		then
		    landscape=1
		fi
	    fi
	    ;;
	-l*)
	    length="$1"
	    ;;
	-i*)
	    indent="$1"
	    ind=`expr X"$1" : 'X-i\([0-9][0-9]*\)$' \| 0`
	    ;;
	-n)
	    if [ $# -gt 1 ]
	    then
		shift
		name="$1"
	    fi
	    ;;
	-h)
	    if [ $# -gt 1 ]
	    then
		shift
		host="$1"
	    fi
	    ;;
	-*)
	    echo bad flag to filter: $1 >&2
	    exit 1
	    ;;
	*)
	    acct_file="$1"
	    ;;
    esac
    shift
done

# Now, based on printer type, define the command pipelines to print.
case "$PRINTER_TYPE" in
    ljiip)
	PRINTER_TYPE="ljiip"
	TX_PIPE="\
	    ($CHR ESC E; \
	     $CHR ESC \& k 2 G; \
	     cat $TMP/$$; \
	     if [ $landscape -eq 1 ]; then $CHR ESC \& l 1 O; fi; \
	     $CHR ESC 9; \
	     $CHR ESC '(' s 1 2 H; \
	     $CHR ESC \& a; echo -n `expr 6 + $ind`; $CHR L; \
	     $CHR ESC \& a; echo -n `expr 5 + $cols`; $CHR M; \
	     $CHR ESC \& s 0 C; \
	     cat -; \
	     $CHR ESC \& l 0 H) | \
	    $NCD_DRIVER $NCD_NAME"
	PS_PIPE="exit 2"
	;;
    lw | lwiint | lwiintx)
	PRINTER_TYPE="lw"
	if [ $fold -eq 1 ]
	then
	    TX_PIPE="$FOLD -$cols | "
	else
	    TX_PIPE=""
	fi
	#TX_PIPE="$TX_PIPE (cat $TMP/$$; $TXT_TO_PS) | $NCD_LW_DRIVER $NCD_NAME"
	TX_PIPE="$TX_PIPE ($TXT_TO_PS; cat $TMP/$$) | $NCD_LW_DRIVER $NCD_NAME"
	#PS_PIPE="(cat $TMP/$$ -) | $NCD_LW_DRIVER $NCD_NAME"
	PS_PIPE="(cat - $TMP/$$) | $NCD_LW_DRIVER $NCD_NAME"
	;;
    *)
	exit 2
	;;
esac

# Make sure we always remove any temporary files.
trap "rm -f $TMP/$$" 0

# Based on printer type, define a banner page.
case "$PRINTER_TYPE" in
    ljiip)
	true > $TMP/$$
	$CHR ESC \* c 2 4 0 0 A >> $TMP/$$	# 2400/300 inch wide
	$CHR ESC \* c 7 5 B >> $TMP/$$		# 75/300 inch high
	$CHR ESC \* c 5 0 G >> $TMP/$$		# set block pattern to 50% black
	$CHR ESC \* c 2 P >> $TMP/$$		# print a gray scale block
	$CHR LF LF LF LF >> $TMP/$$		# space down
	echo "User:  $name" >> $TMP/$$		# user name
	$CHR LF >> $TMP/$$
	echo "Host:  $host" >> $TMP/$$		# originating host
	$CHR LF >> $TMP/$$
	echo "Date:  $date" >> $TMP/$$		# date and time of printing
	$CHR LF >> $TMP/$$
	$CHR ESC \* c 2 P >> $TMP/$$		# print a gray scale block
	$CHR FF >> $TMP/$$			# eject banner page
	;;
    lw)
cat << EOF > $TMP/$$
%!PS-Adobe-2.0
%%Creator: $name
%%CreationDate: $date
%%For: $name
%%DocumentFonts: Helvetica
%%Pages: 1
%%EndComments
%%EndProlog
%%Page: 1
%
%  Define some basic constants
%
/inch  { 72 mul }  def
/black  0  def
/gray  0.8 def
/white  1  def

%
%  We will draw concentric boxes with the upper left corner of the
%  outermost box being at (x1,y1) and the lower right corner at
%  (x2,y2).  This later coordinate is defined after the text has been
%  drawn.
%
/x1 0.5 inch def
/y1 10 inch def
/w 7.5 inch def

/psize 24 def
/lead psize 1.5 mul def

/lw 2 def
/lsp lw 2 mul def
/numl 4 def

%---------the text------------

/Helvetica findfont psize scalefont setfont
black setgray
/x x1 lsp numl mul add 18 add def
/y y1 lsp numl mul sub lead sub def
x y moveto
/nl { /y y lead sub def x y moveto } def
gray setgray
(User: ) show
black setgray
($name) show nl
gray setgray
(Host: $host) show nl
(Date: $date) show nl
black setgray

%--------the boxes-----------

lw setlinewidth
/x2 x1 w add def
/y2 y lead add psize sub lsp numl mul sub def

/xul x1 def
/yul y1 def
/xlr x2 def
/ylr y2 def

numl -1 1
  { pop % numl div setgray
    newpath
    xul yul moveto
    xlr yul lineto
    xlr ylr lineto
    xul ylr lineto
    xul yul lineto
    closepath
    stroke
    /xul xul lsp add def
    /yul yul lsp sub def
    /xlr xlr lsp sub def
    /ylr ylr lsp add def
  }
  for

/lsize  0.5 inch  def % change this to change logo size

gsave

xlr lsize sub ylr translate

white -0.01 black
  {     0     0 moveto
    lsize     0 lineto
    lsize lsize lineto
        0 lsize lineto
        0     0 lineto
    setgray fill
  }
  for

/Times-Roman findfont lsize 3 div scalefont setfont

black 0.01 white
  { setgray
    lsize 6 div dup moveto
    { pop pop } (NCD) kshow
  }
  for

grestore

%! xlogo.ps - draw the "official" X Window System Logo, designed by Danny Chong
%
% Copyright (C) 1988 by Jef Poskanzer.
%
% Permission to use, copy, modify, and distribute this software and its
% documentation for any purpose and without fee is hereby granted, provided
% that the above copyright notice appear in all copies and that both that
% copyright notice and this permission notice appear in supporting
% documentation.  This software is provided "as is" without express or
% implied warranty.

/size  6 inch  def % change this to change logo size

gsave

8.5 inch size sub 2 div  1 inch  translate

0  size translate
[ 1 0 0 -1 0 0 ] concat

/d11  size 11 div          def
/d21  d11 3 add 4 div      def
/d31  d11 d11 d21 add add  def
/eps  size 100 div         def

%           -----
%          /    /
%         /    /
%        /    /
%       /    /
%      /____/

size                      0                   moveto
size d31 sub              0                   lineto
0                         size                lineto
d31                       size                lineto
gray  setgray  fill

%           ------
%          /     /
%         /  __ /
%        /  /  /
%       /  /  /
%      /__/__/

d31 2 div                 size                moveto
size 2 div                size 2 div          lineto
size 2 div d31 2 div add  eps add size 2 div  lineto
d31 eps add               size eps add        lineto
white  setgray  fill

%           ------
%          /  /  /
%         /__/  /
%        /     /
%       /     /
%      /_____/

size d31 2 div sub        0                   moveto
size 2 div                size 2 div          lineto
size 2 div d31 2 div sub  eps sub size 2 div  lineto
size d31 sub eps sub      0 eps sub           lineto
white  setgray  fill

% -----
% \    \
%  \    \
%   \    \
%    \    \
%     \____\

0                         0                   moveto
size 4 div                0                   lineto
size                      size                lineto
size size 4 div sub       size                lineto
gray  setgray  fill

%          /
%         /
%        /
%       /
%      /

size d11 sub              0                   moveto
size d11 d21 add sub      0                   lineto
d11                       size                lineto
d11 d21 add               size                lineto
white  setgray  fill

grestore

showpage

%%Trailer
%%Pages: 1
EOF
	;;
    esac

# And, finally, print the job.
$DIR/if -p "$PS_PIPE" -t "$TX_PIPE" \
    $width $length $indent -n "$name" -h "$host" $acct_file

exit $?
