;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;
PAGE	,132
	TITLE	GETPNT - Get graphics point

;**	GETPNT - Get graphics point
;
;	GETPNT reads the specified pixel from video ram
;	and returns its attributes in AL.
;
;	ENTRY:	CX	=	Horizontal (x) axis
;		BX	=	Vertical (y) axis
;
;	EXIT:	AL	=	Attributes (defined below)
;
;	USES:	AX,BX,CX,DX,SI,DI
;

	EXTRN	VMODE:BYTE

CODE	SEGMENT BYTE PUBLIC 'CODE'
	PUBLIC	GETPNT,INT_END

	INCLUDE	..\COMMONS\Z150ROM.DEF

	ASSUME  CS:CODE,DS:CODE,ES:CODE,SS:CODE


;	CX = x value
;	BX = y value
;

GETPNT:
	PUSH	DX
	PUSH	CX
	PUSH	AX

	MOV	DX,BX			; Put row in correct reg.
	CMP	VMODE,5			; Check if in high res.
	JA	GP1			; Skip point mapping if so
	PUSH	CX
	SHR	CX,1
GP1:
	MOV	AH,VIO_RDOT
	INT	VIDEO_IO_INTR

	CMP	VMODE,5
	JA	GP3
	POP	CX
	TEST	CX,1
	JNZ	GP2
	SHR	AL,1
GP2:
	AND	AL,1
GP3:
	POP	CX
	MOV	AH,CH
	POP	CX
	POP	DX
	RET

INT_END	LABEL	NEAR

CODE	ENDS
	END	

