page	60,132
title	Set the border color index
name	setbord

code	segment
assume	cs:code, ds:code

	org	100h		;for .com file

begin:
	mov	ax,cs
	mov	ds,ax		;ds = es = cs
	mov	es,ax

;init
	cld
	mov	si,80h		;point to command line input
	lodsb			;get string length
	cmp	al,0		;anything there?
	je	noargs		;no-jump

;get the index
	mov	cl,al
	xor	ch,ch

;skip until valid hex digit
findhex:
	lodsb			;get char
	call	ascii2hex	;convert to hex
	jnc	hex		;jump if hex
	loop	findhex		;continue if not
	jmp	short noargs	;help message if none

hex:
;write the palette
	mov	ah,0ah		;set palette
	mov	cx,0		;no data, only index
	int	0efh		;do it
	jmp	short exit	;and exit

noargs:
;print out a help message and exit without changing modes
	mov	ah,9		;display string
	mov	dx,offset msg	;ds:dx points to message
	int	21h		;dos call

exit:
	mov	ax,4c00h	;return to dos
	int	21h

;-----------------------------------------------------------
ascii2hex	proc	near
;converts al from ascii to hex.
;returns with carry set if al is not valid hex digit.
	cmp	al,'0'		;see if numeric
	jb	nothex
	cmp	al,'9'
	jg	alpha
	sub	al,'0'		;convert to hex
	clc
	ret
alpha:	or	al,20h		;force lower case
	cmp	al,'a'
	jb	nothex
	cmp	al,'f'
	ja	nothex
	sub	al,('a' - 10)	;convert to hex
	clc
	ret

nothex:	stc
	ret
ascii2hex	endp


;-----------------------------------------------------------
;DATA

msg	label	byte		;help message
	db	13,10
	db	'SETBORD  index  (sets the border color index).',13,10
	db	'  where "index" is a hexidecimal digit from 0->f.',13,10
	db	'$'
code	ends
end	begin
