page	60,132
title	Set the palette
name	setpal

code	segment
assume	cs:code, ds:code

	org	100h		;for .com file

begin:
	mov	ax,cs
	mov	ds,ax		;ds = es = cs
	mov	es,ax

;init
	cld
	mov	si,80h		;point to command line input
	lodsb			;get string length
	cmp	al,0		;anything there?
	je	noargs		;no-jump

	mov	ah,0bh		;get palette
	xor	cx,cx		;only get border
	int	0efh
	mov	border,al	;save border color index	

;get the data
ploop:
	cmp	index,16	;is palette full?
	ja	exit		;exit if so

;skip until valid hex digit
findhex:
	lodsb			;get char
	call	ascii2hex	;convert to hex
	jnc	hex		;jump if hex
	cmp	al,0dh		;end of string?
	je	exit		;yes-exit
	jmp	short findhex	;no-continue


hex:
;create the data word
	xor	ah,ah
	mov	di,ax		;initial value
	mov	cl,4		;shift value
;see if more
hex1:	lodsb			;get char
	call	ascii2hex	;convert to hex
	jc	gothex		;jump if done
	shl	di,cl		;shift over one hex digit
	add	di,ax		;add in latest
	jmp	short hex1	;loop
	
gothex:
	mov	color,di

;write the palette
	mov	ah,0ah		;set palette
	mov	al,border	;use original border
	mov	bx,offset color	;point to data
	mov	cx,1		;only one word
	mov	dx,index	;current index to write
	inc	index		;increment for next time
	int	0efh		;do it

	cmp	byte ptr ds:[si-1],0dh	;end of string?
	je	exit			;yes-jump
	jmp	short ploop		;no-continue
	

noargs:
;print out a help message and exit without changing modes
	mov	ah,9		;display string
	mov	dx,offset msg	;ds:dx points to message
	int	21h		;dos call

exit:
	mov	ax,4c00h	;return to dos
	int	21h

;-----------------------------------------------------------
ascii2hex	proc	near
;converts al from ascii to hex.
;returns with carry set if al is not valid hex digit.
	cmp	al,'0'		;see if numeric
	jb	nothex
	cmp	al,'9'
	jg	alpha
	sub	al,'0'		;convert to hex
	clc
	ret
alpha:	or	al,20h		;force lower case
	cmp	al,'a'
	jb	nothex
	cmp	al,'f'
	ja	nothex
	sub	al,('a' - 10)	;convert to hex
	clc
	ret

nothex:	stc
	ret
ascii2hex	endp


;-----------------------------------------------------------
;DATA

strlen	dw	0		;command line length
border	db	0		;border color index
color	dw	0		;palette color data
index	dw	0		;current palette index



msg	label	byte		;help message
	db	13,10
	db	'SETPAL data data data... (sets the color palette).',13,10
	db	'  where "data" is a hexidecimal number from 0->ffff.',13,10
	db	'  SETPAL begins loading at palette index 0,',13,10
	db	'  and continues loading palette locations until',13,10
	db	'  out of data (maximum of 16).',13,10,10
	db	'The palette is defined as follows:',13,10,10
 db ' 15  14  13  12  11  10   9   8   7   6   5   4   3   2   1   0',13,10
 db '+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+',13,10
 db '| M | M | M | M | U | U | T | T | T | T | T | T | T | T | T | T |',13,10
 db '| I | R | G | B | U | U | K | B | B | B | G | G | G | R | R | R |',13,10
 db '+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+',13,10
	db	' where:',13,10
	db	'    M = a bit used to define a monitor color',13,10
	db	'    T = a bit used to define a television color',13,10
	db	'    R = red',13,10
	db	'    G = green',13,10
	db	'    B = blue',13,10
	db	'    I = intensity',13,10
	db	'    K = key onto external video',13,10
	db	'    U = unused',13,10
	db	'$'
code	ends
end	begin
