/*
 * TX-0 code reverses the bit order of the 
 * channels
 *
 */

#include <stdio.h>

// upper case table
//
char cvt[] = {
		0,	'T',	0,	'O',	' ',	'H',	'N',	'M',  // 00
		0,	'L',	'R',	'G',	'I',	'P',	'C',	'V',  // 10
		'E',	'Z',    'D',    'B',	'S',	'Y',    'F',	'X',  // 20
		'A',	'W',	'J',	'9',	'U',	'Q',	'K',	'0',  // 30
		0,	0,	')',	0,	':',	'\n',	'(',	0,    // 40
		'|',	'\t',	'1',	0,	'/',	0,	'-',	0,    // 50
		'8',	0,	'5',	0,	'4',	0,	'6',	0,    // 60
		'3',	0,	'7',	0,	'2',	0,	0,	0     // 70
        };

// lower case table
//
char cvtl[] ={
		0,	't',	0,	'o',	' ',	'h',	'n',	'm',  // 00
		0,	'l',	'r',	'g',	'i',	'p',	'c',	'v',  // 10
		'e',	'z',    'd',    'b',	's',	'y',    'f',	'x',  // 20
		'a',	'w',	'j',	'9',	'u',	'q',	'k',	'0',  // 30
		0,	0,	'.',	0,	'=',	'\n',	',',	0,    // 40
		'|',	'\t',	'1',	0,	'+',	0,	'_',	0,    // 50
		'8',	0,	'5',	0,	'4',	0,	'6',	0,    // 60
		'3',	0,	'7',	0,	'2',	0,	0,	0     // 70
        };
main()
{
        char c, flip;
        int state = 0;

        while(!feof(stdin)){
                c = getchar() & 0x3f;

                if (c == 0) continue;
		if (c == 077) continue;
		if (c == 002) continue;                 /* color shift */
		if (c == 043) continue;                 /* page break */
                if (c == 057) {state = 0; continue;}    /* lower case */
                if (c == 047) {state = 1; continue;}    /* upper case */
                
                if(state){
                 if(cvt[c] == 0) { printf(">>%02o<<",c); continue;}
                 putchar(cvt[c]);
                }
                else{
                 if(cvtl[c] == 0) {printf(">>%02o<<",c); continue;}
                 putchar(cvtl[c]);
                }
        }
}
