/*
 *	$Source: /u1/Xr/usr/contrib/RB/RCS/filePanel.c,v $
 *	$Header: filePanel.c,v 1.1 86/12/17 08:53:23 swick Exp $
 */

#ifndef lint
static char *rcsid_filePanel_c = "$Header: filePanel.c,v 1.1 86/12/17 08:53:23 swick Exp $";
#endif	lint

static char rcsid[] = "$Header: filePanel.c,v 1.1 86/12/17 08:53:23 swick Exp $";
/*************************************<+>*************************************
 *****************************************************************************
 **
 **   File:        filePanel.c
 **
 **   Project:     X-ray Toolbox
 **
 **   Description: The file the initialization and handling code for
 **                read and write panels.
 **
 **   *******************************************************************
 **   * (c)  Copyright Hewlett-Packard Company, 1986.  All rights are   *
 **   * reserved.  Copying or other reproduction of this program except *
 **   * for archival purposes is prohibited without the prior written   *
 **   * consent of Hewlett-Packard Company.                             *
 **   *******************************************************************
 **
 **
 **   ------------------------ MODIFICATION RECORD   ------------------------
 *
 * $Log:	filePanel.c,v $
 * Revision 1.1  86/12/17  08:53:23  swick
 * Initial revision
 * 
 *
 *****************************************************************************
 *************************************<+>*************************************/


#include <X/Xlib.h>
#include <Xr/defs.h>
#include <Xr/types.h>
#include <Xr/keycode.h>
#include "filePanel.h"


FilePanel (rasterData, message, data)
xrPixmap * rasterData;
INT32      message;
INT8       data;

{

   /*
    *  Set up a switch to handle the two messages FilePanel understand.
    */

   switch (message)
   {
      case MSG_NEW:	/*  Create the two panels  */
      {

         /*
          *  Size all of the editors.
          */

         XrTitleBar (NULL, MSG_SIZE, &readTBInfo);
         XrPushButton (NULL, MSG_SIZE, &readPBInfo);

         XrTextEdit (NULL, MSG_SIZE, &panelTEInfo);

         XrTitleBar (NULL, MSG_SIZE, &writeTBInfo);
         XrPushButton (NULL, MSG_SIZE, &writePBInfo);


         /*
          *  Offset the editors to the correct locations.
          */

         panelTEInfo.editorRect.x = 10;
         panelTEInfo.editorRect.y = readTBInfo.editorRect.height + 30;

         readPBInfo.editorRect.x = 
            panelTEInfo.editorRect.x + panelTEInfo.editorRect.width + 30;
         readPBInfo.editorRect.y = readTBInfo.editorRect.height + 10;

         writePBInfo.editorRect.x = 
            panelTEInfo.editorRect.x + panelTEInfo.editorRect.width + 30;
         writePBInfo.editorRect.y = readTBInfo.editorRect.height + 10;


         /*
          *  Get and set a panel context so that the panels will
          *  be created hidden.  Get the size of the panels, and
          *  set the title bar widths to the sizes.
          */

         XrPanel (NULL, MSG_GETPANELCONTEXT, &panelContext);
         panelContext.showFlag = FALSE;

         XrPanel (NULL, MSG_SIZE, &readInfo);
         XrPanel (NULL, MSG_SIZE, &writeInfo);

         readTBInfo.editorRect.width = readInfo.panelSize.width;
         writeTBInfo.editorRect.width = writeInfo.panelSize.width;


         /*
          *  Set the panel structure so that the panels will be created
          *  relative to the root window and create the panels.
          */

         readInfo.relativeTo = RootWindow;
         writeInfo.relativeTo = RootWindow;

         readPanel = XrPanel (NULL, MSG_NEW, &readInfo);
         writePanel = XrPanel (NULL, MSG_NEW, &writeInfo);
      }
      break;


      case MSG_EDIT:
      {
         POINT          movePt;
         xrPanel      * panel;
         xrPanelField * panelFields;
         xrEvent        panelInput;
         XEvent         xInput;
         xrEvent      * xrInput;
         xrPixmap       rData;
         int i;


         /*
          *  Set up the panel to be used.
          */

         if (data == (INT8) XrWRITE)
         {
            panel = writePanel;
            panelFields = &writeFields[0];
         }
         else
         {
            panel = readPanel;
            panelFields = &readFields[0];
         }


         /*
          *  Position and show the panel.
          */

         CenterWindow (&panel -> panelZeroRect, &movePt); 
         XrPanel (panel, MSG_MOVE, &movePt);
         XrPanel (panel, MSG_SHOW, NULL);
         

         /*
          *  Make the text edit field the current editor and 
          *  set up the loop to call the panel manager.
          */

         XrPanel (panel, MSG_CURRENTEDITOR, panelFields[1].editorInstance);

         while (1)
         {
            XrPanel (panel, MSG_EDIT, &panelInput);
            XrInput (0, MSG_NONBLKHOTREAD, &xInput);
            xrInput = (xrEvent *) &xInput;

            if (panelInput.inputCode == XrPANELEDITOR)
            {
               /*
                *  Check for a select out of the Text Editor.
                */

               if (panelInput.value3 == 1 && xrInput -> value2 == XrSELECT)
                  XrPanel (panel, MSG_CURRENTEDITOR, NULL);

               /*
                *  Check for a return key in the Text Editor or
                *  either of the button presses.
                */

               else if ((panelInput.value3 == 1                   && 
                         xrInput -> value1 == XrTEDIT_BREAK       &&
                         xrInput -> value3 == (RETURN_KEY | K_s)) ||
                         panelInput.value3 == 2)
               {
                  if (panelInput.value3 == 1)
                     xrInput -> value2 = 0;

                  if (xrInput -> value2 == 0)
                  {

                     /*
                      *  Strip spaces off the end of the line.
                      */

                     for (i = strlen (fileName); i > 0; i--)
                        if (fileName [i - 1] != ' ')
                        {
                           fileName[i] = NULL;
                           break;
                        }

                     if (data == (INT8) XrWRITE)
                     {
                        WriteFile (fileName, rasterData);
                        XrPanel (panel, MSG_HIDE, NULL);
                        return (TRUE);
                     }
                     else
                     {
                        if (GetFileInfo (fileName, &rData))
                        {
                           RasterInit(rData.width, rData.height, rData.depth);
                           ReadFile (fileName, rasterData);
                           XrPanel (panel, MSG_HIDE, NULL);
                           MainWindowInit();
                           return (TRUE);
                        }
                        XrPanel (panel, MSG_CURRENTEDITOR, 
                                 panelFields[1].editorInstance);
                     }
                  }
                  else
                  {
                     XrPanel (panel, MSG_HIDE, NULL);
                     return (FALSE);
                  }
               }
            }
            else if (panelInput.inputCode == XrPANELINPUT)
               XrPanel (panel, MSG_CURRENTEDITOR, 
                        panelFields[1].editorInstance);
         }
      }
      break;
   }
}

