/*
 *	$Source: /u1/Xr/usr/contrib/RB/RCS/buildPanel.c,v $
 *	$Header: buildPanel.c,v 1.1 86/12/17 08:52:45 swick Exp $
 */

#ifndef lint
static char *rcsid_buildPanel_c = "$Header: buildPanel.c,v 1.1 86/12/17 08:52:45 swick Exp $";
#endif	lint

static char rcsid[] = "$Header: buildPanel.c,v 1.1 86/12/17 08:52:45 swick Exp $";
/*************************************<+>*************************************
 *****************************************************************************
 **
 **   File:        buildPanel.c
 **
 **   Project:     X-ray Toolbox
 **
 **   Description: The file contains the initialization and processing
 **                code for the builder panel for the raster builder.
 **
 **   *******************************************************************
 **   * (c)  Copyright Hewlett-Packard Company, 1986.  All rights are   *
 **   * reserved.  Copying or other reproduction of this program except *
 **   * for archival purposes is prohibited without the prior written   *
 **   * consent of Hewlett-Packard Company.                             *
 **   *******************************************************************
 **
 **
 **   ------------------------ MODIFICATION RECORD   ------------------------
 *
 * $Log:	buildPanel.c,v $
 * Revision 1.1  86/12/17  08:52:45  swick
 * Initial revision
 * 
 *
 *****************************************************************************
 *************************************<+>*************************************/


#include <X/Xlib.h>
#include <Xr/defs.h>
#include <Xr/types.h>
#include "buildPanel.h"



/************************************************************************
 *
 *  PanelInit
 *	PanelInit is called once to set up the builder settings panel.
 *	All of the sizes and locations of the editors are calculated,
 *	and the panel is sized and created.
 *
 ************************************************************************/

PanelInit()
{
   int i;


   /*
    *  Get the sizes for each of the static text strings.
    */

   panelSTInfo1.editorRect.width =
      XrStringWidth(xrBaseFontInfo,panelSTInfo1.string,XrNULLTERMINATED,0,0);

   panelSTInfo2.editorRect.width =
      XrStringWidth(xrBaseFontInfo,panelSTInfo2.string,XrNULLTERMINATED,0,0);

   panelSTInfo3.editorRect.width =
      XrStringWidth(xrBaseFontInfo,panelSTInfo3.string,XrNULLTERMINATED,0,0);

   panelSTInfo4.editorRect.width =
      XrStringWidth(xrBaseFontInfo,panelSTInfo4.string,XrNULLTERMINATED,0,0);

   panelTEInfo1.cellWidth = panelTEInfo2.cellWidth = 
   panelTEInfo3.cellWidth = panelTEInfo4.cellWidth = 
   panelTEInfo5.cellWidth = 
      XrStringWidth (xrBaseFontInfo, "9", XrNULLTERMINATED, 0, 0);


   /*
    *  Size all of the editors.
    */

   for (i = 0; i < panelInfo.numFields; i++)
      (*panelFields[i].editorFunct) 
            (NULL, MSG_SIZE, panelFields[i].editorData);


   /*
    *  Offset each of the editors to position them within the panel.
    */

   panelSTInfo1.editorRect.x = 10;
   panelSTInfo1.editorRect.y = panelTBInfo.editorRect.height + 10;

   panelTEInfo1.editorRect.x = 15;
   panelTEInfo1.editorRect.y = 
      panelSTInfo1.editorRect.y + panelSTInfo1.editorRect.height;

   panelTEInfo2.editorRect.x = 15;
   panelTEInfo2.editorRect.y = 
      panelTEInfo1.editorRect.y + panelTEInfo1.editorRect.height;

   panelSTInfo2.editorRect.x = 10;
   panelSTInfo2.editorRect.y = 
      panelTEInfo2.editorRect.y + panelTEInfo2.editorRect.height + 8;

   panelTEInfo3.editorRect.x = 15;
   panelTEInfo3.editorRect.y = 
      panelSTInfo2.editorRect.y + panelSTInfo2.editorRect.height;

   panelSTInfo3.editorRect.x =
      panelSTInfo1.editorRect.x + panelSTInfo1.editorRect.width + 30;
   panelSTInfo3.editorRect.y =  panelSTInfo1.editorRect.y;

   panelTEInfo4.editorRect.x = panelSTInfo3.editorRect.x + 5;
   panelTEInfo4.editorRect.y =  panelTEInfo1.editorRect.y;

   panelTEInfo5.editorRect.x = panelSTInfo3.editorRect.x + 5;
   panelTEInfo5.editorRect.y =  panelTEInfo2.editorRect.y;

   panelSTInfo4.editorRect.x = panelSTInfo3.editorRect.x;
   panelSTInfo4.editorRect.y =  panelSTInfo2.editorRect.y;

   panelRBInfo.editorRect.x = panelSTInfo3.editorRect.x + 5;
   panelRBInfo.editorRect.y = panelTEInfo3.editorRect.y + 4;

   panelPBInfo.editorRect.x = 
      panelSTInfo4.editorRect.x + panelSTInfo3.editorRect.width + 30;
   panelPBInfo.editorRect.y = panelTEInfo4.editorRect.y;


   /*
    *  Get the size of the panel and set the title bar width to that size.
    */

   XrPanel (NULL, MSG_SIZE, &panelInfo);
   panelTBInfo.editorRect.width = panelInfo.panelSize.width;


   /*
    *  Get a panel context and set it such that the panel is relative
    *  to the root windows and it is hidden when created.
    */

   XrPanel (NULL, MSG_GETPANELCONTEXT, &panelContext);
   panelContext.showFlag = FALSE;
   panelInfo.panelContext = &panelContext;
   panelInfo.relativeTo = RootWindow;


   /*
    *  Create the panel.
    */

   panel = XrPanel (NULL, MSG_NEW, &panelInfo);
}



/************************************************************************
 *
 *  ProcessPanel is called when the builder settings item is selected
 *  out of the main menu.  It handles the display and processing of the
 *  panel.
 *
 ************************************************************************/

ProcessPanel ()
{
   POINT movePt;

   XEvent    xInput;
   xrEvent   panelInput;
   xrEvent * xrInput;

   INT32 newRasterWidth;
   INT32 newRasterHeight;
   INT32 newViewWidth;
   INT32 newViewHeight;
   INT32 newPixelSize;
   INT32 depthChange;
   INT32 activeField;


   /*
    *  Initialize the variables needed to process the panel.
    */

   xrInput = (xrEvent *) &xInput;

   newPixelSize = rasterEditInfo.pixelSize;
   newViewWidth = rasterEditInfo.viewRegion.width;
   newViewHeight = rasterEditInfo.viewRegion.height;
   newRasterWidth = rasterEditInfo.rasterData.width;
   newRasterHeight = rasterEditInfo.rasterData.height;
   depthChange = FALSE;


   /*
    *  Display the settings panel and activate the first 
    *  text edit field.
    */

   CenterWindow (&panel -> panelZeroRect, &movePt);

   XrPanel (panel, MSG_MOVE, &movePt);
   XrPanel (panel, MSG_SHOW, NULL);   

   activeField = 7;
   XrPanel (panel, MSG_CURRENTEDITOR, 
            (INT8 *) panelFields[activeField].editorInstance);


   /*
    *  Set up the panel processing loop.
    */

   while (1)
   {
      XrPanel (panel, MSG_EDIT, &panelInput);
      XrInput (0, MSG_NONBLKHOTREAD, &xInput);


      /*
       *  Input from an editor, set up a switch to handle each editor.
       */

      if (panelInput.inputCode == XrPANELEDITOR)
      {
         switch (panelInput.value3)
         {
            case 5:	/*  Raster Depth Radio button  */
               if (xrInput -> value1 == XrSELECT)
                  depthChange = TRUE;
            break;

            case 6:	/*  Push Button  */
               if (xrInput -> value2 == 0)
               {
                  newPixelSize = 8;
                  newViewWidth = 24;
                  newViewHeight = 24;
                  newRasterWidth = 64;
                  newRasterHeight = 64;
                  if (rasterEditInfo.rasterData.depth != XrBIT1)
                  {
                     panelRValue = 0;
                     depthChange = TRUE;
                  }
                  PanelStrings (24, 24, 8, 64, 64);

                  XrTextEdit (panelFields[7].editorInstance, 
                            MSG_REDRAW, XrREDRAW_ACTIVE);
                  XrTextEdit (panelFields[8].editorInstance, 
                            MSG_REDRAW, XrREDRAW_ACTIVE);
                  XrTextEdit (panelFields[9].editorInstance, 
                            MSG_REDRAW, XrREDRAW_ACTIVE);
                  XrTextEdit (panelFields[10].editorInstance, 
                            MSG_REDRAW, XrREDRAW_ACTIVE);
                  XrTextEdit (panelFields[11].editorInstance, 
                            MSG_REDRAW, XrREDRAW_ACTIVE);
                  XrRadioButton (panelFields[5].editorInstance,
                            MSG_REDRAW, XrREDRAW_ACTIVE);

                  XrPanel (panel, MSG_CURRENTEDITOR, 
                          (INT8 *) panelFields[activeField].editorInstance);
               }
               else if (xrInput -> value2 == 1)
               {
                  XrPanel (panel, MSG_HIDE, NULL);
                  XrTextEdit (panelFields[activeField].editorInstance, 
                              MSG_DEACTIVATE, NULL);
                  XrPanel (panel, MSG_CURRENTEDITOR, NULL);
                  CheckPanel (newViewWidth, newViewHeight, newPixelSize,
                              newRasterWidth, newRasterHeight, depthChange);
                  return (TRUE);
               }
            break;

            case 7:	/*  View Size Width Text Edit     */
            case 8:	/*  View Size Height Text Edit    */
            case 9:	/*  Bit Size Text Edit            */
            case 10:	/*  Raster Size Width Text Edit   */
            case 11:	/*  Raster Size Height Text Edit  */

               if (panelInput.value3 == 7)
                  newViewWidth = atoi (panelTEString1);
               else if (panelInput.value3 == 8)
                  newViewHeight = atoi (panelTEString2);
               else if (panelInput.value3 == 9)
                  newPixelSize = atoi (panelTEString3);
               else if (panelInput.value3 == 10)
                  newRasterWidth = atoi (panelTEString4);
               else if (panelInput.value3 == 11)
                  newRasterHeight = atoi (panelTEString5);

               if (xrInput -> value1 == XrTEDIT_BREAK)
               {
                  activeField = panelInput.value3;

                  if (xrInput -> value2 == XrNEXT)
                     activeField++;

                  if (xrInput -> value2 == XrPREVIOUS)
                     activeField--;

                  if (activeField > 11)
                     activeField = 7;
                  if (activeField < 7)
                     activeField = 11;

                  if (xrInput -> value2 == XrSELECT)
                     XrPanel (panel, MSG_CURRENTEDITOR, NULL);
                  else
                     XrPanel (panel, MSG_CURRENTEDITOR, 
                           (INT8 *) panelFields[activeField].editorInstance);
               }
               else
               {
                  activeField = panelInput.value3;
                  XrPanel (panel, MSG_CURRENTEDITOR, 
                          (INT8 *) panelFields[activeField].editorInstance);
               }
            break;
         }
      }
      else if (panelInput.inputCode == XrPANELINPUT)
      {
         if (xInput.window != panel -> panelWindow)
         {
            XrInput (0, MSG_PUSHEVENT, &xInput);
            XrTextEdit (panelFields[activeField].editorInstance, 
                        MSG_DEACTIVATE, NULL);
            XrPanel (panel, MSG_CURRENTEDITOR, NULL);
            XrPanel (panel, MSG_HIDE, NULL);
            CheckPanel (newViewWidth, newViewHeight, newPixelSize,
                       newRasterWidth, newRasterHeight, depthChange);
            return (TRUE);
         }
      }
   }
}




/************************************************************************
 *
 *  CheckPanel
 *	CheckPanel takes a set of values for the main window raster width,
 *	view size, pixelSize, and depth.  If the values have changed from
 *	the original settings, the appropriate functions are called to
 *	changes the raster or raster editor.
 *
 ************************************************************************/

CheckPanel (viewWidth, viewHeight, pixelSize, 
            rasterWidth, rasterHeight, depthChange)
int viewWidth, viewHeight;
int pixelSize;
int rasterWidth, rasterHeight;
int depthChange;

{
   int changeWindow;
   int i;


   /*
    *  Check for valid settings for the view, raster, and pixel sizes.
    *  Then make sure the panel strings represent the values.
    */

   if (viewWidth < 16) viewWidth = 16;
   if (viewHeight < 16) viewHeight = 16;
   if (rasterWidth < 16) rasterWidth = 16;
   if (rasterHeight < 16) rasterHeight = 16;
   if (pixelSize < 4) pixelSize = 4;
   if (viewWidth > rasterWidth) viewWidth = rasterWidth;
   if (viewHeight > rasterHeight) viewHeight = rasterHeight;


   /*
    *  Make sure that the panels strings are set correctly.
    */

   PanelStrings (viewWidth, viewHeight, pixelSize, rasterWidth, rasterHeight);


   /*
    *  Check to see if the raster width, height, or depth have changed.
    */

   changeWindow = FALSE;
   if (rasterWidth != rasterEditInfo.rasterData.width ||
       rasterHeight != rasterEditInfo.rasterData.height ||
       depthChange)
   {
      changeWindow = TRUE;
      if (panelRValue == 0)
         RasterInit (rasterWidth, rasterHeight, XrBIT1);
      else 
         RasterInit (rasterWidth, rasterHeight, XrBYTE1);
   }


   /*
    *  Check to see if the raster editor view width, height, 
    *  or pixel size has changed.
    */

   if (viewWidth != rasterEditInfo.viewRegion.width ||
       viewHeight != rasterEditInfo.viewRegion.height ||
       pixelSize != rasterEditInfo.pixelSize)
   {
      changeWindow = TRUE;
      rasterEditInfo.viewRegion.width = viewWidth;
      rasterEditInfo.viewRegion.height = viewHeight;
      rasterEditInfo.pixelSize = pixelSize;
   }

   if (changeWindow == TRUE)
      MainWindowInit();
}



/************************************************************************
 *
 *  PanelStrings
 *	PanelStrings takes a set of values as parameters and changes them
 *	into strings and places the strings into the correct text edit
 *	string in the builder settings panel.
 *
 ************************************************************************/

PanelStrings (viewWidth, viewHeight, pixelSize, rasterWidth, rasterHeight)
int viewWidth, viewHeight;
int pixelSize;
int rasterWidth, rasterHeight;

{
   if (viewWidth != -1)
      sprintf (panelTEString1, "%d", viewWidth);

   if (viewHeight != -1)
      sprintf (panelTEString2, "%d", viewHeight);

   if (pixelSize != -1)
      sprintf (panelTEString3, "%d", pixelSize);

   if (rasterWidth != -1)
      sprintf (panelTEString4, "%d", rasterWidth);

   if (rasterHeight != -1)
      sprintf (panelTEString5, "%d", rasterHeight);
}

