/*
 *	$Source: /u1/Xr/src/Xrlib/Intrinsic/RCS/inputTable.c,v $
 *	$Header: inputTable.c,v 1.1 86/12/17 09:08:48 swick Exp $
 */

#ifndef lint
static char *rcsid_inputTable_c = "$Header: inputTable.c,v 1.1 86/12/17 09:08:48 swick Exp $";
#endif	lint

#include <Xr/xr-copyright.h>

/* $Header: inputTable.c,v 1.1 86/12/17 09:08:48 swick Exp $ */
/* Copyright 1986, Hewlett-Packard Company */
/* Copyright 1986, Massachussetts Institute of Technology */

static char rcsid[] = "$Header: inputTable.c,v 1.1 86/12/17 09:08:48 swick Exp $";
/*************************************<+>*************************************
 *****************************************************************************
 **
 **   File:        inputTable.c
 **
 **   Project:     X-ray Toolbox
 **
 **   Description: 
 **
 **
 **   ------------------------ MODIFICATION RECORD   ------------------------
 *
 * $Log:	inputTable.c,v $
 * Revision 1.1  86/12/17  09:08:48  swick
 * Initial revision
 * 
 * Revision 7.0  86/11/13  08:20:29  08:20:29  rick ()
 * Final QA release
 * 
 * Revision 6.0  86/11/10  15:22:23  15:22:23  rick ()
 * QA #2 release
 * 
 * Revision 5.1  86/11/07  14:02:14  14:02:14  rick ()
 * Added the copyright message.
 * 
 * Revision 5.0  86/10/28  08:23:00  08:23:00  rick ()
 * QA #1.1 release
 * 
 * Revision 4.1  86/10/24  08:59:04  08:59:04  karen
 * update to make ALT and 16BIT handling more general, remove CAPSLOCK
 * 
 * Revision 3.0  86/10/02  15:58:54  15:58:54  rick ()
 *  Alpha release set to 3.0
 * 
 * Revision 1.1  86/10/02  15:37:52  15:37:52  rick ()
 * Initial revision
 * 
 *
 *****************************************************************************
 *************************************<+>*************************************/

#include <Xr/keycode.h>

extern unsigned char	itf_extend[];
extern unsigned char	kanatab[];

extern unsigned char	k_us[];
extern unsigned char	k_french[];
extern unsigned char	k_canada[];
extern unsigned char	k_danish[];
extern unsigned char	k_dutch[];
extern unsigned char	k_finnish[];
extern unsigned char	k_swissfr[];
extern unsigned char	k_german[];
extern unsigned char	k_swissgr[];
extern unsigned char	k_italian[];
extern unsigned char	k_norway[];
extern unsigned char	k_spain[];
extern unsigned char	k_latinam[];
extern unsigned char	k_finnish[];
extern unsigned char	k_uk[];
extern unsigned char	k_swissf2[];
extern unsigned char	k_swissg2[];

extern unsigned char	k_isus[];
extern unsigned char	k_isfr[];
extern unsigned char	k_iscn[];
extern unsigned char	k_isdn[];
extern unsigned char	k_isdu[];
extern unsigned char	k_issw[];
extern unsigned char	k_isss[];
extern unsigned char	k_isgm[];
extern unsigned char	k_isit[];
extern unsigned char	k_isnw[];
extern unsigned char	k_ises[];
extern unsigned char	k_isls[];
extern unsigned char	k_isuk[];
extern unsigned char	k_isss2[];

unsigned char * k_alttab[] = {
	itf_extend,	/* (0) HP ITF United States */
	itf_extend,	/* (1) HP ITF Belgian  */
	itf_extend,	/* (2) HP ITF Canadian English  */
	itf_extend,	/* (3) HP ITF Danish  */
	itf_extend,	/* (4) HP ITF Dutch  */
	itf_extend,	/* (5) HP ITF Finnish  */
	itf_extend,	/* (6) HP ITF French (AZERTY) */
	itf_extend,	/* (7) HP ITF Canadian French  */
	itf_extend,	/* (8) HP ITF Swiss French  */
	itf_extend,	/* (9) HP ITF German  */
	itf_extend,	/* (10) HP ITF Swiss German  */
	itf_extend,	/* (11) HP ITF Italian  */
	itf_extend,	/* (12) HP ITF Norwegian  */
	itf_extend,	/* (13) HP ITF European Spanish  */
	itf_extend,	/* (14) HP ITF Latin Spanish  */
	itf_extend,	/* (15) HP ITF Swedish  */
	itf_extend,	/* (16) HP ITF United Kingdom  */
	kanatab,	/* (17) HP ITF Katakana  */
	itf_extend,	/* (18) HP ITF Swiss French II  */
	itf_extend,	/* (19) HP ITF Swiss German II */
	kanatab,	/* (20) HP ITF Kanji */
};

/* Typewriter keyboard table for KATAKANA */
unsigned char kanatab[] = {
	/* unshifted */
	176, 199, 192, 193, 194, K_ILLEGAL,
	204, 195, 196, 187, K_ILLEGAL, K_ILLEGAL, 
	177, 178, 188, 191, K_ILLEGAL, 179,
	189, 202, 203, 32, K_ILLEGAL, 180,
	182, 183, 186, K_ILLEGAL, 181, 221,
	184, 208, K_ILLEGAL, 212, 197, 207,
	211, K_ILLEGAL, 213, 198, 201, 200,
	K_ILLEGAL, 214, 215, 216, 217, K_ILLEGAL,
	220, 190, K_ILLEGAL, 218, 210, K_ILLEGAL,
	205, 162, 163, K_ILLEGAL, 206, 222,
	185, 
	/* shifted */
	219, 199, 192, 193, 175, K_ILLEGAL,
	204, 195, 196, 187, K_ILLEGAL, K_ILLEGAL,
	167, 168, 188, 191, K_ILLEGAL, 169,
	189, 202, 203, 32, K_ILLEGAL, 170,
	182, 183, 186, K_ILLEGAL, 171, 221,
	184, 208, K_ILLEGAL, 172, 197, 207,
	211, K_ILLEGAL, 173, 198, 201, 164, 
	K_ILLEGAL, 174, 215, 216, 161, K_ILLEGAL, 
	166, 190, K_ILLEGAL, 218, 165, K_ILLEGAL, 
	205, 223, 209, K_ILLEGAL, 176, 222, 
	185
};

/* Typewriter keyboard table for EXTEND */
unsigned char itf_extend[] = {
	/* Unshifted */
	R_LEFTSHIFT,	/*	` */
	R_i,		/*	1 */
	R_MIDDOT,	/*	q */
	R_a_DOT,	/*	a */
	R_PILCROW,	/*	z */
	K_ILLEGAL,
	'@',		/*   	2 */
	'~',		/*	w */
	R_BETA, 	/*	s */
	R_s_V, 		/*	x */
	K_ILLEGAL,
	K_ILLEGAL,
	'#',		/*	3 */
	R_ae, 		/*	e */
	R_d_CROSS, 	/*	d */
	R_c_BEARD, 	/*	c */
	K_ILLEGAL,
	R_ONEFOURTH,	/*	4 */
	R_BQUOTE, 	/*	r */
	R_F, 		/*	f */
	R_SO, 		/*	v */
	' ',		/*  space */
	K_ILLEGAL,
	R_ONEHALF,	/*	5 */
	R_FQUOTE,	/*	t */
	R_OX, 		/*	g */
	R_BLACK, 	/*	b */
	K_ILLEGAL,
	'^',		/*	6 */
	R_HAT,		/*	y */
	R_YEN, 		/*	h */
	R_AUSCORE,	/*	n */
	K_ILLEGAL,
	'\\',		/*	7 */
	R_DDOT, 	/*	u */
	'$',		/*	j */
	R_OUSCORE,	/*	m */
	K_ILLEGAL,
	'[',		/*	8 */
	R_TILTA,	/*	i */
	R_CENT, 	/*	k */
	'<',		/*	, */
	K_ILLEGAL,
	']',		/*	9 */
	R_zero, 	/*	o */
	R_SPOUND,	/*	l */
	'>',		/*	. */
	K_ILLEGAL,
	R_UQUES,	/*	0 */
	R_ip, 		/*	p */
	K_ILLEGAL,
	R_DPOUND,	/*	; */
	'_',		/*	/ */
	K_ILLEGAL,
	R_PLUSMINUS,	/*	= */
	'|',		/*	] */
	R_MICRO,	/*	\ */
	K_ILLEGAL,
	R_MIDLINE,	/*	- */
	R_DEGREE,	/*	[ */
	'`',		/*	' */
	/* Shifted */
	R_RIGHTSHIFT,	/*	` */
	R_i,		/*	1 */
	R_MIDDOT,	/*	q */
	R_A_DOT,	/*	a */
	R_PILCROW,	/*	z */
	K_ILLEGAL,
	'@',		/*	2 */
	'~',		/*	w */
	R_BETA, 	/*	s */
	R_S_V, 		/*	x */
	K_ILLEGAL,
	K_ILLEGAL,
	'#',		/*	3 */
	R_AE, 		/*	e */
	R_D_CROSS, 	/*	d */
	R_C_BEARD, 	/*	c */
	K_ILLEGAL,
	R_THREEFOURTH,	/*	4 */
	R_BQUOTE, 	/*	r */
	R_F, 		/*	f */
	R_SO, 		/*	v */
	' ',		/* space */
	K_ILLEGAL,
	R_ONEHALF,	/*	5 */
	R_FQUOTE,	/*	t */
	R_OX, 		/*	g */
	R_BLACK, 	/*	b */
	K_ILLEGAL,
	'^',		/*	6 */
	R_HAT,		/*	y */
	R_YEN, 		/*	h */
	R_AUSCORE,	/*	n */
	K_ILLEGAL,
	'\\',		/*	7 */
	R_DDOT, 	/*	u */
	'$',		/*	j */
	R_OUSCORE,	/*	m */
	K_ILLEGAL,
	'\{',		/*	8 */
	R_TILTA,	/*	i */
	R_CENT, 	/*	k */
	'<',		/*	, */
	K_ILLEGAL,
	'\}',		/*	9 */
	R_ZERO, 	/*	o */
	R_SPOUND,	/*	l */
	'>',		/*	. */
	K_ILLEGAL,
	R_UQUES,	/*	0 */
	R_IP, 		/*	p */
	K_ILLEGAL,
	R_DPOUND,	/*	; */
	'_',		/*	/ */
	K_ILLEGAL,
	R_PLUSMINUS,	/*	= */
	'|',		/*	] */
	R_MICRO,	/*	\ */
	K_ILLEGAL,
	R_OVERBAR,	/*	- */
	R_DEGREE,	/*	[ */
	39,		/*	' */
};


unsigned short k_mute_enable[] = {
	K_MUTE,	/* (0) HP ITF United States */
	K_MUTE,	/* (1) HP ITF Belgian (Mute in 8 bit only) */
	K_MUTE,	/* (2) HP ITF Canadian English (Mute in 8 bit only) */
	K_MUTE,	/* (3) HP ITF Danish (Mute in 8 bit only) */
	K_MUTE,	/* (4) HP ITF Dutch (Mute in 8 bit only) */
	K_MUTE,	/* (5) HP ITF Finnish (Mute Characters - None) */
	K_MUTE,	/* (6) HP ITF French (AZERTY)(Mute in both 7 and 8 bit modes)*/
	K_MUTE,	/* (7) HP ITF Canadian French (Mute in 8 bit mode only) */
	K_MUTE,	/* (8) HP ITF Swiss French (Mute in 8 bit mode only) */
	K_MUTE,	/* (9) HP ITF German (Mute Characters - None) */
	K_MUTE,	/* (10) HP ITF Swiss German (Mute in 8 bit mode only) */
	K_MUTE,	/* (11) HP ITF Italian (Mute in 8 bit mode only) */
	K_MUTE,	/* (12) HP ITF Norwegian (Mute in 8 bit mode only) */
	K_MUTE,	/* (13) HP ITF European Spanish (Mute in 8 bit mode only) */
	K_MUTE,	/* (14) HP ITF Latin Spanish (Mute in both 7 and 8 bit modes) */
	K_MUTE,	/* (15) HP ITF Swedish (Mute in 8 bit mode only) */
	K_MUTE,	/* (16) HP ITF United Kingdom (Mute Characters - None) */
	0,	/* (17) HP ITF Katakana (Mute Characters - None) */
	K_MUTE,	/* (18) HP ITF Swiss French II (Mute in 8 bit mode only) */
	K_MUTE,	/* (19) HP ITF Swiss German II (Mute in 8 bit mode only) */
	0,	/* (20) HP ITF KANJI (Mute Characters - None) */
};

unsigned char k_alt_enable[] = {
	0,	/* (0) HP ITF United States */
	0,	/* (1) HP ITF Belgian */
	0,	/* (2) HP ITF Canadian English */
	0,	/* (3) HP ITF Danish */
	0,	/* (4) HP ITF Dutch */
	0,	/* (5) HP ITF Finnish */
	0,	/* (6) HP ITF French (AZERTY) */
	0,	/* (7) HP ITF Canadian French */
	0,	/* (8) HP ITF Swiss French */
	0,	/* (9) HP ITF German */
	0,	/* (10) HP ITF Swiss German */
	0,	/* (11) HP ITF Italian */
	0,	/* (12) HP ITF Norwegian */
	0,	/* (13) HP ITF European Spanish */
	0,	/* (14) HP ITF Latin Spanish */
	0,	/* (15) HP ITF Swedish */
	0,	/* (16) HP ITF United Kingdom */
	1,	/* (17) HP ITF Katakana (right extend set, left extend clear) */
	0,	/* (18) HP ITF Swiss French II */
	0,	/* (19) HP ITF Swiss German II */
	3,	/* (20) HP ITF Kanji (right extend toggle) */
};

unsigned char k_16bit_enable[] = {
	0,	/* (0) HP ITF United States */
	0,	/* (1) HP ITF Belgian */
	0,	/* (2) HP ITF Canadian English */
	0,	/* (3) HP ITF Danish */
	0,	/* (4) HP ITF Dutch */
	0,	/* (5) HP ITF Finnish */
	0,	/* (6) HP ITF French (AZERTY) */
	0,	/* (7) HP ITF Canadian French */
	0,	/* (8) HP ITF Swiss French */
	0,	/* (9) HP ITF German */
	0,	/* (10) HP ITF Swiss German */
	0,	/* (11) HP ITF Italian */
	0,	/* (12) HP ITF Norwegian */
	0,	/* (13) HP ITF European Spanish */
	0,	/* (14) HP ITF Latin Spanish */
	0,	/* (15) HP ITF Swedish */
	0,	/* (16) HP ITF United Kingdom */
	0,	/* (17) HP ITF Katakana */
	0,	/* (18) HP ITF Swiss French II */
	0,	/* (19) HP ITF Swiss German II */
	4, 	/* (20) HP ITF Kanji (left extend toggle) */
};

unsigned short k_code[] = {
/* unshifted table */
F1_KEY+K_s, 	F2_KEY+K_s, 	F3_KEY+K_s, 	F4_KEY+K_s,
F5_KEY+K_s, 	BREAK_KEY+K_s, 	STOP_KEY+K_s, 	MENU_KEY+K_s,
SYS_KEY+K_s, 	ENTER_KEY+K_s, 	CLR_LINE_KEY+K_s, DEL_LINE_KEY+K_s,
INSERT_LINE_KEY+K_s, CLR_DISP_KEY+K_s, F6_KEY+K_s, F7_KEY+K_s,
F8_KEY+K_s, 	MENU_KEY+K_s, 	SYS_KEY+K_s, 	K_ILLEGAL+K_s,
K_ILLEGAL+K_s, 	K_ILLEGAL+K_s, 	K_ILLEGAL+K_s, 	K_ILLEGAL+K_s,
K_ILLEGAL+K_s, 	K_ILLEGAL+K_s, 	K_ILLEGAL+K_s, 	'\033',
BS_KEY+K_s, 	'\n', 		HOME_UP_KEY+K_s, K_ILLEGAL+K_s,
K_ILLEGAL+K_s, 	K_ILLEGAL+K_s, 	K_ILLEGAL+K_s, 	K_ILLEGAL+K_s,
K_ILLEGAL+K_s, 	K_ILLEGAL+K_s, 	HELP_KEY+K_s, 	DO_KEY+K_s,
K_ILLEGAL+K_s, 	K_ILLEGAL+K_s, 	CLR_LINE_KEY+K_s,CLR_DISP_KEY+K_s,
INSERT_LINE_KEY+K_s, DEL_LINE_KEY+K_s, BS_KEY+K_s, '*',
'/', 		'+', 		TAB_KEY+K_s, 	'\033',
FIND_KEY+K_s,	INSERT_CHAR_KEY+K_s, DEL_CHAR_KEY+K_s, SELECT_KEY+K_s,
PREV_KEY+K_s, 	NEXT_KEY+K_s, 	K_ILLEGAL+K_s, 	K_ILLEGAL+K_s,
'0', 		K_ILLEGAL+K_s, 	'.', 		ENTER_KEY+K_s,
'1', 		'2', 		'3', 		'4',
'5', 		'6', 		',', 		'7',
'8', 		'9', 		'-', 		BLANK_1_KEY+K_s,
BLANK_2_KEY+K_s, BLANK_3_KEY+K_s, BLANK_4_KEY+K_s, K_ILLEGAL+K_s,
K_ILLEGAL+K_s, 	CURS_LF_KEY+K_s, CURS_RT_KEY+K_s, CURS_DN_KEY+K_s,
CURS_UP_KEY+K_s, HOME_UP_KEY+K_s, K_ILLEGAL+K_s, K_ILLEGAL+K_s,
SHIFT_KEY+K_s, 	CONTROL_KEY+K_s, CAPS_KEY+K_s, 	TO_ROMAN_KEY+K_s,
TO_ALT_KEY+K_s, KANJI_LF_KEY+K_s, KANJI_RT_KEY+K_s, K_ILLEGAL+K_s,
K_ILLEGAL+K_s, 	K_ILLEGAL+K_s, 	K_ILLEGAL+K_s, 	K_ILLEGAL+K_s,
K_ILLEGAL+K_s, 	K_ILLEGAL+K_s, 	BS_KEY+K_s, 	RETURN_KEY+K_s,
TAB_KEY+K_s, 	K_LANG0, 	K_LANG2, 	K_LANG21,
K_LANG24, 	K_LANG26,	K_ILLEGAL, 	K_LANG3,
K_LANG22,	's', 		'x', 		'\033',
K_ILLEGAL+K_s, 	K_LANG4,	'e', 		'd',
'c', 		K_ILLEGAL+K_s, 	K_LANG5,	'r',
'f', 		'v', 		' ', 		K_ILLEGAL+K_s,
K_LANG6,	't', 		'g', 		'b',
K_ILLEGAL+K_s, 	K_LANG7,	K_LANG23,	'h',
'n', 		K_ILLEGAL+K_s, 	K_LANG8,	'u',
'j', 		K_LANG25,	K_ILLEGAL+K_s, 	K_LANG9,
'i', 		'k', 		K_LANG18,	K_ILLEGAL+K_s,
K_LANG10,	'o', 		'l', 		K_LANG19,
K_ILLEGAL+K_s, 	K_LANG11,	'p', 		K_ILLEGAL+K_s,
K_LANG16,	K_LANG20, 	K_ILLEGAL+K_s, 	K_LANG13,
K_LANG15, 	K_LANG1, 	K_ILLEGAL+K_s, 	K_LANG12,
K_LANG14, 	K_LANG17,

 /* shifted table */
F9_KEY+K_s, 	F10_KEY+K_s, 	F11_KEY+K_s, 	F12_KEY+K_s,
F13_KEY+K_s, 	RESET_KEY+K_s, 	SH_STOP_KEY+K_s, MENU_KEY+K_s,
USER_KEY+K_s, 	PRINT_KEY+K_s, 	CLR_ALL_LINE_KEY+K_s, DEL_LINE_KEY+K_s,
INSERT_LINE_KEY+K_s, CLR_ALL_DISP_KEY+K_s, F14_KEY+K_s,	F15_KEY+K_s,
F16_KEY+K_s, 	MENU_KEY+K_s, 	USER_KEY+K_s,   K_ILLEGAL+K_s,
K_ILLEGAL+K_s, 	K_ILLEGAL+K_s, 	K_ILLEGAL+K_s, 	K_ILLEGAL+K_s,
K_ILLEGAL+K_s, 	K_ILLEGAL+K_s, 	K_ILLEGAL+K_s, 	'\033',
BS_KEY+K_s, 	'\n', 		HOME_DN_KEY+K_s, K_ILLEGAL+K_s,
K_ILLEGAL+K_s, 	K_ILLEGAL+K_s, 	K_ILLEGAL+K_s, 	K_ILLEGAL+K_s,
K_ILLEGAL+K_s, 	K_ILLEGAL+K_s, 	HELP_KEY+K_s, 	DO_KEY+K_s,
K_ILLEGAL+K_s, 	K_ILLEGAL+K_s, 	CLR_ALL_LINE_KEY+K_s, CLR_ALL_DISP_KEY+K_s,
INSERT_LINE_KEY+K_s, DEL_LINE_KEY+K_s, BS_KEY+K_s, '*',
'/', 		'+', 		BACKTAB_KEY+K_s, '\177',
FIND_KEY+K_s,   INSERT_CHAR_KEY+K_s, DEL_CHAR_KEY+K_s, SH_SELECT_KEY+K_s,
PREV_KEY+K_s, 	NEXT_KEY+K_s, 	K_ILLEGAL+K_s, 	K_ILLEGAL+K_s,
'0', 		K_ILLEGAL+K_s, 	'.', 		ENTER_KEY+K_s,
'1', 		'2', 		'3', 		'4',
'5', 		'6', 		',', 		'7',
'8', 		'9', 		'-', 		BLANK_5_KEY+K_s,
BLANK_6_KEY+K_s, BLANK_7_KEY+K_s, BLANK_8_KEY+K_s, K_ILLEGAL+K_s,
K_ILLEGAL+K_s, 	ROLL_LF_KEY+K_s, ROLL_RT_KEY+K_s, ROLL_DN_KEY+K_s,
ROLL_UP_KEY+K_s, HOME_DN_KEY+K_s, K_ILLEGAL+K_s, 	K_ILLEGAL+K_s,
SHIFT_KEY+K_s, 	CONTROL_KEY+K_s, CAPS_KEY+K_s, 	TO_ROMAN_KEY+K_s,
TO_ALT_KEY+K_s, KANJI_LF_KEY+K_s, KANJI_RT_KEY+K_s, K_ILLEGAL+K_s,
K_ILLEGAL+K_s, 	K_ILLEGAL+K_s, 	K_ILLEGAL+K_s, 	K_ILLEGAL+K_s,
K_ILLEGAL+K_s, 	K_ILLEGAL+K_s, 	BS_KEY+K_s, 	RETURN_KEY+K_s,
BACKTAB_KEY+K_s, K_LANG27, 	K_LANG30, 	K_LANG49,
K_LANG52,	K_LANG54,	K_ILLEGAL+K_s, 	K_LANG31,
K_LANG50, 	'S', 		'X', 		'\177',
K_ILLEGAL+K_s, 	K_LANG32,	'E', 		'D',
'C', 		K_ILLEGAL+K_s, 	K_LANG33,	'R',
'F', 		'V', 		' ', 		K_ILLEGAL+K_s,
K_LANG34,	'T', 		'G', 		'B',
K_ILLEGAL+K_s, 	K_LANG35,	K_LANG51,	'H',
'N', 		K_ILLEGAL+K_s, 	K_LANG36,	'U',
'J', 		K_LANG53,	K_ILLEGAL+K_s, 	K_LANG37,
'I', 		'K', 		K_LANG46,	K_ILLEGAL+K_s,
K_LANG38,	'O', 		'L', 		K_LANG47,
K_ILLEGAL+K_s, 	K_LANG39,	'P', 		K_ILLEGAL+K_s,
K_LANG44,	K_LANG48, 	K_ILLEGAL+K_s, 	K_LANG41,
K_LANG43,	K_LANG28, 	K_ILLEGAL+K_s, 	K_LANG40,
K_LANG42,	K_LANG45 
};

unsigned char * k_langtab[] = {
	k_us,	   /* (0) HP ITF United States */
	k_french,  /* (1) HP ITF Belgian */
	k_canada,  /* (2) HP ITF Canadian English */
	k_danish,  /* (3) HP ITF Danish */
	k_dutch,   /* (4) HP ITF Dutch */
	k_finnish, /* (5) HP ITF Finnish */
	k_french,  /* (6) HP ITF French (AZERTY) */
	k_canada,  /* (7) HP ITF Canadian French */
	k_swissfr, /* (8) HP ITF Swiss French */
	k_german,  /* (9) HP ITF German */
	k_swissgr, /* (10) HP ITF Swiss German */
	k_italian, /* (11) HP ITF Italian */
	k_norway,  /* (12) HP ITF Norwegian */
	k_spain,   /* (13) HP ITF European Spanish */
	k_latinam, /* (14) HP ITF Latin Spanish */
	k_finnish, /* (15) HP ITF Swedish */
	k_uk,	   /* (16) HP ITF United Kingdom */
	k_us,	   /* (17) HP ITF Katakana */
	k_swissf2, /* (18) HP ITF Swiss French II */
	k_swissg2, /* (19) HP ITF Swiss German II */
	k_us, 	   /* (20) HP ITF Kanji */
};

/* Nationalized Keyboard Tables
*/
	/*	160-213						*/
	/* K_LANG31	160	@  */
	/* K_LANG35	161	^  */
	/* K_LANG36	162	&  */
	/* K_LANG37	163	*  */
	/* K_LANG38	164	(  */
	/* K_LANG39	165	)  */
	/* K_LANG40	166	_  */
	/* K_LANG12	167	-  */
	/* K_LANG41	168	+  */
	/* K_LANG13	169	=  */
	/* K_LANG51	170	Y  */
	/* K_LANG23	171	y  */
	/* K_LANG42	172	{  */
	/* K_LANG14	173	[  */
	/* K_LANG43	174	}  */
	/* K_LANG15	175	]  */
	/* K_LANG44	176	:  */
	/* K_LANG16	177	;  */
	/* K_LANG45	178	"  */
	/* K_LANG17	179	'  */
	/* K_LANG54	180	Z  */
	/* K_LANG26	181	z  */
	/* K_LANG46	182	<  */
	/* K_LANG47	183	>  */
	/* K_LANG48	184	?  */
	/* K_LANG20	185	/  */
	/* K_LANG32	186	#  */
	/* K_LANG49	187	Q  */
	/* K_LANG21	188	q  */
	/* K_LANG50	189	W  */
	/* K_LANG22	190	w  */
	/* K_LANG52	191	A  */
	/* K_LANG24	192	a  */
	/* K_LANG0	193	`  */
	/* K_LANG1	194	\  */
	/* K_LANG2	195	1  */
	/* K_LANG3	196	2  */
	/* K_LANG4	197	3  */
	/* K_LANG5	198	4  */
	/* K_LANG6	199	5  */
	/* K_LANG7	200	6  */
	/* K_LANG8	201	7  */
	/* K_LANG9	202	8  */
	/* K_LANG10	203	9  */
	/* K_LANG11	204	0  */
	/* K_LANG18	205	,  */
	/* K_LANG19	206	.  */
	/* K_LANG25	207	m  */
	/* K_LANG27	208	~  */
	/* K_LANG28	209	|  */
	/* K_LANG30	210	!  */
	/* K_LANG33	211	$  */
	/* K_LANG34	212	%  */
	/* K_LANG53	213	M  */

/* (0) HP ITF United States */
/* (17) HP ITF Katakana */
/* (20) HP ITF Kanji */
unsigned char k_us[] = {
	/* 160-213 */
	'@',	/* K_LANG31	160	@  */
	'^',	/* K_LANG35	161	^  */
	'&',	/* K_LANG36	162	&  */
	'*',	/* K_LANG37	163	*  */
	'(',	/* K_LANG38	164	(  */
	')',	/* K_LANG39	165	)  */
	'_',	/* K_LANG40	166	_  */
	'-',	/* K_LANG12	167	-  */
	'+',	/* K_LANG41	168	+  */ 
	'=',	/* K_LANG13	169	=  */
	'Y',	/* K_LANG51	170	Y  */
	'y',	/* K_LANG23	171	y  */
	'\{',	/* K_LANG42	172	{  */
	'[',	/* K_LANG14	173	[  */
	'\}',	/* K_LANG43	174	}  */
	']',	/* K_LANG15	175	]  */
	':',	/* K_LANG44	176	:  */
	';',	/* K_LANG16	177	;  */
	'"',	/* K_LANG45	178	"  */
	39,	/* K_LANG17	179	'  */
	'Z',	/* K_LANG54	180	Z  */
	'z',	/* K_LANG26	181	z  */
	'<',	/* K_LANG46	182	<  */
	'>',	/* K_LANG47	183	>  */
	'?',	/* K_LANG48	184	?  */
	'/',	/* K_LANG20	185	/  */
	'#',	/* K_LANG32	186	#  */
	'Q',	/* K_LANG49	187	Q  */
	'q',	/* K_LANG21	188	q  */
	'W',	/* K_LANG50	189	W  */
	'w',	/* K_LANG22	190	w  */
	'A',	/* K_LANG52	191	A  */
	'a',	/* K_LANG24	192	a  */
	'`',	/* K_LANG0	193	`  */
	'\\',	/* K_LANG1	194	\  */
	/* 195-204 K_LANG2 - K_LANG11 */
	'1', '2', '3', '4', '5', '6', '7', '8', '9', '0',
	',',	/* K_LANG18	205	,  */
	'.',	/* K_LANG19	206	.  */
	'm',	/* K_LANG25	207	m  */
	'~',	/* K_LANG27	208	~  */
	'|',	/* K_LANG28	209	|  */
	'!',	/* K_LANG30	210	!  */
	'$',	/* K_LANG33	211	$  */
	'%',	/* K_LANG34	212	%  */
	'M',	/* K_LANG53	213	M  */
};

/* (1) HP ITF Belgian */
/* (6) HP ITF French (AZERTY) */
unsigned char k_french[] = {
	/* 160-213 */
	'2',	/* K_LANG31	160	@  */
	'6',	/* K_LANG35	161	^  */
	'7',	/* K_LANG36	162	&  */
	'8',	/* K_LANG37	163	*  */
	'9',	/* K_LANG38	164	(  */
	'0',	/* K_LANG39	165	)  */
	R_DEGREE, /* K_LANG40	166	_  */
	')',	/* K_LANG12	167	-  */
	'_',	/* K_LANG41	168	+  */
	'-',	/* K_LANG13	169	=  */
	'Y',	/* K_LANG51	170	Y  */
	'y',	/* K_LANG23	171	y  */
	R_DDOT,	/* K_LANG42	172	{  */
	R_HAT,	/* K_LANG14	173	[  */
	'*',	/* K_LANG43	174	}  */
	'`',	/* K_LANG15	175	]  */
	'M',	/* K_LANG44	176	:  */
	'm',	/* K_LANG16	177	;  */
	'%',	/* K_LANG45	178	"  */
	R_u_FQUOTE, /* K_LANG17	179	'  */
	'W',	/* K_LANG54	180	Z  */
	'w',	/* K_LANG26	181	z  */
	'.',	/* K_LANG46	182	<  */
	'/',	/* K_LANG47	183	>  */
	'+',	/* K_LANG48	184	?  */
	'=',	/* K_LANG20	185	/  */
	'3',	/* K_LANG32	186	#  */
	'A',	/* K_LANG49	187	Q  */
	'a',	/* K_LANG21	188	q  */
	'Z',	/* K_LANG50	189	W  */
	'z',	/* K_LANG22	190	w  */
	'Q',	/* K_LANG52	191	A  */
	'q',	/* K_LANG24	192	a  */
	'$',	/* K_LANG0	193	`  */
	'<',	/* K_LANG1	194	\  */
	'&',	/* K_LANG2	195	1  */
	R_e_BQUOTE, /* K_LANG3	196	2  */
	'"',	/* K_LANG4	197	3  */
	39,	/* K_LANG5	198	4  */
	'(',	/* K_LANG6	199	5  */
	R_SO,	/* K_LANG7	200	6  */
	R_e_FQUOTE, /* K_LANG8	201	7  */
	'!',	/* K_LANG9	202	8  */
	R_c_BEARD, /* K_LANG10	203	9  */
	R_a_FQUOTE, /* K_LANG11	204	0  */
	';',	/* K_LANG18	205	,  */
	':',	/* K_LANG19	206	.  */
	',',	/* K_LANG25	207	m  */
	R_SPOUND, /* K_LANG27	208	~  */
	'>',	/* K_LANG28	209	|  */
	'1',	/* K_LANG30	210	!  */
	'4',	/* K_LANG33	211	$  */
	'5',	/* K_LANG34	212	%  */
	'?',	/* K_LANG53	213	M  */
};

/* (2) HP ITF Canadian English */
/* (7) HP ITF Canadian French */
unsigned char k_canada[] = {
	/* 160-213 */
	'"',	/* K_LANG31	160	@  */
	'?',	/* K_LANG35	161	^  */
	'&',	/* K_LANG36	162	&  */
	'*',	/* K_LANG37	163	*  */
	'(',	/* K_LANG38	164	(  */
	')',	/* K_LANG39	165	)  */
	'_',	/* K_LANG40	166	_  */
	'-',	/* K_LANG12	167	-  */
	'+',	/* K_LANG41	168	+  */
	'=',	/* K_LANG13	169	=  */
	'Y',	/* K_LANG51	170	Y  */
	'y',	/* K_LANG23	171	y  */
	R_DDOT,	/* K_LANG42	172	{  */
	R_HAT,	/* K_LANG14	173	[  */
	R_C_BEARD, /* K_LANG43	174	}  */
	R_c_BEARD, /* K_LANG15	175	]  */
	':',	/* K_LANG44	176	:  */
	';',	/* K_LANG16	177	;  */
	39,	/* K_LANG45	178	"  */
	R_FQUOTE, /* K_LANG17	179	'  */
	'Z',	/* K_LANG54	180	Z  */
	'z',	/* K_LANG26	181	z  */
	'<',	/* K_LANG46	182	<  */
	'>',	/* K_LANG47	183	>  */
	R_E_BQUOTE, /* K_LANG48	184	?  */
	R_e_BQUOTE, /* K_LANG20	185	/  */
	'/',	/* K_LANG32	186	#  */
	'Q',	/* K_LANG49	187	Q  */
	'q',	/* K_LANG21	188	q  */
	'W',	/* K_LANG50	189	W  */
	'w',	/* K_LANG22	190	w  */
	'A',	/* K_LANG52	191	A  */
	'a',	/* K_LANG24	192	a  */
	']',	/* K_LANG0	193	`  */
	'@',	/* K_LANG1	194	\  */
	'1', '2', '3', '4', '5', '6', '7', '8', '9', '0',
	',',	/* K_LANG18	205	,  */
	'.',	/* K_LANG19	206	.  */
	'm',	/* K_LANG25	207	m  */
	'[',	/* K_LANG27	208	~  */
	'#',	/* K_LANG28	209	|  */
	'!',	/* K_LANG30	210	!  */
	'$',	/* K_LANG33	211	$  */
	'%',	/* K_LANG34	212	%  */
	'M',	/* K_LANG53	213	M  */
};

/* (3) HP ITF Danish */
unsigned char k_danish[] = {
	/* 160-213 */
	'"',	/* K_LANG31	160	@  */
	'&',	/* K_LANG35	161	^  */
	'/',	/* K_LANG36	162	&  */
	'(',	/* K_LANG37	163	*  */
	')',	/* K_LANG38	164	(  */
	'=',	/* K_LANG39	165	)  */
	'?',	/* K_LANG40	166	_  */
	'+',	/* K_LANG12	167	-  */
	R_FQUOTE, /* K_LANG41	168	+  */
	R_BQUOTE,/* K_LANG13	169	=  */
	'Y',	/* K_LANG51	170	Y  */
	'y',	/* K_LANG23	171	y  */
	R_A_DOT, /* K_LANG42	172	{  */
	R_a_DOT, /* K_LANG14	173	[  */
	'^',	/* K_LANG43	174	}  */
	R_DDOT,	/* K_LANG15	175	]  */
	R_AE,	/* K_LANG44	176	:  */
	R_ae,	/* K_LANG16	177	;  */
	R_ZERO,	/* K_LANG45	178	"  */
	R_zero,	/* K_LANG17	179	'  */
	'Z',	/* K_LANG54	180	Z  */
	'z',	/* K_LANG26	181	z  */
	';',	/* K_LANG46	182	<  */
	':',	/* K_LANG47	183	>  */
	'_',	/* K_LANG48	184	?  */
	'-',	/* K_LANG20	185	/  */
	R_SO,	/* K_LANG32	186	#  */
	'Q',	/* K_LANG39	187	Q  */
	'q',	/* K_LANG21	188	q  */
	'W',	/* K_LANG50	189	W  */
	'w',	/* K_LANG22	190	w  */
	'A',	/* K_LANG52	191	A  */
	'a',	/* K_LANG24	192	a  */
	'<',	/* K_LANG0	193	`  */
	'@',	/* K_LANG1	194	\  */
	'1', '2', '3', '4', '5', '6', '7', '8', '9', '0',
	',',	/* K_LANG18	205	,  */
	'.',	/* K_LANG19	206	.  */
	'm',	/* K_LANG25	207	m  */
	'>',	/* K_LANG27	208	~  */
	'*',	/* K_LANG28	209	|  */
	'!',	/* K_LANG30	210	!  */
	'$',	/* K_LANG33	211	$  */
	'%',	/* K_LANG34	212	%  */
	'M',	/* K_LANG53	213	M  */
};

/* (4) HP ITF Dutch */
unsigned char k_dutch[] = {
	/* 160-213 */
	'"',	/* K_LANG31	160	@  */
	'&',	/* K_LANG35	161	^  */
	'_',	/* K_LANG36	162	&  */
	'(',	/* K_LANG37	163	*  */
	')',	/* K_LANG38	164	(  */
	39,	/* K_LANG39	165	)  */
	'?',	/* K_LANG40	166	_  */
	'/',	/* K_LANG12	167	-  */
	'\\',	/* K_LANG41	168	+  */
	'|',	/* K_LANG13	169	=  */
	'Y',	/* K_LANG51	170	Y  */
	'y',	/* K_LANG23	171	y  */
	R_HAT,	/* K_LANG42	172	{  */
	R_DDOT,	/* K_LANG14	173	[  */
	'>',	/* K_LANG43	174	}  */
	'<',	/* K_LANG15	175	]  */
	'+',	/* K_LANG44	176	:  */
	':',	/* K_LANG16	177	;  */
	R_FQUOTE, /* K_LANG45	178	"  */
	R_BQUOTE, /* K_LANG17	179	'  */
	'Z',	/* K_LANG54	180	Z  */
	'z',	/* K_LANG26	181	z  */
	';',	/* K_LANG46	182	<  */
	'*',	/* K_LANG47	183	>  */
	'=',	/* K_LANG48	184	?  */
	'-',	/* K_LANG20	185	/  */
	'#',	/* K_LANG32	186	#  */
	'Q',	/* K_LANG49	187	Q  */
	'q',	/* K_LANG21	188	q  */
	'W',	/* K_LANG50	189	W  */
	'w',	/* K_LANG22	190	w  */
	'A',	/* K_LANG52	191	A  */
	'a',	/* K_LANG24	192	a  */
	'@',	/* K_LANG0	193	`  */
	R_c_BEARD, /* K_LANG1	194	\  */
	'1', '2', '3', '4', '5', '6', '7', '8', '9', '0',
	',',	/* K_LANG18	205	,  */
	'.',	/* K_LANG19	206	.  */
	'm',	/* K_LANG25	207	m  */
	R_SO,	/* K_LANG27	208	~  */
	R_F,	/* K_LANG28	209	|  */
	'!',	/* K_LANG30	210	!  */
	'$',	/* K_LANG33	211	$  */
	'%',	/* K_LANG34	212	%  */
	'M',	/* K_LANG53	213	M  */
};

/* (5) HP ITF Finnish */
/* (15) HP ITF Swedish */
unsigned char k_finnish[] = {
	/* 160-213 */
	'"',	/* K_LANG31	160	@  */
	'&',	/* K_LANG35	161	^  */
	'/',	/* K_LANG36	162	&  */
	'(',	/* K_LANG37	163	*  */
	')',	/* K_LANG38	164	(  */
	'=',	/* K_LANG39	165	)  */
	'?',	/* K_LANG40	166	_  */
	'+',	/* K_LANG12	167	-  */
	R_E_BQUOTE, /* K_LANG41	168	+  */
	R_e_BQUOTE, /* K_LANG13	169	=  */
	'Y',	/* K_LANG51	170	Y  */
	'y',	/* K_LANG23	171	y  */
	R_A_DOT, /* K_LANG42	172	{  */
	R_a_DOT, /* K_LANG14	173	[  */
	R_U_DDOT, /* K_LANG43	174	}  */
	R_u_DDOT, /* K_LANG15	175	]  */
	R_O_DDOT, /* K_LANG44	176	:  */
	R_o_DDOT, /* K_LANG16	177	;  */
	R_A_DDOT, /* K_LANG45	178	"  */
	R_a_DDOT, /* K_LANG17	179	'  */
	'Z',	/* K_LANG54	180	Z  */
	'z',	/* K_LANG26	181	z  */
	';',	/* K_LANG46	182	<  */
	':',	/* K_LANG47	183	>  */
	'_',	/* K_LANG48	184	?  */
	'-',	/* K_LANG20	185	/  */
	'#',	/* K_LANG32	186	#  */
	'Q',	/* K_LANG49	187	Q  */
	'q',	/* K_LANG21	188	q  */
	'W',	/* K_LANG50	189	W  */
	'w',	/* K_LANG22	190	w  */
	'A',	/* K_LANG52	191	A  */
	'a',	/* K_LANG24	192	a  */
	'<',	/* K_LANG0	193	`  */
	39,	/* K_LANG1	194	\  */
	'1', '2', '3', '4', '5', '6', '7', '8', '9', '0',
	',',	/* K_LANG18	205	,  */
	'.',	/* K_LANG19	206	.  */
	'm',	/* K_LANG25	207	m  */
	'>',	/* K_LANG27	208	~  */
	'*',	/* K_LANG28	209	|  */
	'!',	/* K_LANG30	210	!  */
	'$',	/* K_LANG33	211	$  */
	'%',	/* K_LANG34	212	%  */
	'M',	/* K_LANG53	213	M  */
};

/* (8) HP ITF Swiss French */
unsigned char k_swissfr[] = {
	/* 160-213 */
	'"',	/* K_LANG31	160	@  */
	'&',	/* K_LANG35	161	^  */
	'/',	/* K_LANG36	162	&  */
	'(',	/* K_LANG37	163	*  */
	')',	/* K_LANG38	164	(  */
	'=',	/* K_LANG39	165	)  */
	'?',	/* K_LANG40	166	_  */
	'!',	/* K_LANG12	167	-  */
	R_FQUOTE, /* K_LANG41	168	+  */
	R_HAT,	/* K_LANG13	169	=  */
	'Z',	/* K_LANG51	170	Y  */
	'z',	/* K_LANG23	171	y  */
	R_u_DDOT, /* K_LANG42	172	{  */
	R_e_FQUOTE, /* K_LANG14	173	[  */
	R_BQUOTE, /* K_LANG43	174	}  */
	R_DDOT,	/* K_LANG15	175	]  */
	R_o_DDOT, /* K_LANG44	176	:  */
	R_e_BQUOTE, /* K_LANG16	177	;  */
	R_a_DDOT, /* K_LANG45	178	"  */
	R_a_FQUOTE, /* K_LANG17	179	'  */
	'Y',	/* K_LANG54	180	Z  */
	'y',	/* K_LANG26	181	z  */
	';',	/* K_LANG46	182	<  */
	':',	/* K_LANG47	183	>  */
	'_',	/* K_LANG48	184	?  */
	'-',	/* K_LANG20	185	/  */
	'*',	/* K_LANG32	186	#  */
	'Q',	/* K_LANG49	187	Q  */
	'q',	/* K_LANG21	188	q  */
	'W',	/* K_LANG50	189	W  */
	'w',	/* K_LANG22	190	w  */
	'A',	/* K_LANG52	191	A  */
	'a',	/* K_LANG24	192	a  */
	R_SO,	/* K_LANG0	193	`  */
	'$',	/* K_LANG1	194	\  */
	'1', '2', '3', '4', '5', '6', '7', '8', '9', '0',
	',',	/* K_LANG18	205	,  */
	'.',	/* K_LANG19	206	.  */
	'm',	/* K_LANG25	207	m  */
	R_DEGREE, /* K_LANG27	208	~  */
	R_SPOUND, /* K_LANG28	209	|  */
	'+',	/* K_LANG30	210	!  */
	R_c_BEARD, /* K_LANG33	211	$  */
	'%',	/* K_LANG34	212	%  */
	'M',	/* K_LANG53	213	M  */
};

/* (9) HP ITF German */
unsigned char k_german[] = {
	/* 160-213 */
	'"',	/* K_LANG31	160	@  */
	'&',	/* K_LANG35	161	^  */
	'/',	/* K_LANG36	162	&  */
	'(',	/* K_LANG37	163	*  */
	')',	/* K_LANG38	164	(  */
	'=',	/* K_LANG39	165	)  */
	'?',	/* K_LANG40	166	_  */
	R_BETA,	/* K_LANG12	167	-  */
	'`',	/* K_LANG41	168	+  */
	39,	/* K_LANG13	169	=  */
	'Z',	/* K_LANG51	170	Y  */
	'z',	/* K_LANG23	171	y  */
	R_U_DDOT, /* K_LANG42	172	{  */
	R_u_DDOT, /* K_LANG14	173	[  */
	'*',	/* K_LANG43	174	}  */
	'+',	/* K_LANG15	175	]  */
	R_O_DDOT, /* K_LANG44	176	:  */
	R_o_DDOT, /* K_LANG16	177	;  */
	R_A_DDOT, /* K_LANG45	178	"  */
	R_a_DDOT, /* K_LANG17	179	'  */
	'Y',	/* K_LANG54	180	Z  */
	'y',	/* K_LANG26	181	z  */
	';',	/* K_LANG46	182	<  */
	':',	/* K_LANG47	183	>  */
	'_',	/* K_LANG48	184	?  */
	'-',	/* K_LANG20	185	/  */
	R_SO,	/* K_LANG32	186	#  */
	'Q',	/* K_LANG49	187	Q  */
	'q',	/* K_LANG21	188	q  */
	'W',	/* K_LANG50	189	W  */
	'w',	/* K_LANG22	190	w  */
	'A',	/* K_LANG52	191	A  */
	'a',	/* K_LANG24	192	a  */
	'<',	/* K_LANG0	193	`  */
	R_SPOUND, /* K_LANG1	194	\  */
	'1', '2', '3', '4', '5', '6', '7', '8', '9', '0',
	',',	/* K_LANG18	205	,  */
	'.',	/* K_LANG19	206	.  */
	'm',	/* K_LANG25	207	m  */
	'>',	/* K_LANG27	208	~  */
	'^',	/* K_LANG28	209	|  */
	'!',	/* K_LANG30	210	!  */
	'$',	/* K_LANG33	211	$  */
	'%',	/* K_LANG34	212	%  */
	'M',	/* K_LANG53	213	M  */
};

/* (10) HP ITF Swiss German */
unsigned char k_swissgr[] = {
	/* 160-213 */
	'"',	/* K_LANG31	160	@  */
	'&',	/* K_LANG35	161	^  */
	'/',	/* K_LANG36	162	&  */
	'(',	/* K_LANG37	163	*  */
	')',	/* K_LANG38	164	(  */
	'=',	/* K_LANG39	165	)  */
	'?',	/* K_LANG40	166	_  */
	'!',	/* K_LANG12	167	-  */
	R_FQUOTE, /* K_LANG41	168	+  */
	R_HAT,	/* K_LANG13	169	=  */
	'Z',	/* K_LANG51	170	Y  */
	'z',	/* K_LANG23	171	y  */
	R_e_FQUOTE, /* K_LANG42	172	{  */
	R_u_DDOT, /* K_LANG14	173	[  */
	R_BQUOTE, /* K_LANG43	174	}  */
	R_DDOT,	/* K_LANG15	175	]  */
	R_e_BQUOTE, /* K_LANG44	176	:  */
	R_o_DDOT, /* K_LANG16	177	;  */
	R_a_FQUOTE, /* K_LANG45	178	"  */
	R_a_DDOT, /* K_LANG17	179	'  */
	'Y',	/* K_LANG54	180	Z  */
	'y',	/* K_LANG26	181	z  */
	';',	/* K_LANG46	182	<  */
	':',	/* K_LANG47	183	>  */
	'_',	/* K_LANG48	184	?  */
	'-',	/* K_LANG20	185	/  */
	'*',	/* K_LANG32	186	#  */
	'Q',	/* K_LANG49	187	Q  */
	'q',	/* K_LANG21	188	q  */
	'W',	/* K_LANG50	189	W  */
	'w',	/* K_LANG22	190	w  */
	'A',	/* K_LANG52	191	A  */
	'a',	/* K_LANG24	192	a  */
	R_SO,	/* K_LANG0	193	`  */
	'$',	/* K_LANG1	194	\  */
	'1', '2', '3', '4', '5', '6', '7', '8', '9', '0',
	',',	/* K_LANG18	205	,  */
	'.',	/* K_LANG19	206	.  */
	'm',	/* K_LANG25	207	m  */
	R_DEGREE, /* K_LANG27	208	~  */
	R_SPOUND, /* K_LANG28	209	|  */
	'+',	/* K_LANG30	210	!  */
	R_c_BEARD, /* K_LANG33	211	$  */
	'%',	/* K_LANG34	212	%  */
	'M',	/* K_LANG53	213	M  */
};

/* (11) HP ITF Italian */
unsigned char k_italian[] = {
	/* 160-213 */
	'2',	/* K_LANG31	160	@  */
	'6',	/* K_LANG35	161	^  */
	'7',	/* K_LANG36	162	&  */
	'8',	/* K_LANG37	163	*  */
	'9',	/* K_LANG38	164	(  */
	'0',	/* K_LANG39	165	)  */
	R_DEGREE, /* K_LANG40	166	_  */
	')',	/* K_LANG12	167	-  */
	'+',	/* K_LANG41	168	+  */
	'-',	/* K_LANG13	169	=  */
	'Y',	/* K_LANG51	170	Y  */
	'y',	/* K_LANG23	171	y  */
	'=',	/* K_LANG42	172	{  */
	R_i_FQUOTE, /* K_LANG14	173	[  */
	'&',	/* K_LANG43	174	}  */
	'$',	/* K_LANG15	175	]  */
	'M',	/* K_LANG44	176	:  */
	'm',	/* K_LANG16	177	;  */
	'%',	/* K_LANG45	178	"  */
	R_u_FQUOTE, /* K_LANG17	179	'  */
	'W',	/* K_LANG54	180	Z  */
	'w',	/* K_LANG26	181	z  */
	'.',	/* K_LANG46	182	<  */
	'/',	/* K_LANG47	183	>  */
	'!',	/* K_LANG48	184	?  */
	R_o_FQUOTE, /* K_LANG20	185	/  */
	'3',	/* K_LANG32	186	#  */
	'Q',	/* K_LANG49	187	Q  */
	'q',	/* K_LANG21	188	q  */
	'Z',	/* K_LANG50	189	W  */
	'z',	/* K_LANG22	190	w  */
	'A',	/* K_LANG52	191	A  */
	'a',	/* K_LANG24	192	a  */
	'<',	/* K_LANG0	193	`  */
	'*',	/* K_LANG1	194	\  */
	R_SPOUND, /* K_LANG2	195	1  */
	R_e_BQUOTE, /* K_LANG3	196	2  */
	'"',	/* K_LANG4	197	3  */
	39,	/* K_LANG5	198	4  */
	'(',	/* K_LANG6	199	5  */
	'_',	/* K_LANG7	200	6  */
	R_e_FQUOTE, /* K_LANG8	201	7  */
	R_HAT,	/* K_LANG9	202	8  */
	R_c_BEARD, /* K_LANG10	203	9  */
	R_a_FQUOTE, /* K_LANG11	204	0  */
	';',	/* K_LANG18	205	,  */
	':',	/* K_LANG19	206	.  */
	',',	/* K_LANG25	207	m  */
	'>',	/* K_LANG27	208	~  */
	R_SO,	/* K_LANG28	209	|  */
	'1',	/* K_LANG30	210	!  */
	'4',	/* K_LANG33	211	$  */
	'5',	/* K_LANG34	212	%  */
	'?',	/* K_LANG53	213	M  */
};

/* (12) HP ITF Norwegian */
unsigned char k_norway[] = {
	/* 160-213 */
	'"',	/* K_LANG31	160	@  */
	'&',	/* K_LANG35	161	^  */
	'/',	/* K_LANG36	162	&  */
	'(',	/* K_LANG37	163	*  */
	')',	/* K_LANG38	164	(  */
	'=',	/* K_LANG39	165	)  */
	'?',	/* K_LANG40	166	_  */
	'+',	/* K_LANG12	167	-  */
	R_FQUOTE, /* K_LANG41	168	+  */
	R_BQUOTE,/* K_LANG13	169	=  */
	'Y',	/* K_LANG51	170	Y  */
	'y',	/* K_LANG23	171	y  */
	R_A_DOT, /* K_LANG42	172	{  */
	R_a_DOT, /* K_LANG14	173	[  */
	'^',	/* K_LANG43	174	}  */
	R_DDOT,	/* K_LANG15	175	]  */
	R_ZERO,	/* K_LANG44	176	:  */
	R_zero,	/* K_LANG16	177	;  */
	R_AE,	/* K_LANG45	178	"  */
	R_ae,	/* K_LANG17	179	'  */
	'Z',	/* K_LANG54	180	Z  */
	'z',	/* K_LANG26	181	z  */
	';',	/* K_LANG46	182	<  */
	':',	/* K_LANG47	183	>  */
	'_',	/* K_LANG48	184	?  */
	'-',	/* K_LANG20	185	/  */
	'#',	/* K_LANG32	186	#  */
	'Q',	/* K_LANG49	187	Q  */
	'q',	/* K_LANG21	188	q  */
	'W',	/* K_LANG50	189	W  */
	'w',	/* K_LANG22	190	w  */
	'A',	/* K_LANG52	191	A  */
	'a',	/* K_LANG24	192	a  */
	'<',	/* K_LANG0	193	`  */
	'@',	/* K_LANG1	194	\  */
	'1', '2', '3', '4', '5', '6', '7', '8', '9', '0',
	',',	/* K_LANG18	205	,  */
	'.',	/* K_LANG19	206	.  */
	'm',	/* K_LANG25	207	m  */
	'>',	/* K_LANG27	208	~  */
	'*',	/* K_LANG28	209	|  */
	'!',	/* K_LANG30	210	!  */
	'$',	/* K_LANG33	211	$  */
	'%',	/* K_LANG34	212	%  */
	'M',	/* K_LANG53	213	M  */
};

/* (13) HP ITF European Spanish */
unsigned char k_spain[] = {
	/* 160-213 */
	'"',	/* K_LANG31	160	@  */
	'&',	/* K_LANG35	161	^  */
	'/',	/* K_LANG36	162	&  */
	'(',	/* K_LANG37	163	*  */
	')',	/* K_LANG38	164	(  */
	'=',	/* K_LANG39	165	)  */
	'?',	/* K_LANG40	166	_  */
	39,	/* K_LANG12	167	-  */
	R_i,	/* K_LANG41	168	+  */
	'`',	/* K_LANG13	169	=  */
	'Y',	/* K_LANG51	170	Y  */
	'y',	/* K_LANG23	171	y  */
	'#',	/* K_LANG42	172	{  */
	'@',	/* K_LANG14	173	[  */
	'*',	/* K_LANG43	174	}  */
	'+',	/* K_LANG15	175	]  */
	R_N_TILTA, /* K_LANG44	176	:  */
	R_n_TILTA, /* K_LANG16	177	;  */
	R_DDOT,	/* K_LANG45	178	"  */
	R_BQUOTE, /* K_LANG17	179	'  */
	'Z',	/* K_LANG54	180	Z  */
	'z',	/* K_LANG26	181	z  */
	';',	/* K_LANG46	182	<  */
	':',	/* K_LANG47	183	>  */
	'_',	/* K_LANG48	184	?  */
	'-',	/* K_LANG20	185	/  */
	R_UQUES, /* K_LANG32	186	#  */
	'Q',	/* K_LANG49	187	Q  */
	'q',	/* K_LANG21	188	q  */
	'W',	/* K_LANG50	189	W  */
	'w',	/* K_LANG22	190	w  */
	'A',	/* K_LANG52	191	A  */
	'a',	/* K_LANG24	192	a  */
	'<',	/* K_LANG0	193	`  */
	R_c_BEARD, /* K_LANG1	194	\  */
	'1', '2', '3', '4', '5', '6', '7', '8', '9', '0',
	',',	/* K_LANG18	205	,  */
	'.',	/* K_LANG19	206	.  */
	'm',	/* K_LANG25	207	m  */
	'>',	/* K_LANG27	208	~  */
	R_DEGREE, /* K_LANG28	209	|  */
	'!',	/* K_LANG30	210	!  */
	'$',	/* K_LANG33	211	$  */
	'%',	/* K_LANG34	212	%  */
	'M',	/* K_LANG53	213	M  */
};

/* (14) HP ITF Latin Spanish */
unsigned char k_latinam[] = {
	/* 160-213 */
	'@',	/* K_LANG31	160	@  */
	'^',	/* K_LANG35	161	^  */
	'&',	/* K_LANG36	162	&  */
	'*',	/* K_LANG37	163	*  */
	'(',	/* K_LANG38	164	(  */
	')',	/* K_LANG39	165	)  */
	'_',	/* K_LANG40	166	_  */
	'-',	/* K_LANG12	167	-  */
	'+',	/* K_LANG41	168	+  */
	'=',	/* K_LANG13	169	=  */
	'Y',	/* K_LANG51	170	Y  */
	'y',	/* K_LANG23	171	y  */
	R_DDOT,	/* K_LANG42	172	{  */
	R_BQUOTE, /* K_LANG14	173	[  */
	'"',	/* K_LANG43	174	}  */
	39,	/* K_LANG15	175	]  */
	R_N_TILTA, /* K_LANG44	176	:  */
	R_n_TILTA, /* K_LANG16	177	;  */
	':',	/* K_LANG45	178	"  */
	';',	/* K_LANG17	179	'  */
	'Z',	/* K_LANG54	180	Z  */
	'z',	/* K_LANG26	181	z  */
	'<',	/* K_LANG46	182	<  */
	'>',	/* K_LANG47	183	>  */
	'?',	/* K_LANG48	184	?  */
	'/',	/* K_LANG20	185	/  */
	'#',	/* K_LANG32	186	#  */
	'Q',	/* K_LANG49	187	Q  */
	'q',	/* K_LANG21	188	q  */
	'W',	/* K_LANG50	189	W  */
	'w',	/* K_LANG22	190	w  */
	'A',	/* K_LANG52	191	A  */
	'a',	/* K_LANG24	192	a  */
	'`',	/* K_LANG0	193	`  */
	R_UQUES, /* K_LANG1	194	\  */
	'1', '2', '3', '4', '5', '6', '7', '8', '9', '0',
	',',	/* K_LANG18	205	,  */
	'.',	/* K_LANG19	206	.  */
	'm',	/* K_LANG25	207	m  */
	R_c_BEARD, /* K_LANG27	208	~  */
	R_i,	/* K_LANG28	209	|  */
	'!',	/* K_LANG30	210	!  */
	'$',	/* K_LANG33	211	$  */
	'%',	/* K_LANG34	212	%  */
	'M',	/* K_LANG53	213	M  */
};

/* (16) HP ITF United Kingdom */
unsigned char k_uk[] = {
	/* 160-213 */
	'"',	/* K_LANG31	160	@  */
	'&',	/* K_LANG35	161	^  */
	'^',	/* K_LANG36	162	&  */
	'(',	/* K_LANG37	163	*  */
	')',	/* K_LANG38	164	(  */
	'=',	/* K_LANG39	165	)  */
	'?',	/* K_LANG40	166	_  */
	'+',	/* K_LANG12	167	-  */
	'/',	/* K_LANG41	168	+  */
	39,	/* K_LANG13	169	=  */
	'Y',	/* K_LANG51	170	Y  */
	'y',	/* K_LANG23	171	y  */
	'\{',	/* K_LANG42	172	{  */
	'[',	/* K_LANG14	173	[  */
	'\}',	/* K_LANG43	174	}  */
	']',	/* K_LANG15	175	]  */
	'@',	/* K_LANG44	176	:  */
	'*',	/* K_LANG16	177	;  */
	'|',	/* K_LANG45	178	"  */
	'\\',	/* K_LANG17	179	'  */
	'Z',	/* K_LANG54	180	Z  */
	'z',	/* K_LANG26	181	z  */
	';',	/* K_LANG46	182	<  */
	':',	/* K_LANG47	183	>  */
	'_',	/* K_LANG48	184	?  */
	'-',	/* K_LANG20	185	/  */
	R_SPOUND, /* K_LANG32	186	#  */
	'Q',	/* K_LANG49	187	Q  */
	'q',	/* K_LANG21	188	q  */
	'W',	/* K_LANG50	189	W  */
	'w',	/* K_LANG22	190	w  */
	'A',	/* K_LANG52	191	A  */
	'a',	/* K_LANG24	192	a  */
	'`',	/* K_LANG0	193	`  */
	'<',	/* K_LANG1	194	\  */
	'1', '2', '3', '4', '5', '6', '7', '8', '9', '0',
	',',	/* K_LANG18	205	,  */
	'.',	/* K_LANG19	206	.  */
	'm',	/* K_LANG25	207	m  */
	'~',	/* K_LANG27	208	~  */
	'>',	/* K_LANG28	209	|  */
	'!',	/* K_LANG30	210	!  */
	'$',	/* K_LANG33	211	$  */
	'%',	/* K_LANG34	212	%  */
	'M',	/* K_LANG53	213	M  */
};

/* (18) HP ITF Swiss French II */
unsigned char k_swissf2[] = {
	/* 160-213 */
	'"',	/* K_LANG31	160	@  */
	'&',	/* K_LANG35	161	^  */
	'/',	/* K_LANG36	162	&  */
	'(',	/* K_LANG37	163	*  */
	')',	/* K_LANG38	164	(  */
	'=',	/* K_LANG39	165	)  */
	'?',	/* K_LANG40	166	_  */
	96,	/* K_LANG12	167	-  */
	R_FQUOTE, /* K_LANG41	168	+  */
	R_HAT,	/* K_LANG13	169	=  */
	'Z',	/* K_LANG51	170	Y  */
	'z',	/* K_LANG23	171	y  */
	R_u_DDOT, /* K_LANG42	172	{  */
	R_e_FQUOTE, /* K_LANG14	173	[  */
	'!',	/* K_LANG43	174	}  */
	R_DDOT,	/* K_LANG15	175	]  */
	R_o_DDOT, /* K_LANG44	176	:  */
	R_e_BQUOTE, /* K_LANG16	177	;  */
	R_a_DDOT, /* K_LANG45	178	"  */
	R_a_FQUOTE, /* K_LANG17	179	'  */
	'Y',	/* K_LANG54	180	Z  */
	'y',	/* K_LANG26	181	z  */
	';',	/* K_LANG46	182	<  */
	':',	/* K_LANG47	183	>  */
	'_',	/* K_LANG48	184	?  */
	'-',	/* K_LANG20	185	/  */
	'*',	/* K_LANG32	186	#  */
	'Q',	/* K_LANG49	187	Q  */
	'q',	/* K_LANG21	188	q  */
	'W',	/* K_LANG50	189	W  */
	'w',	/* K_LANG22	190	w  */
	'A',	/* K_LANG52	191	A  */
	'a',	/* K_LANG24	192	a  */
	R_SO,	/* K_LANG0	193	`  */
	'$',	/* K_LANG1	194	\  */
	'1', '2', '3', '4', '5', '6', '7', '8', '9', '0',
	',',	/* K_LANG18	205	,  */
	'.',	/* K_LANG19	206	.  */
	'm',	/* K_LANG25	207	m  */
	R_DEGREE, /* K_LANG27	208	~  */
	R_SPOUND, /* K_LANG28	209	|  */
	'+',	/* K_LANG30	210	!  */
	R_c_BEARD, /* K_LANG33	211	$  */
	'%',	/* K_LANG34	212	%  */
	'M',	/* K_LANG53	213	M  */
};

/* (19) HP ITF Swiss German II */
unsigned char k_swissg2[] = {
	/* 160-213 */
	'"',	/* K_LANG31	160	@  */
	'&',	/* K_LANG35	161	^  */
	'/',	/* K_LANG36	162	&  */
	'(',	/* K_LANG37	163	*  */
	')',	/* K_LANG38	164	(  */
	'=',	/* K_LANG39	165	)  */
	'?',	/* K_LANG40	166	_  */
	96,	/* K_LANG12	167	-  */
	R_FQUOTE, /* K_LANG41	168	+  */
	R_HAT,	/* K_LANG13	169	=  */
	'Z',	/* K_LANG51	170	Y  */
	'z',	/* K_LANG23	171	y  */
	R_e_FQUOTE, /* K_LANG42	172	{  */
	R_u_DDOT, /* K_LANG14	173	[  */
	'!',	/* K_LANG43	174	}  */
	R_DDOT,	/* K_LANG15	175	]  */
	R_e_BQUOTE, /* K_LANG44	176	:  */
	R_o_DDOT, /* K_LANG16	177	;  */
	R_a_FQUOTE, /* K_LANG45	178	"  */
	R_a_DDOT, /* K_LANG17	179	'  */
	'Y',	/* K_LANG54	180	Z  */
	'y',	/* K_LANG26	181	z  */
	';',	/* K_LANG46	182	<  */
	':',	/* K_LANG47	183	>  */
	'_',	/* K_LANG48	184	?  */
	'-',	/* K_LANG20	185	/  */
	'*',	/* K_LANG32	186	#  */
	'Q',	/* K_LANG49	187	Q  */
	'q',	/* K_LANG21	188	q  */
	'W',	/* K_LANG50	189	W  */
	'w',	/* K_LANG22	190	w  */
	'A',	/* K_LANG52	191	A  */
	'a',	/* K_LANG24	192	a  */
	R_SO,	/* K_LANG0	193	`  */
	'$',	/* K_LANG1	194	\  */
	'1', '2', '3', '4', '5', '6', '7', '8', '9', '0',
	',',	/* K_LANG18	205	,  */
	'.',	/* K_LANG19	206	.  */
	'm',	/* K_LANG25	207	m  */
	R_DEGREE, /* K_LANG27	208	~  */
	R_SPOUND, /* K_LANG28	209	|  */
	'+',	/* K_LANG30	210	!  */
	R_c_BEARD, /* K_LANG33	211	$  */
	'%',	/* K_LANG34	212	%  */
	'M',	/* K_LANG53	213	M  */
};


unsigned char * k_isotab[] = {
	k_isus,  /* (0) HP ITF United States */
	k_isfr,  /* (1) HP ITF Belgian */
	k_iscn,  /* (2) HP ITF Canadian English */
	k_isdn,  /* (3) HP ITF Danish */
	k_isdu,  /* (4) HP ITF Dutch */
	k_issw,  /* (5) HP ITF Finnish */
	k_isfr,  /* (6) HP ITF French (AZERTY) */
	k_iscn,  /* (7) HP ITF Canadian French */
	k_isss,  /* (8) HP ITF Swiss French */
	k_isgm,  /* (9) HP ITF German */
	k_isss,  /* (10) HP ITF Swiss German */
	k_isit,  /* (11) HP ITF Italian */
	k_isnw,  /* (12) HP ITF Norwegian */
	k_ises,  /* (13) HP ITF European Spanish */
	k_isls,  /* (14) HP ITF Latin Spanish */
	k_issw,  /* (15) HP ITF Swedish */
	k_isuk,  /* (16) HP ITF United Kingdom */
	k_isus,  /* (17) HP ITF Katakana */
	k_isss2, /* (18) HP ITF Swiss French II */
	k_isss2, /* (19) HP ITF Swiss German II */
	k_isus,  /* (20) HP ITF Kanji */
};

unsigned char k_isus[] = {
	35, 39, 60, 62, 64, 91, 92, 93,
	94, 96, 123, 124, 125, 126
};
unsigned char k_isfr[] = {
	R_SPOUND, 39, 60, 62, R_a_FQUOTE, R_DEGREE, R_c_BEARD, R_SO,
	R_HAT, 96, R_e_BQUOTE, R_u_FQUOTE, R_e_FQUOTE, R_DDOT
};
unsigned char k_isgm[] = {
	R_SPOUND, 39, 60, 62, R_SO, R_A_DDOT, R_O_DDOT, R_U_DDOT,
	94, 96, R_a_DDOT, R_o_DDOT, R_u_DDOT, R_BETA
};
unsigned char k_issw[] = {
	35, 39, 60, 62, R_E_BQUOTE, R_A_DDOT, R_O_DDOT, R_A_DOT,
	R_U_DDOT, R_e_BQUOTE, R_a_DDOT, R_o_DDOT, R_a_DOT, R_u_DDOT
};
unsigned char k_iscn[] = {
	35, 39, 60, 62, 64, 91, R_c_BEARD, 93,
	R_HAT, R_FQUOTE, R_e_BQUOTE, R_C_BEARD, R_E_BQUOTE, R_DDOT
};
unsigned char k_isdn[] = {
	R_SO, R_BQUOTE, 60, 62, 64, R_AE, R_ZERO, R_A_DOT,
	94, R_FQUOTE, R_ae, R_zero, R_a_DOT, R_DDOT
};
unsigned char k_isdu[] = {
	35, 39, 60, 62, 64, R_c_BEARD, 92, R_SO,
	R_HAT, R_FQUOTE, R_F, 124, R_BQUOTE, R_DDOT
};
unsigned char k_isss[] = {
	R_SPOUND, R_BQUOTE, R_e_BQUOTE, R_e_FQUOTE, R_a_FQUOTE, R_DEGREE, 
	R_c_BEARD, R_SO,
	R_HAT, R_FQUOTE, R_a_DDOT, R_o_DDOT, R_u_DDOT, R_DDOT
};
unsigned char k_isss2[] = {
	R_SPOUND, R_BQUOTE, R_e_BQUOTE, R_e_FQUOTE, R_a_FQUOTE, R_DEGREE, 
	R_c_BEARD, R_SO,
	R_HAT, 96, R_a_DDOT, R_o_DDOT, R_u_DDOT, R_DDOT
};
unsigned char k_isit[] = {
	R_SPOUND, 39, 60, 62, R_SO, R_DEGREE, R_c_BEARD, R_e_BQUOTE,
	R_HAT, R_u_FQUOTE, R_a_FQUOTE, R_o_FQUOTE, R_e_FQUOTE, R_i_FQUOTE
};
unsigned char k_isnw[] = {
	35, R_BQUOTE, 60, 62, 64, R_AE, R_ZERO, R_A_DOT,
	94, R_FQUOTE, R_ae, R_zero, R_a_DOT, R_DDOT
};
unsigned char k_ises[] = {
	35, R_BQUOTE, 60, 62, 64, R_i, R_N_TILTA, R_UQUES,
	R_DEGREE, 96, 39, R_n_TILTA, R_c_BEARD, R_DDOT
};
unsigned char k_isls[] = {
	35, R_BQUOTE, 60, 62, 64, R_i, R_N_TILTA, R_UQUES,
	94, 96, 39, R_n_TILTA, R_c_BEARD, R_DDOT
};
unsigned char k_isuk[] = {
	R_SPOUND, 39, 60, 62, 64, 91, 92 ,93,
	94, 96, 123, 124, 125, 126
};

/* Language Jumper Conversion Table */
char klang_jump[] = {
    K_HP_USASCII, 		/* 0 */	/* HP ITF keyboards */
    K_HP_USASCII, 		/* 1 */
    K_HP_KANJI, 		/* 2 */
    K_HP_SWISSFRENCH, 		/* 3 */
    K_HP_USASCII, 		/* 4 */
    K_HP_USASCII, 		/* 5 */
    K_HP_USASCII, 		/* 6 */
    K_HP_CANENG, 		/* 7 */
    K_HP_USASCII, 		/* 8 */
    K_HP_USASCII, 		/* 9 */
    K_HP_USASCII, 		/* 10 */
    K_HP_ITALIAN, 		/* 11 */
    K_HP_USASCII, 		/* 12 */
    K_HP_DUTCH, 		/* 13 */
    K_HP_SWEDISH, 		/* 14 */
    K_HP_GERMAN, 		/* 15 */
    K_HP_USASCII, 		/* 16 */
    K_HP_USASCII, 		/* 17 */
    K_HP_SWISSFRENCH2, 		/* 18 */
    K_HP_EUROSPANISH, 		/* 19 */
    K_HP_SWISSGERMAN2, 		/* 20 */
    K_HP_BELGIAN, 		/* 21 */
    K_HP_FINNISH, 		/* 22 */
    K_HP_UNITEDK, 		/* 23 */
    K_HP_CANFRENCH, 		/* 24 */
    K_HP_SWISSGERMAN, 		/* 25 */
    K_HP_NORWEGIAN, 		/* 26 */
    K_HP_FRENCH, 		/* 27 */
    K_HP_DANISH, 		/* 28 */
    K_HP_KATAKANA, 		/* 29 */
    K_HP_LATSPANISH, 		/* 30 */
    K_HP_USASCII, 		/* 31 */
};
