/*
 *	$Source: /u1/Xr/src/Xrlib/Editor/RCS/gcUtil.c,v $
 *	$Header: gcUtil.c,v 1.1 86/12/17 09:06:39 swick Exp $
 */

#ifndef lint
static char *rcsid_gcUtil_c = "$Header: gcUtil.c,v 1.1 86/12/17 09:06:39 swick Exp $";
#endif	lint


#include <Xr/xr-copyright.h>

/* $Header: gcUtil.c,v 1.1 86/12/17 09:06:39 swick Exp $ */
/* Copyright 1986, Hewlett-Packard Company */
/* Copyright 1986, Massachussetts Institute of Technology */

static char rcsid[] = "$Header: gcUtil.c,v 1.1 86/12/17 09:06:39 swick Exp $";
/*************************************<+>*************************************
 *****************************************************************************
 **
 **   File:        gcUtil.c
 **
 **   Project:     X-ray Toolbox
 **
 **   Description: 
 **         This file contains all of the graphics context manipulation
 **         routines.  These allow an application to copy and update
 **         a graphics context.  In addition, another routine is
 **         provided, which almost every field editor will use: it sets
 **         up two graphics context structures, using the editor instance's
 **         foreground and background colors.  Most of the values which
 **         may be placed in a graphics context are just simple integer
 **         values, such as the colors, font id, tile id and line width.
 **         However, two fields, the fill style and replacement rule,
 **         should be set using the defines provide by X; refer to the
 **         section of the X documentation dealing with graphics
 **         operations for a complete list of these defines.
 **
 **
 **   ------------------------ MODIFICATION RECORD   ------------------------
 *
 * $Log:	gcUtil.c,v $
 * Revision 1.1  86/12/17  09:06:39  swick
 * Initial revision
 * 
 * Revision 7.0  86/11/13  08:30:14  08:30:14  fred ()
 * Final QA Release
 * 
 * Revision 6.0  86/11/10  15:38:46  15:38:46  fred ()
 * QA #2 release
 * 
 * Revision 5.1  86/11/07  14:26:22  14:26:22  fred ()
 * Added new copyright message.
 * 
 * Revision 5.0  86/10/28  08:40:29  08:40:29  fred ()
 * QA #1.1 release
 * 
 * Revision 4.0  86/10/20  12:16:15  12:16:15  fred ()
 * QA #1 release
 * 
 * Revision 3.1  86/10/16  09:24:00  09:24:00  fred ()
 * Performance enhanced: added use of register variables.
 * 
 * Revision 3.0  86/10/02  16:04:53  16:04:53  fred ()
 * Alpha release set to 3.0
 * 
 * Revision 2.3  86/09/19  07:14:50  07:14:50  fred ()
 * Enlarged graphics context changeList structure.
 * 
 * Revision 2.2  86/09/17  06:37:23  06:37:23  fred ()
 * Upgraded the file header, to point the user to the X documentation.
 * 
 * Revision 2.1  86/09/16  12:50:32  12:50:32  fred ()
 * Filled in procedure headers.
 * 
 * Revision 2.0  86/09/16  08:15:57  08:15:57  fred ()
 * No change; upgraded to revision 2.0 to match other source.
 * 
 * Revision 1.1  86/09/03  13:59:48  13:59:48  fred ()
 * Initial revision
 * 
 *
 *****************************************************************************
 *************************************<+>*************************************/



#include <X/Xlib.h>
#include <Xr/defs.h>
#include <Xr/types.h>



/*************************************<->*************************************
 *
 *  _XrChangeGC (GC, changeMask, changeList)
 *
 *     INT32   GC;
 *     UINT32  changeMask;
 *     INT32 * changeList;
 *
 *   Description:
 *   -----------
 *     This routine allows an application to selectively modify fields
 *     within a particular graphics context.  The fields to be modified
 *     are specified by the bitmask parameter 'changeMask', while the
 *     values to be placed in the structure are contained in the array
 *     pointed to by the 'changeList' parameter.  A series of defines
 *     are provided in the include file 'Xr/defs.h', which can be used
 *     to built the bitmask, and also to fill the proper locations
 *     within the changeList array.  For all entries, the define
 *     'Xr---' is used to construct the bitmask, while the define
 *     'Xr---VAL' is used to index into the array.
 *
 *
 *   Inputs:
 *   ------
 *     GC = This is the index of the graphics context which is to be 
 *          modified.
 *
 *     changeMask = This is a bitmask, composed by OR'ing together the
 *                  defines which describe the field to be changed.
 *
 *     changeList = This is an array of values, which are to be added
 *                  into the specified graphics context.
 * 
 *   Outputs:
 *   -------
 *     The specified graphics context will be modified.
 *
 *   Procedures Called
 *   -----------------
 *
 *************************************<->***********************************/

_XrChangeGC (GC, changeMask, changeList)

   register INT32    GC;
   register UINT32   changeMask;
   register INT32  * changeList;

{
   register int i;

   i = 0;
   while (changeMask)
   {
      if (changeMask & 1)
         xr_GCList[GC][i] = changeList[i];
      i++;
      changeMask>>=1;
   }
}


/*************************************<->*************************************
 *
 *  _XrCopyGC (srcGC, dstGC)
 *
 *     INT32 srcGC;
 *     INT32 dstGC;
 *
 *   Description:
 *   -----------
 *     This routine will copy the contents of the source graphics
 *     context, whose index is specified by the 'srcGC' parameter,
 *     into the destination graphics context, whose index is
 *     specified by the 'dstGC' parameter.
 *
 *
 *   Inputs:
 *   ------
 *     srcGC = The index of the source graphics context: xrEditorGCx
 *
 *     dstGC = The index of the destination graphics context: xrEditorGCx
 * 
 *   Outputs:
 *   -------
 *     The specified destination graphics context will contain the same
 *     values as the source graphics context.
 *
 *   Procedures Called
 *   -----------------
 *
 *************************************<->***********************************/

_XrCopyGC (srcGC, dstGC)
INT32 srcGC;
INT32 dstGC;

{
   _Xrmemcpy ((char *) xr_GCList[dstGC], (char *) xr_GCList[srcGC], 84);
}


/*************************************<->*************************************
 *
 *  _XrInitEditorGCs (foreColor, backColor, fontId)
 *
 *     INT32 foreColor;
 *     INT32 backColor;
 *     Font  fontId;
 *
 *   Description:
 *   -----------
 *     This routine initializes two graphics contexts for a field editor.
 *     The first graphics context (xrEditorGC2) will be set as follows:
 * 
 *       foreground color = 'foreColor' parameter.
 *       background color = 'backColor' parameter.
 *       
 *     The second graphics context (xrEditorGC2) will be set as follows:
 *
 *       foreground color = 'backColor' parameter.
 *       background color = 'foreColor' parameter.
 *
 *     If the 'fontId' parameter is not set to '-1', then the
 *     font field in both graphics contexts will be set to this Id.
 *     All other fields in both graphics contexts will be set to their
 *     default value, as specified in the X-ray documentation.
 *
 *
 *   Inputs:
 *   ------
 *     foreColor = The field editor's foreground color.
 *
 *     backColor = The field editor's background color.
 *
 *     fontId = A valid X font Id; -1, if not to be used.
 * 
 *   Outputs:
 *   -------
 *     The graphics contexts specified by xrEditorGC1 and xrEditorGC2
 *     will be set as described above.
 *
 *   Procedures Called
 *   -----------------
 *   _XrCopyGC()  
 *   _XrChangeGC()
 *
 *************************************<->***********************************/

_XrInitEditorGCs (foreColor, backColor, fontId)

   INT32      foreColor;
   INT32      backColor;
   Font       fontId;

{
   INT32 changeList[21];
   INT32 changeMask;

   /* Initialize the two graphics contexts normally used by editors */
   _XrCopyGC (xrDefaultGC, xrEditorGC1);
   _XrCopyGC (xrDefaultGC, xrEditorGC2);

   /* Set FG/BG combination for the first graphics context */
   changeList[XrFOREGROUNDVAL] = foreColor;
   changeList[XrBACKGROUNDVAL] = backColor;
   changeMask = (XrFOREGROUND | XrBACKGROUND);

   if (fontId >= 0)
   {
      changeList[XrFONTVAL] = fontId;
      changeMask |= XrFONT;
   }

   _XrChangeGC (xrEditorGC1, changeMask, changeList);

   /* Set BG/FG combination for the second graphics context */
   changeList[XrFOREGROUNDVAL] = backColor;
   changeList[XrBACKGROUNDVAL] = foreColor;
   _XrChangeGC (xrEditorGC2, changeMask, changeList);
}


