/*
 *	$Source: /u1/Xr/src/Xrlib/Editor/RCS/ellipUtil.c,v $
 *	$Header: ellipUtil.c,v 1.1 86/12/17 09:06:31 swick Exp $
 */

#ifndef lint
static char *rcsid_ellipUtil_c = "$Header: ellipUtil.c,v 1.1 86/12/17 09:06:31 swick Exp $";
#endif	lint


#include <Xr/xr-copyright.h>

/* $Header: ellipUtil.c,v 1.1 86/12/17 09:06:31 swick Exp $ */
/* Copyright 1986, Hewlett-Packard Company */
/* Copyright 1986, Massachussetts Institute of Technology */

static char rcsid[] = "$Header: ellipUtil.c,v 1.1 86/12/17 09:06:31 swick Exp $";
/*************************************<+>*************************************
 *****************************************************************************
 **
 **   File:        ellipUtil.c
 **
 **   Project:     X-ray Toolbox
 **
 **   Description: 
 **         This file contains several utility routines which may be
 **         used by field editors to draw a variety of elliptical
 **         shapes, including bordered or filled ellipses.  These
 **         routines all use a graphics context structure to obtain
 **         the drawing environment.
 **
 **
 **   ------------------------ MODIFICATION RECORD   ------------------------
 *
 * $Log:	ellipUtil.c,v $
 * Revision 1.1  86/12/17  09:06:31  swick
 * Initial revision
 * 
 * Revision 7.0  86/11/13  08:30:04  08:30:04  fred ()
 * Final QA Release
 * 
 * Revision 6.0  86/11/10  15:38:36  15:38:36  fred ()
 * QA #2 release
 * 
 * Revision 5.1  86/11/07  14:25:58  14:25:58  fred ()
 * Added new copyright message.
 * 
 * Revision 5.0  86/10/28  08:40:21  08:40:21  fred ()
 * QA #1.1 release
 * 
 * Revision 4.0  86/10/20  12:16:05  12:16:05  fred ()
 * QA #1 release
 * 
 * Revision 3.1  86/10/16  09:23:53  09:23:53  fred ()
 * Performance enhanced: added use of register variables.
 * 
 * Revision 3.0  86/10/02  16:04:45  16:04:45  fred ()
 * Alpha release set to 3.0
 * 
 * Revision 2.1  86/09/16  11:50:37  11:50:37  fred ()
 * Filled in procedure headers.
 * 
 * Revision 2.0  86/09/16  08:15:20  08:15:20  fred ()
 * No change; upgraded to revision 2.0 to match other source.
 * 
 * Revision 1.1  86/09/04  06:43:32  06:43:32  fred ()
 * Initial revision
 * 
 * 
 *
 *****************************************************************************
 *************************************<+>*************************************/



#include <X/Xlib.h>
#include <Xr/defs.h>
#include <Xr/types.h>


static Vertex ellipseList [5] =
   { {0, 0, VertexCurved | VertexStartClosed},
     {0, 0, VertexCurved},
     {0, 0, VertexCurved},
     {0, 0, VertexCurved},
     {0, 0, VertexCurved | VertexEndClosed} };




/*************************************<->*************************************
 *
 *  _XrEllipse (windowId, GC, drawRect)
 *
 *     Window      windowId;
 *     INT32       GC;
 *     RECTANGLE * drawRect;
 *
 *   Description:
 *   -----------
 *     This routine will draw the outline of the ellipse which fits 
 *     within the rectangular region defined by the 'drawRect' parameter.
 *     The drawing environment is obtained from the graphics context
 *     indicated by the 'GC' parameter.  The foreground color specified
 *     in the graphics context is used to draw the outline.
 *
 *
 *   Inputs:
 *   ------
 *     windowId = This is the window Id for the window in which the
 *                ellipse is to be drawn.
 *
 *     GC = This is the index of the graphics context which contains the
 *          drawing environment.  The fields which are used are:
 *
 *             XrLINEWIDTHVAL  = width of the ellipse border.
 *             XrFOREGROUNDVAL = color to draw the ellipse with.
 *             XrALUVAL        = replacement rule to use.
 *
 *     drawRect = This defines the rectangular region into which the
 *                ellipse is to be fitted.
 * 
 *   Outputs:
 *   -------
 *
 *   Procedures Called
 *   -----------------
 *   XDraw()  [libX.a]
 *
 *************************************<->***********************************/

_XrEllipse (windowId, GC, drawRect)

            Window      windowId;
   register INT32       GC;
   register RECTANGLE * drawRect;

{
   INT32 widthHalf;
   INT32 heightHalf;

   widthHalf = ((UINT16) drawRect->width >> 1);
   heightHalf = ((UINT16) drawRect->height >> 1);

   ellipseList[0].x = drawRect->x + widthHalf;
   ellipseList[0].y = drawRect->y;
   ellipseList[1].x = drawRect->x + drawRect->width - 1;
   ellipseList[1].y = drawRect->y + heightHalf;
   ellipseList[2].x = drawRect->x + widthHalf;
   ellipseList[2].y = drawRect->y + drawRect->height - 1;
   ellipseList[3].x = drawRect->x;
   ellipseList[3].y = drawRect->y + heightHalf;
   ellipseList[4].x = drawRect->x + widthHalf;
   ellipseList[4].y = drawRect->y;

   XDraw (windowId, ellipseList, 5, 
          xr_GCList[GC][XrLINEWIDTHVAL], xr_GCList[GC][XrLINEWIDTHVAL],
          xr_GCList[GC][XrFOREGROUNDVAL], xr_GCList[GC][XrALUVAL], AllPlanes);

}


/*************************************<->*************************************
 *
 *  _XrFillEllipse (windowId, GC, drawRect)
 *
 *     Window      windowId;
 *     INT32       GC;
 *     RECTANGLE * drawRect;
 *
 *   Description:
 *   -----------
 *     This routine draws a filled ellipse, which fits within the rectangle
 *     defined by the 'drawRect' parameter.  The drawing environment is
 *     obtained from the specified graphics context structure.  The
 *     types of filling used are: Tiled and Solid.
 *
 *
 *   Inputs:
 *   ------
 *     windowId = Window Id of window in which ellipse is to be drawn.
 *
 *     GC = This is the index of the graphics context which contains
 *          the drawing environment to be used when drawing the ellipse.
 *          The fields of importance are:
 *
 *          XrFILLSTYLEVAL  = Type of filling to use (Tiled or Solid).
 *          XrFOREGROUNDVAL = Used to fill ellipse, if solid fill.
 *          XrALUVAL        = Replacement rule.
 *          XrTILEVAL       = Used to fill ellipse, if tile fill.
 *
 *     drawRect = The ellipse to be drawn is defined such that it will
 *                fit completely within this rectangle.
 * 
 *   Outputs:
 *   -------
 *
 *   Procedures Called
 *   -----------------
 *   XDrawFilled()  [libX.a]
 *   XDrawTiled()   [libX.a]
 *
 *************************************<->***********************************/

_XrFillEllipse (windowId, GC, drawRect)

            Window      windowId;
   register INT32       GC;
   register RECTANGLE * drawRect;

{
   INT32 widthHalf;
   INT32 heightHalf;

   widthHalf = ((UINT16) drawRect->width >> 1);
   heightHalf = ((UINT16) drawRect->height >> 1);

   ellipseList[0].x = drawRect->x + widthHalf;
   ellipseList[0].y = drawRect->y;
   ellipseList[1].x = drawRect->x + drawRect->width - 1;
   ellipseList[1].y = drawRect->y + heightHalf;
   ellipseList[2].x = drawRect->x + widthHalf;
   ellipseList[2].y = drawRect->y + drawRect->height - 1;
   ellipseList[3].x = drawRect->x;
   ellipseList[3].y = drawRect->y + heightHalf;
   ellipseList[4].x = drawRect->x + widthHalf;
   ellipseList[4].y = drawRect->y;

   if (xr_GCList[GC][XrFILLSTYLEVAL] == Solid)
      XDrawFilled (windowId, ellipseList, 5, xr_GCList[GC][XrFOREGROUNDVAL],
                   xr_GCList[GC][XrALUVAL], AllPlanes);
   else if (xr_GCList[GC][XrFILLSTYLEVAL] == Tiled)
      XDrawTiled (windowId, ellipseList, 5, xr_GCList[GC][XrTILEVAL],
                  xr_GCList[GC][XrALUVAL], AllPlanes);
}



