.TL
DEC X Toolkit
.LP
.bp
.ce 4
COPYRIGHT 1986
DIGITAL EQUIPMENT CORPORATION
MAYNARD, MASSACHUSETTS
ALL RIGHTS RESERVED.
.LP
THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE 
AND SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.
DIGITAL MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE ACCOMPANYING 
SOFTWARE FOR ANY PURPOSE.  
IT IS SUPPLIED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
.LP
IF THE SOFTWARE IS MODIFIED IN A MANNER CREATING DERIVATIVE COPYRIGHT RIGHTS,
APPROPRIATE LEGENDS MAY BE PLACED ON THE DERIVATIVE WORK IN ADDITION TO THAT
SET FORTH ABOVE.
.LP
Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted, provided
that the above copyright notice appear in all copies and that both that
copyright notice and this permission notice appear in supporting documentation,
and that the name of Digital Equipment Corporation not be used in advertising
or publicity pertaining to distribution of the software without specific, 
written prior permission.
.bp
.\".U7
.\".UT Overview 1
.ds XT DEC X Toolkit
.ds CF PRE-RELEASE DRAFT
.so preface.ms
.nr % -1
.bp
.NH 1
Introduction
.LP
This chapter provides an introduction of the \*(XT (User Interface Library).  
This chapter discusses:
.IP \(bu 5
Terminology
.IP \(bu 5
Overview of the \*(XT
.IP \(bu 5
User interface design considerations
.IP \(bu 5
Programming considerations
.NH 2
Terminology
.LP
.IP Object 1i
A software data abstraction consisting of private data and private and public 
routines that operate on the private data.  Users of the abstraction can interact
with the object only through calls to the object's public routines.
.IP Tool 1i
An object providing a user-interface abstraction (for example, a scroll-bar tool).
.IP \*(XT 1i
Name used for the user-interface library that is the subject of this document.
.IP User 1i
Person interacting with a workstation.
.IP Application 1i
.br
.ns
.IP Programmer 1i
A programmer that uses the \*(XT to produce the application user interface.
.IP Object 1i
.br
.ns
.IP Programmer 1i
A programmer who chooses to modify the \*(XT or add new objects to it.
.NH 2
Overview of the \*(XT
.LP
The \*(XT is intended to simplify the usage of workstation
graphics technology for user interface purposes in the X window system
programming environment.  Besides assisting application programmers by 
providing commonly used user-interface tools, it is a goal to allow
programmers to readily modify existing tools or add their own new 
tools.  Applications using this library will have the added side-effect
of presenting similar user interfaces to workstation users.
.LP
The \*(XT has the following underlying principles:
.SH 3 
Every User-Interface Abstraction is an X Window
.LP
This allows normal Xlib window manipulation operations to be used without having to
create equivalent ones for the user-interface tools.  Because windows in X are
inexpensive, this strategy does not suffer in performance.
.SH 3 
Information Hiding
.LP
The data for every object (subwindow) is private to the object and is not
visible outside of the object.  All manipulation of the object is performed
by means of procedures that the object defines.  This allows construction of complex
systems as a collection of objects with the code determining the behavior 
being localized.
.SH 3
Clear Separation of Object Semantics and Layout Geometry
.LP
Objects are concerned with implementing specific user interface semantics; they
have minimal control over issues such as their size or placement relative to 
other objects.  Mechanics are provided for associating geometry managers with
objects.
.NH 2
The User Interface Library Model
.LP
In the X windowing system windows are organized hierarchically and maintained by the
X server.  Because each object is associated with one window, the window handles provided
by X serve as object handles seen by the application programmer.  This strategy allows
the application programmer to use X window procedures (for example, for moving or resizing a
window) to operate on the objects.
.SH 3
Object
.LP
An object instance normally consists of some private data, as well as some private and
public procedures to interact with the object.  Public procedures typically exist for creation and deletion of the object as well as for querying and setting the state of the 
object.  Frequently, tools (user interface objects) allow an application program to 
specify one or more application procedures to be called when a tool changes state in 
particular ways.
.LP
The implementer of a new tool class can choose to use other
objects to define the tool.  However, because of the object
orientation, it will be impossible to tell from the application
programmers' view if a tool either is "atomic" or is formed from other
tools.
.LP
The \*(XT will provide a mechanism for aggregation of objects
(such as a form).  The application will be very aware of the elements of the 
aggregation (in fact the application will have to
create the instances of these elements).  Each element will
behave just as if it were existing independently, with the
\*(XT using the user specifiable geometry manager to place and
size the elements of the aggregate.
.SH 3
Associative Table
.LP
The underlying structure in the \*(XT consists of an
associative/dispatch table. This table is central to the organization of the internals of the \*(XT.  When an instance of an
object is created, pointers to the object's private data structures and event handler are posted in the table. Then, when an X
event is passed to the \*(XT event dispatch routine, the
dispatch routine uses the window handle in the XEvent structure
as an entry in the associative table to determine the appropriate
event handler routine to be used.
.SH 3
Event Handling
.LP
The library provides an event dispatcher to support event handling.  In a typical use of
the \*(XT, an application program obtains events from X using the standard Xlib 
routines and immediately passes the events (blindly) to the \*(XT event dispatcher
routine for servicing.  The dispatcher obtains the appropriate event handler for the 
tool from the associative table, and invokes the handler with the event as an argument.
.LP
An application programmer can alternately preprocess an event
prior to invoking the \*(XT event dispatcher.  Likewise, events
that the dispatcher reports as unhandled can be postprocessed.
.SH 3
Geometry Management
.LP
For a tool to be included as part of a higher-level abstraction the size and placement
of the tool must be controllable by the higher-level abstraction.  Because tool handles
are X window handles, Xlib window configuration routines are sufficient to manipulate 
the tools size and placement.  The tool itself is notified of size changes made from
above by means of the resize event notification.
.LP
It is also necessary to provide a mechanism for a tool to request a change in its size
or placement (as a result of interaction with the user).  In order for this to work 
properly, the tool's parent can need to resize and/or reposition some of the tool's
children.  This case arises in a form which has a text input field which is allowed to
grow as the user types in more information than can be displayed.  The \*(XT provides
a geometry management registry mechanism that allows a window to register its
geometry management handler.  When a tool wishes to change its geometry, it uses the 
registry to obtain the geometry manager of its parent, and invokes the routine passing
it the nature of the change desired.
.LP
Some tools (for example, forms) need to allow the programmer to specify the layout algorithm
for the tools that comprise it.  The \*(XT allows the programmer to furnish a geometry
specification along with a geometry manager that interprets the specification.
.NH 2
Programming Considerations
.LP
Because there is a great deal of similarity in the usage of the 
various tools in the library, 
this section attempts to describe their common aspects.
.NH 3
Tool Creation Steps
.LP
In creating tools, certain steps are common to all lower level tools.  
Procedures from both the \*(XT and Xlib are used.  
From an application programmer's view, 
tool creation involves the following steps:
.IP 1. 5
Create argument data packet for tool creation.
.IP
The argument inputs to the tools are variable length and variable order.  Most arguments
are optional.  The arguments are taken and placed in an array of argument descriptors
that can be parsed by the tool creation routine.  The array is null terminated.
.IP 2. 5
Invoke the tool creation routine
.IP
This routine allocates an internal tool state structure, creates the window
(at an arbitrary location but of the appropriate minimum size) that the tool
runs in, binds the tool event handler to the tool window, and returns to the
caller the window ID of the tool.
.IP 3. 5
Configure the tool window
.IP
The application is expected, if necessary, to move the tool window to the 
specific desired location as well as to alter the size of the window. 
In the case of the tool that is part of a form, this step will likely be performed
by a formatter.
.IP 4. 5
Map the window
.IP
The tool window is mapped using the window ID returned by the creation routine.
In some cases (as in a form), this is accomplished when a parent
form window is mapped, and the tool subwindows are automatically mapped.
.IP 5. 5
Dispatch events
.IP
The application loops waiting for events from the server and dispatches them
using the \*(XT dispatcher routine.  This results in the appropriate event
handler being invoked to service the event.  
.LE
.LP
.NH 3
Tool Attributes
.LP
Most tool attributes have default values in the tool creation routines.  Therefore, the 
application programmer need only provide the minimum number of attributes.  
Alternatively, a programmer can tailor an object into a very specialized 
instance of that object.
.LP
Tools that notify applications of user actions all take a 'TAG' attribute, consisting of
an application-specific data element of an arbitrary type.  This TAG is passed by the 
tool to the application notification routine at notification time.  The TAG enables an
application to service multiple tool instances with the same notification routine.
.NH 3
\*(XT Routines
.LP
Once the tool has been created, routines are available to change tool attributes or
query tool attribute states.  Each tool has its own deletion routine that will delete the
tool window and any tool specific data structures.
.NH 3
Basic Tools
.LP
The basic tools represent the lowest level object in the \*(XT.  Generally, they 
consist of a single window containing some text, a pixmap, or other graphic object
constrained by well-defined semantics.  A given basic tool is seldom used alone.  It is
often combined with other instances of basic tools to create more complex objects such
as menus and forms.
.SH 3
Composite Tools
.LP
Composite tools are constructed by associating groups of basic tools (for example, command
buttons) with a geometry manager or formatter.  Some present a higher-level of 
abstraction to the application, while others expect the application to provide 
function pointers to be passed to the basic tools contained within.
.NH 3
Tool Usage Example
.LP
To clarify the interface discussed above, the following is a sample tool 
specification and a small sample program using it.  The
sample specification is a simplification of the Command Button
tool.
.SH 3
Tool Interface Data Structure 
.LP
.DS 0
/* Data structure and Macro for Creating Attribute List */

typedef struct _Targ {
	int name;
        caddr_t data;
} Targ;

#define TSetArg(arg, n, d) \\\\
	( (arg).name = (n), \\\\
	(arg).data = (caddr_t)(d) )
.DE
.NH 3
Example Program
.DS 0
/* Event notification procedure */
void NotifyCommand()
{
	printf("Command Button was used\\\\n");
}

main()
{
          Window tw
          Targ args[3];

          XOpenDisplay (0);

          /* Create attribute list */
          TSetArg (args[0], T_COMMAND_PROC, NotifyCommand);
          TSetArg (args[1], T_COMMAND_TEXT, "Quit");
          TSetArg (args[2], 0, 0);

          /* Create the Button */
          command = TCreateCommand(RootWindow, args);

          /* Move the Tool Window */
          XMoveWindow (tw, 100, 100);       /* position button */

          /* Map the Tool Window */
          XMapWindow (tw);

          for (;;) {
              XEvent ev;

              /* Get Next Event */
              XNextEvent (&ev);

              /* Invoke tool handler if window ID matches button window */
              TDispatchXEvent (&ev);

	}
}
.DE
.NT 
For a complete explanation of the functions used in this example,
see Sections 2, Event Handling, and 3.1, Using Command Buttons.
.NE
.bp
.\".U7
.\".UT "Event Handling" 2
.ds XT XToolkit
.ds CF PRE-RELEASE DRAFT
.NH 1
Event Handling
.LP
The \*(XT provides functions with which you can service (manage)
events.  \*(XT windows normally register their event handlers with the Toolkit event
management module using the
.PN TSetXEventDispatch 
routine.  
.LP
This chapter discusses how to:
.IP \(bu 5
Dispatch events
.IP \(bu 5 
Register events
.LP
To dispatch events, use
.PN TDispatchXEvent .
The definition for this function is:
.FD 0
TDispatchXEvent(\fIevent\fP)
.br
XEvent *\fIevent\fP;
.FN
.IP \fIevent\fP 1i
Specifies an X event.
.LP
.PN TDispatchXEvent
dispatches the event to the appropriate window and returns an indication
of how the event was handled.
.LP
To register events, use
.PN TSetXEventDispatch .
You use this function to register \*(XT window event handlers with the  
event management module.
Although this function is available to applications programmers,
it normally is of interest only to \*(XT programmers.
The definition of this function is:
.FD 0
TSetXEventDispatch(\fIw\fP, \fIproc\fP, \fIeventmask\fP, \fIdata\fP)
.br
Window \fIw\fP;
.br
int (*\fIproc\fP)();
.br
int \fIeventmask\fP;
.br
caddr_t \fIdata\fP;
.FN
.IP \fIw\fP 1i
Specifies the window ID of the tool.

.IP \fIproc\fP 1i
Specifies an event handling procedure.
.IP \fIeventmask\fP 1i
Specifies the events that are to be dispatched on.
.IP \fIdata\fP 1i
Specifies the tool data.
.LP
.PN TSetXEventDispatch
registers the specified event handling procedure for the named window
with the dispatcher.
.bp
.\".U7
.\".UT "Button and Choice Box Tools" 3
.ds XT XToolkit
.ds CF PRE-RELEASE DRAFT
.NH 1
Button and Choice Box Tools
.LP
Buttons and choice boxes provide application users with a simple way to run 
commands and select command options.  
Buttons and choice boxes are basic tools. 
You can use buttons and choice boxes alone or in combination with other
tools.
.LP
This chapter discusses how to use:
.IP \(bu 5
Command buttons
.IP \(bu 5
Boolean buttons
.IP \(bu 5
Choice boxes
.LE
.NH 2
Using Command Buttons
.LP
The command button is a rectangular area containing text or a pixmap.  The border is
optional.  When the cursor is placed over the command button, highlighting will occur to
indicate that the button is available for selection.
.LP
When the cursor is placed over the command button and the mouse button is clicked, the 
command action will take place.
.LP
When the command button is selected, an application-supplied procedure will be immediately
invoked.
Figure 1 illustrates text-labeled and pixmap-labeled command buttons.
.KS 
.sp 10
.LP
Figure 1: Text-labeled and Pixmap-labeled Command Buttons
.KE
.LP
The \*(XT provides functions with which you can create and manipulate
command buttons.
This section discusses how to:
.IP \(bu 5
Create command button
.IP \(bu 5
Set button attributes
.IP \(bu 5
Get button attributes
.IP \(bu 5
Destroy command button
.LE
.LP
To create a command button, use
.PN TCreateCommand .
The definition for this function is:
.FD 0
Window TCreateCommand(\fIparent\fP, \fIarglist\fP)
.br
Window \fIparent\fP;
.br
Targ *\fIarglist\fP;
.FN
.IP \fIparent\fP 1i
Specifies the parent window ID of the tool.
.IP \fIarglist\fP 1i
Specifies a variable length argument list. 

.LP
.PN TCreateCommand
creates a command button sized to accomodate the text or pixmap.  
The attribute T_COMMAND_TYPE determines whether text or pixmap attributes are 
used.  
When the command button is clicked, 
the routine identified by T_COMMAND_PROC will be called with the argument 
specified by T_COMMAND_TAG.
For a complete list of valid argument types, 
see Table 1, Command Button Arguments.
.LP
Table 1: Command Button Arguments
.ps 8
.TS H
l l l .
_
.sp 6p
.TB
Name	Type	Description
.sp 6p
_
.sp 6p
.TH
.R
T_COMMAND_TYPE	int	Flag indicating text or pixmap
T_COMMAND_TEXT	char *	Text 
T_COMMAND_FONTINFO	FontInfo *	Font used for text button
T_COMMAND_TXCOLOR	int	Color index for text
T_COMMAND_PIXM	Pixmap *	Pixmap
T_COMMAND_PIXMW	int	Pixmap width in pixels
T_COMMAND_PIXMH	int	Pixmap height in pixels	
T_COMMAND_HITYPE	int	Highlighting type
T_COMMAND_BACKGRCOLOR	int	Background color
T_COMMAND_BRCOLOR	int	Border color
T_COMMAND_BRWIDTH	int	Border width in pixels
T_COMMAND_SELSTATE	int	0 = unselectable, 1 = selectable
T_COMMAND_PROC	int (*proc)()	Procedure called when button is clicked
T_COMMAND_TAG	caddr_t	Argument when calling above procedure
T_COMMAND_ONHI	int	Event mask that specifies highlighting
T_COMMAND_OFFHI	int	Event mask that unhighlights
T_COMMAND_NOTIFY	int	Event mask that notifies the application
T_COMMAND_REFRESH	int	Event mask to refresh tool
.sp 6p
_
.TE
.ps 10
.LP
The following example creates a command button that invokes a 
print procedure:
.KS
.sp 10
.KE
.LP
To set attributes for a command button, use 
.PN TSetCommandAttr .
The definition for this function is:
.FD 0
TSetCommandAttr\^(\^\fIw\fP, \fIarglist\fP\^)
.br
Window \fIw\fP;
.br
Targ *\fIarglist\fP;
.FN
.IP \fIw\fP 1i
Specifies the window ID of the tool.
.IP \fIarglist\fP 1i
Specifies a variable length argument list. 
.LP
For a complete list of valid argument types, 
see Table 1, Command Button Arguments.
.LP
To get (return) attributes for a command button, use
.PN TGetCommandAttr .
The definition for this function is:
.FD 0
TGetCommandAttr\^(\^\fIw\fP, \fIarglist\fP\^)
.br
Window \fIw\fP;
.br
Targ *\fIarglist\fP;
.FN
.IP \fIw\fP 1i
Specifies the window ID of the tool.
.IP \fIarglist\fP 1i
Specifies a variable length argument list. 
.LP
For a complete list of valid argument types, 
see Table 1, Command Button Arguments.
.LP
To destroy a command button, use
.PN TDestroyCommand .
The definition for this function is:
.FD 0
TDestroyCommand\^(\^\fIw\fP)
.br
Window \fIw\fP;
.FN
.IP \fIw\fP 1i
Specifies the window ID of the tool.
.LP
.PN TDestroyCommand
deletes the command button data structures (for context and event)
as well as the button window.
.NH 2
Using Boolean Buttons
.LP
This rectangular button will have two visual states corresponding to set and clear.  As
with command buttons, boolean buttons can contain either text or a pixmap.  The border is
optional.  When the cursor is placed over the boolean button, highlighting occurs to 
indicate that the button is available for selection.
.LP
When the cursor is placed over the boolean button, user selection toggles both the state
of the button and the text or pixmap image.
.LP
An application can set the state of a boolean button.  The application can also query
the boolean button to determine the current state.
.LP
Figure 2 is an example of a text-labeled and pixmap-labeled command button.
.KS
.sp 10
.LP
Figure 2: Text-labeled and Pixmap-labeled Boolean Buttons 
.KE
.LP
The \*(XT provides functions with which you can create and manipulate
boolean buttons.
The section discusses how to:
.IP \(bu 5
Create boolean button
.IP \(bu 5
Set boolean button attributes
.IP \(bu 5
Get boolean button attributes
.IP \(bu 5
Destroy boolean button
.LP
To create a boolean button, use 
.PN TCreateBoolean .
The definition for this function is:
.FD 0
Window TCreateBoolean(\fIparent\fP, \fIarglist\fP)
.br
Window \fIparent\fP;
.br
Targ *\fIarglist\fP;
.FN
.IP \fIparent\fP 1i
Specifies the parent window ID of the tool.
.IP \fIarglist\fP 1i
Specifies a variable length argument list. 
.LP
.PN TCreateBoolean
creates a boolean button sized to accomodate the text or pixmap. 
The attribute T_BOOLEAN_TYPE determines whether text or pixmap attributes are 
used. 
When the boolean button is selected, 
the routine identified by T_BOOLEAN_PROC is called with arguments corresponding to
T_BOOLEAN_STATE and T_BOOLEAN_TAG.
For a complete list of valid argument types, 
see Table 2, Boolean Button Arguments.
.LP
Table 2:  Boolean Button Arguments
.ps 8
.TS H
l l l .
_
.sp 6p
.TB
Name	Type	Description
.sp 6p
_
.sp 6p
.TH
.R
T_BOOLEAN_TXTORPXM	int	Flag indicating text or pixmap
T_BOOLEAN_TEXT0	char *	Text for state 0
T_BOOLEAN_TEXT1	char *	Text for state 1
T_BOOLEAN_FONTINFO	FontInfo *	Font used for text button
T_BOOLEAN_TXCOLOR	int	Color index for text
T_BOOLEAN_PIXM0	Pixmap *	Pixmap for state 0
T_BOOLEAN_PIXM1	Pixmap *	Pixmap for state 1
T_BOOLEAN_HITYPE	int	Highlighting type
T_BOOLEAN_BACKGRCOLOR	int	Background color
T_BOOLEAN_BRCOLOR	int	Border color
T_BOOLEAN_BRWIDTH	int	Border width
T_BOOLEAN_SELSTATE	int	0 = unselectable, 1 = selectable
T_BOOLEAN_PROC	int (*proc)()	Procedure called when button is selected
T_BOOLEAN_TAG	caddr_t	Argument when calling above procedure
.sp 6p
_
.TE
.ps 10
.LP
To set the attributes for a boolean button, use
.PN TSetBooleanAttr .
The definition for this function is:
.FD 0
TSetBooleanAttr(\fIw\fP, \fIarglist\fP)
.br
Window \fIw\fP;
.br
Targ *\fIarglist\fP;
.FN
.IP \fIw\fP 1i
Specifies the window ID of the tool.
.IP \fIarglist\fP 1i
Specifies a variable length argument list. 
.LP
For a complete list of valid argument types, 
see Table 2, Boolean Button Arguments.
.LP
To get (return) attributes for a boolean button, use 
.PN TGetBooleanAttr .
The definition for this function is:
.FD 0
TGetBooleanAttr(\fIw\fP, \fIarglist\fP)
.br
Window \fIw\fP;
.br
Targ *\fIarglist\fP;
.FN
.IP \fIw\fP 1i
Specifies the window ID of the tool.
.IP \fIarglist\fP 1i
Specifies a variable length argument list. 
.LP
For a complete list of valid argument types, 
see Table 2, Boolean Button Arguments.
.LP
To destroy a boolean button, use
.PN TDestroyBoolean .
The definition for this function is:
.FD 0
TDestroyBoolean\^(\^\fIw\fP)
.br
Window \fIw\fP;
.FN
.IP \fIw\fP 1i
Specifies the window ID of the tool.
.LP
.PN TDestroyBoolean
deletes the boolean button data structures (for context and event)
as well as the button window.
.NH 2
Using Choice Boxes
.LP
.NT
The tools explained in this section currently are not implemented but are
representative of the \*(XT design goals.
.NE
A choice box is a collection of selectable objects in either text or pixmap format.  A
symbol associated with each object indicates whether or not the item is selected.  More
than one item can be selected at one time.  When the cursor is placed over a choice, 
highlighting will occur to indicate that the choice is available for selection.
.LP
When the cursor is placed over a choice and a button pressed, the choice is selected.
.LP
The application program can determine the maximum number of selections allowed.  The
application can set the preferred selection of choices.  The application can query the 
choice box to determine its state.
.LP
Choice boxes can be labeled with text or pixmaps.
.LP
Figure 3 illustrates text-labeled and pixmap-labeled choice boxes.
.KS
.sp 10
.LP
Figure 3: Text-Labeled and Pixmap-Labeled Choice Boxes
.KE
.LP
The \*(XT provides functions with which you can create and manipulate
choice boxes.
This section discusses how to:
.IP \(bu 5
Create choice box
.IP \(bu 5
Set choice box attributes
.IP \(bu 5
Get choice box attributes
.IP \(bu 5
Destroy choice box
.LP
.LP
To create a choice box, use
.PN TCreateChoiceBox .
The definition for this function is:
.FD 0
Window TCreateChoiceBox(\fIparent\fP, \fIarglist\fP)
.br
Window \fIparent\fP;
.br
Targ *\fIarglist\fP;
.FN
.IP \fIparent\fP 1i
Specifies the parent window ID of the tool.
.IP \fIarglist\fP 1i
Specifies a variable length argument list. 
.LP
.PN TCreateChoiceBox
creates a choice box window sized to accomodate
the choice buttons. 
A subwindow is created for each button
within the choice box window. 
The attribute T_CHOICEBOX_TYPE
determines whether text or pixmap buttons are used. 
When a choice is selected, 
the routine identified by T_CHOICEBOX_PROC is called, 
with arguments T_CHOICEBOX_SELECTMASK, the mask of selected buttons, 
and T_CHOICEBOX_TAG.
For a complete list of valid argument types, 
see Table 3, Choice Box Arguments.
.LP
Table 3: Choice Box Arguments
.ps 8
.TS H
l l l .
_
.sp 6p
.TB
Name	Type	Description
.sp 6p
_
.sp 6p
.TH
.R
T_CHOICEBOX_SELECTTYPE	int	Flag indicating '1 of' or 'any of'
T_CHOICEBOX_TYPE	int	Flag indicating text or pixmap buttons
T_CHOICEBOX_TEXT	char **	Array of text items
T_CHOICEBOX_PIXMAP	Pixmap *	Array of pixmaps
T_CHOICEBOX_BACKGROUND	int	Background color
T_CHOICEBOX_BRCOLOR	int	Border color
T_CHOICEBOX_BRWIDTH	int	Border width
T_CHOICEBOX_SELECTNUM	int	Number of choice items
T_CHOICEBOX_SELECTMASK	int	Item(s) are selected(0-31)
T_CHOICEBOX_PROC	int (*proc)()	Procedure called when item(s) are selected
T_CHOICEBOX_TAG	caddr_t	Argument when calling above procedures
.sp 6p
_
.TE
.ps 10
.LP
To set attributes for a choice box, use 
.PN TSetChoiceBoxAttr .
The definition for this function is:
.FD 0
TSetChoiceBoxAttr(\fIw\fP, \fIarglist\fP)
.br
Window \fIw\fP;
.br
Targ *\fIarglist\fP;
.FN
.IP \fIw\fP 1i
Specifies the window ID of the tool.
.IP \fIarglist\fP 1i
Specifies a variable length argument list. 
.LP
For a complete list of valid argument types, 
see Table 3, Choice Box Arguments.
.LP
To get (return) attributes for a choice box, use 
.PN TGetChoiceBoxAttr .
The definition for this function is:
.FD 0
TGetChoiceBoxAttr(\fIw\fP, \fIarglist\fP)
.br
Window \fIw\fP;
.br
Targ *\fIarglist\fP;
.FN
.IP \fIw\fP 1i
Specifies the window ID of the tool.
.IP \fIarglist\fP 1i
Specifies a variable length argument list. 
.LP
For a complete list of valid argument types, 
see Table 3, Choice Box Arguments.
.LP
To destroy a choice box, use
.PN TDestroyChoiceBox .
The definition for this function is:
.FD 0
TDestroyChoiceBox(\fIw\fP)
.br
Window \fIw\fP;
.FN
.IP \fIw\fP 1i
Specifies the window ID of the tool.
.bp
.\".U7
.\".UT "Valuator and Scroll Bar Tools" 4
.ds XT XToolkit
.ds CF PRE-RELEASE DRAFT
.NH 1
Valuator and Scroll Bar Tools
.LP
Valuators and scroll bars enable an application user to move the cursor to
a specific location in a file.  
.LP
This chapter discusses how to use:
.IP \(bu 5
Valuators
.IP \(bu 5
Scroll Bars
.LE
.NH 2
Using Valuators
.LP
A valuator is a rectangular region (vertical or horizontal) with an indicator for 
positioning.  
The indicator is either a narrow bar (the default), or an application
supplied pixmap.  
The valuator area is defined by either a default border or a user-supplied 
pixmap.  
A valuator can be visible or invisible.
.LP
When the cursor is over the indicator,  and when the indicator is selected, the
indicator can be dragged.  Data can
be obtained continuously as the indicator moves or only when the
mouse button is released. A value between 0.0 and 1.0 is returned
to the application.
.LP
The application can set the current indicator position.
.LP
Data can be obtained continuously as the indicator moves or only when the mouse 
button is released. A value between 0.0 and 1.0 is returned to the application.  
Figure 4 illustrates a valuator.
.KS
.sp 10
.LP
Figure 4: Valuator
.KE
.LP
The \*(XT provides functions with which you can create an manipulate 
valuators.
This section discusses how to:
.IP \(bu 5
Create valuators
.IP \(bu 5
Set valuator attributes
.IP \(bu 5
Get valuator attributes
.IP \(bu 5
Destroy valuators
.LE
.LP
To create a valuator, use
.PN TCreateValuator .
The definition for this function is:
.FD 0
Window TCreateValuator(\fIparent\fP, \fIarglist\fP)
.br
Window \fIparent\fP;
.br
Targ *\fIarglist\fP;
.FN
.IP \fIparent\fP 1i
Specifies the parent window ID of the tool.
.IP \fIarglist\fP 1i
Specifies a variable length argument list. 
.LP
.PN TCreateValuator
creates a valuator sized to the input dimension.  
When the indicator is moved, 
the routine identified by T_VALUATOR_INDPROC is called with arguments
corresponding to T_VALUATOR_INDPOS, the current indicator position, and
T_VALUATOR_TAG.
For a complete list of valid argument types,
see Table 4, Valuator Arguments.
.LP
Table 4: Valuator Arguments
.ps 8
.TS H
l l l .
_
.sp 6p
.TB
Name	Type	Description
.sp 6p
_
.sp 6p
.TH
.R
T_VALUATOR_TYPE	int	Specifies if the valuator is visible or invisible
T_VALUATOR_ORIENT	enum Direction	Orientation (horizontal or vertical)
T_VALUATOR_MAXDIM	int	Maximum dimension of valuator
T_VALUATOR_MINDIM	int	Minimum dimension of valuator
T_VALUATOR_INDPOS	float	Current indicator position
T_VALUATOR_INDSIZE	float	Indicator size
T_VALUATOR_INDCOLOR	int	Indicator color
T_VALUATOR_BACKGROUND	int	Background color
T_VALUATOR_BRCOLOR	int	Border color
T_VALUATOR_BRWIDTH	int	Border width
T_VALUATOR_PROC	int (*proc)()	Procedure called when indicator is moved
T_VALUATOR_TAG	caddr_t	Argument when calling above procedures
.sp 6p
_
.TE
.ps 10
.LP
To set attributes for a valuator, use
.PN TSetValuatorAttr .
The definition for this function is:
.FD 0
TSetValuatorAttr(\fIw\fP, \fIarglist\fP)
.br
Window \fIw\fP;
.br
Targ *\fIarglist\fP;
.FN
.IP \fIw\fP 1i
Specifies the window ID of the tool.
.IP \fIarglist\fP 1i
Specifies a variable length argument list. 
.LP
For a complete list of valid argument types,
see Table 4, Valuator Arguments.
.LP
To get (return) attributes for a valuator, use
.PN TGetValuatorAttr .
The definition for this function is:
.FD 0
TGetValuatorAttr(\fIw\fP, \fIarglist\fP)
.br
Window \fIw\fP;
.br
Targ *\fIarglist\fP;
.FN
.IP \fIw\fP 1i
Specifies the window ID of the tool.
.IP \fIarglist\fP 1i
Specifies a variable length argument list. 
.LP
For a complete list of valid argument types,
see Table 4, Valuator Arguments.
.LP
To destroy a valuator, use
.PN TDestroyValuator .
The definition for this function is:
.FD 0
TDestroyValuator(\fIw\fP)
.br
Window \fIw\fP; 
.FN
.IP \fIw\fP 1i
Specifies the window ID of the tool.

.LP
.PN TDestroyValuator
deletes the valuator data structures (for context and event)
as well as the valuator window.
.NH 2
Using Scroll Bars
.LP
The scroll bar is a rectangular region containing a smaller rectangular object
(the thumb). 
The scroll bar can be oriented vertically or horizontally.  
The scroll bar has optional rectangular areas at each end of the bar for 
unit scrolling (that is, page buttons).
.LP
When the cursor is located over the thumb, and when the thumb is selected,
the thumb can be moved and an associated procedure is called.
Scrolling can occur either concurrently with the movement of the
thumb or only when the mouse button is released.  When the cursor
is located on the end rectangular areas and selected, a second
application procedure is called.
.LP      
The application can set the thumb position.
Figure 5 illustrates a scroll bar.
.KS
.sp 10
.LP
Figure 5: Scroll Bar
.KE
.LP
The \*(XT provides functions with which you can create and manipulate
scroll bars.
This section discusses how to:
.IP \(bu 5
Create scroll bars
.IP \(bu 5
Set scroll bar attributes
.IP \(bu 5
Get scroll bar attributes
.IP \(bu 5
Destroy scroll bar 
.LE
.LP
To create a scroll bar, use
.PN TCreateScrollBar .
The definition for this function is:
.FD 0
Window TCreateScrollBar(\fIparent\fP, \fIarglist\fP)
.br
Window \fIparent\fP;
.br
Targ *\fIarglist\fP;
.FN
.IP \fIparent\fP 1i
Specifies the parent window ID of the tool.
.IP \fIarglist\fP 1i
Specifies a variable length argument list. 
.LP
.PN TCreateScrollBar
creates a scroll bar sized to the parent window.  
When the thumb is moved,
the routine identified by T_SCROLLBAR_THUMBPROC is called, 
and the  current thumb position and tag are passed.  
When a page button is selected,
the routine identified by T_SCROLLBAR_PAGEPROC is called, and
a flag indicating up/down and the tag are passed.
For a complete list of valid argument types,
see Table 5, Scroll Bar Arguments.
.LP
Table 5: Scroll Bar Arguments
.ps 8
.TS H
l l l .
_
.sp 6p
.TB
Name	Type	Description
.sp 6p
_
.sp 6p
.TH
.R
T_SCROLLBAR_ORIENT	enum WhichWay	Orientation (Left, Right, Up, Down)
T_SCROLLBAR_STHICK	int	Scroll bar thickness in pixels
T_SCROLLBAR_THUMBPOS	float	Thumb position
T_SCROLLBAR_THUMBSIZE	float	Thumb size
T_SCROLLBAR_THUMBCOLOR	int	Thumb color
T_SCROLLBAR_BACKGROUND	int	Background color
T_SCROLLBAR_BRCOLOR	int	Border color
T_SCROLLBAR_BRWIDTH	int	Border width
T_SCROLLBAR_THUMBPROC	int (*proc)()	Procedure called when thumb is moved
T_SCROLLBAR_TAG	caddr_t	Argument when calling above procedures
.sp 6p
_
.TE
.ps 10
.LP
To set attributes for a scroll bar, use  
.PN TSetScrollBarAttr .
The definition for this function is:
.FD 0
TSetScrollBarAttr(\fIw\fP, \fIarglist\fP)
.br
Window \fIw\fP;
.br
Targ *\fIarglist\fP;
.FN
.IP \fIw\fP 1i
Specifies the window ID of the tool.
.IP \fIarglist\fP 1i
Specifies a variable length argument list. 
.LP
For a complete list of valid argument types,
see Table 5, Scroll Bar Arguments.
.LP
To get (return) attributes for a scroll bar, use
.PN TGetScrollBarAttr .
The definition for this function is:
.FD 0
TGetScrollBarAttr(\fIw\fP, \fIarglist\fP)
.br
Window \fIw\fP;
.br
Targ *\fIarglist\fP;
.FN
.IP \fIw\fP 1i
Specifies the window ID of the tool.
.IP \fIarglist\fP 1i
Specifies a variable length argument list. 
.LP
For a complete list of valid argument types,
see Table 5, Scroll Bar Arguments.
.LP
To destroy a scroll bar, use 
.PN TDestroyScrollBar .
The definition for this function is:
.FD 0
TDestroyScrollBar(\fIw\fP)
.br
Window \fIw\fP;
.FN
.IP \fIw\fP 1i
Specifies the window ID of the tool.
.LP
.PN TDestroyScrollBar
deletes the scroll bar data structures (for context and event)
as well as the scroll bar window.
.bp
.\".U7
.\".UT "Text Tools" 5
.ds XT XToolkit
.ds CF PRE-RELEASE DRAFT
.NH 1
Text Tools
.LP
The text tools allow single font textual information only.  The font can be
specified in the application.
.LP
Subject to restrictions stated in each tool, the user in general can use
mouse to accomplish the following functions:
.IP \(bu 5
Select a range of text
.IP \(bu 5
Cut a selected range of text
.IP \(bu 5
Copy a selected range of text to a buffer
.IP \(bu 5
Position the text insertion point
.LE
.LP
This chapter discusses how to use:
.IP \(bu 5
Labels
.IP \(bu 5
Input fields
.IP \(bu 5
Text tools
.LE
.NH 2
Using Labels
.LP
A label tool allows an application to put a single line of text out in a 
window (typical usage would be to issue a prompt, warning, or diagnostic).
.LP
A label appears as a single line of text with an optional border.  The 
\*(XT is responsible for refresh of the text.  No insertion point is 
visible.
.LP
Visual attributes are font, foreground color, width, height, border width, and
justification.
.LP
No input or editing is supported.  Figure 6 illustrates a message box.
.KS
.sp 10
.LP
Figure 6: Label
.KE
.LP
The \*(XT provides functions with which you can create and manipulate
labels.
This section discusses how to:
.IP \(bu 5
Create labels
.IP \(bu 5
Set label attributes
.IP \(bu 5
Get label attributes
.IP \(bu 5
Destroy labels
.LE
.LP
To create a label, use
.PN TCreateLabel .
The definition for this function is:
.FD 0
Window TCreateLabel(\fIparent\fP, \fIarglist\fP)
.br
Window \fIparent\fP;
.br
Targ *\fIarglist\fP;
.FN
.IP \fIparent\fP 1i
Specifies the parent window ID of the tool.
.IP \fIarglist\fP 1i
Specifies a variable length argument list. 
.LP
.PN TCreateLabel
creates a label tool using the supplied string and returns the
window id.
For a complete list of valid argument types,
see Table 6, Label Arguments.
.LP
Table 6: Label Arguments
.ps 8
.TS H
l l l .
_
.sp 6p
.TB
Name	Type	Description
.sp 6p
_
.sp 6p
.TH
.R
T_LABEL_STRING	char *	String for label
T_LABEL_FONTINFO	FontInfo *	Font used for the label
T_LABEL_BORDERWIDTH	int	Width of the label border in pixels
T_LABEL_FOREGROUNDPIXEL	int	Color of the label text
T_LABEL_WIDTH	int	Width of the label in pixels
T_LABEL_HEIGHT	int	Height of the label in pixels
T_LABEL_JUSTIFY	int	-1 = left justify string;
		0 = center string;
		1 = right justify string;
.sp 6p
_
.TE
.ps 10
.LP
To set attributes for a label, use
.PN TSetLabelAttr .
The definition for this function is:
.FD 0
TSetLabelAttr(\fIw\fP, \fIarglist\fP)
.br
Window \fIw\fP;
.br
Targ *\fIarglist\fP;
.FN
.IP \fIw\fP 1i
Specifies the window ID of the tool.
.IP \fIarglist\fP 1i
Specifies a variable length argument list. 
.LP
For a complete list of valid argument types,
see Table 6, Label Arguments.
.LP
To get (return) attributes for a label, use
.PN TGetLabelAttr .
The definition for this function is:
.FD 0
TGetLabelAttr(\fIw\fP, \fIarglist\fP)
.br
Window \fIw\fP;
.br
Targ *\fIarglist\fP;
.FN
.IP \fIw\fP 1i
Specifies the window ID of the tool.
.IP \fIarglist\fP 1i
Specifies a variable length argument list. 
.LP
For a complete list of valid argument types,
see Table 6, Label Arguments.
.LP
To destroy a label, use
.PN TDestroyLabel .
The definition for this function is:
.FD 0
TDestroyLabel(\fIw\fP)
.br
Window \fIw\fP;
.FN
.IP \fIw\fP 1i
Specifies the window ID of the tool.
.LP
.PN TDestroyLabel
destroys the label tool associated with the window as well as the
label window itself.
.NH 2
Using Input Fields
.NT
The tools explained in this section currently are not implemented but are
representative of the \*(XT design goals.
.NE
.LP
An input field is intended for simple, one line input (for example, filename).  The 
field is of fixed length and has an optional border.  The field can be 
initialized to a given string.  An insertion point is visible within the field.
.LP
The text can be edited by using the mouse to reposition the
insertion point.  Normal characters are inserted in the string at
the insertion point.  The user's normal character-erase and
line-erase characters are interpreted as they normally would by
the shell.  The application is notified of the input string when
an application specified notification character is pressed by the
user.  Figure 7 illustrates an input line.
.KS
.sp 10
.LP
Figure 7: Input Field
.KE
.LP
The \*(XT provides functions with which you can create and manipulate
input fields.
This section discusses how to:
.IP \(bu 5
Create input fields
.IP \(bu 5
Set input field attributes
.IP \(bu 5
Get input field attributes
.IP \(bu 5
Destroy input fields
.LE
.LP
To create an input field, use 
.PN TCreateInputField .
The definition for this function is:
.FD 0
Window TCreateInputField(\fIparent\fP, \fIarglist\fP)
.br
Window \fIparent\fP;
.br
Targ *\fIarglist\fP;
.FN
.IP \fIparent\fP 1i
Specifies the parent window ID of the tool.
.IP \fIarglist\fP 1i
Specifies a variable length argument list. 
.LP
.PN TCreateInputField
creates an input field using the supplied string as the default.
The notification procedure is called when any character from the
T_INPUTFIELD_BREAK is typed.
For a complete list of valid argument types,
see Table 7, Input Field Arguments.
.LP
Table 7: Input Field Arguments
.ps 8
.TS H
l l l .
_
.sp 6p
.TB
Name	Type	Description
.sp 6p
_
.sp 6p
.TH
.R
T_INPUTFIELD_TEXT	char *	Initial string for input field
T_INPUTFIELD_FONTINFO	FontInfo *	Font used for the label
T_INPUTFIELD_BORDER	Pixmap	Border pixmap
T_INPUTFIELD_BACKGROUND	Pixmap	Background pixmap
T_INPUTFIELD_TXCOLOR	int	Color index to be used for text
T_INPUTFIELD_PROC	int (*proc)()	Procedure called when a notification 
		character is typed
T_INPUTFIELD_TAG	caddr_t	Argument used in calling above procedure
T_INPUTFIELD_BREAK	char *	String of notification characters
T_INPUTFIELD_LENGTH	int	Maximum size of input field in characters
T_INPUTFIELD_JUSTIFY	int	-1 = left justify string;
		0 = center string;
		1 = right justify string;
.sp 6p
_
.TE
.ps 10
.LP
To set attributes for an input field, use
.PN TSetInputFieldAttr .
The definition for this function is:
.FD 0
TSetInputFieldAttr(\fIw\fP, \fIarglist\fP)
.br
Window \fIw\fP;
.br
Targ *\fIarglist\fP;
.FN
.IP \fIw\fP 1i
Specifies the window ID of the tool.
.IP \fIarglist\fP 1i
Specifies a variable length argument list. 
.LP
For a complete list of valid argument types,
see Table 7, Input Field Arguments.
.LP
To get (return) attributes for an input field, use
.PN TGetInputFieldAttr .
The definition for this function is:
.FD 0
TGetInputFieldAttr(\fIw\fP, \fIarglist\fP)
.br
Window \fIw\fP;
.br
Targ *\fIarglist\fP;
.FN
.IP \fIw\fP 1i
Specifies the window ID of the tool.
.IP \fIarglist\fP 1i
Specifies a variable length argument list. 
.LP
For a complete list of valid argument types,
see Table 7, Input Field Arguments.
.LP
To destroy an input field, use 
.PN TDestroyInputField .
The definition for this function is:
.FD 0
TDestroyInputField(\fIw\fP)
.br
Window \fIw\fP;

.FN
.IP \fIw\fP 1i
Specifies the window ID of the tool.
.LP
.PN TDestroyInputField
destroys the input field associated with the field window.
.NH 2
Using Text Sources 
.LP
Source objects that will be provided: 
.IP \(bu 5
Read/write string source
.IP \(bu 5
Read-only file source
.IP \(bu 5
Append-only file source
.LP
Sink objects that provide no-wrap, character-wrap, and word-wrap.  Sinks will
also be able to perform tab expansion.
.LP
The \*(XT provides functions with which you can create and manipulate
text sources and text sinks.
This section discusses how to:
.IP \(bu 5
Create text source
.IP \(bu 5
Destroy text source
.IP \(bu 5
Create text source disk file
.IP \(bu 5
Destroy text source disk file
.IP \(bu 5
Create append-only file
.IP \(bu 5
Destroy append-only file
.LE
.LP
To create a text source, use 
.PN TCreateStringSource .
The definition for this function is:
.FD 0
Window TCreateStringSource(\fIstr\fP, \fImaxlength\fP)
.br
char *\fIstr\fP;
.br
int \fImaxlength\fP
.FN
.IP \fIstr\fP 1i
Specifies the handle of the string source.
.IP \fImaxlength\fP 1i
Specifies the maximum length of the string source.

.LP
.PN TCreateStringSource
returns a handle for the string source.
.LP
To destroy a text source, use 
.PN TDestroyStringSource .
The definition for this function is:
.FD 0
TDestroyStringSource(\fIsrc\fP)
.br
TTextSource *\fIsrc\fP;
.FN
.IP \fIsrc\fP 1i
Specifies the handle of the text source to be destroyed.
.LP
.PN TDestroySringSource
destroys the string source.
.LP
To create a text source disk file, use
.PN TCreateDiskSource .
The definition for this function is:
.FD 0
Window TCreateDiskSource(\fIfilename\fP)
.br
char *\fIfilename\fP;
.FN
.IP \fIfilename\fP 1i
Specifies the name of the disk file that is used as the text source.
.LP
.PN TCreateDiskSource
returns a handle for the disk source.
.LP
To destroy a text source disk file, use
.PN TDestroyDiskSource .
The definition for this function is:
.FD 0
TDestroyDiskSource(\fIsrc\fP)
.br
TTextSource *\fIsrc\fP;
.FN
.IP \fIsrc\fP 1i
Specifies the handle of the text source to be destroyed.
.LP
.PN TDestroyDiskSource
destroys the disk source.
.LP
To create an append-only file, use 
.PN TCreateAppendSource .
The definition for this function is:
.FD 0
Window TCreateAppendSource(\fIfilename\fP)
.br
char *\fIfilename\fP;
.br
.FN
.IP \fIfilename\fP 1i
Specifies the name of the disk file that is used as the text source.
.LP
.PN TCreateAppendSource 
returns a handle for the disk source.
.LP
To destroy an append-only file, use 
.PN TDestroyAppendSource .
The definition for this function is:
.FD 0
TDestroyAppendSource(\fIsrc\fP)
.br
TTextSource *\fIsrc\fP;
.FN
.IP \fIsrc\fP 1i
Specifies the handle of the text source to be destroyed.
.LP
.PN TDestroyAppendSource 
destroys the append-only file.
.NH 2
Using Text Tools
.LP
The text tool is intended for viewing and editing single font
textual information and is designed to be used with a variety of
backing stores for the text (for example, string in memory, a disk
file).
.LP
Backing stores for text that will be provided: 
.IP \(bu 5
Read/write string
.IP \(bu 5
Read-only file
.IP \(bu 5
Append-only file  
.LP
Text tools have options for no-wrap, character-wrap and word-
wrap.  
.LP
The field is of fixed height and width with an optional border.
An insertion point is visible within the field.  
.LP
The text can be edited by using the mouse to reposition the
insertion point.  Normal characters are inserted in the text at
the insertion point.  The user's normal character-erase character
is interpreted as it normally would by the shell.  
.LP
At creation time, the application specifies the size in pixels of
the tool window as well as the text backing store and the offset
into the backing store of the first character displayed.  The
tool provides routines to query and set the backing store offset
and to cause the window to scroll up or down a specified number
of lines.
.LP
An optional vertical scrollbar can be attached to the left or right of the text window.
The text displayed is adjusted in sync
with the users repositioning of the thumb on the scroll bar.  In
addition, when the application sets the text offset, the
scrollbar is automatically updated.  The tool includes routines that cause the window to
scroll up or down.
.NT
The tools explained in this section are not implemented but are
representative of the \*(XT design goals.
.NE
.LP
Figure 8 illustrates a text tool with a scroll bar.
.KS
.sp 10
.LP
Figure 8: Text Tool with Scroll Bar
.KE
The \*(XT provides functions with which you can create and manipulate
text tools.
This section discusses how to:
.IP \(bu 5
Create text tool
.IP \(bu 5
Set text tool attribute
.IP \(bu 5
Get text tool attribute
.IP \(bu 5
Create text tool with scroll bar
.IP \(bu 5
Destroy text tool
.LE
.LP
To create a text tool, use 
.PN TCreateTextSW .
The definition for this function is:
.FD 0
Window TCreateTextSW(\fIw\fP, \fIarglist\fP)
.br
Window \fIw\fP;
.br
Targ *\fIarglist\fP;
.FN
.IP \fIw\fP 1i
Specifies the window ID of the tool.
.IP \fIarglist\fP 1i
Specifies a variable length argument list. 
.LP
.PN TCreateTextSW
creates the textual window with the optional scroll-bars.  
The supplied backing store is used to display characters in the window. 
The notification procedure is called when any character
from the T_TEXT_NOTIFY_ROUTINE is typed.
For a complete list of valid argument types,
see Table 8, Text Tool Arguments.
.LP
Table 8: Text Tool Arguments
.ps 8
.TS H
l l l .
_
.sp 6p
.TB
Name	Type	Description
.sp 6p
_
.sp 6p
.TH
.R
T_TEXT_SOURCE	int	Handle for source (backing store)
T_TEXT_FONT_INFO	FontInfo *	Font used for text
T_TEXT_LEFT_MARGIN	int	number of pixels for left margin
		Default is 2
T_TEXT_TOP	int	Character offset into backing store
		Default is 0
T_TEXT_OPTIONS	int	Editability flag, wrap flags
T_TEXT_HEIGHT	int	Window height in pixels
T_TEXT_WIDTH	int	Window width in pixels
T_TEXT_BRWIDTH	int	Border width in pixels
T_TEXT_INSERT_POS	int	Character offset for insertion point
		of editable characters
T_TEXT_NOTIFY_SYMBOLS	char *	string of notification character 
T_TEXT_NOTIFY_ROUTINE	int(*proc)()	Procedure to be called
T_TEXT_NOTIFY_TAG	caddr_t	Arguments passed to procedure
T_TEXT_WORD_DELIM	char *	Character string of word delimiters
		for highlighted by wordSelection
T_TEXT_SEL_TYPE	enum SelectionType
		charSelection, wordSelection, lineSelection
T_TEXT_SEL_MUTUAL_EXCLUDE	int
		1 = highlighting in window is
		mutually exclusive with other
		windows with this flag set
		0 = not mutually exclusive
T_TEXT_UNHIGHLIGHT	Window	Unhighlights text in given window
T_TEXT_HIGHLIGHTS	char *	Returns highlighted character string
.sp 6p
_
.TE
.ps 10
.LP
To set attributes for a text tool, use
.PN TSetTextAttr .
The definition for this function is:
.FD 0
TSetTextAttr(\fIw\fP, \fIarglist\fP)
.br
Window \fIw\fP;
.br
Targ *\fIarglist\fP;

.FN
.IP \fIw\fP 1i
Specifies the window ID of the tool.
.IP \fIarglist\fP 1i
Specifies a variable length argument list. 
.LP
For a complete list of valid argument types,
see Table 8, Text Tool Arguments.
.LP
To get (return) attributes for a text tool, use
.PN TGetTextAttr .
The definition for this function is:
.FD 0
TGetTextAttr(\fIw\fP, \fIarglist\fP)
.br
Window \fIw\fP;
.br
Targ *\fIarglist\fP;
.FN
.IP \fIw\fP 1i
Specifies the window ID of the tool.
.IP \fIarglist\fP 1i
Specifies a variable length argument list. 
.LP
For a complete list of valid argument types,
see Table 8, Text Tool Arguments.
.NT
The next tool in this section currently is not implemented but is
representative of the \*(XT design goals.
.NE
.LP
To scroll text within a text tool, use
.PN TScrollText .
The definition for this function is:
.FD 0
TScrollText(\fIw\fP, \fIlines\fP)
.br
Window \fIw\fP;
.br
int \fIlines\fP;
.FN
.IP \fIw\fP 1i
Specifies the window ID of the tool.
.IP \fIlines\fP 1i
Specifies the number of lines that the text window is scrolled.
.LP
If lines is greater than 0, the window will scroll up.  
If lines is less than 0, the window will scroll down.  
.PN TScrollText
enforces the same restriction on offset of first char displayed as does 
TSetTextPos.
.LP
To destroy a text tool, use 
.PN TDestroyTextTool .
The definition for this function is:
.FD 0
TDestroyTextTool(\fIw\fP)
.br
Window \fIw\fP;
.FN
.IP \fIw\fP 1i
Specifies the window ID of the tool.
.LP
.PN TDestroyTextTool
destroys the tool associated with the text tool window 
.bp
.\".U7
.\".UT "Menu Tools" 6
.ds XT XToolkit
.ds CF PRE-RELEASE DRAFT
.NH 1
Menu Tools
.LP
A menu tool is a composite tool which is packaged for the convenience of
the application programmer.  
It consists of a menu window and a number of client-specified tool windows 
for entries.
.LP
Menu entries can be arranged horizontally, vertically, or in a grid.
Each menu entry is a tool window (typically a command button or boolean
button).  
The client is responsible for servicing callbacks from the menu entry 
tool windows.
.LP
The semantics for a menu vary depending on the event mask specified for
client callback, as well as the event masks for its individual entries.
Enough flexibility is provided, for example, to allow the client to
create various kinds of menu bars with pull-downs.
.LP
The \*(XT provides functions with which you can create and manipulate
menus.
This chapter discusses how to:
.IP \(bu 5
Create menus
.IP \(bu 5
Set menu attributes
.IP \(bu 5
Get menus attributes
.IP \(bu 5
Destroy menus
.IP \(bu 5
Add menu entries
.IP \(bu 5
Set menu entry attributes
.IP \(bu 5
Get menu entry attributes
.IP \(bu 5
Delete menu entries
.LE
.LP
To create a menu, use
.PN TCreateMenu .
The definition for this function is:
.FD 0
Window TCreateMenu(\fIparent\fP, \fIarglist\fP)
.br
Window \fIparent\fP;
.br
Targ *\fIarglist\fP;
.FN
.IP \fIparent\fP 1i
Specifies the parent window ID of the tool.
.IP \fIarglist\fP 1i
Specifies a variable length argument list. 
.LP
.PN TCreateMenu
creates a menu and specifies the attributes which apply
to all of the menu entries.
For a complete list of valid argument types,
see Table 9, Menu Arguments.
.LP
Table 9: Menu Arguments
.ps 8
.TS H
l l l .
_
.sp 6p
.TB
Name	Type	Description
.sp 6p
_
.sp 6p
.TH
.R
T_MENU_ROWS	int	Number of rows in menu
T_MENU_COLS	int	Number of columns in menu
T_MENU_BORDER	Pixmap	Menu border pixmap
T_MENU_BDRWIDTH	int	Menu entry border width
T_MENU_BACKGROUND	Pixmap	Background pixmap 
T_MENU_FOREGROUND	int	Foreground pixel for shadowing, etc.
T_MENU_CURSOR	Cursor	Menu cursor
T_MENU_PROC	int (*proc)()	Procedure called when a menu window
		event occurs (see T_MENU_NOTIFY)
T_MENU_TAG	caddr_t	Argument when calling proc
T_MENU_NOTIFY	int	Event mask for client callback
.sp 6p
_
.TE
.ps 10
.LP
To set attributes for a menu, use
.PN TSetMenuAttr .
The definition for this function is:
.FD 0
TSetMenuAttr(\fIw\fP, \fIarglist\fP)
.br
Window \fIw\fP;
.br
Targ *\fIarglist\fP;
.FN
.IP \fIw\fP 1i
Specifies the window ID of the tool.
.IP \fIarglist\fP 1i
Specifies a variable length argument list. 
.LP
.PN TSetMenuAttr
changes the attributes which apply to all of the menu entries.
For a complete list of valid argument types,
see Table 9, Menu Arguments.
.LP
To get (return) attributes for menu, use
.PN TGetMenuAttr .
The definition for this function is:
.FD 0
TGetMenuAttr(\fIw\fP, \fIarglist\fP)
.br
Window \fIw\fP;
.br
Targ *\fIarglist\fP;
.FN
.IP \fIw\fP 1i
Specifies the window ID of the tool.
.IP \fIarglist\fP 1i
Specifies a variable length argument list. 
.LP
.PN TGetMenuAttr
queries the attributes which apply to all of  the  menu entries.
For a complete list of valid argument types,
see Table 9, Menu Arguments.
.LP
To destroy a menu, use
.PN TDestroyMenu .
The definition for this function is:
.FD 0
TDestroyMenu(\fIw\fP)
.br
Window \fIw\fP;
.FN
.IP \fIw\fP 1i
Specifies the window ID of the tool.
.LP
.PN TDestroyMenu
deletes the window and the data structures associated with the given menu window. 
The menu cannot be redisplayed.
However, it does not delete the menu entry windows and their data structures.  
.LP
To add an entry to an existing menu, use
.PN TAddMenuEntry .
The definition for this function is:
.FD 0
TAddMenuEntry(\fIw\fP, \fIentryarglist\fP)
.br
Window \fIw\fP;
.br
Targ *\fIentryarglist\fP;
.FN
.IP \fIw\fP 1i
Specifies the window ID of the tool.
.IP \fIentryarglist\fP 1i
Specifies a variable length argument list.
.LP
.PN TAddMenuEntry
adds an entry to a menu.  
This entry must be another tool window, such as a command button or label.
For a complete list of valid entry argument types,
see Table 10, Menu Entry Arguments.
.LP
Table 10: Menu Entry Arguments
.ps 8
.TS H
l l l .
_
.sp 6p
.TB
Name	Type	Description
.sp 6p
_
.sp 6p
.TH
.R
T_MENUENTRY_ROW	int	Row number for entry
T_MENUENTRY_COL	int	Column number for entry
T_MENUENTRY_WINDOW	Window	Window ID of entry's tool window
.sp 6p
_
.TE
.ps 10
.LP
To set attributes for a menu entry, use
.PN TSetMenuEntryAttr .
The definition for this function is:
.FD 0
TSetMenuEntryAttr(\fIw\fP, \fIentryarglist\fP)
.br
Window \fIw\fP;
.br
Targ *\fIentryarglist\fP;
.FN
.IP \fIw\fP 1i
Specifies the window ID of the tool.
.IP \fIentryarglist\fP 1i
Specifies a variable length argument list.
.LP
.PN TSetMenuEntryAttr
changes the attributes of a menu entry.
For a complete list of valid entry argument types,
see Table 10, Menu Entry Arguments.
.LP
To get attributes for a menu entry, use
.PN TGetMenuEntryAttr .
The definition for this function is:
.FD 0
TGetMenuEntryAttr(\fIw\fP, \fIentryarglist\fP)
.br
Window \fIw\fP;
.br
Targ *\fIentryarglist\fP;
.FN
.IP \fIw\fP 1i
Specifies the window ID of the tool.
.IP \fIentryarglist\fP 1i
Specifies a variable length argument list.
.LP
.PN TGetMenuEntryAttr
queries the attributes of a menu entry.
For a complete list of valid entry argument types,
see Table 10, Menu Entry Arguments.
.LP
To delete an entry to a menu, use
.PN TDeleteMenuEntry .
The definition for this function is:
.FD 0
TDeleteMenuEntry(\fIw\fP, \fIentryarglist\fP)
.br
Window \fIw\fP;
.br
Targ *\fIentryarglist\fP;
.FN
.IP \fIw\fP 1i
Specifies the window ID of the tool.
.IP \fIentryarglist\fP 1i
Specifies a variable length argument list.
.LP
.PN TDeleteMenuEntry
delete an entry from a menu.  
The client must delete the entry window and its data structures, 
typically by calling the deletion routine for the entry's tool window.
For a complete list of valid entry argument types,
see Table 10, Menu Entry Arguments.
.LP
The menu notification routine interface is:
.FD 0
void notify_proc(ev, tag)
XEvent *ev;                 /* X event causing proc to be called */
caddr_t tag;                /* additional data of menu*/
.FN
.bp
.\".U7
.\".UT "Interactive Form Tools" 7
.ds XT XToolkit
.ds CF PRE-RELEASE DRAFT
.NH 1
Interactive Form Tools
.LP
An interactive form is a graphic device used to organize (both
conceptually and visually) a variable set of tools for immediate
user interaction.  A form provides the visual context for a compartmentalized
user-computer dialog.  Forms are typically used to
present and/or collect sets of data (such as parameter settings).
In its most general format, a form is a bordered rectangular area
containing one or more application specified tools, along with
text and/or graphics, in a programmer-specified configuration.
A form appears and disappears under program control and is on top in
the stacking order of windows.
.LP
When an interactive form appears on the screen, users are able to
interact freely with the various tools contained within. Upon
selecting some "completion action", the form disappears from the
screen and any defined procedures are carried out.
.LP
.IP \(bu 5
Use help forms
.IP \(bu 5
Use warning/problem forms
.IP \(bu 5
Make forms
.LE
.NH 2
Using Help Forms
.LP
.NT
The tools explained in this section are not implemented but are
representative of the \*(XT design goals.
.NE
The help form can be used by both the window manager and application programs
to provide user assistance. In response to a "help"
request, this form appears on the screen. The form can have one
or two command buttons on it.
.LP      
Figure 9 illustrates a help form.
.KS
.sp 10
.LP
Figure 9: Help Form
.KE
.LP
The \*(XT provides functions with which you can create and manipulate
help forms.
This section discusses how to:
.IP \(bu 5
Create help forms
.IP \(bu 5
Set help form attributes
.IP \(bu 5
Get help form attributes
.IP \(bu 5
Destroy help forms
.LE
.LP
To create a help form, use
.PN TCreateHelpForm .
The definition for this function is:
.FD 0
Window TCreateHelpForm(\fIarglist\fP)
.br
Targ *\fIarglist\fP;
.FN
.IP \fIarglist\fP 1i
Specifies a variable length argument list. 
.LP
.PN TCreateHelpForm
accepts a text string of variable length, formats the
text, and sets up a context-specific help form which can appear
under user/program control. 
The help form has a go-away button which, when selected by the user, 
causes the form to disappear. 
An optional continuation button can be used to provide an additional help form
when selected. 
The default location for a help form is the center of
the screen, unless another offset is specified.
For a complete list of valid argument types,
see Table 11, Help Form Arguments.
.LP
Table 11: Help Form Arguments
.ps 8
.TS H
l l l .
_
.sp 6p
.TB
Name	Type	Description
.sp 6p
_
.sp 6p
.TH
.R
T_HELP_TEXT	char *	Text for help form
T_HELP_TITLE	char *	Alternative title for help form
T_HELP_FOREGROUND	int	Color index to be used for foreground
T_HELP_BACKGROUND	int	Color index to be used for background
T_HELP_WIDTH	int	Width of form
T_HELP_HEIGHT	int	Height of form
.sp 6p
_
.TE
.ps 10
.LP
To set attributes for a help form, use
.PN TSetHelpAttr .
The definition for this function is:
.FD 0
TSetHelpAttr(\fIw\fP, \fIarglist\fP)
.br
Window \fIw\fP;
.br
Targ *\fIarglist\fP;
.br
.FN
.IP \fIw\fP 1i
Specifies the window ID of the tool.
.IP \fIarglist\fP 1i
Specifies a variable length argument list. 
.LP
For a complete list of valid argument types,
see Table 11, Help Form Arguments.
.LP
To get (return) attributes for a help form, use
.PN TGetHelpAttr .
The definition for this function is:
.FD 0
TGetHelpAttr(\fIw\fP, \fIarglist\fP)
.br
Window \fIw\fP;
.br
Targ *\fIarglist\fP;
.br
.FN
.IP \fIw\fP 1i
Specifies the window ID of the tool.
.IP \fIarglist\fP 1i
Specifies a variable length argument list. 
.LP
For a complete list of valid argument types,
see Table 11, Help Form Arguments.
.LP
To destroy a help form, use
.PN TDestroyHelpForm .
The definition for this function is:
.FD 0
TDestroyHelpForm(\fIw\fP)
.br
Window \fIw\fP;
.br
.FN
.IP \fIw\fP 1i
Specifies the window ID of the tool.
.LP
.PN TDestroyHelpForm
deletes a help form, including the form's window and the OpaqueFrame
structure associated with it.
.NH 2
Using Warning/Problem Forms
.LP
.NT
The tools explained in this section are currently are not implemented but
are representative of the \*(XT design goals.
.NE
The warning/problem form provides a standard way to engage the
user in an out-of-band dialog concerning exceptions and problem
situations.
.LP
A distinctive form appears on the screen, providing instructions
to the user, and a variable set of command buttons.
.LP
When the form appears on the screen, the user can select one or
more command buttons to indicate which way to proceed. Once
chosen, the form disappears from the screen.
.LP
Figure 10 illustrates a warning/problem form.
.KS
.sp 10
.LP
Figure 10: Warning/Problem Form
.KE
.LP
The \*(XT provides functions with which you can create and manipulate
warning/problem forms.
This section discusses how to:
.IP \(bu 5
Create warning/problem forms
.IP \(bu 5
Set warning/problem form attributes
.IP \(bu 5
Get warning/problem form attributes
.IP \(bu 5
Destroy warning/problem forms
.LE
.LP
To create a warning/problem form, use
.PN TCreateWarningForm .
The definition for this function is:
.FD 0
Window TCreateWarningForm(\fIparent\fP, \fIarglist\fP)
.br
Window \fIparent\fP;
.br
Targ *\fIarglist\fP;
.br
.FN
.IP \fIarglist\fP 1i
Specifies a variable length argument list. 
.LP
.PN TCreateWarningForm
accepts a variable text string, formats the text, and
sets up a warning/problem form which can appear under
specific program states. 
The warning form can contain up to three command buttons: 
.IP \(bu 5 
Cancel button (return to previous state) 
.IP \(bu 5
Continue button (carry on) 
.IP \(bu 5
Help button (provide context-specific information) 
.LP
The warning form is a child of the root window. 
The default location for a warning form is the center of the
screen, unless another offset is specified.
For a complete list of valid argument types,
see Table 12, Warning Form Arguments.
.LP
Table 12: Warning Form Arguments
.ps 8
.TS H
l l l .
_
.sp 6p
.TB
Name	Type	Description
.sp 6p
_
.sp 6p
.TH
.R
T_WARN_TEXT	char *	Text for warning form
T_WARN_TITLE	char *	Alternative title for warning form
T_WARN_FOREGROUND	int	Color index to be used for foreground
T_WARN_BACKGROUND	int	Color index to be used for background
T_WARN_WIDTH	int	Width of form
T_WARN_HEIGHT	int	Height of form
T_WARN_X	int	X location of form on display
T_WARN_Y	int	Y location of form on display
T_WARN_CANCEL	int (*proc)()	Cancellation procedure
T_WARN_CANCEL_LABEL	char *	Text label for cancellation button
T_WARN_CONTINUE	int (*proc)()	Continuation procedure
T_WARN_CONTINUE_LABEL	char *	Text label for continuation button
T_WARN_HELP	int (*proc)()	Procedure to provide additional help
T_WARN_HELP_LABEL	char *	Text label for help button
.sp 6p
_
.TE
.ps 10
.LP
To set attributes for a warning/problem form, use
.PN TSetWarnAttr .
The definition for this function is:
.FD 0
TSetWarnAttr(\fIw\fP, \fIarglist\fP)
.br
Window \fIw\fP;
.br
Targ *\fIarglist\fP;
.br
.FN
.IP \fIw\fP 1i
Specifies the window ID of the tool.
.IP \fIarglist\fP 1i
Specifies a variable length argument list. 
.LP
For a complete list of valid argument types,
see Table 12, Warning Form Arguments.
.LP
To get (return) attributes for a warning/problem form, use
.PN TGetWarnAttr .
The definition for this function is:
.FD 0
TGetWarnAttr(\fIw\fP, \fIarglist\fP)
.br
Window \fIw\fP;
.br
Targ *\fIarglist\fP;
.br
.FN
.IP \fIw\fP 1i
Specifies the window ID of the tool.
.IP \fIarglist\fP 1i
Specifies a variable length argument list. 
.LP
For a complete list of valid argument types,
see Table 12, Warning Form Arguments.
.LP
To destroy a warning/problem form, use 
.PN TDestroyWarnForm .
The definition for this function is:
.FD 0
TDestroyWarnForm(\fIw\fP)
.br
Window \fIw\fP;
.br
.FN
.IP \fIw\fP 1i
Specifies the window ID of the tool.
.LP
.PN TDestroyWarnForm
deletes a warning form, including the form's window and the OpaqueFrame
structure associated with it.
.NH 2
Making Forms
.LP
Interactive forms are not tool objects in the same sense of other
tools (command buttons and menus). Rather, this set
of routines provides the mechanism for building new classes of
form tools.  The help form and warning form are two examples of
tool classes built with these procedures.
.LP
To create a new form class, an application program creates a set
of tools to be contained within the form. The application also
creates a hint array, containing for each tool, size and location
hints, and (optional) values.
.LP
A form is created by calling a 
.PN TMakeForm 
function and passing an
array of tools and of placement hints, a parent window, and the
form layout manager to handle the layout. Event handling for
individual tools will remain within those tools. The layout
manager will handle events on a form-wide basis, such as resizing
and exposure events.
.LP
The \*(XT provides functions with which you can make (create)
forms.
This section discusses how to:
.IP \(bu 5
Create custom forms
.IP \(bu 5
Map custom form
.IP \(bu 5
Arrange custom form subtools
.IP \(bu 5
Layout custom form
.IP \(bu 5
Set custom from attributes
.IP \(bu 5
Get custom form attributes
.IP \(bu 5
Add a tool to a custom form
.IP \(bu 5
Destroy custom forms
.LE
.LP
To create a custom form, use 
.PN TMakeForm .
The definition for this function is:
.FD 0
TMakeForm(\fIparent\fP, \fItools\fP, \fIhints\fP, \fIformatter\fP, \fIarglist\fP)
.br
Window \fIparent\fP;
.br
Window *\fItools\fP;
.br
FormLayoutHints **\fIhints\fP;
.br
FormFormatter \fIformatter\fP;
.br
Targ *\fIarglist\fP;
.br
.FN
.IP \fIparent\fP 1i
Specifies the parent window ID of the tool.
.IP \fItools\fP 1i
Specifies an array of tool windows.
.IP \fIhints\fP 1i
Specifies an array of tool location and size information.
.IP \fIformatter\fP 1i
Specifies a form formatter procedure.
.IP \fIarglist\fP 1i
Specifies a variable length argument list. 
.LP
Given a set of tools and tool location/size hints, 
.PN TMakeForm
builds an interactive form. 
The form is only created, it is not displayed.
For a complete list of valid argument types,
see Table 13, Form Tool Arguments.
For a complete list of valid format hints,
see Table 14, Format Hints.
.LP
Table 13: Form Tool Arguments
.ps 8
.TS H
l l l .
_
.sp 6p
.TB
Name	Type	Description
.sp 6p
_
.sp 6p
.TH
.R
T_FORM_TOOLS	window *	Array of windows
T_FORM_HINTS	FormLayoutHints **	Array of tool geometry structures
T_FORM_FORMATTER	int (*proc)()	Optional formatting procedure
T_FORM_BORDER	int	Color index to be used for border
T_FORM_BACKGROUND	int	Color index to be used for background
T_FORM_BDRWIDTH	int	Width of border
T_FORM_WIDTH	int	Width of form
T_FORM_HEIGHT	int	Height of form
T_FORM_X	int	X location of form on display
T_FORM_Y	int	Y location of form on display
.sp 6p
_
.TE
.ps 10
.LP
Table 14: Format Hints
.ps 8
.TS H
l l l .
_
.sp 6p
.TB
Name	Type	Description
.sp 6p
_
.sp 6p
.TH
.R
AbsoluteX	enum	Offset from parent's origin
UnchangedX	enum	Same X as previous tool
RelativeX	enum	Offset from last tool's X position
CenterX	enum	Center tool horizontally in parent window

AbsoluteY	enum	Offset from parent's origin
UnchangedY	enum	Same Y as previous tool
RelativeY	enum	Offset from last tool's Y position
CenterY	enum	Center tool vertically in parent window

AbsoluteW	enum	Use specified width
UnchangedW	enum	Same width as previous tool
CurrentW	enum	Use current width of tool
ParentW	enum	Extend full width of parent
ParentRight	enum	Extend to right border of parent

AbsoluteH	enum	Use specified height
UnchangedH	enum	Same height as previous tool
CurrentH	enum	Use current height of tool
ParentH	enum	Extend full height of parent
ParentBottom	enum	Extend to bottom border of parent
.sp 6p
_
.TE
.ps 10
.LP
To map a custom form, use 
.PN DisplayForm .
The definition for this function is:
.FD 0
DisplayForm(\fIw\fP)
.br
Window \fIw\fP;
.br
.FN
.IP \fIw\fP 1i
Specifies the window ID of the tool.
.LP
.PN DisplayForm
maps the form and all subwindows to the display.
.LP
To arrange subtools for a custom form, use 
.PN BaseFormatter .
The definition for this function is:
.FD 0
BaseFormatter(\fIf\fP)
.br
FormData \fIf\fP;
.br
.FN
.IP \fIf\fP 1i
Specifies a form data structure.
.LP
.PN BaseFormatter
arranges the various subtools in the form according
to the hints contained in the form data structure and
maps all the tools (excluding the parent). 
The formatter can be used to rearrange the form as well.
.LP
.PN 
.LP
To provide layout hints for a custom form, use 
.PN MakeFormLayoutHints .
The definition for this function is:
.FD 0
MakeFormLayoutHints(\fIxOption\fP, \fIx\fP, \fIyOption\fP, \fIy\fP, \fIwOption\fP, \fIw\fP, \fIhOption\fP, \fIh\fP)
.br
enum XLayoutHints \fIxOption\fP;
.br
enum XLayoutHints \fIyOption\fP;
.br
enum XLayoutHints \fIwOption\fP;
.br
enum XLayoutHints \fIhOption\fP;
.br
.FN
.IP \fIxOption\fP 1i
Specifies the horizontal location hint for the form.
.IP \fIx\fP 1i
Specifies the horizontal offset for the form.
.IP \fIyOption\fP 1i
Specifies the vertical location hint for the form.
.IP \fIy\fP 1i
Specifies the vertical offset for the form.
.IP \fIwOption\fP 1i
Specifies the width hint for the form.
.IP \fIw\fP 1i
Specifies the width offset for the form.
.IP \fIwOption\fP 1i
Specifies the width hint for the form. 

.IP \fIh\fP 1i
Specifies the height offset for the form.
.LP
.PN MakeFormLayoutHints
takes a set of hints and dimensional attributes for a
tool and puts them in a data structure for the form creation routine.
(Hints and offsets can be used in combination to provide additional
flexibility in laying out a form. For example, providing an X
offset with a centering hint causes a tool to be centered about the offset.)
.LP
To set attributes for a custom form, use 
.PN TSetFormAttr .
The definition for this function is:
.FD 0
TSetFormAttr(\fIw\fP, \fIarglist\fP)
.br
Window \fIw\fP;
.br
Targ *\fIarglist\fP;
.br
.FN
.IP \fIw\fP 1i
Specifies the window ID of the tool.
.IP \fIarglist\fP 1i
Specifies a variable length argument list. 
.LP
For a complete list of valid argument types,
see Table 13, Form Tool Arguments.
.LP
To get (return) attributes for a custom form, use 
.PN TGetFormAttr .
The definition for this function is:
.FD 0
TGetFormAttr(\fIw\fP, \fIarglist\fP)
.br
Window \fIw\fP;
.br
Targ *\fIarglist\fP;
.br
.FN
.IP \fIw\fP 1i
Specifies the window ID of the tool.
.IP \fIarglist\fP 1i
Specifies a variable length argument list. 
.LP
For a complete list of valid argument types,
see Table 13, Form Tool Arguments.
.LP
To add a tool to a custom form, use 
.PN TAddToForm .
The definition for this function is:
.FD 0
TAddToForm(\fIw\fP, \fIarglist\fP)
.br
Window \fIw\fP;
.br
Targ *\fIarglist\fP
.FN
.IP \fIw\fP 1i
Specifies the window ID of the tool.
.IP \fIarglist\fP 1i
Specifies a variable length argument list. 
.LP
For a complete list of valid argument types,
see Table 15, Form Arguments.
.LP
Table 15: Form Arguments
.ps 8
.TS H
l l l .
_
.sp 6p
.TB
Name	Type	Description
.sp 6p
.TH
.R
T_FORMITEM_WIDTH	int	Width of the tool
T_FORMITEM_HEIGHT	int	Height of the tool
T_FORMITEM_X	int	Horizontal offset of the tool
T_FORMITEM_Y	int	Vertical offset of the tool
T_FORMITEM_W_HINT	int	Width constraint
T_FORMITEM_H_HINT	int	Height constraint 
T_FORMITEM_X_HINT	int	Horizontal position constraint
T_FORMITEM_Y_HINT	int	Vertical position constraint
.sp 6p
_
.TE
.ps 10
.LP
To destroy a custom form, use 
.PN TDestroyForm .
The definition for this function is:
.FD 0
TDestroyForm(\fIw\fP)
.br
Window \fIw\fP;
.br
.FN
.IP \fIw\fP 1i
Specifies the window ID of the tool.
.LP
.PN TDestroyForm
deletes the tools within the form, as well as the form's window
and the OpaqueFrame structure associated with it.
.bp
.\".U7
.\".UT "Paned Window Tools" 8
.ds XT XToolkit
.ds CF Pre-Release Draft
.NH 1
Paned Window Tools
.LP
Paned windows are a major organizing device for application programs. Paned 
windows consist of an overall frame.  Within the
window frame, the tiled subwindows can be added, removed, and
varied in height, both by the user and by the program.  The
subwindows extend the full width of the window frame.  The
subwindows within a paned window frame are completely general.
They typically are used as variable windows for text or graphics
editing and for other applications where a user would want direct
control over the relative size of windows.
.LP
This chapter discusses how to create:
.IP \(bu 5
Horizontally organized paned windows
.IP \(bu 5
Vertically organized paned windows
.NH 2
Horizontally Organized Paned Windows
.LP
The \*(XT provides functions with which you can create and manipulate
horizontally paned window tools.
This section discusses how to:
.IP \(bu 5
Create horizontally organized paned windows
.IP \(bu 5
Add horizontally organized paned window subtools
.IP \(bu 5
Remove horizontally organized paned window subtools
.IP \(bu 5
Set horizontally organized paned window attributes
.IP \(bu 5
Get horizontally organized paned window attributes
.IP \(bu 5
Delete horizontally organized paned windows
.LP
To create a horizontally organized paned window, use
.PN TMakeHWindowFrame .
The definition for this function is:
.FD 0
Window TMakeHWindowFrame(\fIw\fP)
.br
Window \fIw\fP;
.FN
.IP \fIw\fP 1i
Specifies the window ID of the tool.
.LP
.PN TMakeHWindowFrame
sets up the framework for a horizontally organized paned window.
.LP
To add subwindows to a horizontally organized paned window, use
.PN TAddToHWindowFrame .
The definition for this function is:
.FD 0
Window TAddToHWindowFrame(\fIparent\fP, \fIarglist\fP)
.br
Window \fIparent\fP;
.br
Targ *\fIarglist\fP;
.FN
.IP \fIparent\fP 1i
Specifies the parent window ID of the tool.
.IP \fIarglist\fP 1i
Specifies a variable length argument list. 
.LP
.PN TAddToHWindowFrame
adds a subwindow to the horizontally organized paned window in a particular 
location by readjusting the height of any permitted subwindows within the
specified bounds.
For a complete list of valid argument types,
see Table 16, Paned Window Arguments.
.LP
Table 16: Paned Window Arguments
.ps 8
.TS H
l l l .
_
.sp 6p
.TB
Name	Type	Description
.sp 6p
_
.sp 6p
.TH
.R
T_PANED_WINDOW	Window	Window ID of the entry's tool window
T_PANED_ORIENT	int	HORIZONTAL or VERTICAL
T_PANED_POSITION	int	Rank order of subwindow 
		(left to right or top to bottom)
T_PANED_HEIGHT	int	Starting height (vertically tiled windows only)
T_PANED_WIDTH	int	Starting width (horizontally tiled windows only)
T_PANED_MIN	int	Minimum height/width
T_PANED_MAX	int	Maximum height/width
T_PANED_AUTOCHANGE	int	Allow programs to change subwindow size (Yes/No)
T_PANED_BRCOLOR	int	Border color for subwindow
T_PANED_BACKGROUND	int	Background color for subwindow
.sp 6p
_
.TE
.ps 10
.LP
To remove subwindows from a horizontally organized paned window, use
.PN TDeleteFromHWindowFrame .
The definition for this function is:
.FD 0
TDeleteFromHWindowFrame(\fIw\fP)
.br
Window \fIw\fP;
.FN
.IP \fIparent\fP 1i
Specifies the parent window ID of the tool.
.IP \fIsw\fP 1i
Specifies the ID of the tool subwindow.
.LP
.PN TDeleteFromHWindowFrame
removes a subwindow from the horizontally organized paned window 
and readjust any permitted subwindows within their specified bounds.
.LP
To set attributes for a horizontally organized paned window, use
.PN TSetHPanedAttr .
The definition for this function is:
.FD 0
TSetHPanedAttr(\fIw\fP, \fIarglist\fP)
.br
Window \fIw\fP;
.br
Targ \fIarglist\fP;
.FN
.IP \fIw\fP 1i
Specifies the window ID of the tool.
.IP \fIarglist\fP 1i
Specifies a variable length argument list. 
.LP
For a complete list of valid argument types,
see Table 16, Paned Window Arguments.
.LP
To get (return) attributes for a horizontally organized paned window, use
.PN TGetHPanedAttr .
The definition for this function is:
.FD 0
TGetHPanedAttr(\fIw\fP, \fIarglist\fP)
.br
Window \fIw\fP;
.br
Targ *\fIarglist\fP;
.FN
.IP \fIw\fP 1i
Specifies the window ID of the tool.

.IP \fIarglist\fP 1i
Specifies a variable length argument list. 
.LP
For a complete list of valid argument types,
see Table 16, Paned Window Arguments.
.LP
To delete frames from a horizontally organized paned window, use
.PN TDeleteHWindowFrame .
The definition for this function is:
.FD 0
TDeleteHWindowFrame(\fIw\fP)
.br
Window \fIw\fP;
.FN
.IP \fIw\fP 1i
Specifies the window ID of the tool.
.LP
.PN TDeleteHWindowFrame
deletes the paned window frame, including the OpaqueFrame structure
associated with it.
.NH 2
Vertically Organized Paned Windows
.LP
The \*(XT provides functions with which you can create and manipulate
vertically paned window tools.
This section discusses how to:
.IP \(bu 5
Create vertically organized paned windows
.IP \(bu 5
Add vertically organized paned window subtools
.IP \(bu 5
Remove vertically organized paned window subtools
.IP \(bu 5
Set vertically organized paned window attributes
.IP \(bu 5
Get vertically organized paned window attributes
.IP \(bu 5
Delete vertically organized paned windows
.LP
To create a vertically organized paned window, use
.PN TMakeVWindowFrame .
The definition for this function is:
.FD 0
Window TMakeVWindowFrame(\fIw\fP)
.br
Window \fIw\fP;
.FN
.IP \fIw\fP 1i
Specifies the window ID of the tool.
.LP
.PN TMakeVWindowFrame
sets up the framework for a vertically organized paned window.
.LP
To add subwindows to a vertically organized paned window, use
.PN TAddToVWindowFrame .
The definition for this function is:
.FD 0
Window TAddToVWindowFrame(\fIparent\fP, \fIarglist\fP)
.br
Window \fIparent\fP;
.br
Targ *\fIarglist\fP;
.FN
.IP \fIparent\fP 1i
Specifies the parent window ID of the tool.
.IP \fIarglist\fP 1i
Specifies a variable length argument list. 
.LP
.PN TAddToVWindowFrame
adds a subwindow to the vertically organized paned window in a particular 
location by readjusting the height of any permitted subwindows within the
specified bounds.
For a complete list of valid argument types,
see Table 16, Paned Window Arguments.
.LP
To remove subwindows from a vertically organized paned window, use
.PN TDeleteFromVWindowFrame .
The definition for this function is:
.FD 0
TDeleteFromVWindowFrame(\fIw\fP)
.br
Window \fIw\fP;
.FN
.IP \fIparent\fP 1i
Specifies the parent window ID of the tool.
.IP \fIsw\fP 1i
Specifies the ID of the tool subwindow.
.LP
.PN TDeleteFromVWindowFrame
removes a subwindow from the vertically organized paned window 
and readjust any permitted subwindows within their specified bounds.
.LP
To set attributes for a vertically organized paned window, use
.PN TSetVPanedAttr .
The definition for this function is:
.FD 0
TSetVPanedAttr(\fIw\fP, \fIarglist\fP)
.br
Window \fIw\fP;
.br
Targ \fIarglist\fP;
.FN
.IP \fIw\fP 1i
Specifies the window ID of the tool.
.IP \fIarglist\fP 1i
Specifies a variable length argument list. 
.LP
For a complete list of valid argument types,
see Table 16, Paned Window Arguments.
.LP
To get (return) attributes for a vertically organized paned window, use
.PN TGetVPanedAttr .
The definition for this function is:
.FD 0
TGetVPanedAttr(\fIw\fP, \fIarglist\fP)
.br
Window \fIw\fP;
.br
Targ \fIarglist\fP;
.FN
.IP \fIw\fP 1i
Specifies the window ID of the tool.

.IP \fIarglist\fP 1i
Specifies a variable length argument list. 
.LP
For a complete list of valid argument types,
see Table 16, Paned Window Arguments.
.LP
To delete frames from a vertically organized paned window, use
.PN TDeleteVWindowFrame .
The definition for this function is:
.FD 0
TDeleteVWindowFrame(\fIw\fP)
.br
Window \fIw\fP;
.FN
.IP \fIw\fP 1i
Specifies the window ID of the tool.
.LP
.PN TDeleteVWindowFrame
deletes the paned window frame, including the OpaqueFrame structure
associated with it.
