/*
 *	Character type
 */
#define	_U	0x01	/* Upper case	*/
#define	_L	0x02	/* Lower case	*/
#define	_N	0x04	/* Number	*/
#define	_S	0x08	/* White space	*/
#define _P	0x10	/* Punctuation	*/
#define _C	0x20	/* Control char	*/
#define _X	0x40	/* Hex digit	*/
/****		0x80 */	/* Undefined	*/

extern	char	_ctype_[];

#define	isalpha(c)	((_ctype_+1)[c]&(_U|_L))
#define	isupper(c)	((_ctype_+1)[c]&_U)
#define	islower(c)	((_ctype_+1)[c]&_L)
#define	isdigit(c)	((_ctype_+1)[c]&_N)
#define	isxdigit(c)	((_ctype_+1)[c]&(_N|_X))
#define	isspace(c)	((_ctype_+1)[c]&_S)
#define ispunct(c)	((_ctype_+1)[c]&_P)
#define isalnum(c)	((_ctype_+1)[c]&(_U|_L|_N))
#define isprint(c)	((_ctype_+1)[c]&(_P|_U|_L|_N))
#define iscntrl(c)	((_ctype_+1)[c]&_C)
#define isascii(c)	((unsigned)(c)<=0x7f)
#define toupper(c)	(islower(c) ? ((c)-'a'+'A') : (c))
#define tolower(c)	(isupper(c) ? ((c)-'A'+'a') : (c))
#define toascii(c)	((c)&0x7f)
