	; This program queries user for various EPSON MX-80FT
	; modes and sets them accordingly.
	; Written by James R. Hossenlopp 9/5/1982
	; 3465 Big Ridge Road, Spencerport, N.Y. 14559
	; for general CPM systems
cout 	equ	0002	; Console out function
cin	equ	0001	; Console in function
string	equ 	0009	; String output function
BDOS    equ     0005    ; Standard CPM entry
PRINT   equ     0005    ; List output function
READBUF equ	000ah	; Read console buffer function
	org 100h	; set for com file
	LXI H,0		; SAVE CPM ORIGINAL STACK FOR SMOOTH RETURN
	DAD SP
	SHLD OLDSP
	LXI SP,STKTOP
	lxi d,intro	; List Header
	call pmsg	; send string 

	lxi d,double	; Query double strike
	call pmsg
	call conin	; yes or no ( Y or N )
	cpi 'Y'
	jz yesds
	cpi 'y'
	jz yesds
	lxi d,nn	; no
	call pmsg
	mvi c,1bh	; escape
	call list
	mvi c,'H'	; turn off double strike 
	call list
	jmp next1
yesds:	lxi d,yy
	call pmsg	; yes
	mvi c,1bh
	call list
	mvi c,'G'	; turn on double strike
	call list

next1:	lxi d,comp	; Query compressed
	call pmsg
	call conin
	cpi 'Y'
	jz yescom
	cpi 'y'
	jz yescom
	lxi d,nn
	call pmsg
	mvi c,146	; turn off compressed mode
	call list
	jmp next2
yescom:	lxi d,yy
	call pmsg
	mvi c,15	; turn on compressed mode
	call list

next2:  lxi d,dbw	; Query double width
	call pmsg
	mvi c,1BH	; double width lead-in (Graftrax +)
	call list
	mvi c,'W'
	call list
	call conin
	cpi 'Y'
	jz yesdbw
	cpi 'y'
	jz yesdbw
	lxi d,nn
	call pmsg
	mvi c,0		; turn double width off (Graftrax +)
	call list
	jmp next3
yesdbw:	lxi d,yy
	call pmsg
	mvi c,1		; turns on double width (Graftrax +)
	call list

next3:	lxi d,emp	; Query emphasized
	call pmsg
	call conin
	cpi 'Y'
	jz yesemp
	cpi'y'
	jz yesemp
	lxi d,nn
	call pmsg
	mvi c,1bh
	call list
	mvi c,'F'	; turns off emphasized mode
	call list
	jmp next5
yesemp:	lxi d,yy
	call pmsg
	mvi c,1bh
	call list
	mvi c,'E'	; turns on emphasized mode
	call list

next5:	lxi d,italic	; Query italicized 
	call pmsg
	call conin
	cpi 'y'
	jz yesita
	cpi 'Y'
	jz yesita
	lxi d,nn
	call pmsg
	mvi c,1bh
	call list
	mvi c,'5'
	call list

next10:	lxi d,papout	; Query paper out sensor option
	call pmsg
	mvi c,1bh	; Start escape sequence
	call list
	call conin
	cpi 'y'
	jz igpout
	cpi 'Y'
	jz igpout
	lxi d,nn
	call pmsg
	mvi c,'9'	; Enable paper out sensor
	call list

next11:	nop		; was perf skip but setting top of form seemed
			; to cancel it.

next12:	lxi d,0ffffh	; Pause before repainting header
lll:	dcr e
	nop
	nop
	nop
	nop
	jnz lll
	dcr d
	jnz lll

	lxi d,intro	;Repaint header
	call pmsg
	lxi d,norm	; Normal line feed?
	call pmsg
	call conin
	cpi 'n'
	jz next6
	cpi 'N'
	jz next6
	lxi d,yy
	call pmsg
	mvi c,1bh	
	call list
	mvi c,'A'
	call list
	mvi c,12
	call list
;	mvi c,1bh	; Remove for Graftrax80
;	call list
;	mvi c,'2'
;	call list
	MVI 	C,1BH	; SET FORM TO 66 LINES
	CALL	LIST
	MVI	C,'C'
	CALL	LIST
	MVI	C,66
	CALL	LIST
	jmp cpm

next6:	lxi d,nn	; One and 1/2 line feed?
	call pmsg
	lxi d,half1	
	call pmsg
	call conin
	cpi 'y'
	jz next7
	cpi 'Y'
	jz next7
	lxi d,nn
	call pmsg

spc2:	lxi d,space2	; Double spaced?
	call pmsg
	call conin
	cpi 'y'
	jz next8
	cpi 'Y'
	jz next8
	lxi d,nn
	call pmsg

cmplf:	lxi d,complf	; Compressed line feed?
	call pmsg
	call conin
	cpi 'y'
	jz next9
	cpi 'Y'
	jz next9
	lxi d,nn
	call pmsg

cpm:    lxi d,perf	; Query auto form feed before perforations
	call pmsg
	mvi c,1bh	; Start escape sequence
	call list
	call conin
	cpi 'y'
	jz yperf
	cpi 'Y'
	jz yperf
	lxi d,nn
	call pmsg
	mvi c,'O'	; Disable auto jump over perforations
	call list

cpm1:	mvi a,0dh	; All Done !
	call conout
	mvi a,0ah
	call conout
	LHLD OLDSP
	SPHL
	RET		; return to CPM

next7:	lxi d,yy	; Set 1&1/2 line feed.
	call pmsg
	mvi c,1bh
	call list
	mvi c,'A'
	call list
	mvi c,18
	call list
;	mvi c,1bh	; Remove for Graftrax80
;	call list
;	mvi c,'2'
;	call list
	MVI	C,1BH	; SET FORM TO 44 LINES
	CALL	LIST
	MVI	C,'C'
	CALL	LIST
	MVI	C,44
	CALL	LIST
	jmp cpm

next8:	lxi d,yy	; Set double spaced line feeds
	call pmsg
	mvi c,1bh
	call list
	mvi c,'A'
	call list
	mvi c,24
	call list
;	mvi c,1bh	; Remove for Graftrax80
;	call list
;	mvi c,'2'
;	call list
	MVI	C,1BH	; SET FORM TO 33 LINES
	CALL	LIST
	MVI	C,'C'
	CALL	LIST
	MVI	C,33
	CALL	LIST
	jmp cpm

next9:	lxi d,yy	; Set compressed line feed
	call pmsg
	mvi c,1bh
	call list
	mvi c,'1'
	call list
	MVI	C,1BH	; SET FORM TO 113 LINES
	CALL	LIST	; NOT EXACTLY A FULL FORM
	MVI	C,'C'	; FORM = 113.14286
	CALL	LIST
	MVI	C,113
	CALL	LIST
	jmp cpm

yesita:	lxi d,yy	; Yes send italics command
	call pmsg
	mvi c,1bh
	call list
	mvi c,'4'
	call list
	jmp next10

igpout:	lxi d,yy	; Yes disable paper out sensor
	call pmsg
	mvi c,'8'	; ignore paper out sensor
	call list
	jmp next11

yperf:	lxi d,yy	; Yes jump over perforations
	call pmsg
	mvi c,'N'
	call list
	mvi c,3		; Jump by three (3) lines
	call list
	jmp cpm1

conout:	PUSH B
	PUSH D
	PUSH H
	MOV E,A		; PASS CHAR. IN "E" FOR CPM CALL
	MVI C,cout	; CONSOLE OUT FUNCTION CALL
	CALL BDOS
	POP H
	POP D
	POP B
	RET


conin:	MVI C,cin	; CONSOLE IN FUNCTION CALL
	CALL BDOS
	RET

PMSG:	MVI C,string	; STRING OUTPUT FUNCTION CALL
	CALL BDOS
	RET

list:	PUSH B
	PUSH D
	PUSH H
	MOV E,C		; PASS CHAR. IN "E" FOR CPM CALL
	MVI C,PRINT	; LIST DEVICE FUNCTION CALL
	CALL BDOS
	POP H
	POP D
	POP B
	RET

NOCR:	LDAX D		; SIMILAR TO STRING ROUTINE BUT DOES NOT
	CPI '$'		; AUTOMATICALLY SEND CR AT END OF STRING
	RZ
	CALL CONOUT
	INX D
	JMP NOCR

intro	db 0CH,1AH,'Epson MX80-F/T with Graftrax +  Set-up Program',13,10
	db 'Answer questions yes or no by entering ( Y or N )',13,10
	db '  Just entering Carriage Return will enter default value { }$'
comp	db 13,10,10,'     Compressed Mode? ( Y or {N} )  ==>$'
double	db 13,10,10,'     Double Strike Mode? ( Y or {N} )  ==>$'
dbw	db 13,10,10,'     Double Width Mode? ( Y or {N} )  ==>$'
emp	db 13,10,10,'     Emphasized Mode? ( Y or {N} )  ==>$'
nn	db 13,'No,$'
yy	db 13,'Yes,$'
norm	db 13,10,10,'     Normal Line Feed? ( {Y} or N )  ==>$'
half1	db 13,10,10,'     1&1/2 Normal Line Feed? ( Y or {N} )  ==>$'
space2	db 13,10,10,'     Double Line Feed? ( Y or {N} )  ==>$'
complf	db 13,10,10,'     Compressed Line Feed? ( Y or {N} )  ==>$'
italic	db 13,10,10,'     Italicized Mode? ( Y or {N} )  ==>$'
papout	db 13,10,10,'     Ignore Paper Out Sensor? ( Y or {N} )  ==>$'
perf	db 13,10,10,'     Skip Over Page Perforation? ( Y or {N} ) '
	db 13,10,'       provides auto formfeed at page length - three lines'
	db 13,10,'       answer here please  ==>$'
BUFF:	DS 32		; CONSOLE BUFFER
OLDSP:	DS 2
	DS 64		; STACK AREA, 32 LEVEL
STKTOP: DS 2
	end
 
