/* copyright (c) 1982	Peter Baker */

#include <stdio.h>

/*
 *   Replace blanks by tabs using standard input and output.
 * 
 *   Heavily derived from Software Toolworks by Kernighan and Plauger.
 */

#define BOOLEAN	int
#define MAXLINE	133
#define BLANK	' '
#define TAB		0X09
#define NEWLINE '\n'

main( argc, argv)
char *argv[];
int argc;
{
	int c;				/* int because it has to be able to hold EOF */
	int col, i, newcol;
	BOOLEAN  tabpos();
	BOOLEAN	 tabs[MAXLINE];
	int tabsize;		/* tab at every tabsize'th column */

	if( argc > 1 )
	{
		if( *(argv[1]+1) == 'T' )
			tabsize = atoi( argv[1]+2 );
		else
			tabsize = 8;
	}
	else
		tabsize = 8;

	settab( tabs, tabsize );

	col = 1;
	while( 1 )			/* repeat until break */
	{
		newcol = col;
		while( (c = getchar()) == BLANK )		/* collect blanks */
		{
			newcol++;
			if( tabpos( newcol, tabs ) )
			{
				putchar( TAB );
				col = newcol;
			}
		}
		while( col < newcol )
		{
			putchar( BLANK );				/* output leftover blanks */
			col++;
		}
		if( c == EOF )
			break;
		putchar( c );
		if( c == NEWLINE )
			col = 1;
		else
			col++;
	}
}

/*
 * example: if tabsize == 8 then tab stops will be at:
 *	1 9 17 25 33 ...
 */
settab( tabs, tabsize )
char *tabs;
int tabsize;
{
	int i;

	for( i = 1 ; i < MAXLINE ; i++ )
		if( (i % tabsize) == 0 )
			tabs[i+1] = true;
		else
			tabs[i+1] = false;
}

BOOLEAN tabpos( col, tabs )
char *tabs;
int col;
{
	if( col > MAXLINE )
		return( true );
	else
		return( tabs[col] );
}
/

	if( argc > 1 )
	{
		if( *(argv[1]+1) == 'T' )
			tabsize = atoi( argv[1]+2 );
		else
	