#include <stdio.h>

/* copyright (c) 1982	Peter Baker */

/* cp - copy from one file to another */
/*      optionally copy a binary file ( -b option ) */

char use[] = "\nUsage: cp [-b] fromfile tofile\n";

main( argc, argv )
char *argv[];
int argc;
{
	FILE infile, outfile;
	int binfile;
	char c;

	if( argc < 3 )
		error( use );		/* error exits! */
	if( *argv[1] == '-' )
	{
		if( argc != 4 )
			error( use );	/* error exits! */
		if( *(argv[1]+1) == 'B' )		/* 'b' for unix systems!!! */
			binfile = true;
		else
			error( use );	/* error exits! */
	}
	else
		binfile = false;

	if( binfile )
		infile = fopen( argv[2], "rb" );
	else
		infile = fopen( argv[1], "r" );

	if( infile == 0 )
		error( "\nCannot open input file\n" );

	if( binfile )
		outfile = fopen( argv[3], "wb" );
	else
		outfile = fopen( argv[2], "w" );
	if( outfile == 0 )
	{
		fclose( infile );
		error( "\nCannot open output file\n" );
	}

	while( ( c = getc( infile ) ) != EOF )
		putc( c, outfile );

	fclose( infile );
	fclose( outfile );
}


error( msg )
char *msg;
{
	printf( msg );
	exit( -1 );
}
nally copy 