/*
 *   New multiplexed file driver   --   Ross Nealon.
 */

#define		NCHAN		64		/* max # of chans */
#define		NMXCHAN		16		/* max chans/mx file */
#define		NMXF		5		/* max # of multiplexed files */

#define		MXTHRESH	1		/* max data msgs buffered */
#define		MXMAXMSG	512		/* max size of message */

#define		DEAD(dev)	(minor(dev) == NMXF)


struct	mxf	{				/* multiplexed file */
	short	mx_flags;			/* mode of this mx file */
	short	mx_nchan;			/* chans open/active */
	struct	mxchan	*mx_chan[NMXCHAN];	/* pointers into chan table */
	struct	inode	*mx_ip;			/* incode inode for mx file */
	};

struct	hdr	{				/* data record header */
	short	hd_index;			/* chan number */
	short	hd_msg;				/* msg from mx driver */
	short	hd_length;			/* length of data message */
	};

struct	mxmsg	{
	struct	hdr	m_h;			/* message header */
	struct	mxmsg	*m_link;		/* chain */
	char	m_data[ ];			/* following data pattern */
	};

struct	message	{				/* data message format */
	struct	hdr	hd;			/* header: who sent it */
	char	data[ ];			/* form of message data */
	};


#define		MXALLOC		0x0001		/* chan struct is used */
#define		MXTTY		0x0002		/* chan connection is to tty */
#define		MXCLOSED	0x0040		/* closef already done */
#define		MXSLEEP		0x0080		/* someone sleeping here */
#define		MXERROR		0x0400		/* chan error occurred */


/*
 *   System call function
 */
#define		MXSCREATE	1		/* sys call - create */
#define		MXSATTACH	2		/* sys call - attach */
#define		MXSDETACH	3		/* sys call - detach */


/*
 *   Control messages
 */
#define		M_DATA		0		/* normal data message */
#define		M_WATCH		1		/* wanting to open */
#define		M_CLOSE		2		/* has closed chan */
#define		M_EOF		3		/* end-of-file occured */
#define		M_IOCTL		4		/* ioctl sys call */
