h20120
s 00186/00127/00232
d D 1.3 82/09/13 13:42:32 ross 3 2
c Use Auto Channel Driver for input and output.
c Add code to make work with a Quad Sync. Adapter.
e
s 00000/00000/00359
d D 1.2 82/09/13 12:04:34 ross 2 1
c 
e
s 00359/00000/00000
d D 1.1 82/09/13 10:28:58 ross 1 0
e
u
U
t
T
I 1
/*
 *		Synchronous Data Set Adapter driver
 *
D 3
 *	- uses Autodriver Channel for output
E 3
I 3
 *	- uses Autodriver Channel for input & output
E 3
 *
I 3
 *	- for QSA (Quad Synchronous Adapter) #define QSA
 *
E 3
 */

#include "../h/param.h"
#include "../h/conf.h"
#include "../h/tty.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/proc.h"
#include "../h/ccb.h"

I 3
#define	QSA
#define ISIZE	256
#define	OSIZE	256


E 3
extern int	ndsa;		/* number of DSA'S */
extern char	dsaaddr[];	/* DSA addresses */
extern struct tty dsa[];	/* common tty structure */

D 3
#ifdef ACD
int	DOBUF = 0;	/* patch here to turn off acd */
extern struct ccb *dsaccb;		/* output channel control blocks */
E 3
I 3
#define	q1	tp->t_rawq
#define	q2	tp->t_outq

extern struct ccb *dsaccb;		/* channel control blocks */
E 3
extern short isp[];			/* interrupt service ptr table */
D 3
#endif
E 3

D 3
#define LASTC	DKCALL		/* one character left in this input block */
E 3
I 3
char	dsaibuf[ISIZE];
char	dsaobuf[OSIZE];
E 3

D 3
int dsastart(), ttrstrt();
E 3
I 3
int dsastin(), dsastout();
E 3

/*
 * DSA commands & status bits
 */

#define	DIS	0xc0
#define	ENB	0x40
#define PAR	0x20
#define SYNSCH	0x10
I 3
#define RSDTA	0x10
E 3
#define	DTR	0x08
#define	WR	0x02
I 3
#define RQ2S	0x02
E 3
#define RD	0x01
I 3
#define CMD	0x01
E 3

I 3
#define BITS7	0x20
#define BITS8	0x30
#define PODD	0x04
#define PEVEN	0x06

E 3
#define OV		0x80
#define PARF		0x40
#define SYNC		0x20
#define BSY		0x08
#define	EX		0x04
#define	CARR_OFF	0x02
I 3
#define NOT_CL2S	0x02
E 3
#define DU		0x01

I 3
#define RDERR	(OV|PARF|CARR_OFF|DU)
#define WRERR	(OV|BSY|NOT_CL2S|DU)

#define SYN	0x16
#define ETX	0x03
#define PAD	0xff

E 3
/*
 * open routine:
 *	called each time a process opens a DSA as a character file
 *
 *	- set up the initial status
 *	  and arm interrupts
 */
dsaopen(dev)
{
	register struct tty *tp;
I 3
	register struct ccb *ccb;
E 3

	if (minor(dev) >= ndsa) {
		u.u_error = ENXIO;
		return;
	}
	tp = &dsa[minor(dev)];
	if (tp->t_state & ISOPEN) {
		u.u_error = ENXIO;
		return;
	}
	tp->t_state = ISOPEN;
	tp->t_dev = dev;
	tp->t_flags = RAW;
D 3
	tp->t_oproc = dsastart;
#ifdef ACD
	if (DOBUF)
		isp[dsaaddr[minor(dev)] + 1] = (short)&dsaocb[minor(dev)] + 1;
#endif
E 3
I 3
	tp->t_oproc = dsastout;
	tp->t_iproc = dsastin;
	q1.c_cf = q1.c_cl = dsaibuf;
	q1.c_cc = - (ISIZE);
	ccb = &dsaccb[minor(dev)<<1];
	isp[dsaaddr[minor(dev)]] = (short)ccb + 1;
	isp[dsaaddr[minor(dev)] + 1] = (short)(ccb + 1) + 1;
	tp->t_addr = (caddr_t)ccb;
E 3

	dsaenab(tp);
	spl4();
	while (!(tp->t_state&CARR_ON))
D 3
		sleep(&tp->t_rawq, TTIPRI);
E 3
I 3
		sleep((caddr_t)&q1, TTIPRI);
E 3
	spl0();
D 3
	ttyopen(dev, tp);
E 3
I 3
	(*linesw[tp->t_line].l_open)(dev, tp);
E 3
}

/*
 * close routine:
 */
dsaclose(dev)
{
	register struct tty *tp;
	tp = &dsa[minor(dev)];
I 3
	(*linesw[tp->t_line].l_close)(tp);
E 3
	ttyclose(tp);
	dsadisab(dev);
}

/*
 * read, write, ioctl routines:
 */
dsaread(dev)
{
	register struct tty *tp;
	register c;

	tp = &dsa[minor(dev)];
I 3
	if (tp->t_line) {
		(*linesw[tp->t_line].l_read)(tp);
		return;
	}
E 3
	spl4();
D 3
	while (tp->t_rawq.c_cc == 0) {
		if ((tp->t_state & CARR_ON) == 0)
			return(0);
		sleep(&tp->t_rawq, TTIPRI);
E 3
I 3
	while (q1.c_cl == dsaibuf) {
		dsastin(tp);
		sleep((caddr_t)&q1, TTIPRI);
E 3
	}
	spl0();
D 3

	while ((c = getc(&tp->t_rawq)) >= 0) {
		if (passc(c) < 0)
			break;
	}
E 3
I 3
	while (q1.c_cf < q1.c_cl)
		if (passc(*q1.c_cf++) < 0)
			return;
	q1.c_cf = q1.c_cl = dsaibuf;
E 3
}

dsawrite(dev)
{
	register struct tty *tp;
I 3
	register char *p;
E 3
	register c;
I 3
	static char syns[] = SYN, SYN, SYN, SYN, 0;
	static char pads[] = PAD, PAD, 0;
E 3

	tp = &dsa[minor(dev)];
I 3
	if (tp->t_line) {
		(*linesw[tp->t_line].l_write)(tp);
		return;
	}
E 3
	if ((tp->t_state & CARR_ON) == 0)
		return(0);
D 3
	while ((c = cpass()) >= 0)
		putc(c, &tp->t_outq);
	dsastart(tp);
E 3
I 3
	spl4();
	while (q2.c_cc) {
		tp->t_state |= ASLEEP;
		sleep((caddr_t)&q2, TTOPRI);
	}
	spl0();
	q2.c_cf = q2.c_cl = dsaobuf;
	for (p = syns; (c = *p); p++)
		*q2.c_cl++ = c;
	while (q2.c_cl < dsaobuf + OSIZE - sizeof pads) {
		if ((c = cpass()) < 0)
			break;
		*q2.c_cl++ = c;
	}
	for (p = pads; (c = *p); p++)
		*q2.c_cl++ = c;
	q2.c_cc = q2.c_cf - q2.c_cl;
	spl4();
	dsastout(tp);
	spl0();
E 3
}

dsaioctl(dev, cmd, addr, flag)
caddr_t addr;
{
	register struct tty *tp;

	tp = &dsa[minor(dev)];
D 3
	u.u_error = ENOTTY;
	return;
E 3
I 3
	if (ttioccom(cmd, tp, addr, dev) == 0)
		u.u_error = ENOTTY;
E 3
}

/*
D 3
 * dsastart routine - called when there might be something to send
 *   to the DSA
E 3
I 3
 * start output to DSA
E 3
 */

D 3
dsastart(atp)
struct tty *atp;
E 3
I 3
dsastout(tp)
register struct tty *tp;
E 3
{
D 3
	register struct tty *tp;
E 3
	register c, waddr;
	register struct ccb *ccb;
I 3
	register char *s;
E 3

D 3
	tp = atp;
E 3
	waddr = dsaaddr[minor(tp->t_dev)] + 1;
trace(8<<16, "dsastart", waddr);
	if ((tp->t_state&(BUSY|CARR_ON)) != CARR_ON
D 3
	    || tp->t_outq.c_cc <= 0)
E 3
I 3
	    || q2.c_cc == 0)
E 3
		return;
	tp->t_state |= BUSY;
I 3
	ccb = (struct ccb *)tp->t_addr + 1;
	if (q2.c_cc > 0) {
		s = dsaobuf;
		s[0] = SYN; s[1] = SYN; s[2] = SYN; s[3] = SYN;
		s += 4;
		s += q_to_b(&q2, s, OSIZE - 6);
		s[0] = PAD; s[1] = PAD;
		s += 1;
		ccb->cc_buf0 = s;
		ccb->cc_cnt0 = dsaobuf - s;
	} else {
		ccb->cc_buf0 = q2.c_cl - 1;
		ccb->cc_cnt0 = q2.c_cf - q2.c_cl + 1;
		q2.c_cc = 0;
	}
	ccb->cc_ccw = (WRERR<<8) | CCEX | CCWR | CCFAST;
#ifdef QSA
	oc(waddr, ENB | RSDTA | DTR | RQ2S | CMD);
	if ((ss(waddr)&BSY) == 0)
		wd(waddr, PAD);
#else
E 3
	wd(waddr, -1);
	oc(waddr, ENB | PAR | DTR | WR);
D 3
trace(8<<16, "wrt", ss(waddr));
#ifdef ACD
	if (DOBUF) {
		ccb = &dsaccb[minor(tp->t_dev)];
		if (dsaputc(tp, ccb))
			ccb->cc_ccw = 0x85;
	}
E 3
#endif
I 3
trace(8<<16, "wrt", ss(waddr));
	if ((tp->t_state&ASLEEP) && q2.c_cc == 0)
		wakeup((caddr_t)&q2);
E 3
}

dsastop(tp)
register struct tty *tp;
{
	register struct ccb *ccb;
	register n;

trace(8<<16, "dsstop", tp->t_dev);
D 3
#ifdef ACD
	if (!DOBUF)
		return;
	ccb = &dsaccb[minor(tp->t_dev)];
	if ((n = ccb->cc_cnt1 + ccb->cc_cnt0 - 1) > 0)
		ndflush(&tp->t_outq, n);
E 3
I 3
	ccb = (struct ccb *)tp->t_addr + 1;
E 3
	ccb->cc_cnt1 = 0;
	ccb->cc_ccw = 0;
D 3
#endif
E 3
}

D 3
#ifdef ACD
E 3
/*
D 3
 * Set up ccb to continue output
E 3
I 3
 * start input from DSA
E 3
 */
D 3
dsaputc(tp, ccb)
E 3
I 3
dsastin(tp)
E 3
register struct tty *tp;
D 3
register struct ccb *ccb;
E 3
{
D 3
	register n;
E 3
I 3
	register struct ccb *ccb;
	register int raddr;
E 3

D 3
trace(8<<16, "dsaputc", ccb->cc_buf1);
	if ((n = ccb->cc_cnt1 = ndqb(&tp->t_outq, 0200)) <= 0)
		return(0);
	n--;
	ccb->cc_cnt0 = -n;
	ccb->cc_buf0 = tp->t_outq.c_cf + n;
trace(8<<16, "ccount", n);
	return(1);
}
E 3
I 3
	raddr = dsaaddr[minor(tp->t_dev)];
	ccb = (struct ccb *)tp->t_addr;
	ccb->cc_buf0 = q1.c_cf + (-q1.c_cc) - 1;
	ccb->cc_cnt0 = q1.c_cc + 1;
	ccb->cc_ccw = (RDERR<<8) | CCEX | CCRD | CCFAST;

#ifdef QSA
	oc(raddr, ENB | SYNSCH | DTR | CMD);
#else
	oc(raddr, ENB | PAR | SYNSCH | DTR);
E 3
#endif
I 3
	rd(raddr);
}
E 3

dsarint(dev, stat)
{
	register int raddr;
	register struct tty *tp;
I 3
	register struct ccb *ccb;
E 3
	register char c;

	tp = &dsa[dev];
	raddr = dsaaddr[dev];

D 3
	if (!(tp->t_state & ISOPEN))
E 3
I 3
	if (!(tp->t_state & ISOPEN)) {
		dsadisab(dev);
E 3
		return;
I 3
	}
E 3
trace(8<<16, "rint", raddr);
trace(8<<16, "stat", stat);

	/*
D 3
	 * SYNC interrupt - nothing to do
	 */
	if (stat & (SYNC|BSY) == (SYNC|BSY))
		return;

	/*
	 * OV interrupt - resynchronise
	 */
	if (stat & OV) {
		oc(raddr, ENB | PAR | SYNSCH | DTR);
		rd(raddr);
		return;
	}

	/*
E 3
	 * Loss of DSR - hangup
	 */
D 3

E 3
	if (stat & DU) {
		if (tp->t_state & CARR_ON) {
			signal(tp->t_pgrp, SIGHUP);
			flushtty(tp);
		}
		tp->t_state &= ~CARR_ON;
		return;
	}
D 3

	c = rd(raddr)&0177;
trace(8<<16, "char", c);
E 3
	if (!(tp->t_state & CARR_ON)) {
		tp->t_state |= CARR_ON;
D 3
		wakeup(&tp->t_rawq);
E 3
I 3
		wakeup((caddr_t)&q1);
	}

	/*
	 * overrun - throw away block and resynchronise
	 */
	if (stat & OV) {
		dsastin(tp);
E 3
		return;
	}
D 3
	if (tp->t_rawq.c_cc > 512)
		flushtty(tp);
	putc(c, &tp->t_rawq);
	wakeup(&tp->t_rawq);
	if (tp->t_state & LASTC) {
		tp->t_state &= ~LASTC;
		oc(raddr, ENB | PAR | SYNSCH | DTR | RD);
	} else if (c == '\03')
		tp->t_state |= LASTC;
E 3
I 3

	/*
	 * if BSY still set - no char to read
	 */
	if ((stat & (BSY|CARR_OFF)) == BSY)
		return;

	/*
	 * buffer full or carrier off -- give data to reader
	 */
#ifdef QSA
	oc(raddr, DIS | DTR | CMD);
#else
	oc(raddr, DIS | DTR | RD);
#endif
	ccb = (struct ccb *)tp->t_addr;
	q1.c_cl = ccb->cc_buf0 + ccb->cc_cnt0;
	if (tp->t_line)
		(*linesw[tp->t_line].l_rend)(tp, q1.c_cf, q1.c_cl);
	else
		wakeup((caddr_t)&q1);
E 3
}

dsaxint(dev, stat)
{
	register int waddr;
	register struct tty *tp;
	register c;

	tp = &dsa[dev];
	waddr = dsaaddr[dev] + 1;
D 3
	if (!(tp->t_state & ISOPEN))
E 3
I 3
	if (!(tp->t_state & ISOPEN)) {
		dsadisab(dev);
E 3
		return;
I 3
	}
E 3
trace(8<<16, "wint", waddr);
trace(8<<16, "stat", stat);
D 3
	if ((c = getc(&tp->t_outq)) < 0) {
		tp->t_state &= ~BUSY;
		oc(waddr, DIS | DTR | WR);
E 3
I 3

	if (stat&BSY)
E 3
		return;
D 3
	}
	wd(waddr, c);
trace(8<<16, "wrt", ss(waddr));
#ifdef ACD
	if (DOBUF) {
		ccb = &dsaccb[minor(tp->t_dev)];
		if (dsaputc(tp, ccb))
			ccb->cc_ccw = 0x85;
	}
#endif
E 3

I 3
	tp->t_state &= ~BUSY;
#ifdef QSA
	oc(waddr, DIS | RSDTA | DTR | CMD);
#else
	oc(waddr, DIS | DTR | WR);
#endif
	(*linesw[tp->t_line].l_start)(tp);
E 3
}

D 3
#ifdef ACD
dsaxbint(dev, stat);
{
	register int waddr;
	register struct tty *tp;
	register struct ccb *ccb;

	tp = &dsa[dev];
	waddr = dsaaddr[dev] + 1;
	if (!(tp->t_state & ISOPEN))
		return;
trace(8<<16, "bint", waddr);
trace(8<<16, "stat", stat);
	ccb = &dsaccb[minor(tp->t_dev)];
	ndflush(&tp->t_outq, ccb->cc_cnt1);
	if ((tp->t_state&TTSTOP) || dsaputc(tp, ccb) == 0)
		isp[waddr] = (short)&dsax;
}
#endif

E 3
/*
 * Arm interrupts from DSA and set reading
 */
dsaenab(atp)
struct tp *atp;
{
	register struct tp *tp;
	register radd;
	register stat;

	tp = atp;
	radd = dsaaddr[minor(tp->t_dev)];

I 3
#ifdef QSA
	oc(radd, BITS7 | PODD);
	oc(radd+1, BITS7 | PODD);
	wd(radd, SYN);
	oc(radd, ENB | SYNSCH | DTR | CMD);
#else
E 3
	oc(radd, ENB | PAR | SYNSCH | DTR);
I 3
#endif
E 3
	stat = ss(radd);
	if ((stat&DU) == 0)
		tp->t_state |= CARR_ON;

trace(8<<16, "dsaenab", stat);
	rd(radd);
}

/*
 * Disarm interrupts from DSA
 */
dsadisab(dev)
{
	register radd, wadd;

	radd = dsaaddr[minor(dev)];
	wadd = radd + 1;

I 3
#ifdef QSA
	oc(radd, DIS | CMD);
	oc(wadd, DIS | CMD);
#else
E 3
	oc(radd, DIS);
	oc(wadd, DIS);
I 3
#endif
E 3

trace(8<<16, "dsadisab", ss(radd));
}
E 1
