h51318
s 00000/00000/01814
d D 1.3 82/09/13 12:27:27 ross 3 2
c 
e
s 00002/00015/01812
d D 1.2 82/09/13 10:48:08 ross 2 1
c Faster interrupt processing.
e
s 01827/00000/00000
d D 1.1 82/09/13 10:12:51 ross 1 0
e
u
U
t
T
I 1
*****************************************************************
*								*
*		UNIX Floating-Point Emulation			*
*								*
*		Perkin-Elmer 7/32, 8/32, 3220, 3240		*
*								*
* NOTE:	Only the floating-point instructions of the 7/32 and	*
*	8/32 are emulated, as well as the 3200-series		*
*	instructions 'lde', 'stde' and 'lcdr' which may be	*
*	generated by the C compiler.				*
*	The 3200-series "R*-Rounding" algorithm is not used.	*
*								*
*****************************************************************

	entry	fptrap
	extrn	uisa,lra

*
* The following equates (in param.s) are used to generate single and/or double
* precision versions:
*
*	SPFPT	if 1, simulate single-precision f.p.
*	DPFPT	if 1, simulate double-precision f.p.
D 2
*	LRA	if 1, lra instruction available
E 2
*

* Signal numbers for errors in emulation

SIGSEG	equ	11		memory segmentation error
SIGFPT	equ	8		arithmetic error
SIGINS	equ	4		illegal instruction

r0	equ	0
r1	equ	1
r2	equ	2
r3	equ	3
r4	equ	4
r5	equ	5
r6	equ	6
sp	equ	7
e8	equ	8
e9	equ	9
ea	equ	10
eb	equ	11
ec	equ	12
ed	equ	13
ee	equ	14
ef	equ	15
e9.x	equ	9
ec.s	equ	12
ee.stat	equ	14
ef.loc	equ	15


*	register usage:	r0,r1,r2,r6  	scratch
*			r3	address of users saved r8 ( see reg.h )
*			r4	address of users fp regs in ppda
*			r5	real pc in kernal segment
*			ed	(rd) real destination addr
*

*
* stack data area definition
*
data	struc
handlr	ds	adc
gregs	ds	8*adc
	ends

**********************
*                    *
*   entry sequence   *
*                    *
**********************

*--------------pre-processor

fptrap	equ	*
	shi	sp,data		allocate local variables on stack
	stm	e8,gregs(sp)	save r8-r15 just like c
	lis	r0,SIGINS	set to return error if not fp opcode
*				on first instruction
	st	r0,laflag	look ahead flag
	l	r3,data(sp)	addr of users saved r0 ( see reg.h )
*
	lm	ee.stat,9*adc(r3) old psw
	shi	r3,10*adc	adjust to point to users saved r8
*					so all offsets are +ve
	l	r4,data+4(sp)	pointer to users fp regs
*
fptrap1	equ	*		look ahead entry ( see nofault )
	lr	r1,ef.loc	make pc real wrt kernal seg regs
	l	r2,uisa		segmentation descriptor
D 2
	ifnz	LRA
	lra	r1,0(r2)
	else
E 2
	bal	r6,lra		load real addr
D 2
	endc
E 2
*
	btc	x'd',sigseg	if pc not valid ( not present or 
*					not executable )
	lr	r5,r1		save real pc
*

*--------------the simulated instruction interpretation

	lb	e8,0(r5)	opcode
	lb	ed,1(r5)	r1 & r2 field
	lr	ec.s,ed		r1 into source register
	srls	ec.s,2		r1*4
	ais	ef.loc,2	update location counter
	ais	r5,2		update real pc
	lb	e8,opcodes(e8)	pointer to vector tables
	l	e9,vectab1(e8)	1st level handler pointer
	l	e8,vectab2(e8)	second level handler pointer
	sta	e8,handlr(sp)
	br	e9		go to 1st level handler

****************************
*                          *
*   format preprocessors   *
*                          *
****************************

*--------------register & register instructions

	ifnz	SPFPT
xer	equ	*
	srls	ec.s,1		force r1 to multiple-of-4 boundary
	nhi	ec.s,x'1c'
	ar	ec.s,r4		address of pseudo register
	ar	ed,ed		r2*2
	nhi	ed,x'1c'	force r2 to multiple-of-4 boundary
	ar	ed,r4		address of pseudo-register
go.to.it l	eb,handlr(sp)
	br	eb		go to 2nd level handler


	endc
	ifnz	DPFPT
xdr	equ	*
	nhi	ec.s,x'38'	force r1 to multiple-of-8 boundary
	slls	ed,2		r2*4
	nhi	ed,x'38'	force r2 to multiple-of-8 boundary
	ai	ec.s,32(r4)	make up the register's physical addr
	ai	ed,32(r4)
	l	eb,handlr(sp)
D 2
	br	eb		go to second levle handler
E 2
I 2
	br	eb		go to second level handler
E 2
	endc


*--------------register & memory instruction
	ifnz	SPFPT
xes	equ	*
	lis	r0,1		if store type instruction
	b	xe1
*
xe	equ	*
	lis	r0,0		set load type instruction
xe1	st	r0,lsflag
	srls	ec.s,1		force r1 to multiple-of-4 boundary
	nhi	ec.s,x'1c'
	ar	ec.s,r4		address of pseudo - register


	endc
	ifnz	DPFPT
	b	xd.2
xds	equ	*		enter here if store type instruction
	lis	r0,1		set flag
	b	xd1
xd	equ	*
	lis	r0,0		set load type instruction
xd1	st	r0,lsflag
	nhi	ec.s,x'38'	force r1 to multiple-of-8 boundary
	ai	ec.s,32(r4)

	endc
xd.2	equ	*
	lhl	e9,0(r5)	get 1st address h/w
	thi	e9,x'8000'
	bnz	rx2		rx2 format
	thi	e9,x'4000'
	bz	rx1		rx1 format

*--------------rx3

	ais	ef.loc,2	update location counter
	ais	r5,2		update real pc as well
	exhr	eb,e9		address to bits 0-15 of eb
	lhl	ea,0(r5)	get 2nd address h/w
	or	eb,ea		merge address parts
-------------------------a must be adjusted

aese.5	ar	e9.x,ed		complement exponent difference
	sr	ed,e9.x
	srls	ed,6
	lr	e9.x,ea		save a exp
	ni	ea,y'ffffff'	strip exponent from a
	srl	ea,0(ed)	adjust a
	lr	ed,eb		save b exp
	ni	eb,y'ffffff'	strip b exponent

*-----------------------------b > a

bga	xr	e9.x,ed		effective add or subtract?
	bnm	aese.2a		b if effective add
	sr	eb,ea		subtract
	bz	stz		if zero, go store it
	lr	ea,eb		else put reault in "a" registers
	lr	e9.x,ed
	b	le.4a		and go normalize

***********
*         *
*   fxr   *
*         *
***********

*-----------------------------fix (convert to integer)


fxr	nhi	ee.stat,-16	zero current cc
	ar	ed,ed		r2 is floating reg
	nhi	ed,x'1c'	force it even
	ar	ed,r4		address of pseudo reg
	l	ea,0(ed)	get floating number
	lr	eb,ea		magnitude to b
	slls	eb,8		left justified
	lb	e9.x,0(ed)	exponent to x (low byte)
	ni	e9.x,x'7f'	dump sign
	si	e9.x,x'40'	is there an integer part?
	bnp	fxrzero		b if no
	lis	ed,8		compare exponent with 8
	sr	ed,e9.x
	bm	fxrovf		exit if number too big
	bnz	fxr.1		go adjust number unless exp=8
	lr	eb,eb		exp=8 but it could still be too big
	bnm	fxr.2		b if it is ok
fxrovf	ais	ee.stat,4	set v flag
	li	eb,y'7fffffff'	set number as big as possible
	lr	ea,ea
	bp	fxrstore
	b	fxr.2a
fxr.1	slls	ed,2		prepare to adjust
	srl	eb,0(ed)	adjust
fxr.2	lr	ea,ea		test sign
	bp	fxrstore
fxr.2a	xi	eb,-1
	ais	eb,1
	b	fxrstore
fxrzero	xr	eb,eb		zero b
fxrstore lr	eb,eb		test sign of number
	bz	fxr.6		b if zero
	bm	fxr.5		b if minus
	ais	ee.stat,2	set g flag
	b	fxr.6
fxr.5	ais	ee.stat,1	set l flag
fxr.6	equ	*
*
	srls	ec.s,2		was r1 * 4
	lb	r1,grtab(ec.s)	offset from users saved r8
	st	eb,0(r3,r1)	put into users saved general reg
*
	b	nofault

***********
*         *
*   flr   *
*         *
***********

*-----------------------------flr preprocessing

flr.1	srls	ec.s,1		source reg
	nhi	ec.s,x'1c'	word boundary
	ar	ec.s,r4		address of pseudo reg
*
	nhi	ed,x'f'
	lb	ed,grtab(ed)	offset from users saved r8
	l	ed,0(r3,ed)	general register
*
* note: in this case only, ed contains the value of the second
*    operand, not its address!!
*


*-----------------------------float (convert to real)

flr.2	nhi	ee.stat,-16
	lr	ea,ed		get number to float
	bz	sta		out if zero
	bm	flr.3		b if minus
	li	e9.x,y'46000000' get starter exponent
	b	flr.4
flr.3	li	e9.x,y'c6000000' negative number
	xi	ea,-1
	ai	ea,1
flr.4	ti	ea,y'ff000000'	normalized to 6 digits?
	bz	le.4a		<= 6 digits, go finish normalization
	ai	e9.x,y'1000000'	> 6 digits, shift right
	srls	ea,4		and fix exponent
	b	flr.4		try again

*        since everything is done at this point, fxr.10 (see the
*        instruction modification routines section) returns directly
*        to nofault.
	endc

************************************************
*                                              *
*   load and store double-precision floating   *
*                                              *
************************************************

	ifnz	DPFPT
*--------------load double-precision floating


ld	equ	*
	l	e9,4(ed)	low-order word of source
	l	e8,0(ed)	high-order word of source
ld.1	equ	*
	nhi	ee.stat,-16	clear current condition code
	ti	e8,y'f00000'	is it normalized?
	bz	normlize
ld.50	lr	e8,e8
	bm	stmd		datum is -ve

*--------------positive number - flag g

stpd	ais	ee.stat,2	set g flag
	st	e9,4(ec.s)
	st	e8,0(ec.s)
	b	dpfinal

*--------------negative number - flag l

stmd	ais	ee.stat,1	set l flag

*--------------zero or exception

stad	st	e9,4(ec.s)
	st	e8,0(ec.s)
	b	dpfinal

*--------------forced zero

stzd	xr	e9,e9
	xr	e8,e8
	b	stad

*-------------load complement of double register

lcdr	equ	*
	l	e9,4(ed)	low-order word of source
	l	e8,0(ed)	high-order word of source
	xi	e8,y'80000000'	complement sign bit
	b	ld.1		continue with common ld code

*-------------load double register from single precision memory

lde	equ	*
	li	e9,0		low-order word forced to zero
	l	e8,0(ed)	high-order word of source
	b	ld.1		continue with common ld code

*--------------store double-precision floating


std	equ	*
	l	e9,4(ec.s)	no condition code changes
	l	e8,0(ec.s)
	st	e8,0(ed)
	st	e9,4(ed)
	b	errfree

*-----------------store double register in single precision memory

stde	equ	*
	l	e8,0(ec.s)	high-order word of source
	l	e9,4(ec.s)	low-order word
	ti	e8,y'f00000'	is it normalized?
	bnz	stde.0		yes - skip
	bal	r6,dnorml	pre-normalize (the 3220 does)
	bz	stde.st		zero - just store it
stde.0	cli	e9,y'80000000'	do 'R*-Rounding'
	bl	stde.st		high bit off - just store it
	bne	stde.1		only high bit on:
	oi	e8,1		turn on low bit of high word
	b	stde.st		store result
stde.1	equ	*		round upwards
	ai	e8,1		increment fraction
	btc	12,ovfinal	carry or overflow means exponent overflowed
	ti	e8,y'ffffff'	fraction all zero?
	bnz	stde.st		no - we are safe
	oi	e8,y'100000'	else set fraction (exp already incremented)
stde.st equ	*
	st	e8,0(ed)	store as single-precision number
	b	errfree



***************************************************************
*                                                             *
*   load multiple and store multiple double-precision float   *
*                                                             *
***************************************************************

*--------------load multiple double-precision floating


lmd	equ	*

*--------------lmd loop

lmd.10	l	e8,0(ed)	move memory
	l	e9,4(ed)
	st	e8,0(ec.s)	to double-precision floating reg
	st	e9,4(ec.s)
	ais	ed,8
	ais	ec.s,8
	cli	ec.s,64+32(r4)	finished?  r4 = fwa of sp fp regs
	bl	lmd.10		not quite
	b	errfree

*--------------store multiple double-precision floating


stmd.00	equ	*

*--------------stmd loop

stmd.10	l	e8,0(ec.s)	move double-precision floating reg
	l	e9,4(ec.s)
	st	e8,0(ed)	to memory
	st	e9,4(ed)
	ais	ec.s,8
	ais	ed,8
	cli	ec.s,64+32(r4)	done?
	bl	stmd.10		not yet
	b	errfree

******************************
*                            *
*   overflow and underflow   *
*                            *
******************************

*--------------overflow

overfld	li	e8,y'7fffffff'	largest possible no
	li	e9,y'ffffffff'
	ais	ee.stat,4	set v flag
	or	e8,ed		get an appropriate sign
	bm	stmd		-ve
	b	stpd		+ve

*--------------underflow

underfld ais	ee.stat,4	set v flag
	xr	e8,e8		zeroise the number
	xr	e9,e9
	b	stad

*********************
*                   *
*   normalization   *
*                   *
*********************

*--------------normalization of double-precision floating


normlize equ	*
	bal	r6,dnorml	call common normalization routine
	bp	stpd		positive
	bm	stmd		negative
	b	stad		must be zero

dnorml	equ	*
	ti	e8,y'ffffff'	test if a1=zero
	bz	norm.10
	lhi	r2,-1
	lr	ea,e8		get exponent
	ni	e8,y'ffffff'	separate fraction
	xr	ea,e8		separate sign & exponent
norm.05	si	ea,y'1000000'	decrement exponent
	btc	12,norm.und	c or v set - underflow
	slls	e8,4		a1
	rll	e9,4		a2
	slls	r2,4		mask
	ti	e8,y'f00000'
	bz	norm.05		needs more ...
	lr	eb,e9		save a2
	nr	e9,r2		result2
	xr	eb,e9		separate most significant of old a2
	or	e8,eb		fraction a1
	ar	e8,ea		attach sign and exponent
	br	r6		cond code set

*--------------a1 fraction zero

norm.10	lr	e9,e9		a2 ? 0
	bz	norm.zer	forced x'0000000000000000'
	si	e8,y'6000000'	cater for 6 x digits from a1
	btc	12,norm.und	c or v set - underflow
	rrl	e9,8
norm.15	ti	e9,y'f00000'	potentially normalized?
	bnz	norm.20		yes, branch
	si	e8,y'1000000'	decrement exponent
	btc	12,norm.und	c or v set - underflow
	rll	e9,4
	b	norm.15
norm.20	lr	ea,e9		normalization's terminated
	ni	e9,y'ff000000'	a2
	xr	ea,e9		most significant of old a2
	ar	e8,ea		a1
	br	r6		cond code set

norm.und equ	*		normalization underflow
	ais	ee.stat,4	set v flag
norm.zer equ	*
	xr	e8,e8		force zero
	xr	e9,e9
	br	r6		cond code set

*****************************************
*                                       *
*   compare double-precision floating   *
*                                       *
*****************************************

*--------------compare double-precision floating


cd	equ	*
	nhi	ee.stat,-16	clear current condition code
	l	ea,0(ed)	b1
	bnm	cd.10		b is +ve
	l	e8,0(ec.s)	a1
	bm	cd.30		a -ve, b -ve
cd.5	ais	ee.stat,2	a > b , set flag g
	b	dpfinal
*
cd.10	l	e8,0(ec.s)	a1
	bnm	cd.20		a is +ve
cd.15	ais	ee.stat,9	a < b , set flags l & c
	b	dpfinal
*
cd.20	clr	e8,ea		a ? b , both identical signs
	bc	cd.15		a < b
	btc	3,cd.5		a > b
	l	e9,4(ec.s)	a2, a1 = b1
	cl	e9,4(ed)	a2 ? b2
	bc	cd.15		a2 < b2, a < b
	btc	3,cd.5		a > b
	b	dpfinal
cd.30	clr	e8,ea		a -ve, b -ve
	bc	cd.5		b<a
	btc	3,cd.15		b>a
	l	e9,4(ec.s)
	cl	e9,4(ed)
	bc	cd.5		b2<a2
	btc	3,cd.15		b>a
	b	dpfinal

**************************************************
*                                                *
*   add and subtract double-precision floating   *
*                                                *
**************************************************

*--------------add double-precision floating


ad	equ	*
	nhi	ee.stat,-16	clear current condition code
	l	eb,4(ed)	b2
	l	ea,0(ed)	b1
	b	adsd.00

*--------------subtract double-precision floating


sd	equ	*
	nhi	ee.stat,-16	clear current condition code
	l	eb,4(ed)	b2
	l	ea,0(ed)	b1
	xi	ea,y'80000000'	reverse sign

*--------------add and subtract common sequence

adsd.00	l	e9,4(ec.s)	a2
	l	e8,0(ec.s)	a1
	st	ec.s,source
	exhr	ec,e8		a's exponent
	exhr	ed,ea		b's exponent
	nhi	ec,x'7f00'	value of a's exponent
	nhi	ed,x'7f00'	value of b's exponent
	sr	ec,ed
	bz	adsd.60		exponents are equal
	bm	adsd.70		a<b   (magnitudes)
	clhi	ec,x'e00'	a>b     (magnitudes)
	bnl	adsd.55		a>>b    (magnitudes)

*--------------a > b

adsd.03	srls	ec,6
	st	ea,expb		b's exponent
	shi	ec,24		test if shifted more or less than 6x
	bnm	adsd.40		shift 6 or more hex digits
	ni	ea,y'ffffff'	b1
	ahi	ec,24
	srl	eb,0(ec)
	rrl	ea,0(ec)
	lhi	ed,-1		construct a mask
	srl	ed,0(ec)
	lr	ec,ea
	nr	ea,ed		adjusted b1
	xr	ec,ea		t'least signif dig of original b1
	or	eb,ec		new b2
adsd.05	lr	ec,e8		preserve a's exponent
	ni	e8,y'ffffff'
	xr	ec,e8		clear a1 fraction
adsd.12	st	ec,exp		preserve result's exponent
	x	ec,expb		effective + or -
	bnm	adsd.25		effective add

*--------------effective subtraction

	l	ec.s,source	restore source address
	sr	e9,eb		a2-b2=r2
	bnc	adsd.15
	sis	e8,1		a1-1:=a1  arith fault new psw
	dc	trap.af

* Bootstrap Loader information

	al      x'cf'           50  '50-sequence' loader
	b       x'80'           54  branch to bootstrap record

	org     low+x'60'
	b       start           60  LSU start address
	b       dump            66  dump start address

	org	low+x'78'	LSU addresses
	entry	consaddr,conscmd2
consaddr db	y'10'		device address of 'system console'
conscmd2 db	x'ee'		pals command 2 for 'system console'

I 2
	org	low+x'7a'	Default boot address
	db	x'c7'		Disk
	db	x'32'		Device code
	db	x'b6'		Controller
	db	x'f0'		Selch

E 2
* Pointers and PSW's

	org	low+x'80'
	dc      0               80  &(system queue)
    ifnz M3200
	dc      pf.save         84  &(power-fail save area)
    else
	dc      z(pf.psw)       84  &(power-fail psw save area)
	dc      z(pf.regs)      86  &(power-fail reg save area)
    endc
	dc      ps.trap         88  system queue service new psw
	dc	trap.sq
	dc      ps.trap         90  relocation fault new psw
	dc	trap.mf

* SVC table

	dc      ps.trap         98  SVC new psw status
	dc      z(trap.svc)		svc 0 - Version 7 system call
	dc	z(trap.isv)		svc 1
	dc	z(trap.isv)		svc 2
	dc	z(trap.isv)		svc 3
	dc	z(trap.isv)		svc 4
	dc	z(trap.isv)		svc 5
	dc	z(trap.isv)		svc 6
	dc	z(trap.isv)		svc 7
	dc	z(trap.isv)		svc 8
	dc	z(trap.isv)		svc 9
	dc	z(trap.isv)		svc 10
	dc	z(trap.isv)		svc 11
	dc	z(trap.isv)		svc 12
	dc	z(trap.isv)		svc 13
	dc      z(trap.osv)		svc 14 - Version 6 system call
    ifnz PIC
	dc      z(trap.tim)		svc 15 - quick and dirty access to PIC
    else
	dc	z(trap.isv)		svc 15
    endc

	das     3               BC              -
    ifnz M3200
	dc      ps.trap         C8  data format fault new psw
	dc	trap.dat
    else
	das     2               C8              -
    endc

* Interrupt Service Pointer table

	entry	isp
isp     equ     *               D0  interrupt service pointer table
	nlist
	do      NDEVS
	dc      z(interupt)
	list
*       do      NDEVS
*	dc	z(interupt)		listing suppressed

* Memory Access Controller registers ( except 3240 )

    ifz M3240
	org     *-low+255&y'ffffff00'+low       (align 256 )
	entry	macregs
macregs	equ	*		300 / 500 / 900, depending on NDEVS
	das	16		MAC segmentation registers
mac.rs  das     1               MAC status register ( 7/32 and 8/32 only )
	org	*-low+255&y'ffffff00'+low	( align 256 )
    endc

*********************************************************
*                                                       *
*               Hardware-Dependent Areas                *
*                                                       *
*       Locations of the following code are not fixed,  *
*       but because of addressing or alignment must be  *
*       in the first 64K segment of physical memory.    *
*                                                       *
*********************************************************

* Power-fail save areas

pf.save equ	*		power-fail save area
pf.psw	das	2		psw
    ifz M3200
pf.regs	das	2*16		general registers (2 sets)
    else
pf.regs	das	8*16		general registers (8 sets)
	das     16              scratchpad registers
    endc
    ifnz FPREGS!DPREGS
pf.fpr	das	24		floating-point registers
    endc

* MAC segmentation registers ( except 3240 )
*       To establish address mapping, the user or kernel seg regs are
*       copied into the hardware MAC registers.

    ifz M3240
	entry	kisa0,useg,uisa0
kisa0   das     16              kernel mode segmentation registers
useg	equ	*-4		segmentation register for u area
uisa0   das     16              user mode segmentation registers

kst     dc      a(macregs-low*y'10000'+kisa0)    kernel seg table descriptor
ust     dc      a(macregs-low*y'10000'+uisa0)    user seg table descriptor
    endc

* MAT segment tables ( 3240 only )
*       To establish address mapping, a pointer to the user or kernel
*       seg regs is loaded into the hardware Segment Table Descriptor

    ifnz M3240
	entry	kisa0,useg,uisa0
	org     *-low+127&y'ffffff80'+low       ( align 128 )
kisa0   das     32              kernel mode segment table
useg	equ	*-8		segment table entry for u area
	org     *-low+127&y'ffffff80'+low       ( align 128 )
uisa0   das     32              user mode segment table
	org     *-low+127&y'ffffff80'+low       ( align 128 )
kiss0   dc      0,0             dummy kernel shared segment table
	org	*-low+127&y'ffffff80'+low
uiss0   dc      0,0             dummy user shared segment table

kst     dc      a(kisa0-low/128+y'1e0000')      kernel seg table descriptor
	dc      a(kiss0-low/128)
ust     dc      a(uisa0-low/128+y'1e0000')      user seg table descriptor
	dc      a(uiss0-low/128)
    endc

* Pointers to segment descriptors, for use in calls to addrsw and lraddr

	entry	kisa,uisa
kisa    dc      a(kst)          pointer to kernel seg descriptor
uisa    dc      a(ust)          pointer to user seg descriptor

* Auto-driver 'channel' control blocks

	entry	ccb
ccb	equ	*
	nlist
	do	NCCB
	dc	0,0,0,0,0,z(autod),x'0'
	list
*	do	NCCB
*	dc	0,0,0,0,0,z(autod),x'0'		listing suppressed

I 2
* Interrupt stack

istk	equ	*
	ds	2*1024		2k should be enough
istktop	equ	*

E 2
*********************************************************
*                                                       *
*               Trap Transfer Vector                    *
*                                                       *
* Initial entry from microcode on all interrupts        *
*                                                       *
*********************************************************

* Machine malfunction

trap.mm equ     *
    ifnz M3200
	l	r0,mm.stat	get reason code
	ti	r0,y'38000000'	memory parity error?
	bnz	trap.mp
	ti	r0,y'07000000'	non-configured memory error?
	bnz	trap.mf
    else
	btc	6,trap.mp
    endc
	lm	re,mm.opsw	get saved old psw
	bal	r6,trapx
	dc	h'4'

* Memory parity error

trap.mp equ     *
	lm	re,mm.opsw	get saved old psw
	bal	r6,trapx
	dc	h'0'

* Arithmetic fault

trap.af equ     *
    ifnz M3200
	ti	re,ps.af	floating-point underflow masked off?
	bnz	af1		  no - take interrupt
	lr	rf,rc		  yes - ignore all arithmetic faults
	lpswr	re			(i.e. same as 7/32)
af1	equ	*
    endc
	bal	r6,trapx
	dc	h'8'

* Segmentation fault

trap.mf equ     *
    ifz M3200
	lis	r0,0
	st	r0,mac.rs		clear mac status register
    endc
	bal	r6,trapx
	dc	h'9'

* Illegal instruction / protect mode

trap.ii	equ	*
	bal	r6,trapx
	dc	h'1'

* Supervisor Call

trap.isv equ	*		illegal supervisor call
	bal	r6,trapx
	dc	h'10'

trap.osv equ	*		Version 6 supervisor call
D 2
	ai	rd,x'100'	set flag for trap()
E 2
I 2
	ai	rd,x'1000'	set flag for trap()
E 2
trap.svc equ	*		Version 7 supervisor call
	bal	r6,trapx
	dc	h'6'

    ifnz	PIC
trap.tim equ	*	quick and dirty access to precision clock values

*	return in user r0 the current value of 
*	sytim , utime , or itime
*	user must supply in r1 one of 0,4,8 to get
*	the corresponding value of the above

	stm	re,nr.psw	save old psw for quick return
	epsr	rc,rc		current ps
	ohi	rc,ps.ureg	switch to user regs
	epsr	r0,rc
	ni	r1,x'c'		make sure offset is legal
	l	r0,sytim(r1)	load requested time value
	lpsw	nr.psw		exit quickly without telling anyone

	align	adc
nr.psw	das	2		space to save psw
    endc

* System queue service ( should never happen )

trap.sq	equ	*
	bal	r6,trapx
	dc	h'4'

* Data format fault ( 3200 only )

    ifnz M3200
trap.dat equ	*
	bal	r6,trapx
	dc	h'13'
    endc

* Common trap routine - get reason code & status and go to C trap routine

trapx	equ	*
	lr	r3,rd		'stat' is effective arg address (SVC) etc.
	lh	r2,0(r6)	get trap code
	epsr	rd,rd		current psw
	li	rb,ps.kern	new psw: kernel mode, enabled
	la	rc,trap
	b	call		go call c trap handler

* I/O Interrupt - get address of C interrupt handler and go to it

autod	equ	*		entry from auto-driver 'channel'
	bnm	autod1		L bit in condition code ?
	oi	r3,x'100'	  yes - bad status
	b	autod2
autod1	bnp	autod2		G bit in condition code ?
	oi	r3,x'200'	  yes - buffer limit
autod2	equ	*		fall through to interrupt code

interupt equ	*		entry from immediate interrupt
	lb	rc,devint(r2)	handler table offset
	l	rc,handler(rc)	address of C interrupt handler
	lb	r2,devmap(r2)	minor device number
D 2
	lr	re,r0		move psw to correct regs
	lr	rf,r1
E 2
	epsr	rd,rd		current psw
	nhi	rd,x'ffff'-ps.il	all interrupt levels off ( 3200 )
D 2
	epsr	r0,rd
	li	rb,ps.disb	new psw: kernel mode, disabled
	b	call		go call c interrupt-handler
E 2
I 2
	epsr	r6,rd

	la	sp,-4*adc+istktop	use interrupt stack
	st	r2,0(sp)	dev
	st	r3,adc(sp)	stat
	st	r0,2*adc(sp)	ps
	st	r1,3*adc(sp)	pc

	balr	rf,rc		call C interrupt routine

	lm	re,2*adc(sp)	old ps & pc
	thi	re,ps.prot	user mode?
	bz	noswtch		no - don't switch kernel process
	lb	r1,runrun	higher-priority process waiting?
	lr	r1,r1
	bz	noswtch		no - don't switch

	la	rc,trap		call trap routine
	li	rb,ps.kern	new psw: kernel mode, interrupts disabled
	li	r2,12		trap code 12: reschedule
	b	call		go transfer to C trap routine

noswtch equ	*
	ni	re,-1-ps.wait	turn off wait bit
	lpswr	re		return to previous status
E 2
E 1
	st	r1,3*adc(sp)	pc

	balr	rf,rc		call C interrupt routine

	lm	re,2*adc(sp)	old ps & pc
	thi	re,ps.prot	user mode?
	bz	noswtch		no - don't switch kernel process
	lb	r1,runrunsys/conf/s.call.s                                                                                      444       2       2        21235  2770527564   7153                                                                                                                                                                                                                                                                                                                                                                      h19165
s 00000/00000/00365
d D 1.3 82/09/13 12:26:20 ross 3 2
c 
e
s 00011/00000/00354
d D 1.2 82/09/13 10:47:37 ross 2 1
c Faster interrupt processing.
e
s 00354/00000/00000
d D 1.1 82/09/13 10:12:39 ross 1 0
e
u
U
t
T
I 1
*****************************************************************
*								*
*		UNIX First-level Interrupt Handler		*
*								*
*		Perkin-Elmer 7/32, 8/32, 3220, 3240		*
*								*
*****************************************************************

	extrn	trap
I 2
	extrn	printf
E 2
	extrn	kisa,uisa
	extrn	runrun
	extrn	u

* PSW bit definitions

ps.flm	equ	y'40000'	floating-point masked (3200)
ps.iip	equ	y'20000'	interruptible instruction in progress (3200)
ps.wait equ	x'8000'		wait state
ps.io	equ	x'4000'		immediate interrupt mask
ps.mm	equ	x'2000'		machine malfunction interrupt mask
ps.af	equ	x'1000'		arith fault interrupt mask
ps.il	equ	x'0800'		multi level interrupts (8/32 & 3200)
ps.rp	equ	x'0400'		memory relocation / protection
ps.sq	equ	x'0200'		system queue service mask
ps.prot equ	x'0100'		protect mode
ps.ureg equ	x'00f0'		user register set

* PSW definitions

ps.user equ	ps.io+ps.mm+ps.af+ps.rp+ps.prot+ps.ureg
ps.idle equ	ps.wait+ps.io+ps.mm+ps.af+ps.rp+ps.ureg
ps.kern equ	ps.io+ps.mm+ps.af+ps.rp+ps.ureg
ps.disb equ	ps.mm+ps.af+ps.rp+ps.ureg
ps.trap equ	ps.mm+ps.af

* Register definitions

r0	equ	0
r1	equ	1
r2	equ	2
r3	equ	3
r4	equ	4
r5	equ	5
r6	equ	6
r7	equ	7
r8	equ	8
r9	equ	9
ra	equ	10
rb	equ	11
rc	equ	12
rd	equ	13
re	equ	14
rf	equ	15
sp	equ	r7

*****************************************************************
*								*
* call:		interface to C interrupt handlers		*
*								*
*	re-rf	- old PSW					*
*	rd	- current (interrupt) PSW status		*
*	rc	- interrupt routine address			*
*	rb	- interrupt routine PSW status			*
*	r3	- device status ( or SVC arg address )		*
*	r2	- device address ( or trap code )		*
*								*
*****************************************************************

	pure
	entry	call
call	equ	*

    ifnz PIC
	bal	r6,rdpic	get last pic timing interval
    endc

* if trap from user mode, switch to kernel address space 

	thi	re,ps.prot	user mode?
	bz	kernel		no - kernel already

    ifnz PIC
	am	r5,utime	add new interval to user time
    endc

	l	r1,kisa		kernel seg regs
	bal	r6,addrsw	switch address space
	b	nkernel

* else trap from kernel mode -- get stack pointer from register set f

kernel	equ	*

    ifnz PIC
	thi	re,ps.wait
	bz	kernel2		not in wait
	am	r5,itime	if wait add current interval to idle time
	b	kernel3
kernel2	am	r5,sytim	if kernel and not wait increment sys time
kernel3	equ	*
    endc

	st	rd,nr.psw	set up resume psw
	la	r1,nkernel
	st	r1,nr.psw+adc
	lr	r1,rd		current psw
	ohi	r1,ps.ureg	switch to reg set f
	epsr	r0,r1
	st	sp,ksp		save stack pointer
	lpsw	nr.psw		back to reg set 0
nkernel	equ	*

* enable memory relocation / protection

	ohi	rd,ps.rp	enable relocation
	epsr	r0,rd

* if stack pointer is out of range, set it to top of u area and force a panic

	l	sp,ksp		get kernel stack pointer
	ci	sp,u		below bottom of u area?
	bl	badsp
	c	sp,maxsp	above top of u area?
	bnp	goodsp
badsp	l	sp,maxsp	set to top of u area
I 2
*	shi	sp,3*adc
*	l	0,ksp
*	st	0,adc(sp)
*	l	0,maxsp
*	st	0,2*adc(sp)
*	la	0,badsps
*	st	0,0(sp)
*	bal	15,printf
*	ahi	sp,3*adc
E 2
	la	rc,stkovflo	force a panic
goodsp	equ	*

    ifnz	M3200
* save microcode scratchpad registers if necessary (3200 only)

	ti	re,ps.iip		interruptible instruction in progress?
	bz	nsiip			  no - skip
	shi	sp,16*adc		space on stack for scratchpad regs
	psf	5,0(sp)			save scratchpad regs
nsiip	equ	*
    endc

* save psw & status on kernel stack

	shi	sp,14*adc	space for 14 words
	stm	re,11*adc(sp)	save old psw
	st	rb,13*adc(sp)	save new psw
	st	r2,0(sp)	save dev code
	st	r3,adc(sp)	save status

* switch to user register set, and save regs

	st	rc,nr.intp	save routine address
	st	sp,ksp		save stack pointer
	ohi	rd,ps.ureg	switch to user regs
	epsr	r0,rd
	stm	r0,nr.regs	save all regs
	l	sp,ksp		restore stack pointer
	lm	r8,nr.regs	stack regs r0-sp
	stm	r8,2*adc(sp)

* reload user high regs ( to be saved by standard c linkage )
*  and call c trap handler

	lm	r8,8*adc+nr.regs	restore regs r8-rf
	st	rf,10*adc(sp)	stack link reg
	l	r1,nr.intp	trap routine address
	l	r0,13*adc(sp)	new psw
	epsr	r2,r0
	balr	rf,r1		call trap routine

* on return from trap routine, check whether higher-priority process
* is now ready to run

	l	r1,11*adc(sp)	old psw
	thi	r1,ps.prot	user mode ?
	bz	noswtch		no - don't switch kernel process

switch	equ	*
	li	r0,ps.disb	disable interrupts
	epsr	r1,r0
	lb	r1,runrun	higher-priority process waiting?
	lr	r1,r1
	bz	nswtch		no - restore interrupted process
	li	r0,ps.kern	enable interrupts
	epsr	r1,r0
	li	r0,12		trap 12 is give up cpu
	st	r0,0(sp)
	bal	rf,trap		call trap routine again
nswtch	equ	*

* restore status of interrupted process

noswtch	equ	*
	li	r0,ps.disb	disable interrupts
	epsr	r1,r0
	l	rf,10*adc(sp)	restore link reg
	stm	r8,8*adc+nr.regs	save r8-rf
	lm	r8,2*adc(sp)	save r0-sp
	stm	r8,nr.regs
	lm	re,11*adc(sp)	old psw
	ahi	sp,14*adc	pop stack

    ifnz	M3200
* restore microcode scratchpad registers (3200 only)

	ti	re,ps.iip	interruptible instruction interrupted?
	bz	noriip		  no - skip
	psf	6,0(sp)		restore scratchpad regs
	ahi	sp,16*adc	pop stack
noriip	equ	*
    endc

* if previous mode was user, switch back to user address space

	thi	re,ps.prot	user mode?
	bz	kernel1		no - stay in kernel mode
	epsr	rd,rd		current psw
	nhi	rd,x'ffff'-ps.rp	disable relocation
	epsr	r0,rd
	l	r1,uisa		user seg regs
	bal	r6,addrsw
kernel1 equ	*

* return to previous status

	st	sp,ksp		save kernel stack pointer
	ni	re,y'ffffffff'-ps.wait	turn off 'wait' bit
	stm	re,nr.psw	save return psw

    ifnz PIC
	bal	r6,rdpic	get last pic timing interval
	am	r5,sytim	add interval to sys time
    endc

	lm	r0,nr.regs	restore all regs
	lpsw	nr.psw		back to previous mode

* stack overflow panic - called instead of 'trap' or interrupt routine
*	to force a panic when kernel stack overflows

stkovflo equ	*
	dc	f'0'		crash with illegal instruction
I 2
*badsps	db	c'ksp=%x maxsp=%x',x'a',x'0'
E 2

	impur

* Non-reentrant save area for use while switching register sets

nr.intp das	1		interrupt handler address save
nr.psw	das	2		psw save
nr.regs das	16		register save

* Kernel mode stack pointer save

	entry	ksp,maxsp
ksp	das	1	save stack pointer during user mode execution
maxsp	das	1	pointer to top of stack segment (initialized by start)

*****************************************************************
*								*
* addrsw:	Switch Address Space Mapping			*
*								*
* input: r1 = &(new segment table descriptor)			*
*        r6 = return address					*
*								*
* Must be called with relocation & interrupts disabled		*
*								*
*****************************************************************

	pure
	entry	addrsw
addrsw	equ	*
    ifnz	M3200
	psf	1,0(r1)		lpstd	process table descriptor
	psf	2,4(r1)		lsstd	shared table descriptor
    else
	extrn	macregs
	l	r1,0(r1)	address of seg registers
	ni	r1,y'fffff'	address part
	lhi	r4,15*adc	start at last reg
seglp	equ	*
	l	r0,0(r1,r4)	next seg value
	st	r0,macregs(r4)	store in mac reg
	sis	r4,adc		back up
	bnm	seglp		repeat for all seg regs
    endc
	br	r6

*****************************************************************
*								*
*		Floating-point Register Save / Restore		*
*								*
*****************************************************************

	entry	savfp,restfp

* save floating point registers

savfp	equ	*
  ifnz	FPREGS!DPREGS
	l	r1,0(sp)	fp save area in u
    ifnz  FPREGS
	stme	r0,0(r1)	save single-precision regs
    endc
    ifnz  DPREGS
	stmd	r0,8*adc(r1)	save double-precision regs
    endc
  endc
	br	rf

* restore floating point registers

restfp	equ	*
  ifnz	FPREGS!DPREGS
	l	r1,0(sp)	fp save area in u
    ifnz  FPREGS
	lme	r0,0(r1)	save single-precision regs
    endc
    ifnz  DPREGS
	lmd	r0,8*adc(r1)	save double-precision regs
    endc
  endc
	br	rf

    ifnz	PIC

*****************************************************************
*								*
* rdpic:	Get length of last precision timing interval	*
*								*
*	r5	- returned value				*
*	r6	- return address				*
*	r0-r1	- work regs					*
*								*
*****************************************************************

	pure
	extrn	clockaddr
	entry	rdpic
rdpic	equ	*
	lb	r0,clockaddr	address of pic
	rhr	r0,r1		read interval
	l	r5,pictim	previous count
	sr	r5,r1		real current clock interval
	bp	ras1		positive?
	ai	r5,1000		  no - must have wrapped around
ras1	st	r1,pictim	save current count
	br	r6		return

* PIC timing information

	impur
	entry sytim
pictim	dac	1000	last PIC interval count
sytim   dac     0       accumulated system time | MUST BE
utime   dac     0       user time               |   KEPT
itime   dac     0       idle time               | TOGETHER
    endc
E 1
0,clockaddr	address of pic
	rhr	r0,r1		read interval
	l	r5,pictim	previous count
	sr	r5,r1		real current clock interval
	bp	ras1		positive?
	ai	r5,1000		  no - must have wrapped around
ras1	st	r1,pictim	save current count
	br	r6		return

* PIC timing information

	impur
	entry sytim
pictim	dac	1000	last PIC interval count
sytim   dac     0       accumulsys/conf/s.mch.s                                                                                       444       2       2        45016  2770530235   6777                                                                                                                                                                                                                                                                                                                                                                      h56912
s 00000/00000/00825
d D 1.3 82/09/13 12:31:37 ross 3 2
c 
e
s 00011/00000/00814
d D 1.2 82/09/13 10:49:33 ross 2 1
c Faster interrupt processing.
e
s 00814/00000/00000
d D 1.1 82/09/13 10:13:04 ross 1 0
e
u
U
t
T
I 1
*****************************************************************
*								*
*		UNIX Hardware Support Routines			*
*								*
*		Perkin-Elmer 7/32, 8/32, 3220, 3240		*
*								*
*		(C) 1980, Richard Miller			*
*		    University of Wollongong			*
*								*
*****************************************************************

	entry	u
	entry	start,idle,waitloc
	entry	initf,icode,szicode
	entry	fuword,fubyte,fuiword,fuibyte
	entry	suword,subyte,suiword,suibyte
	entry	save,resume
	entry	copyin,copyiin,copyout,copyiout
	entry	clearseg,copyseg
	entry	addupc
	entry	spl0,spl1,spl4,spl5,spl6,spl7,splx
	entry	ss,oc,wd,wh,wdh,rd,rh,rdh
	entry	lra,lraddr
	extrn	kisa0,useg
	extrn	uisa,kisa
	extrn	memtop
	extrn	dumpsw
	extrn	clockaddr
	extrn	ksp,maxsp
	extrn	addrsw
	extrn	main
	extrn	end,edata
    ifnz	PIC
	extrn	rdpic,sytim
    endc
*
* psw bit definitions
*
ps.wait equ	x'8000'	wait state
ps.io	equ	x'4000'	immediate interrupt mask
ps.mm	equ	x'2000'	machine malfunction interrupt mask
ps.af	equ	x'1000'	arith fault interrupt mask
ps.il	equ	x'0800'	interrupt levels (8/32)
ps.rp	equ	x'0400'	memory relocation / protection
ps.sq	equ	x'0200'	system queue service mask
ps.prot equ	x'0100'	protect mode
ps.ureg equ	x'00f0'	user register set
*
* psw definitions
*
ps.user equ	ps.io+ps.mm+ps.af+ps.rp+ps.prot+ps.ureg
ps.idle equ	ps.wait+ps.io+ps.mm+ps.af+ps.rp+ps.ureg
ps.kern equ	ps.io+ps.mm+ps.af+ps.rp+ps.ureg
ps.disb equ	ps.mm+ps.af+ps.rp+ps.ureg
ps.trap equ	ps.mm+ps.af

*
* register definitions
*
r0	equ	0
r1	equ	1
r2	equ	2
r3	equ	3
r4	equ	4
r5	equ	5
r6	equ	6
r7	equ	7
r8	equ	8
r9	equ	9
r10	equ	10
r11	equ	11
r12	equ	12
r13	equ	13
r14	equ	14
r15	equ	15
rf	equ	15
sp	equ	r7

    ifz M3240
CLICK	equ	256
CSHIFT	equ	8
    else
CLICK	equ	2048
CSHIFT	equ	11
    endc

*
* per-process data area for current process - always mapped to segment f
*
u	equ	y'f0000'
usize	equ	2048/CLICK

*****************************************************************
*								*
*  start:	System Initialization				*
*								*
I 2
*	Reset error logger					*
E 2
*	Clear bss and user memory				*
*	Establish kernel memory relocation and stack		*
*	Call 'main' to complete initialization			*
*	Enter process 1 ('init') in user mode			*
*								*
*****************************************************************

	pure
	entry	start
start	equ	*

* on entry from bootstrap loader, disable mac & interrupts

	lhi	r1,ps.ureg	disable everything
	epsr	r0,r1
    ifnz	WCS
      ifz  M3240

* initialize writeable control store to vector to illegal instruction handler

	la	r2,wcs.ill	vector to illegal instruction handler
	li	r0,x'800'	wcs starts at word 800
wcslp	lis	r1,0		transfer one word
	wdcs	r2		write to wcs
	ais	r0,1		next wcs word
	ci	r0,x'1000'	total of 2k words
	bne	wcslp
	impur
	align	adc
wcs.ill	dc	y'0e000070'	wcs branch to illegal instruction handler
	pure
      endc
    endc

I 2
*
*   clear error logger
*
    ifnz  ERRLOGGER
	bal	rf,clrelog
    endc


E 2
* clear per-process data area and bss to zeroes

	lis	r0,0
	la	r5,end		end of kernel
	ahi	r5,CLICK-1		round up to 256 byte block
	nhi	r5,-CLICK
	la	r2,CLICK*usize(r5)	end of u area
	la	r1,edata		start of bss
clp	equ	*
	st	r0,0(r1)	clear a word
	ais	r1,4		next word
	cr	r1,r2		finished?
	bl	clp		no - repeat

* Find out how much memory is available

	lr	r1,r2		end of u area
	li	r2,y'fedcba98'	test data value
memlp	equ	*
	st	r2,0(r1)	try storing word
	c	r2,0(r1)	did it work?
	bne	memend		no - end of memory
	ahi	r1,CLICK		yes - try next 256 byte block
	c	r1,memtop	reached upper limit?
	bl	memlp		no - keep looking
memend	equ	*
	sis	r1,1		highest valid address
	st	r1,memtop	save it
	ais	r1,1
	srl	r1,CSHIFT		max memory (in 256-byte blocks)
    ifz M3240

* initialize prototype mac registers for kernel address space:

* segments 0-n: map real low-core addressess (up to n*64k)
*           f : maps per-process data area for current process
* all others  : invalid

	la	r2,kisa0	kernel seg regs
	li	r0,y'0ff00010'	prototype seg reg value
seglp	equ	*
	chi	r1,CLICK		more than full segment left?
	bm	seglast		no - set last segment
	st	r0,0(r2)	set seg reg
	ais	r2,4
	ai	r0,y'10000'	origin of next segment
	shi	r1,CLICK		memory left
	b	seglp

seglast equ	*
	sis	r1,1		last segment length - 1
	bm	segx		no partial segment - skip
	sll	r1,20		move to seg length field
	ni	r0,y'fffff'
	or	r0,r1
	st	r0,0(r2)	set seg reg
	ais	r2,4

segx	equ	*
	la	r2,useg		per-process data segment
	lr	r0,r5		address of end of kernel
	oi	r0,usize*y'100000'+x'10'	size & protection
	st	r0,0(r2)	set as segment for pda

    else

* initialize kernel segment table:

* segments 0-n: map real low-core addressess (up to n*64k)
*           f : maps per-process data area for current process
* all others  : invalid

	la	r2,kisa0	kernel seg regs
	li	r0,y'5c3e0000'	prototype seg reg: present, rd, wrt, exe, len=31
seglp	equ	*
	chi	r1,32		more than full segment left?
	bm	seglast		no - set last segment
	st	r0,0(r2)	set seg reg
	ais	r2,8
	ai	r0,512		origin of next segment (shifted <<4)
	shi	r1,32		memory left
	b	seglp

seglast equ	*
	sis	r1,1		last segment length - 1
	bm	segx		no partial segment - skip
	sll	r1,17		move to seg length field
	ni	r0,-1-y'3e0000'	remove the length field from proto
	or	r0,r1
	st	r0,0(r2)	set seg reg
	ais	r2,8

segx	equ	*
	la	r2,useg		per-process data segment
	lr	r0,r5		address of end of kernel
	srl	r0,7
	oi	r0,usize*y'20000'+y'5c000000'	size, present, rd, wrt, exe
	st	r0,0(r2)	set as segment for pda
    endc


* start kernel stack pointer at top of per process area

	la	sp,CLICK*usize+u-4
	st	sp,ksp		save sp for interrupts
	st	sp,maxsp	save as 'empty stack' ptr

* load hardware mac registers from kernel prototypes, and enable
* memory relocation / protection and interrupts

	l	r1,kisa		kernel seg regs
	bal	r6,addrsw	load into mac regs
	li	r1,ps.kern	enable mac & interrupts
	epsr	r0,r1

* call main() c routine to complete initialization

	bal	rf,main

* on return from main, enter 'user state' at user address 0 to exec
*  init process

	epsr	r3,r3		disable the mac
	nhi	r3,x'ffff'-ps.rp
	epsr	r0,r3
	l	r1,uisa		user seg regs
	bal	r6,addrsw	switch address space
	lhi	r0,ps.user	user state psw
	lis	r1,0		address 0 in user space
	lpswr	r0		enter process 1

* Bootstrap program to load in init process:
*
*	exec("/etc/init", "/etc/init");
*	for (;;)
*		;

	align	adc
icode	equ	*
	svc	0,11		* exec *
	dc	a(initf-icode)
	dc	a(initp-icode)
	b	*		didn't work -- loop forever
initp	dc	a(initf-icode)
	dc	0
initf	db	c'/etc/init',0
* extra patch space in case of emergency
	db	0,0,0,0,0,0,0,0,0,0
	align	adc		must be even words for copyout
szicode	dc	*-icode		size of icode

*****************************************************************
*								*
* dump:		Memory dump to disk or magtape			*
*								*
*	Save register sets 0 and F so they will appear in dump	*
*	Call (*dumpsw)() to dump all of memory			*
*								*
*****************************************************************

	pure
	entry	dump
dump	equ	*
	lpsw	dump.ps1	reg set F, disabled
dump1	stm	r0,uregs	save reg set F
	lpsw	dump.ps2	reg set 0, disabled
dump2	stm	r0,eregs	save reg set 0

dloop	equ	*
	l	sp,memtop	start stack pointer at top of physical memory
	ni	sp,-4
	l	r1,dumpsw	address of dump routine
	balr	rf,r1
	lpsw	dump.ps3	wait
dump3	b	dloop		if restarted, dump again

	align	adc
dum