h65308
s 00140/00000/00000
d D 1.1 82/08/02 16:27:35 cecily 1 0
e
u
U
t
T
I 1
/*
 * Phototypesetter interpreter
 *      Input: C/A/T control codes from (unmodified) troff
 *      Output: lines of 5 decimal numbers -
 *              ch size font esc lead
 *
 * where        ch = character (in C/A/T set - not ASCII order)
 *              size = current type size in points
 *              font = current font position [0..3]
 *              esc = horizontal space to move (in 1/432 inch) before printing
 *              lead = vertical space to move (in 1/144 inch) before printing
 */

#include <stdio.h>

char sizemap[16] = {	/* map strange troff size codes to points */
	7, 8, 10, 11, 12, 14, 18, 9,
	6, 16, 20, 22, 24, 28, 36, 18
};

int	mcase;
int	size;
int	font;
int	esc;
int	lead;

int	negesc;
int	neglead;

/*
 * Read & interpret pt commands from stdin
 */
main()
{
	register i;

	while ((i = getchar()) != EOF) {
		if (i & 0200)			/* escape */
			ptesc( (~i)&0377 );
		else if ((i & 0340) == 0140)	/* lead */
			ptlead( (~i)&037 );
		else if ((i & 0360) == 0120)	/* size */
			ptsize( i&017 );
		else if ((i & 0360) == 0100)	/* control */
			ptcontrol( i&017 );
		else if (i != 0)		/* character */
			ptchar( i );
	}
	ptchar('\0');
}

/*
 * Escape	- horizontal movement
 */
ptesc(offset)
register offset;
{
	if (negesc)
		esc -= offset;
	else
		esc += offset;
}

/*
 * Lead		- vertical movement
 */
ptlead(offset)
register offset;
{
	if (neglead)
		lead -= offset;
	else
		lead += offset;
}

/*
 * Size		- change point size
 */
ptsize(newsize)
{
	size = sizemap[newsize];
}

/*
 * Control	- special functions
 */
ptcontrol(func)
register func;
{
	switch (func) {
		case 0:		/* initialize */
			negesc = neglead = mcase = font = 0;
			break;
		case 1:		/* switch to lower rail fonts */
			font &= ~01;
			break;
		case 2:		/* switch to upper rail fonts */
			font |= 01;
			break;
		case 3:		/* switch to upper magazine fonts */
			font |= 02;
			break;
		case 4:		/* switch to lower magazine fonts */
			font &= ~02;
			break;
		case 5:		/* switch to lower case */
			mcase = 0;
			break;
		case 6:		/* switch to upper case */
			mcase = 0100;
			break;
		case 7:		/* subsequent escapes are forward */
			negesc = 0;
			break;
		case 8:		/* subsequent escapes are backward */
			negesc = 1;
			break;
		case 9:		/* stop ? */
			break;
		case 10:	/* subsequent leading is forward */
			neglead = 0;
			break;
		case 12:	/* subsequent leading is backward */
			neglead = 1;
			break;
	}
}

/*
 * Character	- flush all pending font / mode / etc. changes, and put out
 *		  printable character
 */
ptchar(ch)
register ch;
{
	register char *pt;
	printf("%d	%d	%d	%d	%d\n",
		mcase | ch, size, font, esc, lead);
	esc = lead = 0;
}
E 1
