#
# Filename: meshfilt.awk
#
#######################################################################
#
# Below is a template to use if you need to add another error 
# report to parse for.  
#
# Note: config. entries  have the '<' and '>' around descriptive text
#
#----------------- Start of code --------------------------------------
#
# /<Regular Expression>/ {
#    # the nodes are listed two fields to the right
#    #
#    fmt_print("<string for format reference (field number determination)>", \
#              "<string for error type to be printed>", \
#              <field offset (from format reference) to error SRC->DST nodes>)
#
#    next
# }
#
#----------------- End of code ----------------------------------------
#
# Input file:
#       That passed by the meshfilt script.  The formats accepted are
#       of the psd.def and psd.log file format (which may be part of 
#       and email message), or a screen dump of the psd error message(s).
#
# Output format:
#   Sample output:
#
#       =====> Error search on file: psd.def <=====
#
#       ----------------------------------------
#       Error on line: 266
#
#       Neighbor Concurrent Comm Test FAILED
#       MISCOMPARE
#       00C14(46)->00C09(41)
#       ----------------------------------------
#
#
# Modification History:
#
# $Log: meshfilt.awk,v $
# Revision 1.2  1995/03/28  00:16:36  chowell
# chowell - add version string
#
# Revision 1.1  1994/11/09  23:31:14  chowell
# Initial revision
#
#
# Initial revision:
#
#   09-Nov-94      Chuck Howell   Initial version
#
#######################################################################
#
# What string:
#
# @(#) meshfilt.awk DIAG_REL_2.0 Thu Jan  5 12:04:09 PST 1995
#
##############################################################################


# Initialize variables
#
BEGIN {
   FS = " "
   self = "meshfilt.awk"

   # check that errfile is specified
   #
   if (errfile == "")
   {
      printf "%s: no errfile\n", self
      exit 2
   }
   
   # Print message indicating what file error searching on
   #
   printf "\n"
   printf "=====> Error search on file: %s <=====\n", FILENAME
   printf "\n"
   printf "----------------------------------------\n"
}

# function to print error info 
#
function print_err(type, nodestr)
{
   # Must have a CBS number on current line
   #
   if (match($0, /[0-9][0-9][ABCD][0-9][0-9]/) > 0) {

      # Print line number of error
      #
      printf "Error on line: %d\n\n", NR

      # Print out test that failed (with FAILED at the end)
      #
      for (i = prevTrial; i <= prevLast; i++) {
         if (match(prevline[i], /[Ff][Aa][Ii][Ll][Ee][Dd]/) > 0) {

            # Make sure have a FAILED is capitalized if on test line
            #
            printf "FAILED "
	 }
         else {
            printf "%s ", prevline[i]

            # Make sure have a FAILED end to test name
            #
            if (i == prevLast) {
               printf "FAILED "
	    }
	 }
      }
      printf "\n"

      # Print out type of failure
      #
      printf "%s\n", type

      # Print out node(s) that failed
      #
      split(nodestr, nodes, ",")
      printf "%s\n", nodes[1]

      printf "----------------------------------------\n"
   }
}   

# function to format error info 
#
function fmt_print(fmtstr, errstr, srcoff)
{
   # the nodes are listed (srcoff) fields to the right of the fmtstr
   #
   for(i = 1; i < NF; i++) {
      if (match($i, fmtstr) > 0) {
         break
      }
   }

   # Get SRC and remove end comma (if one exists)
   #
   split($(i + srcoff), src, ",")

   # Print out filtered error info
   #
   print_err(errstr, src[1])
}   

# Check for
#
/MISCOMPARE/ {
   # the nodes are listed two fields to the right
   #
   fmt_print("MISCOMPARE", "MISCOMPARE", 2)

   next
}

# Check for
#
/CRC error/ {
   # format error info and then print
   #
   fmt_print("CRC", "CRC", 5)

   next
}

# Check for
#
/MESH Parity error/ {
   # format error info and then print
   #
   fmt_print("MESH", "MESH Parity", 6)

   next
}

# Check for
#
/RECV_UNDERRUN/ {
   # format error info and then print
   #
   fmt_print("RECV_UNDERRUN", "RECV_UNDERRUN", 4)

   next
}

# Check for
#
/NIC Parity error/ {
   # format error info and then print
   #
   fmt_print("NIC", "NIC Parity", 6)

   next
}

# Check for
#
/XMIT_OVERRUN/ {
   # format error info and then print
   #
   fmt_print("XMIT_OVERRUN", "XMIT_OVERRUN", 4)

   next
}

# Check for
#
/DP ERROR/ {
   # the nodes are listed (srcoff) fields to the right of the fmtstr
   #
   for (i = 1; i <= NF; i++) {
      if (match($i, /DP/) > 0) {
	 break
      }
   }

   # Check hi 32bits of DP_STATUS for a hard ECC error
   #
   if (match($(i + 5), /0x[0-9ABCDEF][0-9ABCDEF][0-9ABCDEF][0-9ABCDEF][0-9ABCDEF]2[0-9ABCDEF][0-9ABCDEF],/) > 0) {
      print_err("DP Hard ECC Error (hi word)", $(i + 2))
   }

   # Check lo 32bits of DP_STATUS for a hard ECC error
   #
   if (match($(i + 6), /0x[0-9ABCDEF][0-9ABCDEF][0-9ABCDEF][0-9ABCDEF][0-9ABCDEF]2[0-9ABCDEF][0-9ABCDEF]/) > 0) {
      print_err("DP Hard ECC Error (lo word)", $(i + 2))
   }
}

# Save the line with the test name that failed
#
/[Tt]rial/ {

   # place the current line into an array
   #
   prevLast = split($0, prevline)

   # Find the array entry of the word Trial
   #
   for (i = 1; i < prevLast; i++) {
      if (match($i, /[Tt]rial/) > 0) {
         break;
      }
   }

   # Set the offset for the failed test name
   #
   prevTrial = i + 2;
}
